/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010 \u001a\n !*\u0004\u0018\u00010\n0\nH\u0002J\b\u0010\"\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006#"}, d2={"Lcom/intellij/sql/formatter/model/SqlFileBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "extraBreakAfterDelimiter", "", "getExtraBreakAfterDelimiter", "()Z", "wrapSemicolon", "getWrapSemicolon", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "determinePostgresSpecialRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "determineRole", "getAlignment", "Lcom/intellij/formatting/Alignment;", "getIndent", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "getWrap", "Lcom/intellij/formatting/Wrap;", "makeSpacingBeforeDelimiter", "makeSpacingBetweenStatements", "kotlin.jvm.PlatformType", "userBreakFirstElement", "intellij.database.sql.impl"})
public final class SqlFileBlock
extends SqlNodeBlock {
    private final boolean getWrapSemicolon() {
        return this.getContext().getSql().NEW_LINE_AROUND_SEMICOLON;
    }

    private final boolean getExtraBreakAfterDelimiter() {
        return this.getContext().getSql().NEW_LINE_AROUND_SEMICOLON;
    }

    @Override
    @NotNull
    public BlockRole determineRole(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_SEMICOLON) || Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.ORAP_SLASH_DELIMITER_TOKEN) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.PG_COPY_TERMINATOR) ? BlockRole.DELIMITER : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_DIV) ? BlockRole.DELIMITER : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_INJECTABLE_RAW_INPUT) || Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_RAW_INPUT) ? BlockRole.AMENDMENT : (CollectionsKt.contains((Iterable)SqlFormattingFunKt.getCOMMENT_TYPES(), (Object)iElementType) ? super.determineRole(node) : (iElementType instanceof IsExternal ? this.determinePostgresSpecialRole(node) : (iElementType instanceof SqlTokenType.Synthetic ? BlockRole.UNKNOWN : BlockRole.ELEMENT)))));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final BlockRole determinePostgresSpecialRole(ASTNode node) {
        BlockRole blockRole;
        if (node.getTextLength() < 80) {
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
            if (StringsKt.startsWith$default((CharSequence)string, (char)'\\', (boolean)false, (int)2, null)) {
                blockRole = BlockRole.PREFIX;
                return blockRole;
            }
        }
        blockRole = BlockRole.AMENDMENT;
        return blockRole;
    }

    @Override
    public boolean userBreakFirstElement() {
        return true;
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        BlockRole r1 = block1.getRole();
        BlockRole r2 = block2.getRole();
        return r2 == BlockRole.DELIMITER ? this.makeSpacingBeforeDelimiter(block2) : (r1 == BlockRole.PREFIX || r1 == BlockRole.AMENDMENT || r2 == BlockRole.AMENDMENT ? this.getContext().makeAutoSpacing(true) : (r1 == BlockRole.DELIMITER ? this.makeSpacingBetweenStatements() : (r2 == BlockRole.ELEMENT ? this.makeSpacingBetweenStatements() : (r1 == BlockRole.UNKNOWN || r2 == BlockRole.UNKNOWN ? this.getContext().makeAutoSpacing(true) : Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)3)))));
    }

    private final Spacing makeSpacingBeforeDelimiter(SqlBlock block2) {
        IElementType t2;
        SqlBlock sqlBlock = block2;
        if (!(sqlBlock instanceof SqlLeafBlock)) {
            sqlBlock = null;
        }
        SqlLeafBlock sqlLeafBlock = (SqlLeafBlock)sqlBlock;
        Object object = t2 = sqlLeafBlock != null ? sqlLeafBlock.getElementType() : null;
        if (t2 == null) {
            return this.getContext().makeAutoSpacing(true);
        }
        IElementType iElementType = t2;
        return Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_SEMICOLON) ? (this.getWrapSemicolon() ? SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null) : SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null)) : (Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.ORAP_SLASH_DELIMITER_TOKEN) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_GO) ? SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null) : this.getContext().makeAutoSpacing(true));
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    private final Spacing makeSpacingBetweenStatements() {
        return Spacing.createSpacing((int)0, (int)0, (int)(1 + SqlUtilFun.toInt(this.getExtraBreakAfterDelimiter())), (boolean)true, (int)3);
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        SqlBlock block1 = blocks.getBlock1();
        if (block1 == null) {
            return "";
        }
        if (block1.getRole() == BlockRole.DELIMITER) {
            return "";
        }
        if (block1 instanceof SqlFlowBlock) {
            if (!block1.incomplete()) {
                return "";
            }
            return block1.getNewLineIndent(new AdjacentBlocks(block1.getLastNestedSqlBlock(), null));
        }
        return null;
    }

    @Override
    @Nullable
    public Wrap getWrap() {
        return this.getMyWrap();
    }

    @Override
    @NotNull
    public Indent getIndent() {
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @Override
    @Nullable
    public Alignment getAlignment() {
        return null;
    }

    public SqlFileBlock() {
        this.setMyWrap(Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false));
    }
}

