/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockKt;
import com.intellij.sql.formatter.model.SqlCursorDefinitionBlock;
import com.intellij.sql.formatter.model.SqlDefinitionsSubsectionBlock$WhenMappings;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlTypeDefinitionBlock;
import com.intellij.sql.formatter.model.SqlVariableDefinitionBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\b\u0010\u0005\u001a\u00020\u0004H\u0014J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/formatter/model/SqlDefinitionsSubsectionBlock;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "analyseOriginalCodeStyle", "", "configureFormattingAttributes", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "makeBlock", "node", "Lcom/intellij/lang/ASTNode;", "userRequiresExpand", "", "intellij.database.sql.impl"})
public final class SqlDefinitionsSubsectionBlock
extends SqlRangeBlock {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        SqlBlock sqlBlock;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_VARIABLE_DEFINITION))) {
            void $this$withSetup$iv;
            SqlNodeBlock sqlNodeBlock = new SqlVariableDefinitionBlock();
            SqlBlock parent$iv = this;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup$intellij_database_sql_impl(parent$iv, node);
            sqlBlock = SqlBlockKt.withRole((SqlBlock)$this$withSetup$iv, BlockRole.ELEMENT);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_CURSOR_DEFINITION))) {
            SqlRangeBlock $this$withSetup$iv = new SqlCursorDefinitionBlock();
            SqlBlock parent$iv = this;
            boolean $i$f$withSetup = false;
            TextRange textRange = node.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"outerNode.textRange");
            $this$withSetup$iv.setup$intellij_database_sql_impl(parent$iv, textRange, SqlFormattingModelFunKt.listChildren(node));
            sqlBlock = SqlBlockKt.withRole((SqlBlock)$this$withSetup$iv, BlockRole.ELEMENT);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_ALIAS_TYPE_DEFINITION)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_TYPE_DEFINITION)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_COLLECTION_TYPE_DEFINITION))) {
            void var3_5;
            SqlNodeBlock $this$withSetup$iv = new SqlTypeDefinitionBlock();
            SqlBlock parent$iv = this;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup$intellij_database_sql_impl(parent$iv, node);
            sqlBlock = SqlBlockKt.withRole((SqlBlock)var3_5, BlockRole.ELEMENT);
        } else {
            sqlBlock = super.makeBlock(node);
        }
        return sqlBlock;
    }

    @Override
    protected void analyseOriginalCodeStyle() {
        if (this.getContext().getSql().IMP_DECLARE_EL_WRAP == 0 && this.getContext().textContains(this.getRange(), '\n')) {
            this.setShape(BlockShape.DECIDED_TO_MULTI_ROWS);
        }
    }

    @Override
    public boolean userRequiresExpand() {
        return this.getContext().getSql().IMP_DECLARE_EL_WRAP == 1;
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @Override
    protected void configureFormattingAttributes() {
        SqlCodeStyleSettings s2 = this.getContext().getSql();
        Wrap w = this.makeWrap$intellij_database_sql_impl(s2.IMP_DECLARE_EL_WRAP, false);
        Alignment a2 = !s2.IMP_DECLARE_CONTENT_WRAP ? SqlFormattingModelFunKt.makeLeftAlignment() : null;
        Wrap nw = SqlFlowBlock.makeWrap$default(this, WrapType.NONE, false, 2, null);
        Alignment innerA1 = s2.IMP_DECLARE_ALIGN_TYPE ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
        Alignment innerA2 = s2.IMP_DECLARE_ALIGN_EQ ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
        Alignment innerA3 = s2.IMP_DECLARE_ALIGN_DEFAULT ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
        boolean alignContent = s2.IMP_DECLARE_ALIGN_TYPE || s2.IMP_DECLARE_ALIGN_EQ || s2.IMP_DECLARE_ALIGN_DEFAULT;
        for (SqlBlock b2 : this.getNestedBlocks()) {
            switch (SqlDefinitionsSubsectionBlock$WhenMappings.$EnumSwitchMapping$1[b2.getRole().ordinal()]) {
                case 1: {
                    SqlBlock this_$iv = b2;
                    Object indent$iv = this_$iv.getMyIndent();
                    boolean $i$f$setAttributes = false;
                    this_$iv.setMyWrap(w);
                    this_$iv.setMyIndent((Indent)indent$iv);
                    this_$iv.setMyAlign(a2);
                    if (!alignContent || !(b2 instanceof SqlVariableDefinitionBlock)) break;
                    for (SqlBlock bb : ((SqlVariableDefinitionBlock)b2).getNestedBlocks()) {
                        Alignment alignment;
                        switch (SqlDefinitionsSubsectionBlock$WhenMappings.$EnumSwitchMapping$0[bb.getRole().ordinal()]) {
                            case 1: {
                                alignment = innerA1;
                                break;
                            }
                            case 2: {
                                alignment = innerA2;
                                break;
                            }
                            case 3: {
                                alignment = innerA3;
                                break;
                            }
                            default: {
                                alignment = null;
                            }
                        }
                        bb.setMyAlign(alignment);
                    }
                    break;
                }
                case 2: {
                    SqlBlock this_$iv = b2;
                    Object indent$iv = this_$iv.getMyIndent();
                    Alignment align$iv = this_$iv.getMyAlign();
                    boolean $i$f$setAttributes = false;
                    this_$iv.setMyWrap(nw);
                    this_$iv.setMyIndent((Indent)indent$iv);
                    this_$iv.setMyAlign(align$iv);
                    break;
                }
            }
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        if (block2.getRole() == BlockRole.ELEMENT) {
            int wrapSetting = this.getContext().getSql().IMP_DECLARE_EL_WRAP;
            boolean keepLB = wrapSetting == 0 || wrapSetting == 3;
            return SqlFormattingContext.makeSpace$default(this.getContext(), false, keepLB, 1, null);
        }
        return super.decideSpacing(block1, block2);
    }
}

