/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.NodeWithLineCommentPattern;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCommentBlock;
import com.intellij.sql.formatter.model.SqlDeclareStatementBlock;
import com.intellij.sql.formatter.model.SqlDeclareStatementEntryBlock;
import com.intellij.sql.formatter.model.SqlDeclareStatementGroupBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\u0007H\u0014J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/formatter/model/SqlDeclareStatementGroupBlock;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "numberOfEntries", "", "numberOfLineComments", "analyseOriginalCodeStyle", "", "configureFormattingAttributes", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/NodeWithLineCommentPattern;", "getDebugNameSuffix", "", "Companion", "intellij.database.sql.impl"})
public final class SqlDeclareStatementGroupBlock
extends SqlRangeBlock {
    private int numberOfEntries;
    private int numberOfLineComments;
    @NotNull
    private static final List<NodeWithLineCommentPattern> patterns;
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected List<NodeWithLineCommentPattern> flowPatterns() {
        return patterns;
    }

    @Override
    protected void analyseOriginalCodeStyle() {
        for (SqlBlock block : this.getNestedBlocks()) {
            if (!(block instanceof SqlDeclareStatementEntryBlock)) continue;
            int n = this.numberOfEntries;
            this.numberOfEntries = n + 1;
            if (((SqlDeclareStatementEntryBlock)block).getCommentBlock$intellij_database_sql_impl() == null) continue;
            n = this.numberOfLineComments;
            this.numberOfLineComments = n + 1;
        }
        if (this.numberOfEntries >= 2) {
            this.setShape(BlockShape.DECIDED_TO_MULTI_ROWS);
        }
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureFormattingAttributes() {
        if (this.getContext().getSql().IMP_DECLARE_ALIGN_TYPE && this.numberOfEntries >= 2) {
            Alignment alignmentForTypes = SqlFormattingModelFunKt.makeLeftAlignmentBS();
            for (SqlBlock b2 : this.getNestedBlocks()) {
                void wrap$iv;
                void this_$iv;
                SqlBlock t;
                SqlDeclareStatementBlock d2;
                if (!(b2 instanceof SqlDeclareStatementEntryBlock)) continue;
                if (((SqlDeclareStatementEntryBlock)b2).getDeclareBlock$intellij_database_sql_impl() == null) {
                    continue;
                }
                if (d2.getTypeBlock$intellij_database_sql_impl() == null) {
                    continue;
                }
                SqlBlock sqlBlock = t;
                Object var7_9 = null;
                Indent indent$iv = null;
                boolean $i$f$setAttributes = false;
                this_$iv.setMyWrap((Wrap)wrap$iv);
                this_$iv.setMyIndent(indent$iv);
                this_$iv.setMyAlign(alignmentForTypes);
            }
        }
        if (this.getContext().getSql().IMP_DECLARE_ALIGN_LINE_COMMENTS && this.numberOfLineComments >= 2) {
            Alignment alignmentForComments = SqlFormattingModelFunKt.makeLeftAlignmentBS();
            for (SqlBlock b2 : this.getNestedBlocks()) {
                if (!(b2 instanceof SqlDeclareStatementEntryBlock)) continue;
                if (((SqlDeclareStatementEntryBlock)b2).getCommentBlock$intellij_database_sql_impl() != null) {
                    void indent$iv;
                    void wrap$iv;
                    void this_$iv;
                    SqlCommentBlock sqlCommentBlock;
                    boolean bl = false;
                    boolean bl2 = false;
                    SqlCommentBlock it2 = sqlCommentBlock;
                    boolean bl3 = false;
                    SqlBlock $i$f$setAttributes = it2;
                    Object var10_14 = null;
                    Object var11_15 = null;
                    Alignment align$iv = alignmentForComments;
                    boolean $i$f$setAttributes2 = false;
                    this_$iv.setMyWrap((Wrap)wrap$iv);
                    this_$iv.setMyIndent((Indent)indent$iv);
                    this_$iv.setMyAlign(align$iv);
                }
            }
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        return block1 instanceof SqlDeclareStatementEntryBlock ? this.getContext().makeSafeSpaceOrBreak() : (block2 instanceof SqlDeclareStatementEntryBlock ? SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null) : super.decideSpacing(block1, block2));
    }

    @Override
    @Nullable
    protected String getDebugNameSuffix() {
        return "" + this.numberOfEntries + ',' + this.numberOfLineComments;
    }

    static {
        Companion = new Companion(null);
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_DECLARE_STATEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_DECLARE_STATEMENT");
        patterns = CollectionsKt.listOf((Object)new NodeWithLineCommentPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE)));
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlDeclareStatementGroupBlock$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/NodeWithLineCommentPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.impl"})
    public static final class Companion {
        @NotNull
        public final List<NodeWithLineCommentPattern> getPatterns() {
            return patterns;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

