/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.psi.SqlCommonTokens;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/formatter/model/SqlAssignmentBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "configureFormattingAttributes", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "intellij.database.sql.impl"})
public final class SqlAssignmentBlock
extends SqlNodeBlock {
    @Override
    @NotNull
    public BlockRole determineRole(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_ASSIGN) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_EQ) ? BlockRole.EQ : super.determineRole(node);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureFormattingAttributes() {
        int n = this.getNestedBlocks().size();
        if (n == 0) {
            return;
        }
        Wrap w = this.makeWrap(WrapType.NORMAL, false);
        this.getNestedBlocks().get(0).setMyWrap(w);
        int n2 = 2;
        int n3 = n;
        while (n2 < n3) {
            void i2;
            if (this.getNestedBlocks().get((int)(i2 - true)).getRole() == BlockRole.EQ) {
                this.getNestedBlocks().get((int)i2).setMyWrap(w);
                this.getNestedBlocks().get((int)i2).setMyIndent(Indent.getContinuationIndent());
            }
            ++i2;
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        return block1.getRole() == BlockRole.EQ || block2.getRole() == BlockRole.EQ ? SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null) : super.decideSpacing(block1, block2);
    }
}

