/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.FlowProcessor;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCommentsFlowBlock;
import com.intellij.sql.formatter.model.SqlErrorFlowBlock;
import com.intellij.sql.formatter.model.SqlErrorNodeBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlRootBlock;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.apache.commons.lang.text.StrBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0005\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002ABB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010-\u001a\u00020.J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u000fJ\u0006\u00100\u001a\u00020.J\b\u00101\u001a\u00020.H\u0002J \u00101\u001a\u00020.2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\fH\u0002J\b\u00107\u001a\u00020.H\u0002J \u00108\u001a\u0004\u0018\u0001092\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010:\u001a\u00020\u000fH\u0002J \u0010;\u001a\u00020.2\u0006\u0010<\u001a\u00020\u000f2\u0006\u00102\u001a\u00020=2\u0006\u00104\u001a\u000205H\u0002J\u001e\u0010>\u001a\u00020?2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010@\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\"\u0010\u001c\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R\"\u0010\u001e\u001a\u0004\u0018\u00010\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010$\u00a8\u0006C"}, d2={"Lcom/intellij/sql/formatter/model/FlowProcessor;", "", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "parentBlock", "Lcom/intellij/sql/formatter/model/SqlFlowBlock;", "nodes", "", "Lcom/intellij/lang/ASTNode;", "patterns", "Lcom/intellij/sql/formatter/model/FlowPattern;", "produceCommentsFlows", "", "(Lcom/intellij/sql/formatter/model/SqlFormattingContext;Lcom/intellij/sql/formatter/model/SqlFlowBlock;Ljava/util/List;Ljava/util/List;Z)V", "<set-?>", "", "currIndex", "getCurrIndex", "()I", "currNode", "getCurrNode", "()Lcom/intellij/lang/ASTNode;", "Lcom/intellij/psi/tree/IElementType;", "currType", "getCurrType", "()Lcom/intellij/psi/tree/IElementType;", "n", "getN", "nextNode", "getNextNode", "nextType", "getNextType", "getNodes", "()Ljava/util/List;", "getPatterns", "getProduceCommentsFlows", "()Z", "state", "", "getState", "()B", "setState", "(B)V", "theEnd", "getTheEnd", "advance", "", "toIndex", "processAll", "processCurrent", "newBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "expandSingleNode", "processIteration", "processMatching", "Lcom/intellij/sql/formatter/model/FlowProcessor$MatchedPattern;", "since", "processSequence", "till", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "showPosition", "", "position", "InternalException", "MatchedPattern", "intellij.database.sql.impl"})
public final class FlowProcessor {
    private final int n;
    private byte state;
    private int currIndex;
    @Nullable
    private ASTNode currNode;
    @Nullable
    private IElementType currType;
    @Nullable
    private ASTNode nextNode;
    @Nullable
    private IElementType nextType;
    private final SqlFormattingContext context;
    private final SqlFlowBlock parentBlock;
    @NotNull
    private final List<ASTNode> nodes;
    @NotNull
    private final List<FlowPattern> patterns;
    private final boolean produceCommentsFlows;

    public final int getN() {
        return this.n;
    }

    public final byte getState() {
        return this.state;
    }

    public final void setState(byte by) {
        this.state = by;
    }

    public final int getCurrIndex() {
        return this.currIndex;
    }

    @Nullable
    public final ASTNode getCurrNode() {
        return this.currNode;
    }

    @Nullable
    public final IElementType getCurrType() {
        return this.currType;
    }

    @Nullable
    public final ASTNode getNextNode() {
        return this.nextNode;
    }

    @Nullable
    public final IElementType getNextType() {
        return this.nextType;
    }

    public final boolean getTheEnd() {
        return this.currIndex >= this.n;
    }

    public final void advance() {
        int n = this.currIndex;
        this.currIndex = n + 1;
        this.currNode = this.nextNode;
        this.currType = this.nextType;
        ASTNode aSTNode = this.nextNode = this.currIndex + 1 < this.n ? this.nodes.get(this.currIndex + 1) : null;
        this.nextType = aSTNode != null ? aSTNode.getElementType() : null;
    }

    public final void advance(int toIndex) {
        this.currIndex = toIndex;
        if (this.currIndex < this.n) {
            ASTNode aSTNode = this.currNode = this.nodes.get(this.currIndex);
            this.currType = aSTNode != null ? aSTNode.getElementType() : null;
            ASTNode aSTNode2 = this.nextNode = this.currIndex + 1 < this.n ? this.nodes.get(this.currIndex + 1) : null;
            this.nextType = aSTNode2 != null ? aSTNode2.getElementType() : null;
        } else {
            this.currNode = null;
            this.currType = null;
            this.nextNode = null;
            this.nextType = null;
        }
    }

    public final void processAll() {
        while (!this.getTheEnd()) {
            this.processIteration();
        }
    }

    private final void processIteration() {
        int currTextLength;
        ASTNode aSTNode = this.currNode;
        int n = currTextLength = aSTNode != null ? aSTNode.getTextLength() : 0;
        if (currTextLength == 0) {
            this.advance();
            return;
        }
        ASTNode aSTNode2 = this.currNode;
        if (aSTNode2 == null) {
            throw (Throwable)new IllegalStateException("Something has gone wrong");
        }
        ASTNode theNode = aSTNode2;
        IElementType iElementType = theNode.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"theNode.elementType");
        IElementType theType = iElementType;
        if (theType instanceof PsiErrorElement || Intrinsics.areEqual((Object)theType, (Object)TokenType.ERROR_ELEMENT)) {
            SqlBlock sqlBlock;
            SqlBlock parent$iv;
            SqlRangeBlock $this$withSetup$iv;
            boolean $i$f$withSetup;
            int recoverIndex;
            for (recoverIndex = this.currIndex + 1; recoverIndex < this.n && SqlUtilFun.isLeaf(this.nodes.get(recoverIndex)); ++recoverIndex) {
            }
            if (this.currIndex + 1 == recoverIndex) {
                SqlLeafBlock sqlLeafBlock = new SqlErrorNodeBlock();
                SqlBlock sqlBlock2 = this.parentBlock;
                ASTNode aSTNode3 = this.currNode;
                Intrinsics.checkNotNull((Object)aSTNode3);
                ASTNode node$iv = aSTNode3;
                $i$f$withSetup = false;
                ((SqlLeafBlock)((Object)$this$withSetup$iv)).setup(parent$iv, node$iv);
                sqlBlock = $this$withSetup$iv;
            } else {
                $this$withSetup$iv = new SqlErrorFlowBlock();
                parent$iv = this.parentBlock;
                List<ASTNode> nodes$iv = this.nodes.subList(this.currIndex, recoverIndex);
                $i$f$withSetup = false;
                $this$withSetup$iv.setup(parent$iv, nodes$iv);
                sqlBlock = $this$withSetup$iv;
            }
            SqlBlock theErrorBlock = sqlBlock;
            this.parentBlock.addNestedBlock$intellij_database_sql_impl(theErrorBlock);
            this.advance(recoverIndex);
            return;
        }
        if (CollectionsKt.contains((Iterable)SqlFormattingFunKt.getCOMMENT_TYPES(), (Object)theType) && this.nextType != null && CollectionsKt.contains((Iterable)SqlFormattingFunKt.getCOMMENT_TYPES(), (Object)this.nextType) && this.produceCommentsFlows) {
            int m;
            for (m = this.currIndex + 2; m < this.n && CollectionsKt.contains((Iterable)SqlFormattingFunKt.getCOMMENT_TYPES(), (Object)this.nodes.get(m).getElementType()); ++m) {
            }
            SqlRangeBlock $this$withSetup$iv = new SqlCommentsFlowBlock();
            SqlBlock parent$iv = this.parentBlock;
            List<ASTNode> nodes$iv = this.nodes.subList(this.currIndex, m);
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup(parent$iv, nodes$iv);
            SqlCommentsFlowBlock theCommentsBlock = (SqlCommentsFlowBlock)$this$withSetup$iv;
            this.parentBlock.addNestedBlock$intellij_database_sql_impl(theCommentsBlock);
            this.advance(m);
            return;
        }
        MatchedPattern m = this.processMatching(this.nodes, this.currIndex);
        if (m != null) {
            SqlBlock newBlock = (SqlBlock)m.getPattern().getProducer().invoke();
            int n2 = m.getRange().getLast() - m.getRange().getFirst() + 1;
            if (n2 == 1) {
                this.processCurrent(newBlock, m.getPattern().getRole(), m.getPattern().getExpandSingleNode());
            } else if (n2 >= 2) {
                SqlRangeBlock sqlRangeBlock;
                try {
                    SqlBlock sqlBlock = newBlock;
                    if (sqlBlock == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.formatter.model.SqlRangeBlock");
                    }
                    sqlRangeBlock = (SqlRangeBlock)sqlBlock;
                }
                catch (ClassCastException cce) {
                    StringBuilder stringBuilder = new StringBuilder().append("\n                |Problem with processing flow in the ").append(Reflection.getOrCreateKotlinClass(this.parentBlock.getClass()).getSimpleName()).append(":\n                |Pattern: ").append(m.getPattern()).append(".\n                |Matched: ").append(m.getRange()).append(" nodes.\n                |Failed to setup ").append(Reflection.getOrCreateKotlinClass(newBlock.getClass()).getSimpleName()).append(" as a SqlRangeBlock for ").append(n2).append(" AST nodes.\n                |AST nodes: ").append(CollectionsKt.joinToString$default((Iterable)this.nodes.subList(this.currIndex, m.getRange().getEndInclusive() + 1), null, null, null, (int)0, null, (Function1)processIteration.newRangeBlock.message.1.INSTANCE, (int)31, null)).append("\n                |Text:\n                |---- 8< ----\n                |");
                    CharSequence charSequence = this.parentBlock.getContext().getText();
                    int n3 = this.nodes.get(this.currIndex).getStartOffset();
                    TextRange textRange = this.nodes.get(m.getRange().getEndInclusive()).getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"nodes[m.range.endInclusive].textRange");
                    String message2 = StringsKt.trimMargin$default((String)stringBuilder.append(charSequence.subSequence(n3, textRange.getEndOffset())).append("\n                |---- >8 ----\n              ").toString(), null, (int)1, null);
                    throw (Throwable)new InternalException(message2, cce);
                }
                SqlRangeBlock newRangeBlock2 = sqlRangeBlock;
                this.processSequence(m.getRange().getEndInclusive() + 1, newRangeBlock2, m.getPattern().getRole());
            }
            if (m.getPattern().getResultState() != null) {
                this.state = m.getPattern().getResultState();
            }
        } else {
            this.processCurrent();
        }
    }

    private final MatchedPattern processMatching(List<? extends ASTNode> nodes, int since) {
        for (FlowPattern pattern : this.patterns) {
            IntRange range;
            if (!SqlUtilFun.isNullOr(pattern.getApplicableState(), this.state) || (range = pattern.process(this.context, nodes, since)) == null) continue;
            boolean bl = !range.isEmpty();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Invalid range " + range + " got from the pattern " + pattern + " here:\n\t" + this.showPosition(nodes, since);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            return new MatchedPattern(pattern, range);
        }
        return null;
    }

    private final String showPosition(List<? extends ASTNode> nodes, int position) {
        StrBuilder b2 = new StrBuilder();
        if (position > 0) {
            StringUtil.join((Iterable)nodes.subList(0, position), (String)" ");
        }
        b2.append(" | ");
        if (position < nodes.size()) {
            StringUtil.join((Iterable)nodes.subList(position, nodes.size()), (String)" ");
        }
        String string = b2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"b.toString()");
        return string;
    }

    private final void processCurrent() {
        ASTNode aSTNode = this.currNode;
        if (aSTNode == null) {
            throw (Throwable)new IllegalStateException(this.getTheEnd() ? "The end of list is reached" : "Something has gone wrong: the node is null when the index is " + this.currIndex + " of " + this.n);
        }
        ASTNode theNode = aSTNode;
        SqlBlock newBlock = this.parentBlock.makeBlock(theNode);
        if (newBlock.getRole() == BlockRole.NOTHING) {
            newBlock.setRole(this.parentBlock.determineRole(theNode));
        }
        this.parentBlock.addNestedBlock$intellij_database_sql_impl(newBlock);
        this.advance();
    }

    /*
     * WARNING - void declaration
     */
    private final void processCurrent(SqlBlock newBlock, BlockRole role, boolean expandSingleNode) {
        ASTNode primaryNode;
        ASTNode aSTNode = this.currNode;
        if (aSTNode == null) {
            throw (Throwable)new IllegalStateException(this.getTheEnd() ? "The end of list is reached" : "Something has gone wrong: the node is null when the index is " + this.currIndex + " of " + this.n);
        }
        ASTNode theNode = aSTNode;
        SqlBlock sqlBlock = newBlock;
        if (sqlBlock instanceof SqlNodeBlock) {
            void $this$withSetup$iv;
            SqlNodeBlock sqlNodeBlock = (SqlNodeBlock)newBlock;
            SqlBlock parent$iv = this.parentBlock;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup$intellij_database_sql_impl(parent$iv, theNode);
        } else if (sqlBlock instanceof SqlRangeBlock) {
            if (expandSingleNode) {
                SqlRangeBlock $this$withSetup$iv = (SqlRangeBlock)newBlock;
                SqlBlock parent$iv = this.parentBlock;
                boolean $i$f$withSetup = false;
                TextRange textRange = theNode.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"outerNode.textRange");
                $this$withSetup$iv.setup$intellij_database_sql_impl(parent$iv, textRange, SqlFormattingModelFunKt.listChildren(theNode));
            } else {
                SqlRangeBlock $this$withSetup$iv = (SqlRangeBlock)newBlock;
                SqlBlock parent$iv = this.parentBlock;
                List nodes$iv = CollectionsKt.listOf((Object)theNode);
                boolean $i$f$withSetup = false;
                $this$withSetup$iv.setup(parent$iv, nodes$iv);
            }
        } else if (sqlBlock instanceof SqlLeafBlock) {
            SqlLeafBlock $this$withSetup$iv = (SqlLeafBlock)newBlock;
            SqlBlock parent$iv = this.parentBlock;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup(parent$iv, theNode);
        } else if (sqlBlock instanceof SqlRootBlock) {
            throw (Throwable)new IllegalArgumentException("Cannot create a root block from FlowTraverser");
        }
        if (role != BlockRole.NOTHING) {
            newBlock.setRole(role);
        }
        if (newBlock.getRole() == BlockRole.NOTHING && (primaryNode = SqlFormattingModelFunKt.primaryNode(newBlock)) != null) {
            newBlock.setRole(this.parentBlock.determineRole(primaryNode));
        }
        this.parentBlock.addNestedBlock$intellij_database_sql_impl(newBlock);
        this.advance();
    }

    /*
     * WARNING - void declaration
     */
    private final void processSequence(int till, SqlRangeBlock newBlock, BlockRole role) {
        void $this$withSetup$iv;
        boolean bl = till <= this.n;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FlowProcessor$processSequence$22 = false;
            String $i$a$-assert-FlowProcessor$processSequence$22 = "Sublist exceeds the node list: till " + till + " of " + this.n;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-FlowProcessor$processSequence$22));
        }
        List<ASTNode> subList = this.nodes.subList(this.currIndex, till);
        SqlRangeBlock sqlRangeBlock = newBlock;
        SqlBlock parent$iv = this.parentBlock;
        boolean $i$f$withSetup = false;
        $this$withSetup$iv.setup(parent$iv, subList);
        if (role != BlockRole.NOTHING) {
            newBlock.setRole(role);
        }
        this.parentBlock.addNestedBlock$intellij_database_sql_impl(newBlock);
        this.advance(till);
    }

    @NotNull
    public final List<ASTNode> getNodes() {
        return this.nodes;
    }

    @NotNull
    public final List<FlowPattern> getPatterns() {
        return this.patterns;
    }

    public final boolean getProduceCommentsFlows() {
        return this.produceCommentsFlows;
    }

    public FlowProcessor(@NotNull SqlFormattingContext context, @NotNull SqlFlowBlock parentBlock, @NotNull List<? extends ASTNode> nodes, @NotNull List<? extends FlowPattern> patterns2, boolean produceCommentsFlows) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)parentBlock, (String)"parentBlock");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter(patterns2, (String)"patterns");
        this.context = context;
        this.parentBlock = parentBlock;
        this.nodes = nodes;
        this.patterns = patterns2;
        this.produceCommentsFlows = produceCommentsFlows;
        this.n = this.nodes.size();
        ASTNode aSTNode = this.currNode = this.n > 0 ? (ASTNode)CollectionsKt.first(this.nodes) : null;
        this.currType = aSTNode != null ? aSTNode.getElementType() : null;
        ASTNode aSTNode2 = this.nextNode = this.n > 1 ? this.nodes.get(1) : null;
        this.nextType = aSTNode2 != null ? aSTNode2.getElementType() : null;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/formatter/model/FlowProcessor$MatchedPattern;", "", "pattern", "Lcom/intellij/sql/formatter/model/FlowPattern;", "range", "Lkotlin/ranges/IntRange;", "(Lcom/intellij/sql/formatter/model/FlowPattern;Lkotlin/ranges/IntRange;)V", "getPattern", "()Lcom/intellij/sql/formatter/model/FlowPattern;", "getRange", "()Lkotlin/ranges/IntRange;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.database.sql.impl"})
    public static final class MatchedPattern {
        @NotNull
        private final FlowPattern pattern;
        @NotNull
        private final IntRange range;

        @NotNull
        public final FlowPattern getPattern() {
            return this.pattern;
        }

        @NotNull
        public final IntRange getRange() {
            return this.range;
        }

        public MatchedPattern(@NotNull FlowPattern pattern, @NotNull IntRange range) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.pattern = pattern;
            this.range = range;
        }

        @NotNull
        public final FlowPattern component1() {
            return this.pattern;
        }

        @NotNull
        public final IntRange component2() {
            return this.range;
        }

        @NotNull
        public final MatchedPattern copy(@NotNull FlowPattern pattern, @NotNull IntRange range) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return new MatchedPattern(pattern, range);
        }

        public static /* synthetic */ MatchedPattern copy$default(MatchedPattern matchedPattern, FlowPattern flowPattern, IntRange intRange, int n, Object object) {
            if ((n & 1) != 0) {
                flowPattern = matchedPattern.pattern;
            }
            if ((n & 2) != 0) {
                intRange = matchedPattern.range;
            }
            return matchedPattern.copy(flowPattern, intRange);
        }

        @NotNull
        public String toString() {
            return "MatchedPattern(pattern=" + this.pattern + ", range=" + this.range + ")";
        }

        public int hashCode() {
            FlowPattern flowPattern = this.pattern;
            IntRange intRange = this.range;
            return (flowPattern != null ? flowPattern.hashCode() : 0) * 31 + (intRange != null ? intRange.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MatchedPattern)) break block3;
                    MatchedPattern matchedPattern = (MatchedPattern)object;
                    if (!Intrinsics.areEqual((Object)this.pattern, (Object)matchedPattern.pattern) || !Intrinsics.areEqual((Object)this.range, (Object)matchedPattern.range)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/FlowProcessor$InternalException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "intellij.database.sql.impl"})
    public static final class InternalException
    extends RuntimeException {
        public InternalException(@NotNull String message2, @Nullable Exception exception) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(message2, exception);
        }
    }
}

