/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.FlowPatternKt;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/formatter/model/AdjacentGroupPattern;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "matcher", "Lcom/intellij/sql/formatter/model/NodeMatcher;", "allowSingle", "", "producer", "Lkotlin/Function0;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlBlockProducer;", "(Lcom/intellij/sql/formatter/model/NodeMatcher;ZLkotlin/jvm/functions/Function0;)V", "process", "Lkotlin/ranges/IntRange;", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "nodes", "", "Lcom/intellij/lang/ASTNode;", "since", "", "intellij.database.sql.impl"})
public final class AdjacentGroupPattern
extends FlowPattern {
    private final NodeMatcher matcher;
    private final boolean allowSingle;

    @Override
    @Nullable
    public IntRange process(@NotNull SqlFormattingContext context, @NotNull List<? extends ASTNode> nodes, int since) {
        ASTNode node;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        int n = nodes.size();
        int m = n - since;
        if (m == 0 || m == 1 && !this.allowSingle) {
            return null;
        }
        ASTNode acceptedNode = null;
        int acceptedIndex = -1;
        int i2 = since;
        while (!(i2 >= n || NodeMatcherKt.doesntMatch(node = nodes.get(i2), this.matcher) || acceptedNode != null && context.textContainsLinesBetween(acceptedNode, node))) {
            acceptedNode = node;
            acceptedIndex = i2++;
            if ((i2 = FlowPatternKt.access$skipSpaces(i2, nodes)) < n) {
                ASTNode nextNode = nodes.get(i2);
                if (CollectionsKt.contains((Iterable)SqlFormattingFunKt.getLINE_COMMENT_TYPES(), (Object)nextNode.getElementType()) && context.onSameLine(node, nextNode)) {
                    acceptedNode = node;
                    acceptedIndex = i2++;
                }
            }
            i2 = FlowPatternKt.access$skipSpaces(i2, nodes);
        }
        if (acceptedIndex < 0) {
            return null;
        }
        int n2 = since;
        return new IntRange(n2, acceptedIndex);
    }

    public AdjacentGroupPattern(@NotNull NodeMatcher matcher, boolean allowSingle, @NotNull Function0<? extends SqlBlock> producer) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        super(producer, null);
        this.matcher = matcher;
        this.allowSingle = allowSingle;
    }
}

