/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.database.script.ScriptModel;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.database.SqlNotebookManager;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.psi.SqlSetStatement;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlNotebookManagerImpl
implements SqlNotebookManager {
    public static final SqlNotebookManager INSTANCE = new SqlNotebookManagerImpl();

    private SqlNotebookManagerImpl() {
    }

    @NotNull
    public <E> Collection<SqlNotebookManager.Cell> getCells(@NotNull PsiFile file, @NotNull ScriptModel<E> model, @NotNull Condition<? super TextRange> filter2, int start2, int end2) {
        if (file == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(0);
        }
        if (model == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(1);
        }
        if (filter2 == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(2);
        }
        TextRange first2 = null;
        TextRange last = null;
        ArrayList<TextRange> curRanges = new ArrayList<TextRange>();
        ArrayList<SqlNotebookManager.Cell> result = new ArrayList<SqlNotebookManager.Cell>();
        EvaluationHelper helper = (EvaluationHelper)EvaluationHelper.EP.forLanguage(model.getLanguage());
        for (ScriptModel.StatementIt statement : model.rawTransform(arg_0 -> ((EvaluationHelper)helper).getNotebookTraverser(arg_0)).statements()) {
            boolean nextCell;
            TextRange current = statement.range();
            if (current.getEndOffset() <= start2 || helper.isFile(statement.api()).value(statement.object()) || !filter2.value((Object)current)) continue;
            TextRange withComments = this.captureComments(statement);
            boolean bl = nextCell = last == null || !current.equals((Object)withComments) || SqlNotebookManagerImpl.isCrossCellGap(file, statement, last, current);
            if (first2 == null || nextCell) {
                TextRange nextCellStart = withComments;
                SqlNotebookManagerImpl.flushCell(result, curRanges, file, first2, last, nextCellStart);
                if (current.getStartOffset() > end2) {
                    first2 = null;
                    last = null;
                    break;
                }
                first2 = current = SqlNotebookManagerImpl.isResultsFree(statement) ? null : withComments;
            }
            ContainerUtil.addAllNotNull(curRanges, (Object[])new TextRange[]{current});
            last = current;
        }
        SqlNotebookManagerImpl.flushCell(result, curRanges, file, first2, last, null);
        ArrayList<SqlNotebookManager.Cell> arrayList = result;
        if (arrayList == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public <E> E getPrecedingComment(@Nullable E element2, @NotNull SyntaxTraverser.Api<E> api) {
        E prevElement;
        if (api == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(4);
        }
        return (prevElement = this.skipWhitespacesBackward(element2, api)) != null && SqlNotebookManagerImpl.isComment(api.typeOf(prevElement)) ? (E)prevElement : null;
    }

    private static boolean isComment(@NotNull IElementType type) {
        ParserDefinition def;
        if (type == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(5);
        }
        return (def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(type.getLanguage())) != null && def.getCommentTokens().contains(type);
    }

    @Nullable
    public <E> E skipWhitespacesBackward(@Nullable E element2, @NotNull SyntaxTraverser.Api<E> api) {
        if (api == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            return null;
        }
        return (E)SqlNotebookManagerImpl.getPrevSiblingsReversed(element2, api).find(sibling -> !TokenSet.WHITE_SPACE.contains(api.typeOf(sibling)));
    }

    @NotNull
    private static <E> JBIterable<E> getPrevSiblingsReversed(E element2, SyntaxTraverser.Api<E> api) {
        if (api instanceof SyntaxTraverser.ApiEx) {
            SyntaxTraverser.ApiEx apiEx = (SyntaxTraverser.ApiEx)api;
            JBIterable jBIterable = JBIterable.generate((Object)apiEx.previous(element2), sibling -> apiEx.previous(sibling));
            if (jBIterable == null) {
                SqlNotebookManagerImpl.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }
        Object parent2 = api.parent(element2);
        if (parent2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlNotebookManagerImpl.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }
        JBIterable children2 = api.children(parent2);
        JBIterable jBIterable = JBIterable.from((Iterable)ContainerUtil.reverse((List)children2.take(children2.indexOf(child -> element2 == child)).toList()));
        if (jBIterable == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    private <E> TextRange captureComments(@NotNull ScriptModel.StatementIt<E> statement) {
        SyntaxTraverser.Api api;
        Object element2;
        Object comment;
        if (statement == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(10);
        }
        TextRange textRange = (comment = this.getPrecedingComment(element2 = statement.object(), api = statement.api())) == null ? api.rangeOf(element2) : TextRange.create((int)api.rangeOf(comment).getStartOffset(), (int)api.rangeOf(element2).getEndOffset());
        if (textRange == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(11);
        }
        return textRange;
    }

    private static void flushCell(@NotNull List<SqlNotebookManager.Cell> result, @NotNull List<TextRange> curRanges, @NotNull PsiFile file, @Nullable TextRange first2, @Nullable TextRange last, @Nullable TextRange nextCellStart) {
        if (result == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(12);
        }
        if (curRanges == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(13);
        }
        if (file == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(14);
        }
        if (first2 == null || last == null) {
            return;
        }
        int cellEnd = nextCellStart == null ? file.getTextLength() : nextCellStart.getStartOffset();
        ArrayList<TextRange> ranges = new ArrayList<TextRange>(curRanges);
        curRanges.clear();
        result.add(new SqlNotebookManager.Cell(TextRange.create((int)first2.getStartOffset(), (int)cellEnd), ranges, last.getEndOffset()));
    }

    private static boolean isCrossCellGap(@NotNull PsiFile file, @NotNull ScriptModel.StatementIt<?> statement, @NotNull TextRange prev, @NotNull TextRange range) {
        if (file == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(15);
        }
        if (statement == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(16);
        }
        if (prev == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(17);
        }
        if (range == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(18);
        }
        if (SqlNotebookManagerImpl.isResultsFree(statement)) {
            return true;
        }
        String text2 = file.getText();
        return text2.substring(prev.getEndOffset(), range.getStartOffset()).contains("\n\n");
    }

    private static boolean isResultsFree(@NotNull ScriptModel.StatementIt<?> statement) {
        PsiElement element2;
        if (statement == null) {
            SqlNotebookManagerImpl.$$$reportNull$$$0(19);
        }
        return (element2 = (PsiElement)ObjectUtils.tryCast((Object)statement.object(), PsiElement.class)) instanceof SqlSetStatement || element2 instanceof SqlUseDatabaseStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/SqlNotebookManagerImpl";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "api";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curRanges";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/SqlNotebookManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCells";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevSiblingsReversed";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "captureComments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCells";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPrecedingComment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isComment";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespacesBackward";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "captureComments";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "flushCell";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCrossCellGap";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isResultsFree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

