/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;

final class SqlLineMarkerProvider
implements LineMarkerProvider {
    SqlLineMarkerProvider() {
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS && element2.getFirstChild() == null) {
            JBIterable parents2 = SyntaxTraverser.psiApi().parents((Object)element2);
            PsiElement p2 = element2.getParent();
            if (p2 instanceof SqlProcedureDefinitionImpl && !(p2 instanceof SqlStatement) || parents2.filter(SqlStatement.class).single() != null) {
                boolean addSeparator = false;
                for (PsiElement parent2 : parents2) {
                    int newLines = -1;
                    if (parent2 instanceof SqlStatement) {
                        newLines = this.countNewLinesToPrev(parent2, (Condition<? super PsiElement>)((Condition)o -> o instanceof SqlStatement));
                    } else if (parent2 instanceof SqlProcedureDefinitionImpl) {
                        newLines = this.countNewLinesToPrev(parent2, (Condition<? super PsiElement>)((Condition)o -> o instanceof SqlDefinition));
                    }
                    if (newLines > 1) {
                        addSeparator = true;
                    }
                    if (newLines == -1 && parent2.getPrevSibling() == null) continue;
                    break;
                }
                if (addSeparator) {
                    return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)element2, (EditorColorsManager)EditorColorsManager.getInstance());
                }
            }
        }
        return null;
    }

    public Integer countNewLinesToPrev(PsiElement parent2, Condition<? super PsiElement> isAcceptable) {
        return (Integer)SqlImplUtil.revSiblings(parent2).skip(1).takeWhile(Conditions.not(isAcceptable)).filter(o -> o instanceof PsiWhiteSpace || o instanceof PsiComment).reduce((Object)0, (result, o) -> result + StringUtil.countNewLines((CharSequence)o.getText()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/editor/SqlLineMarkerProvider", "getLineMarkerInfo"));
    }
}

