/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlDialectHelper;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlEnterHandlerDelegate
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        EnterHandlerDelegate handler;
        if (file == null) {
            SqlEnterHandlerDelegate.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            SqlEnterHandlerDelegate.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            SqlEnterHandlerDelegate.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            SqlEnterHandlerDelegate.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            SqlEnterHandlerDelegate.$$$reportNull$$$0(4);
        }
        if ((handler = SqlEnterHandlerDelegate.getHandlerIfNeeded(file)) == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return handler.preprocessEnter(file, editor, caretOffset, caretAdvance, dataContext, originalHandler);
    }

    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        EnterHandlerDelegate handler;
        if (file == null) {
            SqlEnterHandlerDelegate.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            SqlEnterHandlerDelegate.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            SqlEnterHandlerDelegate.$$$reportNull$$$0(7);
        }
        if ((handler = SqlEnterHandlerDelegate.getHandlerIfNeeded(file)) == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return handler.postProcessEnter(file, editor, dataContext);
    }

    @Nullable
    private static EnterHandlerDelegate getHandlerIfNeeded(@NotNull PsiFile file) {
        SqlEditorOptions instance;
        if (file == null) {
            SqlEnterHandlerDelegate.$$$reportNull$$$0(8);
        }
        if (!(instance = SqlEditorOptions.getInstance()).isCloseBlocksOnEnter()) {
            return null;
        }
        SqlLanguageDialectEx dialectEx = (SqlLanguageDialectEx)((Object)ObjectUtils.tryCast((Object)DbSqlUtilCore.getSqlDialect((PsiElement)file), SqlLanguageDialectEx.class));
        if (dialectEx == null) {
            return null;
        }
        return ((SqlDialectHelper)SqlDialectHelper.EP.forLanguage((Language)dialectEx)).getEnterHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/editor/SqlEnterHandlerDelegate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessEnter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getHandlerIfNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

