/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.psi.DbPresentation;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlBreadcrumbsProvider;
import com.intellij.sql.editor.SqlBreadcrumbsProvider$WhenMappings;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.util.containers.JBIterable;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001b\u0010\f\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/editor/SqlBreadcrumbsProvider;", "Lcom/intellij/ui/breadcrumbs/BreadcrumbsProvider;", "()V", "acceptElement", "", "element", "Lcom/intellij/psi/PsiElement;", "getElementIcon", "Ljavax/swing/Icon;", "getElementInfo", "", "getElementTooltip", "getLanguages", "", "Lcom/intellij/sql/psi/SqlLanguage;", "kotlin.jvm.PlatformType", "()[Lcom/intellij/sql/psi/SqlLanguage;", "Companion", "intellij.database.sql.impl"})
public final class SqlBreadcrumbsProvider
implements BreadcrumbsProvider {
    private static final int MAX_LENGTH = 50;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public SqlLanguage[] getLanguages() {
        return new SqlLanguage[]{SqlLanguage.INSTANCE};
    }

    public boolean acceptElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return element2 instanceof PsiObject;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof PsiObject) {
            String string = StringUtil.shortenTextWithEllipsis((String)((PsiObject)element2).getName(), (int)50, (int)0, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.shortenTextWi\u2026ame, MAX_LENGTH, 0, true)");
            String text2 = string;
            return element2 instanceof DasRoutine ? text2 + "()" : text2;
        }
        String string = "Incorrect element: " + element2;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Nullable
    public Icon getElementIcon(@NotNull PsiElement element2) {
        PsiObject psiObject;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = element2;
        if (!(psiElement instanceof PsiObject)) {
            psiElement = null;
        }
        if ((psiObject = (PsiObject)psiElement) == null || (psiObject = psiObject.getKind()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiObject, (String)"(element as? PsiObject)?.kind ?: return null");
        PsiObject kind = psiObject;
        return DbPresentation.getIcon((ObjectKind)kind);
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (!(element2 instanceof PsiObject)) {
            return null;
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(element2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(element)");
        Dbms dbms = sqlLanguageDialectEx.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"SqlImplUtil.getSqlDialectSafe(element).dbms");
        Dbms dbms2 = dbms;
        String string = DbPresentation.getPresentableName((DasObject)element2, true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DbPresentation.getPresentableName(element, true)");
        String name = string;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        if (element2 instanceof DasRoutine) {
            String string2;
            switch (SqlBreadcrumbsProvider$WhenMappings.$EnumSwitchMapping$0[((DasRoutine)element2).getRoutineKind().ordinal()]) {
                case 1: {
                    string2 = "procedure";
                    break;
                }
                case 2: {
                    string2 = "function";
                    break;
                }
                default: {
                    string2 = "routine";
                }
            }
            String string3 = string2;
            boolean bl6 = false;
            boolean bl7 = false;
            String it2 = string3;
            boolean bl8 = false;
            $this$buildString.append(it2);
            $this$buildString.append(' ' + name);
            JBIterable jBIterable = JBIterable.from((Iterable)((DasRoutine)element2).getArguments()).filter((Condition)getElementTooltip.1.2.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(element.\u2026argumentDirection.isOut }");
            CollectionsKt.joinTo$default((Iterable)((Iterable)jBIterable), (Appendable)$this$buildString, null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)getElementTooltip.1.3.INSTANCE, (int)50, null);
            DasArgument dasArgument = ((DasRoutine)element2).getReturnArgument();
            if (dasArgument != null) {
                string3 = dasArgument;
                bl6 = false;
                bl7 = false;
                it2 = string3;
                boolean bl9 = false;
                $this$buildString.append(": ");
                String string4 = it2;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it");
                DataType dataType = string4.getDataType();
                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"it.dataType");
                $this$buildString.append(dataType.getSpecification());
            }
        } else {
            $this$buildString.append(DbPresentation.getPresentableName(((PsiObject)element2).getKind(), dbms2));
            $this$buildString.append(' ' + name);
            if (element2 instanceof DasTypedObject) {
                $this$buildString.append(": ");
                DataType dataType = ((DasTypedObject)element2).getDataType();
                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"element.dataType");
                $this$buildString.append(dataType.getSpecification());
            }
        }
        String string5 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
        return string5;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/sql/editor/SqlBreadcrumbsProvider$Companion;", "", "()V", "MAX_LENGTH", "", "intellij.database.sql.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

