/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasTypedObjectEx;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DasUserDefinedTypeEx;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbCustomType;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeService;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlTypeSystemBase
extends SqlTypeSystem {
    private final SqlLanguageDialectEx myDialect;
    private final Object myLock = new Object();
    private Map<SqlType.Category, SqlType> myPrimitiveTypes;

    protected SqlTypeSystemBase(SqlLanguageDialectEx dialect) {
        this.myDialect = dialect;
    }

    @NotNull
    public final SqlLanguageDialectEx getDialect() {
        SqlLanguageDialectEx sqlLanguageDialectEx = this.myDialect;
        if (sqlLanguageDialectEx == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(0);
        }
        return sqlLanguageDialectEx;
    }

    @NotNull
    public final DasTypeService getTypeService() {
        DasTypeService dasTypeService = this.getDialect().getTypeService();
        if (dasTypeService == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(1);
        }
        return dasTypeService;
    }

    public SqlType booleanType() {
        return this.primitiveType(SqlType.Category.BOOLEAN);
    }

    public SqlType stringType() {
        return this.primitiveType(SqlType.Category.STRING);
    }

    public SqlType integerType() {
        return this.primitiveType(SqlType.Category.INTEGER);
    }

    public SqlType realType() {
        return this.primitiveType(SqlType.Category.REAL);
    }

    public SqlType dateTimeType() {
        return this.primitiveType(SqlType.Category.DATE_TIME);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name) {
        if (name == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(2);
        }
        if (NamingServices.getNamingService(this.myDialect.getDbms()).isQuoted(name)) {
            String string = name;
            if (string == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(3);
            }
            return string;
        }
        Case casing = this.myDialect.getCasing((ObjectKind)ObjectKind.OBJECT_TYPE, null).plain;
        if (casing == Case.MIXED) {
            casing = Case.LOWER;
        }
        String string = casing.apply(name);
        if (string == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public DataType normalizeType(@NotNull DataType type) {
        String name;
        if (type == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(5);
        }
        if (type.typeName.equals(name = this.getNormalizedTypeName(type.typeName))) {
            DataType dataType = type;
            if (dataType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(6);
            }
            return dataType;
        }
        DataType dataType = DataTypeFactory.withTypeName(type, name);
        if (dataType == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(7);
        }
        return dataType;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(8);
        }
        switch (cat) {
            case INTEGER: {
                return "integer";
            }
            case REAL: {
                return "decimal";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "bytes";
            }
            case ARRAY: {
                return "array";
            }
            case TABLE: {
                return "table";
            }
            case RECORD: {
                return "record";
            }
            case REFERENCE: {
                return null;
            }
            case UNKNOWN: {
                return null;
            }
            case DEFAULT: {
                return null;
            }
        }
        return null;
    }

    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        String fixed;
        if (typeName == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(9);
        }
        if ((fixed = StringUtil.toUpperCase((String)typeName)).contains("BINARY")) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(10);
            }
            return category;
        }
        if (fixed.contains("BOOL")) {
            SqlType.Category category = SqlType.Category.BOOLEAN;
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(11);
            }
            return category;
        }
        if (fixed.equals("DATE")) {
            SqlType.Category category = SqlType.Category.DATE;
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(12);
            }
            return category;
        }
        if (fixed.equals("TIME")) {
            SqlType.Category category = SqlType.Category.TIME;
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(13);
            }
            return category;
        }
        if (fixed.equals("TIMESTAMP")) {
            SqlType.Category category = SqlType.Category.TIMESTAMP;
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(14);
            }
            return category;
        }
        if (fixed.contains("DATE") || fixed.contains("TIME")) {
            SqlType.Category category = SqlType.Category.DATE_TIME;
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(15);
            }
            return category;
        }
        if (fixed.contains("REAL") || fixed.contains("DOUBLE") || fixed.contains("FLOAT") || fixed.contains("NUMBER")) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(16);
            }
            return category;
        }
        if (fixed.contains("INTERVAL")) {
            SqlType.Category category = SqlType.Category.INTERVAL;
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(17);
            }
            return category;
        }
        if (fixed.contains("INT")) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(18);
            }
            return category;
        }
        if (fixed.contains("CHAR")) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(19);
            }
            return category;
        }
        if (fixed.contains("TEXT")) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(20);
            }
            return category;
        }
        if (fixed.contains("REFERENCE")) {
            SqlType.Category category = SqlType.Category.REFERENCE;
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(21);
            }
            return category;
        }
        if (fixed.contains("RECORD")) {
            SqlType.Category category = SqlType.Category.RECORD;
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(22);
            }
            return category;
        }
        SqlType.Category category = SqlType.Category.UNKNOWN;
        if (category == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(23);
        }
        return category;
    }

    @NotNull
    public SqlType.Category getTypeCategory(@NotNull DataType dataType) {
        int type;
        String name;
        SqlType.Category cat;
        if (dataType == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(24);
        }
        if ((cat = this.getTypeCategoryByName(name = this.getNormalizedTypeName(dataType.typeName))) != SqlType.Category.UNKNOWN) {
            SqlType.Category category = cat;
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(25);
            }
            return category;
        }
        int n = type = dataType.jdbcType == 0 ? this.myDialect.getDatabaseDialect().getJavaTypeForNativeType(name) : dataType.jdbcType;
        if (type != 1111) {
            SqlType.Category category = SqlType.Category.findByJdbcType((int)type);
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(26);
            }
            return category;
        }
        if (StringUtil.isEmpty((String)name)) {
            SqlType.Category category = SqlType.Category.UNKNOWN;
            if (category == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(27);
            }
            return category;
        }
        SqlType.Category category = cat;
        if (category == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(28);
        }
        return category;
    }

    @NotNull
    public SqlType getDefinitionType(@NotNull SqlTypedDefinition definition, @Nullable PsiElement usage) {
        if (definition == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(29);
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(30);
        }
        return sqlPrimitiveType;
    }

    @NotNull
    public DasType getDasType(@Nullable SqlReferenceImpl ref, @Nullable PsiElement resolved, @Nullable DasSymbol symbol) {
        ObjectKind kind;
        DasObject target;
        Object delegate;
        DasObject dasObject;
        if (ref == null && resolved == null) {
            DasType dasType = DasType.UNKNOWN;
            if (dasType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(31);
            }
            return dasType;
        }
        PsiElement refElement = ref == null ? null : ref.getElement();
        DasObject dasObject2 = dasObject = symbol != null ? symbol.getDasObject() : null;
        if (dasObject instanceof DasSynonym) {
            dasObject = DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)dasObject));
        }
        if (dasObject instanceof DbElement && (delegate = ((DbElement)dasObject).getDelegate()) instanceof DasObject) {
            dasObject = (DasObject)delegate;
        }
        Object object = target = dasObject != null ? dasObject : resolved;
        if (target == refElement && SqlImplUtil.isAsteriskRef(refElement)) {
            SqlType asteriskType = this.getAsteriskType(refElement);
            Object object2 = asteriskType instanceof SqlTableType ? (SqlTableType)asteriskType : DasType.UNKNOWN;
            if (object2 == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(32);
            }
            return object2;
        }
        ObjectKind objectKind = kind = ref == null ? ObjectKind.NONE : ref.getReferenceElementType().getTargetKind();
        if (kind == ObjectKind.SEQUENCE || target instanceof DasObject && target.getKind() == ObjectKind.SEQUENCE) {
            SqlTableType sqlTableType = this.createSequenceType(refElement == null ? resolved : refElement, resolved);
            if (sqlTableType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(33);
            }
            return sqlTableType;
        }
        if (target instanceof DasTable) {
            SqlTableType sqlTableType = SqlTableTypeBase.createType((DasTable)target, resolved, refElement);
            if (sqlTableType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(34);
            }
            return sqlTableType;
        }
        if (target instanceof DasTypedObjectEx) {
            DasType dasType = ((DasTypedObjectEx)target).getDasType();
            if (dasType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(35);
            }
            return dasType;
        }
        if (target instanceof DasUserDefinedTypeEx) {
            DasType dasType = ((DasUserDefinedTypeEx)target).getDasType();
            if (dasType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(36);
            }
            return dasType;
        }
        if (target instanceof SqlFileImpl.GroupImpl && ((SqlFileImpl.GroupImpl)target).getKind() == ObjectKind.OBJECT_TYPE) {
            SqlCreateTypeStatement o = (SqlCreateTypeStatement)((SqlFileImpl.GroupImpl)target).delegates().filter(SqlCreateTypeStatement.class).first();
            DasType dasType = o != null ? o.getDasType() : DasType.UNKNOWN;
            if (dasType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(37);
            }
            return dasType;
        }
        if (target == refElement) {
            DasType dasType = DasType.UNKNOWN;
            if (dasType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(38);
            }
            return dasType;
        }
        if (target instanceof SqlExpression) {
            DasType dasType = ((SqlExpression)target).getDasType();
            if (dasType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(39);
            }
            return dasType;
        }
        DasType dasType = DasType.UNKNOWN;
        if (dasType == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(40);
        }
        return dasType;
    }

    @NotNull
    public SqlType getSqlType(@Nullable SqlReferenceImpl ref, @Nullable PsiElement resolved, @Nullable DasSymbol symbol) {
        ObjectKind kind;
        DbElement dbElement;
        SqlType typeFromDb;
        PsiElement target;
        DasObject dasObject;
        if (ref == null && resolved == null) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(41);
            }
            return sqlPrimitiveType;
        }
        PsiElement refElement = ref == null ? null : ref.getElement();
        DasObject dasObject2 = dasObject = symbol != null ? symbol.getDasObject() : null;
        if (dasObject instanceof ReservedEntity.Typed) {
            SqlType sqlType = ((ReservedEntity.Typed)dasObject).type;
            if (sqlType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(42);
            }
            return sqlType;
        }
        Object object = target = dasObject != null && !(dasObject instanceof ReservedEntity) ? dasObject : resolved;
        if (target instanceof DbElement && (typeFromDb = DbImplUtilCore.getDatabaseDialect(dbElement = (DbElement)target).getSqlType(refElement, dbElement)) != null) {
            SqlType sqlType = typeFromDb;
            if (sqlType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(43);
            }
            return sqlType;
        }
        ObjectKind objectKind = kind = ref == null ? ObjectKind.NONE : ref.getReferenceElementType().getTargetKind();
        if (target == refElement && SqlImplUtil.isAsteriskRef(refElement)) {
            return this.getAsteriskType(refElement);
        }
        if (kind == ObjectKind.SEQUENCE || target instanceof DasObject && ((DasObject)target).getKind() == ObjectKind.SEQUENCE) {
            SqlTableType sqlTableType = this.createSequenceType(refElement == null ? resolved : refElement, resolved);
            if (sqlTableType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(44);
            }
            return sqlTableType;
        }
        if (target instanceof DasRoutine && refElement instanceof SqlReferenceExpression) {
            SqlType sqlType = SqlFunctionCallExpressionImpl.createFunctionReturnType((SqlReferenceExpression)refElement, refElement);
            if (sqlType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(45);
            }
            return sqlType;
        }
        if (target instanceof DasTable) {
            SqlTableType sqlTableType = SqlTableTypeBase.createType((DasTable)target, resolved, refElement);
            if (sqlTableType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(46);
            }
            return sqlTableType;
        }
        if (target instanceof SqlCreateTypeStatement) {
            SqlType type = ((SqlCreateTypeStatement)target).getSqlType();
            Object object2 = type == null ? SqlType.UNKNOWN : type;
            if (object2 == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(47);
            }
            return object2;
        }
        if (target instanceof SqlFileImpl.GroupImpl && ((SqlFileImpl.GroupImpl)target).getKind() == ObjectKind.OBJECT_TYPE) {
            SqlCreateTypeStatement o = (SqlCreateTypeStatement)((SqlFileImpl.GroupImpl)target).delegates().filter(SqlCreateTypeStatement.class).first();
            SqlType type = o == null ? null : o.getSqlType();
            Object object3 = type == null ? SqlType.UNKNOWN : type;
            if (object3 == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(48);
            }
            return object3;
        }
        if (target instanceof SqlTypedDefinition) {
            SqlTypedDefinition definition = (SqlTypedDefinition)target;
            SqlType type = SqlImplUtil.getSqlType(definition, this.myDialect, refElement);
            SqlType sqlType = type == SqlType.UNKNOWN ? this.getReservedEntityType(definition.getName(), kind, (PsiElement)definition) : type;
            if (sqlType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(49);
            }
            return sqlType;
        }
        if (target instanceof DasObject && ((DasObject)target).getKind() == ObjectKind.OBJECT_TYPE) {
            DasUserDefinedType customType = (DasUserDefinedType)ObjectUtils.tryCast((Object)target, DasUserDefinedType.class);
            if (customType != null && customType.getSuperType() == null && customType.getDasChildren(ObjectKind.OBJECT_ATTRIBUTE).filter(DasTypedObject.class).isEmpty()) {
                SqlType customSqlType;
                DataType dataType = this.myDialect.getDatabaseDialect().convertUDTToDataType(customType);
                SqlType sqlType = customSqlType = dataType == null ? null : SqlTypeFactory.of(dataType, this.myDialect);
                Object object4 = customSqlType != null ? customSqlType : (resolved != null ? SqlImplUtil.getSqlType(customType, resolved, this.myDialect) : SqlType.UNKNOWN);
                if (object4 == null) {
                    SqlTypeSystemBase.$$$reportNull$$$0(50);
                }
                return object4;
            }
            Object object5 = resolved != null ? SqlTableTypeBase.createObjectTypeType((DasObject)target, resolved, refElement) : SqlType.UNKNOWN;
            if (object5 == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(51);
            }
            return object5;
        }
        if (target instanceof DasSynonym) {
            DasTable info;
            DasObject synonymTarget = DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)target));
            DasTable dasTable = info = synonymTarget instanceof DasTable ? (DasTable)synonymTarget : null;
            if (info == null || resolved == null) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    SqlTypeSystemBase.$$$reportNull$$$0(52);
                }
                return sqlPrimitiveType;
            }
            PsiElement tablePsi = SqlImplUtil.wrapObjectToPsi((DasObject)info, resolved.getProject());
            SqlTableType sqlTableType = SqlTableTypeBase.createType(info, tablePsi, refElement);
            if (sqlTableType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(53);
            }
            return sqlTableType;
        }
        if (target instanceof DasColumn) {
            Object object6 = resolved != null ? SqlImplUtil.getSqlType((DasTypedObject)((DasColumn)target), this.myDialect, resolved) : SqlType.UNKNOWN;
            if (object6 == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(54);
            }
            return object6;
        }
        if (target == null && DbImplUtilCore.isTypeKind(kind)) {
            String name = ref.getReferenceName();
            Object object7 = StringUtil.isEmpty((String)name) ? SqlType.UNKNOWN : SqlTypeFactory.of(DataTypeFactory.of(name), this.myDialect);
            if (object7 == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(55);
            }
            return object7;
        }
        if (target == refElement) {
            SqlType sqlType = this.getReservedEntityType(ref.getReferenceName(), kind, refElement);
            if (sqlType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(56);
            }
            return sqlType;
        }
        if (target instanceof BuiltinFunction && refElement != null && refElement.getParent() instanceof SqlFunctionCallExpression) {
            SqlType sqlType = ((SqlFunctionCallExpression)refElement.getParent()).getSqlType();
            if (sqlType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(57);
            }
            return sqlType;
        }
        if (target instanceof SqlExpression) {
            SqlType sqlType = ((SqlExpression)target).getSqlType();
            if (sqlType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(58);
            }
            return sqlType;
        }
        if (target instanceof SqlColumnSymbol) {
            SqlType sqlType = ((SqlColumnSymbol)target).getType();
            if (sqlType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(59);
            }
            return sqlType;
        }
        if (target instanceof SqlDefinition && ((SqlDefinition)target).getParent() instanceof SqlSelectIntoClause) {
            SqlSelectClause clause = (SqlSelectClause)PsiTreeUtil.getPrevSiblingOfType((PsiElement)((SqlDefinition)target).getParent(), SqlSelectClause.class);
            if (clause != null) {
                SqlTableType sqlTableType = SqlImplUtil.getSelectType(clause.getExpressions(), target);
                if (sqlTableType == null) {
                    SqlTypeSystemBase.$$$reportNull$$$0(60);
                }
                return sqlTableType;
            }
        } else {
            if (kind == ObjectKind.TABLE) {
                SqlTableType sqlTableType = SqlTableTypeBase.createUnresolvedTableType((PsiReference)ref);
                if (sqlTableType == null) {
                    SqlTypeSystemBase.$$$reportNull$$$0(61);
                }
                return sqlTableType;
            }
            if (target instanceof DbCustomType && ((DbCustomType)target).getDelegate() instanceof DasTypedObject) {
                Object object8 = resolved != null ? SqlImplUtil.getSqlType((DasTypedObject)((DbCustomType)target).getDelegate(), this.myDialect, resolved) : SqlType.UNKNOWN;
                if (object8 == null) {
                    SqlTypeSystemBase.$$$reportNull$$$0(62);
                }
                return object8;
            }
            if (target instanceof DasTypedObject) {
                Object object9 = resolved != null ? SqlImplUtil.getSqlType((DasTypedObject)target, this.myDialect, resolved) : SqlType.UNKNOWN;
                if (object9 == null) {
                    SqlTypeSystemBase.$$$reportNull$$$0(63);
                }
                return object9;
            }
            if (target instanceof DasUserDefinedType) {
                Object object10 = resolved != null ? SqlImplUtil.getSqlType((DasUserDefinedType)target, resolved, this.myDialect) : SqlType.UNKNOWN;
                if (object10 == null) {
                    SqlTypeSystemBase.$$$reportNull$$$0(64);
                }
                return object10;
            }
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(65);
        }
        return sqlPrimitiveType;
    }

    @Nullable
    public SqlType getUnqualifiedAsteriskType(@NotNull PsiElement element2) {
        SqlQueryExpression queryExpression;
        if (element2 == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(66);
        }
        SqlTableExpression tableExpression = (queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlQueryExpression.class, (boolean)true)) == null ? null : queryExpression.getTableExpression();
        return tableExpression == null ? null : tableExpression.getSqlType();
    }

    @Nullable
    public SqlType getBuiltinFunctionReturnType(@NotNull SqlFunctionDefinition.Prototype prototype, @Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params, @NotNull PsiElement routineElement) {
        if (prototype == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(67);
        }
        if (routineElement == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(68);
        }
        return null;
    }

    @NotNull
    public SqlTableType createSequenceType(@NotNull PsiElement element2, @Nullable PsiElement object) {
        if (element2 == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(69);
        }
        SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
        if (sqlTableType == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(70);
        }
        return sqlTableType;
    }

    public boolean isTriggerFunctionType(@NotNull DataType returnType) {
        if (returnType == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(71);
        }
        return false;
    }

    public boolean supportsImplicitConversion(@NotNull DataType fromType, @NotNull DataType toType) {
        if (fromType == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(72);
        }
        if (toType == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(73);
        }
        return true;
    }

    @NotNull
    public Map<String, DeprecatedTypeInfo> getDeprecatedTypes(@NotNull PsiFile contextFile) {
        if (contextFile == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(74);
        }
        Map<String, DeprecatedTypeInfo> map2 = Collections.emptyMap();
        if (map2 == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(75);
        }
        return map2;
    }

    @NotNull
    private SqlType getAsteriskType(@NotNull PsiElement element2) {
        SqlType targetType;
        if (element2 == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(76);
        }
        PsiElement parent2 = element2.getParent();
        SqlExpression qualifier = element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).getQualifierExpression() : null;
        SqlType sqlType = targetType = qualifier != null ? qualifier.getSqlType() : this.getUnqualifiedAsteriskType(element2);
        if (targetType == null) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            if (sqlTableType == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(77);
            }
            return sqlTableType;
        }
        Dbms dbms = this.myDialect.getDbms();
        if (dbms == Dbms.CLICKHOUSE || dbms == Dbms.VERTICA) {
            SqlType sqlType2 = targetType;
            if (sqlType2 == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(78);
            }
            return sqlType2;
        }
        if (parent2 instanceof SqlExpressionList && dbms.isPostgres() && qualifier != null) {
            SqlType sqlType3 = targetType;
            if (sqlType3 == null) {
                SqlTypeSystemBase.$$$reportNull$$$0(79);
            }
            return sqlType3;
        }
        if (parent2 instanceof SqlExpressionList && parent2.getParent() instanceof SqlFunctionCallExpression) {
            BuiltinFunction definition = ((SqlFunctionCallExpression)parent2.getParent()).getFunctionDefinition();
            if (definition == null) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    SqlTypeSystemBase.$$$reportNull$$$0(80);
                }
                return sqlPrimitiveType;
            }
            if (qualifier != null && !this.myDialect.getDatabaseDialect().supportsQualifiedAsteriskInCalls() || !Comparing.strEqual((String)definition.getName(), (String)"count", (boolean)false) && (!dbms.isMicrosoft() || !Comparing.strEqual((String)definition.getName(), (String)"count_big", (boolean)false))) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    SqlTypeSystemBase.$$$reportNull$$$0(81);
                }
                return sqlPrimitiveType;
            }
        } else {
            PsiElement curParent = parent2;
            while (curParent instanceof SqlReferenceExpression) {
                curParent = curParent.getParent();
            }
            if (dbms.isPostgres() || dbms.isHsqldb() || dbms.isH2()) {
                while (curParent instanceof SqlParenthesizedExpression) {
                    curParent = curParent.getParent();
                }
            }
            if (!(curParent instanceof SqlSelectClause || curParent instanceof SqlDmlInstruction || curParent instanceof SqlFromClause && curParent.getParent() instanceof SqlDmlInstruction || dbms.isMysql() && PsiUtilCore.getElementType((PsiElement)curParent) == SqlCompositeElementTypes.SQL_CLAUSE && curParent.getParent() instanceof SqlDmlInstruction)) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    SqlTypeSystemBase.$$$reportNull$$$0(82);
                }
                return sqlPrimitiveType;
            }
        }
        SqlType sqlType4 = targetType;
        if (sqlType4 == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(83);
        }
        return sqlType4;
    }

    private SqlType getReservedEntityType(@Nullable String name, @NotNull ObjectKind kind, @NotNull PsiElement element2) {
        if (kind == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(84);
        }
        if (element2 == null) {
            SqlTypeSystemBase.$$$reportNull$$$0(85);
        }
        final Ref ref = Ref.create();
        this.myDialect.processReservedEntitiesWithType(name, element2, true, new SqlScopeProcessorBase(name, this.myDialect, Collections.emptyList(), element2){

            public boolean isResultEmpty() {
                return ref.isNull();
            }

            public boolean executeTarget(@NotNull DasSymbol symbol, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (sqlType != null) {
                    ref.set((Object)sqlType);
                }
                return sqlType == null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "symbol";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/dialects/SqlTypeSystemBase$1";
                objectArray[2] = "executeTarget";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!ref.isNull()) {
            return (SqlType)ref.get();
        }
        if (kind == ObjectKind.TABLE) {
            return SqlTableTypeBase.EMPTY_TABLE;
        }
        if (StringUtil.isNotEmpty((String)name) && DbImplUtilCore.isTypeKind(kind)) {
            return SqlTypeFactory.of(DataTypeFactory.of(name), this.myDialect);
        }
        return SqlType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SqlType primitiveType(SqlType.Category category) {
        Object object = this.myLock;
        synchronized (object) {
            Map<SqlType.Category, SqlType> primitiveTypes = this.myPrimitiveTypes;
            if (primitiveTypes == null) {
                this.myPrimitiveTypes = primitiveTypes = new EnumMap<SqlType.Category, SqlType>(SqlType.Category.class);
            }
            return primitiveTypes.computeIfAbsent(category, c2 -> SqlTypeFactory.defaultType(c2, this.myDialect));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 24: 
            case 29: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 84: 
            case 85: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 24: 
            case 29: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 84: 
            case 85: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlTypeSystemBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 66: 
            case 69: 
            case 76: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routineElement";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromType";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeService";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 24: 
            case 29: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlTypeSystemBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeType";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategory";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinitionType";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "createSequenceType";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeprecatedTypes";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsteriskType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "normalizeType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategory";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionType";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getUnqualifiedAsteriskType";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinFunctionReturnType";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createSequenceType";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isTriggerFunctionType";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "supportsImplicitConversion";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecatedTypes";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getAsteriskType";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getReservedEntityType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 24: 
            case 29: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 84: 
            case 85: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DeprecatedTypeInfo {
        private final String myDescriptionKey;
        private final List<String> myReplacements;

        public DeprecatedTypeInfo(String key, List<String> replacements) {
            this.myDescriptionKey = key;
            this.myReplacements = replacements;
        }

        public String getDescriptionKey() {
            return this.myDescriptionKey;
        }

        public List<String> getReplacements() {
            return this.myReplacements;
        }
    }
}

