/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.view.ui.DbCheckBoxTree;
import com.intellij.database.view.ui.DbSchemasSelector;
import com.intellij.database.view.ui.DbSchemasTree;
import com.intellij.openapi.project.Project;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.FilteringTree;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlResolveEditor
extends DbSchemasSelector {
    protected TreePattern mySelectedScope;
    protected TreePattern myPermStructure;

    public SqlResolveEditor(@NotNull Project project) {
        if (project == null) {
            SqlResolveEditor.$$$reportNull$$$0(0);
        }
        super(project);
        this.mySelectedScope = TreePattern.EMPTY;
        this.myPermStructure = TreePattern.EMPTY;
    }

    @Override
    @NotNull
    public MyTree createTree(@NotNull Project project) {
        if (project == null) {
            SqlResolveEditor.$$$reportNull$$$0(1);
        }
        return new MyTree(this, project, new DbSchemasTree.MyNode(null, null, null){

            @Override
            @NotNull
            public JBIterable<BasicMetaObject<?>> getWildcardMetas() {
                JBIterable jBIterable = JBIterable.of(DbImplUtilCore.getMetaModel((Dbms)Dbms.UNKNOWN).root);
                if (jBIterable == null) {
                    1.$$$reportNull$$$0(0);
                }
                return jBIterable;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveEditor$1", "getWildcardMetas"));
            }
        });
    }

    public void setPatterns(@Nullable TreePattern selection, @Nullable TreePattern structure) {
        boolean structChanged;
        boolean permStructChanged;
        if (selection == null && structure == null) {
            return;
        }
        boolean selChanged = selection != null && !selection.equals(this.mySelectedScope);
        if (selChanged) {
            this.mySelectedScope = selection;
        }
        if (permStructChanged = structure != null && !structure.equals(this.myPermStructure)) {
            this.myPermStructure = structure;
        }
        boolean bl = structChanged = permStructChanged || selChanged;
        if (selChanged) {
            this.recheck(this.mySelectedScope);
        }
        DbUIUtil.invokeLater(() -> {
            if (structChanged) {
                TreePattern tempStructure = TreePatternUtils.union(this.myPermStructure, this.mySelectedScope);
                if (permStructChanged || tempStructure != this.myPermStructure) {
                    this.createShadowStructure((DbSchemasTree.MyNode)this.myTree.getSearchModel().getRootObject(), tempStructure);
                    this.myTree.getSearchModel().updateStructure();
                }
            }
            this.recheck(this.mySelectedScope);
            this.onSetPatternReady();
        });
    }

    protected void onSetPatternReady() {
    }

    private void createShadowStructure(@NotNull DbSchemasTree.MyNode root2, @NotNull TreePattern pattern) {
        if (root2 == null) {
            SqlResolveEditor.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            SqlResolveEditor.$$$reportNull$$$0(3);
        }
        this.fillShadowChildren(root2, pattern.root);
    }

    private void fillShadowChildren(@NotNull DbSchemasTree.MyNode root2, @NotNull TreePatternNode<?> tn) {
        if (root2 == null) {
            SqlResolveEditor.$$$reportNull$$$0(4);
        }
        if (tn == null) {
            SqlResolveEditor.$$$reportNull$$$0(5);
        }
        SmartList nodes = new SmartList();
        for (DbSchemasTree.MyNode node : root2.getChildNodes()) {
            nodes.clear();
            if (tn.matchedChildren(ObjectName.quoted((String)SqlResolveEditor.getNodeName(node)), Casing.EXACT, (ObjectKind)ObjectUtils.chooseNotNull((Object)node.getKind(), (Object)ObjectKind.NONE), (Collection<TreePatternNode<?>>)nodes)) {
                this.fillShadowObjects(node, (TreePatternNode)nodes.get(0));
                continue;
            }
            node.purgeShadow();
        }
    }

    private void fillShadowObjects(@NotNull DbSchemasTree.MyNode p2, @NotNull TreePatternNode<?> tn) {
        if (p2 == null) {
            SqlResolveEditor.$$$reportNull$$$0(6);
        }
        if (tn == null) {
            SqlResolveEditor.$$$reportNull$$$0(7);
        }
        ArrayList<DbSchemasTree.MyNode> shadow = new ArrayList<DbSchemasTree.MyNode>();
        Map<String, DbSchemasTree.MyNode> childObjects = SqlResolveEditor.fillNodesCache(p2.getChildren());
        Map<String, DbSchemasTree.MyNode> oldSchemasCache = SqlResolveEditor.fillNodesCache(p2.getShadowChildren());
        for (TreePatternNode.Group group : tn.groups) {
            for (ObjectName n2 : JBIterable.of((Object[])group.positiveChildren).append(group.negativeChild).flatten(n -> JBIterable.of((Object[])((TreePatternNode.BaseNaming)n.naming).names))) {
                if (childObjects.containsKey(n2.name)) continue;
                DbSchemasTree.MyNode child = oldSchemasCache.get(n2.name);
                if (child == null) {
                    child = new DbSchemasTree.MyNode(n2.name, p2.findChild(group.kind), n2.name);
                    childObjects.put(n2.name, child);
                }
                shadow.add(child);
            }
        }
        p2.setShadowChildren(shadow);
        this.fillShadowChildren(p2, tn);
    }

    private void recheck(@NotNull TreePattern pattern) {
        if (pattern == null) {
            SqlResolveEditor.$$$reportNull$$$0(8);
        }
        FilteringTree.SearchTreeModel model = this.myTree.getSearchModel();
        DbSchemasTree.MyNode root2 = (DbSchemasTree.MyNode)model.getRootObject();
        root2.setChecked(true);
        SqlResolveEditor.recheck(root2, pattern.root);
        this.myTree.getTree().updateFromNodes();
    }

    private static void recheck(@NotNull DbSchemasTree.MyNode node, @Nullable TreePatternNode<?> tn) {
        TreePatternNode.Group group;
        if (node == null) {
            SqlResolveEditor.$$$reportNull$$$0(9);
        }
        SmartList nodes = new SmartList();
        List allNodes = node.getAllNodes();
        if (allNodes != null) {
            for (DbSchemasTree.MyNode allNode : allNodes) {
                group = tn == null ? null : tn.getGroup(allNode.getKind());
                allNode.setChecked(group != null && group.negativeChild != null);
            }
        }
        for (DbSchemasTree.MyNode child : node.getSimpleChildNodes()) {
            nodes.clear();
            TreePatternNode.Group group2 = group = tn == null ? null : tn.getGroup(child.getKind());
            if (group != null && node.getAllNodeState() != ThreeState.YES && group.matchedChildren(ObjectName.quoted((String)SqlResolveEditor.getNodeName(child)), Casing.EXACT, (Collection<TreePatternNode<?>>)nodes)) {
                child.setChecked(true);
                SqlResolveEditor.recheck(child, (TreePatternNode)nodes.get(0));
                continue;
            }
            child.setChecked(false);
            SqlResolveEditor.recheck(child, null);
        }
    }

    @NotNull
    public TreePattern getPattern() {
        DbSchemasTree.MyNode root2 = (DbSchemasTree.MyNode)this.myTree.getSearchModel().getRootObject();
        TreePattern treePattern = TreePatternUtils.sorted(new TreePattern(this.getGroups(root2)));
        if (treePattern == null) {
            SqlResolveEditor.$$$reportNull$$$0(10);
        }
        return treePattern;
    }

    private TreePatternNode.Group[] getGroups(@NotNull DbSchemasTree.MyNode node) {
        if (node == null) {
            SqlResolveEditor.$$$reportNull$$$0(11);
        }
        Map nodes = ContainerUtil.classify((Iterator)JBIterable.from(node.getSimpleChildNodes()).filter(DbCheckBoxTree.MyNode::isChecked).iterator(), DbCheckBoxTree.MyNode::getKind);
        ArrayList<TreePatternNode.Group> res2 = new ArrayList<TreePatternNode.Group>();
        for (DbSchemasTree.MyNode myNode : node.iterAllNodes()) {
            ObjectKind kind;
            if (!myNode.isChecked() || (kind = myNode.getKind()) == null) continue;
            nodes.remove(kind);
            res2.add(TreePatternUtils.create(ObjectName.NULL, kind, TreePatternNode.NO_GROUPS));
        }
        for (Map.Entry entry : nodes.entrySet()) {
            TreePatternUtils.GroupBuilder builder = new TreePatternUtils.GroupBuilder();
            for (DbSchemasTree.MyNode child : (Set)entry.getValue()) {
                this.append(builder, child);
            }
            builder.deduplicate();
            res2.add(builder.build((ObjectKind)entry.getKey()));
        }
        return res2.toArray(TreePatternNode.NO_GROUPS);
    }

    private void append(@NotNull TreePatternUtils.GroupBuilder builder, @NotNull DbSchemasTree.MyNode node) {
        if (builder == null) {
            SqlResolveEditor.$$$reportNull$$$0(12);
        }
        if (node == null) {
            SqlResolveEditor.$$$reportNull$$$0(13);
        }
        builder.positives.add(new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(ObjectName.quoted((String)SqlResolveEditor.getNodeName(node))), this.getGroups(node)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tn";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlResolveEditor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlResolveEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createShadowStructure";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillShadowChildren";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillShadowObjects";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "recheck";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getGroups";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTree
    extends DbSchemasSelector.TreeEditor {
        final /* synthetic */ SqlResolveEditor this$0;

        MyTree(@NotNull SqlResolveEditor sqlResolveEditor, Project project, DbSchemasTree.MyNode root2) {
            if (project == null) {
                MyTree.$$$reportNull$$$0(0);
            }
            this(sqlResolveEditor, project, DbSchemasTree.createNode(root2));
        }

        private MyTree(@NotNull SqlResolveEditor sqlResolveEditor, Project project, CheckedTreeNode root2) {
            if (project == null) {
                MyTree.$$$reportNull$$$0(1);
            }
            this.this$0 = sqlResolveEditor;
            super(project, (Tree)new DbSchemasTree(root2), root2);
        }

        @Override
        protected void createShadowStructure(@NotNull DbSchemasTree.MyNode root2) {
            if (root2 == null) {
                MyTree.$$$reportNull$$$0(2);
            }
            this.this$0.createShadowStructure(root2, TreePatternUtils.union(this.this$0.myPermStructure, this.this$0.mySelectedScope));
        }

        @Override
        @NotNull
        protected ObjectKind getDsKind() {
            ObjectKind objectKind = SqlImportUtil.DATA_SOURCE;
            if (objectKind == null) {
                MyTree.$$$reportNull$$$0(3);
            }
            return objectKind;
        }

        @Override
        protected boolean hasAll(@Nullable Object obj) {
            if (obj == null) {
                return true;
            }
            if (obj instanceof DasDataSource) {
                return !DbSchemasSelector.isSingleRoot((DasDataSource)obj);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/SqlResolveEditor$MyTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/SqlResolveEditor$MyTree";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDsKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createShadowStructure";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

