/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlResolveMappings;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlImportUtilCore {
    public static final ObjectKind DATA_SOURCE = ObjectKind.ROOT;
    public static final ObjectName NON_MATCHING_NAME = ObjectName.quoted((String)"SOME NON MATCHING NAME");
    public static final ObjectName[] NON_MATCHING_NAMES = (ObjectName[])ContainerUtil.ar((Object[])new ObjectName[]{NON_MATCHING_NAME});

    protected SqlImportUtilCore() {
    }

    @NotNull
    public static ObjectName getDataSourceName(@NotNull DasDataSource dataSource2) {
        String id;
        if (dataSource2 == null) {
            SqlImportUtilCore.$$$reportNull$$$0(0);
        }
        ObjectName objectName = ObjectName.quoted((String)(StringUtil.isEmpty((String)(id = dataSource2.getUniqueId())) ? dataSource2.getName() : id));
        if (objectName == null) {
            SqlImportUtilCore.$$$reportNull$$$0(1);
        }
        return objectName;
    }

    public static ObjectName @Nullable [] getRealDsNames(@Nullable DbDataSource dataSource2) {
        if (dataSource2 == null) {
            return null;
        }
        if (!(dataSource2.getDelegate() instanceof SqlDataSource)) {
            return (ObjectName[])ContainerUtil.ar((Object[])new ObjectName[]{SqlImportUtilCore.getDataSourceName((DasDataSource)dataSource2)});
        }
        SmartList res2 = new SmartList();
        do {
            res2.add(SqlImportUtilCore.getDataSourceName((DasDataSource)dataSource2));
        } while ((dataSource2 = dataSource2.getDelegate() instanceof SqlDataSource ? ((SqlDataSource)dataSource2.getDelegate()).getParentDataSource() : null) != null);
        return ObjectName.toArray((Iterable)res2);
    }

    @NotNull
    public static TreePatternNode.Group createDataSources(ObjectName @Nullable [] names, TreePatternNode.Group ... groups) {
        TreePatternNode.Group group = TreePatternUtils.create(names == null ? NON_MATCHING_NAMES : names, DATA_SOURCE, groups);
        if (group == null) {
            SqlImportUtilCore.$$$reportNull$$$0(2);
        }
        return group;
    }

    @NotNull
    static TreePattern createDefaultScopePattern(@Nullable DbDataSource ds, @NotNull SqlLanguageDialectEx language) {
        if (language == null) {
            SqlImportUtilCore.$$$reportNull$$$0(3);
        }
        TreePattern treePattern = language.getDefaultImports(ds);
        if (treePattern == null) {
            SqlImportUtilCore.$$$reportNull$$$0(4);
        }
        return treePattern;
    }

    public static TreePattern processResolveScopePattern(TreePattern resolvePattern, TreePattern defaultPattern) {
        return new TreePatternUtils.GroupedGroupFactory(){
            private boolean myAccept = false;
            private TreePatternNode.Group myUnAccept = null;

            @Override
            protected void enterGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
                TreePatternNode.Group second;
                TreePatternNode.Group first2;
                if (this.myAccept || kind == ObjectKind.NONE) {
                    return;
                }
                Iterator<TreePatternNode.Group> it2 = groups.iterator();
                TreePatternNode.Group group = first2 = it2.hasNext() ? it2.next() : null;
                if (first2 != null) {
                    return;
                }
                TreePatternNode.Group group2 = second = it2.hasNext() ? it2.next() : null;
                if (second == null) {
                    return;
                }
                this.myAccept = true;
                this.myUnAccept = second;
            }

            @Override
            protected void leaveGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
                TreePatternNode.Group second;
                if (!this.myAccept || kind == ObjectKind.NONE) {
                    return;
                }
                Iterator<TreePatternNode.Group> it2 = groups.iterator();
                if (it2.hasNext()) {
                    it2.next();
                }
                TreePatternNode.Group group = second = it2.hasNext() ? it2.next() : null;
                if (second != this.myUnAccept) {
                    return;
                }
                this.myAccept = false;
                this.myUnAccept = null;
            }

            @Override
            protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                Iterator<TreePatternNode.Group> it2 = value2.iterator();
                return this.myAccept || it2.hasNext() && it2.next() != null;
            }

            @Override
            protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                Iterator<TreePatternNode<?>> it2 = value2.iterator();
                return this.myAccept || it2.hasNext() && it2.next() != null;
            }

            @Override
            public boolean mergeChildren() {
                return false;
            }

            @Override
            public boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> groups) {
                return !1.containsNotNull(groups);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/sql/dialects/SqlImportUtilCore$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkGroup";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkNode";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.merge(Arrays.asList(resolvePattern, defaultPattern));
    }

    private static TreePatternNode.Group @Nullable [] removeNulls(TreePatternNode.Group @Nullable [] groups) {
        if (groups == null) {
            return null;
        }
        int nonNulls = 0;
        for (TreePatternNode.Group group : groups) {
            if (group == null) continue;
            ++nonNulls;
        }
        if (nonNulls == 0) {
            return TreePatternNode.NO_GROUPS;
        }
        if (nonNulls == groups.length) {
            return groups;
        }
        TreePatternNode.Group[] newGroups = new TreePatternNode.Group[nonNulls];
        int i2 = 0;
        for (TreePatternNode.Group group : groups) {
            if (group == null) continue;
            newGroups[i2++] = group;
        }
        return newGroups;
    }

    @NotNull
    public static TreePattern createPattern(@NotNull List<?> names, @NotNull List<ObjectKind> kinds, TreePatternNode.Group @Nullable [] tail) {
        if (names == null) {
            SqlImportUtilCore.$$$reportNull$$$0(5);
        }
        if (kinds == null) {
            SqlImportUtilCore.$$$reportNull$$$0(6);
        }
        TreePatternNode.Group[] children2 = (TreePatternNode.Group[])ObjectUtils.chooseNotNull((Object)SqlImportUtilCore.removeNulls(tail), (Object)TreePatternNode.NO_GROUPS);
        for (int i2 = 0; i2 < names.size(); ++i2) {
            TreePatternNode[] treePatternNodeArray;
            Object name = names.get(i2);
            ObjectKind kind = kinds.get(i2);
            TreePatternNode<TreePatternNode.PositiveNaming> p2 = null;
            TreePatternNode<TreePatternNode.NegativeNaming> n = null;
            if (name == null) {
                n = new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, children2);
            } else {
                TreePatternNode.PositiveNaming naming;
                if (name instanceof ObjectName) {
                    naming = new TreePatternNode.PositiveNaming((ObjectName)name);
                } else if (name instanceof ObjectName[]) {
                    naming = new TreePatternNode.PositiveNaming((ObjectName[])name);
                } else if (name instanceof Iterable) {
                    naming = new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)((Iterable)name)));
                } else {
                    throw new AssertionError((Object)("Unexpected: " + name.getClass().getSimpleName()));
                }
                p2 = new TreePatternNode<TreePatternNode.PositiveNaming>(naming, children2);
            }
            TreePatternNode.Group[] groupArray = new TreePatternNode.Group[1];
            if (p2 == null) {
                treePatternNodeArray = null;
            } else {
                TreePatternNode[] treePatternNodeArray2 = new TreePatternNode[1];
                treePatternNodeArray = treePatternNodeArray2;
                treePatternNodeArray2[0] = p2;
            }
            groupArray[0] = new TreePatternNode.Group(kind, treePatternNodeArray, n);
            children2 = groupArray;
        }
        return new TreePattern(children2);
    }

    @Nullable
    public static List<ObjectKind> getSingleRootPath(@NotNull ObjectKind kind, @NotNull Dbms dbms) {
        BasicMetaModel<?> metaModel;
        JBIterable roots;
        ArrayList<ObjectKind> root2;
        if (kind == null) {
            SqlImportUtilCore.$$$reportNull$$$0(7);
        }
        if (dbms == null) {
            SqlImportUtilCore.$$$reportNull$$$0(8);
        }
        if ((root2 = (ArrayList<ObjectKind>)(roots = (metaModel = DbImplUtilCore.getMetaModel(dbms)).getPathsToRoot(kind)).first()) == null || root2.isEmpty() || !roots.skip(1).isEmpty()) {
            Logger.getInstance(metaModel.getClass()).warn("To many roots from " + kind);
            return null;
        }
        root2 = new ArrayList<ObjectKind>(root2);
        assert (!root2.isEmpty());
        assert (root2.get(root2.size() - 1) == ObjectKind.ROOT);
        root2.set(root2.size() - 1, DATA_SOURCE);
        return root2;
    }

    @Nullable
    public static TreePattern createRefPattern(@NotNull SqlReferenceExpression ref, @NotNull ObjectKind refKind, @NotNull Dbms dbms) {
        if (ref == null) {
            SqlImportUtilCore.$$$reportNull$$$0(9);
        }
        if (refKind == null) {
            SqlImportUtilCore.$$$reportNull$$$0(10);
        }
        if (dbms == null) {
            SqlImportUtilCore.$$$reportNull$$$0(11);
        }
        assert (refKind != SqlDbElementType.ANY);
        List<ObjectKind> kinds = SqlImportUtilCore.getSingleRootPath(refKind, dbms);
        if (kinds == null) {
            return null;
        }
        SmartList names = new SmartList();
        names.add(new ObjectName(ref.getName(), !ref.isPlainIdentifier()));
        SqlReferenceExpression qual = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getQualifierExpression(), SqlReferenceExpression.class);
        while (names.size() < kinds.size()) {
            names.add(qual == null ? null : new ObjectName(qual.getName(), !qual.isPlainIdentifier()));
            qual = qual == null ? null : (SqlReferenceExpression)ObjectUtils.tryCast((Object)qual.getQualifierExpression(), SqlReferenceExpression.class);
        }
        return SqlImportUtilCore.createPattern(names, kinds, null);
    }

    @Nullable
    public static RawConnectionConfig getConnectionConfig(@Nullable DbDataSource ds) {
        return ds == null ? null : ds.getConnectionConfig();
    }

    @Nullable
    public static TreePatternNode.Group createNodeIfNotNull(@Nullable ObjectName name, @NotNull ObjectKind kind, TreePatternNode.Group ... groups) {
        if (kind == null) {
            SqlImportUtilCore.$$$reportNull$$$0(12);
        }
        return name == null ? null : TreePatternUtils.create(name, kind, groups);
    }

    @Nullable
    public static TreePattern getResolveScopePattern(@NotNull SqlFile file) {
        if (file == null) {
            SqlImportUtilCore.$$$reportNull$$$0(13);
        }
        SqlResolveMappings mapping = SqlResolveMappings.getInstance(file.getProject());
        VirtualFile vFile = SqlImplUtil.getTopLevelFile((PsiFile)file);
        return (TreePattern)mapping.getMapping(vFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlImportUtilCore";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refKind";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlImportUtilCore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSources";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultScopePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceName";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultScopePattern";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPattern";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSingleRootPath";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRefPattern";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createNodeIfNotNull";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScopePattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

