/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.sql.dialects.SqlImportUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlImportUtil
extends SqlImportUtilCore {
    @NotNull
    public static TreePatternNode.Group createPositiveDatabase(@NotNull ObjectName name, TreePatternNode.Group ... groups) {
        if (name == null) {
            SqlImportUtil.$$$reportNull$$$0(0);
        }
        TreePatternNode.Group group = TreePatternUtils.create(name, ObjectKind.DATABASE, groups);
        if (group == null) {
            SqlImportUtil.$$$reportNull$$$0(1);
        }
        return group;
    }

    @Nullable
    public static TreePatternNode.Group createPositiveDatabase(boolean useNonMatching, @Nullable ObjectName name, TreePatternNode.Group ... groups) {
        return name == null && !useNonMatching ? null : TreePatternUtils.create((ObjectName)ObjectUtils.chooseNotNull((Object)name, (Object)NON_MATCHING_NAME), ObjectKind.DATABASE, groups);
    }

    @NotNull
    public static TreePattern createAddPattern(ObjectName @Nullable [] ds, ObjectKind @NotNull [] kinds) {
        if (kinds == null) {
            SqlImportUtil.$$$reportNull$$$0(2);
        }
        TreePatternNode.Group[] children2 = TreePatternNode.NO_GROUPS;
        for (int i2 = kinds.length - 1; i2 >= 0; --i2) {
            children2 = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{kinds[i2] == DATA_SOURCE && ds != null ? SqlImportUtil.createDataSources(ds, children2) : TreePatternUtils.create((ObjectName)null, kinds[i2], children2)});
        }
        return new TreePattern(children2);
    }

    @NotNull
    public static TreePattern addObjectsByPath(@NotNull TreePattern pattern, ObjectName @Nullable [] dsNames, @NotNull List<ObjectName> names, boolean atBegin, ObjectKind ... path) {
        if (pattern == null) {
            SqlImportUtil.$$$reportNull$$$0(3);
        }
        if (names == null) {
            SqlImportUtil.$$$reportNull$$$0(4);
        }
        if (path == null) {
            SqlImportUtil.$$$reportNull$$$0(5);
        }
        ObjectKind targetKind = path[path.length - 1];
        TreePattern treePattern = TreePatternUtils.patternProcessor(pattern, SqlImportUtil.createAddPattern(dsNames, path), (g, parent2, parentKind) -> {
            if (parent2 instanceof TreePatternNode.NegativeNaming) {
                return TreePatternUtils.SKIP_PROCESSING;
            }
            if (g.kind != targetKind) {
                return g;
            }
            SmartList notFound = new SmartList();
            for (ObjectName name : names) {
                if (g.matchedChildren(name, null, null)) continue;
                notFound.add(name);
            }
            if (notFound.isEmpty()) {
                return g;
            }
            TreePatternNode.PositiveNaming naming = new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)notFound));
            TreePatternUtils.GroupBuilder builder = TreePatternUtils.GroupBuilder.from(g);
            builder.positives.add(atBegin ? 0 : builder.positives.size(), new TreePatternNode<TreePatternNode.PositiveNaming>(naming, TreePatternNode.NO_GROUPS));
            return builder.build(g.kind);
        });
        if (treePattern == null) {
            SqlImportUtil.$$$reportNull$$$0(6);
        }
        return treePattern;
    }

    @Nullable
    public static TreePatternNode.Group getRootGroup(boolean schemaRoot, MultiMap<String, String> databases, boolean integrateStar) {
        return schemaRoot ? SqlImportUtil.getSchemaGroup(databases) : SqlImportUtil.getDbGroup(databases, integrateStar);
    }

    @Nullable
    public static TreePatternNode.Group getSchemaGroup(MultiMap<String, String> databases) {
        if (!databases.containsKey((Object)"*")) {
            return null;
        }
        return SqlImportUtil.getSchemaGroups(databases.get((Object)"*"));
    }

    @Nullable
    public static TreePatternNode.Group getSchemaGroups(Collection<String> schemas) {
        if (schemas.contains("*")) {
            return TreePatternUtils.create((ObjectName)null, ObjectKind.SCHEMA, TreePatternNode.NO_GROUPS);
        }
        if (schemas.isEmpty()) {
            return null;
        }
        return TreePatternUtils.create(JBIterable.from(schemas).transform(n -> ObjectName.quoted((String)n)).toList(), ObjectKind.SCHEMA, TreePatternNode.NO_GROUPS);
    }

    @Nullable
    public static TreePatternNode.Group getDbGroup(MultiMap<String, String> databases, boolean integrateStar) {
        if (databases.containsKey((Object)"*") && !integrateStar) {
            return TreePatternUtils.create((ObjectName)null, ObjectKind.DATABASE, TreePatternNode.NO_GROUPS);
        }
        if (databases.size() == 0) {
            return null;
        }
        ArrayList<TreePatternNode.Group> gr = new ArrayList<TreePatternNode.Group>();
        for (Map.Entry entry : databases.entrySet()) {
            TreePatternNode.Group sgr = SqlImportUtil.getSchemaGroups((Collection)entry.getValue());
            gr.add(TreePatternUtils.create(((String)entry.getKey()).equals("*") ? null : ObjectName.quoted((String)((String)entry.getKey())), ObjectKind.DATABASE, SqlImportUtil.optAr(sgr)));
        }
        return TreePatternUtils.UNION_PROCESSOR.mergeGroups(ObjectKind.DATABASE, gr);
    }

    public static TreePatternNode.Group[] optAr(TreePatternNode.Group x) {
        return x == null ? TreePatternNode.NO_GROUPS : (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{x});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlImportUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlImportUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPositiveDatabase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addObjectsByPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPositiveDatabase";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAddPattern";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addObjectsByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

