/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsoleCore;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.dataSource.LocalDataSourceCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtilCore;
import com.intellij.database.editor.DatabaseEditorHelperCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.vfs.DatabaseElementVirtualFileCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlImportUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialectImplUtilCore {
    public static final Logger LOG = Logger.getInstance(SqlDialectImplUtilCore.class);
    public static final String DEFAULT_DIALECT_PROPERTY = "DBE.Default.Dialect";
    private static final ClearableLazyValue<Language> ourDefaultDialect = new ClearableLazyValue<Language>(){

        @NotNull
        protected Language compute() {
            SqlDialects.ensureSqlDialectsLoaded();
            PropertiesComponent properties = PropertiesComponent.getInstance();
            String dialectId = properties == null ? null : properties.getValue(SqlDialectImplUtilCore.DEFAULT_DIALECT_PROPERTY);
            Language language = dialectId == null ? null : Language.findLanguageByID((String)dialectId);
            Language language2 = (Language)ObjectUtils.notNull((Object)language, (Object)Language.ANY);
            if (language2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return language2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtilCore$1", "compute"));
        }
    };

    protected SqlDialectImplUtilCore() {
    }

    @NotNull
    public static SqlLanguageDialectEx getDefaultSqlDialect() {
        SqlLanguageDialectEx result = SqlDialectImplUtilCore.getConfiguredDefaultSqlDialect();
        SqlLanguageDialectEx sqlLanguageDialectEx = result == null ? (SqlLanguageDialectEx)SqlDialects.getGenericDialect() : result;
        if (sqlLanguageDialectEx == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(0);
        }
        return sqlLanguageDialectEx;
    }

    @Nullable
    public static SqlLanguageDialectEx getConfiguredDefaultSqlDialect() {
        return (SqlLanguageDialectEx)((Object)ObjectUtils.tryCast((Object)ourDefaultDialect.getValue(), SqlLanguageDialectEx.class));
    }

    public static void setDefaultSqlDialect(@Nullable SqlLanguageDialect dialect) {
        PropertiesComponent.getInstance().setValue(DEFAULT_DIALECT_PROPERTY, dialect == null ? "" : dialect.getID());
        ourDefaultDialect.drop();
    }

    public static boolean placeBefore(PsiElement p1, PsiElement p2) {
        if (p1 == null || p2 == null) {
            return true;
        }
        if (p1 instanceof StubBasedPsiElement && p2 instanceof StubBasedPsiElement) {
            StubElement s1 = ((StubBasedPsiElement)p1).getStub();
            StubElement s2 = ((StubBasedPsiElement)p2).getStub();
            if (s1 != null && s2 != null) {
                StubElement e;
                ArrayList<StubElement> parents1 = new ArrayList<StubElement>();
                for (e = s1; e != null; e = e.getParentStub()) {
                    parents1.add(e);
                }
                StubElement prevE = null;
                for (e = s2; e != null; e = e.getParentStub()) {
                    if (e == s1) {
                        return true;
                    }
                    int idx = parents1.indexOf(e);
                    if (idx != -1) {
                        if (idx == 0 || prevE == null) {
                            return true;
                        }
                        StubElement prev1 = (StubElement)parents1.get(idx - 1);
                        for (StubElement element2 : e.getChildrenStubs()) {
                            if (element2 == prev1) {
                                return true;
                            }
                            if (element2 != prevE) continue;
                            return false;
                        }
                        throw new AssertionError();
                    }
                    prevE = e;
                }
            }
        }
        TextRange r1 = p1.getTextRange();
        TextRange r2 = p2.getTextRange();
        return (r1 == null ? 0 : r1.getStartOffset()) < (r2 == null ? 0 : r2.getStartOffset());
    }

    public static String loadDialectResource(Class<?> dialectClass, String name) throws IOException {
        InputStream xmlIs = SqlDialectImplUtilCore.openDialectResource(dialectClass, name);
        return xmlIs == null ? "" : FileUtil.loadTextAndClose((Reader)new InputStreamReader(xmlIs, StandardCharsets.UTF_8));
    }

    @Nullable
    public static InputStream openDialectResource(Class<?> dialectClass, String name) {
        String dialectName = dialectClass.getName();
        String packageName = dialectName.substring(0, dialectName.lastIndexOf(46) + 1).replace('.', '/');
        String xmlResource = packageName + name;
        return dialectClass.getClassLoader().getResourceAsStream(xmlResource);
    }

    @NotNull
    public static SqlImportState getNearestImportState(PsiElement place, SqlImportState state) {
        PsiElement p2;
        if (state.prevState == null) {
            SqlImportState sqlImportState = state;
            if (sqlImportState == null) {
                SqlDialectImplUtilCore.$$$reportNull$$$0(1);
            }
            return sqlImportState;
        }
        for (p2 = place; p2 != null; p2 = p2.getContext()) {
            if (SqlPsiElementFactory.isROFile(p2)) continue;
            if (p2 instanceof StubBasedPsiElement && ((StubBasedPsiElement)p2).getStub() != null || p2 instanceof PsiFileWithStubSupport && ((PsiFileWithStubSupport)p2).getStubTree() != null) break;
            if (!(p2 instanceof PsiFile)) continue;
            p2 = null;
            break;
        }
        if (p2 == null) {
            p2 = place;
        }
        while (state.prevState != null) {
            if (p2 != null && SqlDialectImplUtilCore.placeBefore(state.element, p2)) {
                SqlImportState sqlImportState = state;
                if (sqlImportState == null) {
                    SqlDialectImplUtilCore.$$$reportNull$$$0(2);
                }
                return sqlImportState;
            }
            state = state.prevState;
        }
        SqlImportState sqlImportState = state;
        if (sqlImportState == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(3);
        }
        return sqlImportState;
    }

    @NotNull
    public static SqlImportState getImportCheckerAt(@NotNull SqlFile sqlFile, @Nullable PsiElement place) {
        if (sqlFile == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(4);
        }
        while (place != null) {
            PsiFile file = place.getContainingFile();
            if (file instanceof SqlFile) {
                sqlFile = (SqlFile)file;
            }
            if (file == sqlFile) break;
            place = file.getContext();
        }
        return SqlDialectImplUtilCore.getNearestImportState(place, SqlDialectImplUtilCore.buildImports(sqlFile));
    }

    @NotNull
    public static SqlImportState buildImports(SqlFile sqlFile) {
        SqlImportState sqlImportState = (SqlImportState)CachedValuesManager.getCachedValue((PsiElement)sqlFile, () -> new CachedValueProvider.Result((Object)SqlDialectImplUtilCore.calcImports(sqlFile), new Object[]{sqlFile, DbPsiFacade.getInstance((Project)sqlFile.getProject())}));
        if (sqlImportState == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(5);
        }
        return sqlImportState;
    }

    @Nullable
    public static TreePattern buildOverlayPattern(SqlFile sqlFile) {
        return (TreePattern)CachedValuesManager.getCachedValue((PsiElement)sqlFile, () -> new CachedValueProvider.Result((Object)SqlDialectImplUtilCore.calcOverlayPattern(sqlFile), new Object[]{sqlFile, DbPsiFacade.getInstance((Project)sqlFile.getProject())}));
    }

    protected static TreePattern calcOverlayPattern(SqlFile sqlFile) {
        PsiFile hostFile;
        SqlFile original = (SqlFile)ObjectUtils.tryCast((Object)sqlFile.getOriginalFile(), SqlFile.class);
        if (original != null && original != sqlFile) {
            return SqlDialectImplUtilCore.buildOverlayPattern(original);
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)sqlFile.getProject()).getInjectionHost((PsiElement)sqlFile);
        PsiFile psiFile = hostFile = host == null ? null : host.getContainingFile();
        if (hostFile instanceof SqlFile) {
            return SqlDialectImplUtilCore.calcOverlayPattern((SqlFile)hostFile);
        }
        if (DbSrcUtilsCore.isDbSrcFile(sqlFile.getVirtualFile())) {
            return null;
        }
        SearchPath searchPath = DatabaseEditorHelperCore.getSearchPath((PsiFile)sqlFile);
        DbDataSource dataSource2 = DbImplUtilCore.getForcedDataSource((PsiFile)sqlFile);
        return ((SqlLanguageDialectEx)sqlFile.getSqlLanguage()).forcedContextPattern(dataSource2, searchPath);
    }

    @NotNull
    protected static SqlImportState calcImports(SqlFile sqlFile) {
        SqlImportState.Shared shared = new SqlImportState.Shared(sqlFile, SqlDialectImplUtilCore.buildOverlayPattern(sqlFile));
        SqlImportState current = new SqlImportState(null, shared, SqlDialectImplUtilCore.calcInitialImportState(sqlFile), null);
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        for (SqlUseDatabaseStatement statement : JBIterable.from((Iterable)sqlFile.getDdl()).filter(SqlUseDatabaseStatement.class)) {
            current = new SqlImportState((PsiElement)statement, shared, language.processImports(statement, current.state), current);
        }
        SqlImportState sqlImportState = current;
        if (sqlImportState == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(6);
        }
        return sqlImportState;
    }

    @NotNull
    private static TreePattern calcInitialImportState(@NotNull SqlFile sqlFile) {
        TreePattern resolvePattern;
        SqlFile hostFile;
        SqlFile orig;
        if (sqlFile == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(7);
        }
        if ((orig = (SqlFile)ObjectUtils.tryCast((Object)sqlFile.getOriginalFile(), SqlFile.class)) != null && orig != sqlFile) {
            return SqlDialectImplUtilCore.calcInitialImportState(orig);
        }
        VirtualFile vfile = sqlFile.getVirtualFile();
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)sqlFile.getProject()).getInjectionHost((PsiElement)sqlFile);
        if (host == null) {
            host = sqlFile.getContext();
        }
        SqlFile sqlFile2 = hostFile = host == null ? null : (SqlFile)ObjectUtils.tryCast((Object)host.getContainingFile(), SqlFile.class);
        if (hostFile != null && SqlImplUtil.getSqlDialectSafe((PsiElement)hostFile) == SqlImplUtil.getSqlDialectSafe((PsiElement)sqlFile)) {
            SqlImportState at = SqlDialectImplUtilCore.getImportCheckerAt(hostFile, (PsiElement)host);
            TreePattern treePattern = at.state;
            if (treePattern == null) {
                SqlDialectImplUtilCore.$$$reportNull$$$0(8);
            }
            return treePattern;
        }
        if (DbSrcUtilsCore.isDbSrcFile(vfile)) {
            SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
            String dataSourceId = DbSrcUtilsCore.getDataSource(vfile);
            DbDataSource ds2 = dataSourceId == null ? null : DbPsiFacade.getInstance((Project)sqlFile.getProject()).findDataSource(dataSourceId);
            SearchPath searchPath = DatabaseEditorHelperCore.dbSrcSearchPath(sqlFile.getProject(), vfile, true);
            TreePattern treePattern = searchPath != null ? language.srcFilePattern(ds2, searchPath) : TreePattern.EMPTY;
            if (treePattern == null) {
                SqlDialectImplUtilCore.$$$reportNull$$$0(9);
            }
            return treePattern;
        }
        if (vfile instanceof DatabaseElementVirtualFileCore) {
            SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
            DbElement o = ((DatabaseElementVirtualFileCore)vfile).findElement(sqlFile.getProject());
            SearchPath searchPath = ObjectPaths.searchPathOf((DasObject)DbImplUtilCore.getSearchPathObject(language.getDatabaseDialect(), (DasObject)o));
            TreePattern treePattern = searchPath != null && o != null ? language.srcFilePattern(o.getDataSource(), searchPath) : TreePattern.EMPTY;
            if (treePattern == null) {
                SqlDialectImplUtilCore.$$$reportNull$$$0(10);
            }
            return treePattern;
        }
        JdbcConsoleCore console = JdbcConsoleProviderCore.getValidConsole(sqlFile.getProject(), vfile);
        TreePattern treePattern = resolvePattern = console == null ? SqlImportUtilCore.getResolveScopePattern(sqlFile) : null;
        if (resolvePattern == null || TreePatternUtils.isWildcard(resolvePattern.root.getGroup(SqlImportUtilCore.DATA_SOURCE))) {
            return SqlDialectImplUtilCore.getDefaultInitialPattern(sqlFile, null);
        }
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        JBIterable<DbDataSource> dataSources = SqlDialectImplUtilCore.getFilteredDataSources(sqlFile, resolvePattern);
        TreePattern defaultPattern = TreePatternUtils.union((Iterable<TreePattern>)dataSources.transform(ds -> SqlImportUtilCore.createDefaultScopePattern(ds, language)));
        resolvePattern = TreePatternUtils.union(resolvePattern, new TreePattern(SqlImportUtilCore.createDataSources(null, new TreePatternNode.Group[0])));
        TreePattern pattern = SqlImportUtilCore.processResolveScopePattern(resolvePattern, defaultPattern);
        pattern = (TreePattern)dataSources.reduce((Object)pattern, (p2, ds) -> language.applyImplicitImports(SqlImportUtilCore.getRealDsNames(ds), (TreePattern)p2));
        TreePattern treePattern2 = TreePatternUtils.union(pattern, SqlImportUtilCore.createDefaultScopePattern(null, language));
        if (treePattern2 == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(11);
        }
        return treePattern2;
    }

    @NotNull
    private static JBIterable<DbDataSource> getFilteredDataSources(@NotNull SqlFile sqlFile, @Nullable TreePattern filter2) {
        boolean all;
        if (sqlFile == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(12);
        }
        TreePatternNode.Group group = filter2 == null ? null : filter2.root.getGroup(SqlImportUtilCore.DATA_SOURCE);
        boolean bl = all = filter2 == null || TreePatternUtils.isWildcard(group);
        if (!all && group == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDialectImplUtilCore.$$$reportNull$$$0(13);
            }
            return jBIterable;
        }
        JBIterable res2 = JBIterable.from(SqlImplUtil.getDataSources((PsiElement)sqlFile));
        if (!all) {
            res2 = res2.filter(ds -> {
                SqlDataSource sql = (SqlDataSource)ObjectUtils.tryCast((Object)ds.getDelegate(), SqlDataSource.class);
                return sql != null && sql.containsFile(sqlFile.getVirtualFile()) || group.matchedChildren(SqlImportUtilCore.getDataSourceName((DasDataSource)ds), Casing.EXACT, null);
            });
        }
        JBIterable jBIterable = res2;
        if (jBIterable == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(14);
        }
        return jBIterable;
    }

    @NotNull
    protected static TreePattern getDefaultInitialPattern(@NotNull SqlFile sqlFile, @Nullable TreePattern filter2) {
        if (sqlFile == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(15);
        }
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        JBIterable<DbDataSource> dataSources = SqlDialectImplUtilCore.getFilteredDataSources(sqlFile, filter2);
        TreePattern treePattern = TreePatternUtils.union((Iterable<TreePattern>)dataSources.transform(ds -> SqlImportUtilCore.createDefaultScopePattern(ds, language)).append((Object)SqlImportUtilCore.createDefaultScopePattern(null, language)));
        if (treePattern == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(16);
        }
        return treePattern;
    }

    public static boolean checkImports(@NotNull SqlImportState checker, @Nullable DasDataSource dataSource2, DasObject object) {
        if (checker == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(17);
        }
        return checker.isImported(dataSource2, object);
    }

    public static Set<String> getAllKeywordsFromDefinition(Collection<SqlFunctionDefinition> definitions, Set<String> keywords) {
        for (SqlFunctionDefinition definition : definitions) {
            for (SqlFunctionDefinition.Prototype prototype : definition.getPrototypes()) {
                SqlDialectImplUtilCore.getAllKeywordsFromDefinition(prototype, keywords);
            }
        }
        return keywords;
    }

    public static void getAllKeywordsFromDefinition(SqlFunctionDefinition.ParameterBlock block, Set<String> keywords) {
        for (SqlFunctionDefinition.Parameter parameter : block.getParams()) {
            if (parameter instanceof SqlFunctionDefinition.Keyword) {
                keywords.add(((SqlFunctionDefinition.Keyword)parameter).getName());
                continue;
            }
            if (!(parameter instanceof SqlFunctionDefinition.ParameterBlock)) continue;
            SqlDialectImplUtilCore.getAllKeywordsFromDefinition((SqlFunctionDefinition.ParameterBlock)parameter, keywords);
        }
    }

    @Contract(value="null,null,null->null")
    public static TreePattern createObjectPattern(@Nullable ObjectName[] dsNames, @Nullable DasObject object, TreePatternNode.Group ... tail) {
        if (object == null && dsNames == null) {
            return null;
        }
        SmartList kinds = new SmartList();
        SmartList names = new SmartList();
        SqlImportState.getPartialTrace(SqlDialectImplUtilCore.trace(object), (List<ObjectKind>)kinds, (List)names, null);
        kinds.add(SqlImportUtilCore.DATA_SOURCE);
        names.add(dsNames);
        return SqlImportUtilCore.createPattern(names, (List<ObjectKind>)kinds, tail);
    }

    @Nullable
    public static ObjectTracer<DasObject> trace(@Nullable DasObject element2) {
        return element2 == null || element2.getKind() == ObjectKind.NONE || element2.getKind() == ObjectKind.ROOT ? null : new DasObjectTracer(element2);
    }

    @Contract(value="null,_,null,null->null")
    public static TreePattern createObjectPattern(@Nullable ObjectName[] dsNames, @NotNull Dbms dbms, @Nullable ObjectPath object, TreePatternNode.Group ... tail) {
        List<ObjectKind> path;
        if (dbms == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(18);
        }
        if (object == null && dsNames == null) {
            return null;
        }
        SmartList kinds = new SmartList();
        SmartList names = new SmartList();
        if (object != null && (path = SqlImportUtilCore.getSingleRootPath(object.kind, dbms)) != null) {
            int e = path.size() - 1;
            for (int i2 = 0; i2 < e; ++i2) {
                kinds.add(path.get(i2));
                if (object != null) {
                    names.add(new ObjectName(object.name, object.isQuoted()));
                } else {
                    names.add(ObjectName.quoted((String)""));
                }
                object = object == null ? null : object.parent;
            }
        }
        kinds.add(SqlImportUtilCore.DATA_SOURCE);
        names.add(dsNames);
        return SqlImportUtilCore.createPattern(names, (List<ObjectKind>)kinds, tail);
    }

    @Nullable
    public static String getUserName(@Nullable RawConnectionConfig config) {
        LocalDataSourceCore ds = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)config);
        if (ds == null) {
            return null;
        }
        String username = StringUtil.nullize((String)ds.getUsername());
        if (username != null) {
            return username;
        }
        JdbcUrlParser parser2 = SqlDialectImplUtilCore.getParsed(config);
        return parser2 == null ? null : StringUtil.nullize((String)parser2.getParameter("user"));
    }

    @Nullable
    public static JdbcUrlParser getParsed(@Nullable RawConnectionConfig config) {
        if (config == null) {
            return null;
        }
        JdbcUrlParser stateful = JdbcUrlParserUtilCore.stateful(JdbcUrlParserUtilCore.select(config));
        if (stateful != null) {
            stateful.setUrlText(config.getUrl());
            return stateful;
        }
        return null;
    }

    @NotNull
    public static TreePattern getDefaultInitialPattern(@NotNull SqlFile sqlFile) {
        if (sqlFile == null) {
            SqlDialectImplUtilCore.$$$reportNull$$$0(19);
        }
        return SqlDialectImplUtilCore.getDefaultInitialPattern(sqlFile, SqlImportUtilCore.getResolveScopePattern(sqlFile));
    }

    @Nullable
    public static String getDatabaseName(@Nullable RawConnectionConfig config) {
        JdbcUrlParser stateful = SqlDialectImplUtilCore.getParsed(config);
        return stateful != null ? StringUtil.nullize((String)stateful.getParameter("database")) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlDialectImplUtilCore";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSqlDialect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNearestImportState";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlDialectImplUtilCore";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildImports";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcImports";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInitialImportState";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredDataSources";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultInitialPattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getImportCheckerAt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calcInitialImportState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredDataSources";
                break;
            }
            case 15: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultInitialPattern";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkImports";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createObjectPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DasObjectTracer
    extends ObjectTracer<DasObject> {
        private final DasObject myElement;

        DasObjectTracer(@NotNull DasObject element2) {
            if (element2 == null) {
                DasObjectTracer.$$$reportNull$$$0(0);
            }
            this.myElement = element2;
        }

        @Override
        public ObjectTracer.ObjectTraceIt<DasObject> trace() {
            return new ObjectTracer.ObjectTraceIt<DasObject>(DasUtil.dasParents((DasObject)this.myElement).filter(o -> o.getKind() != ObjectKind.ROOT).iterator()){
                private DasObject myCurrent;

                @Override
                public DasObject next() {
                    this.myCurrent = (DasObject)super.next();
                    return this.myCurrent;
                }

                @Override
                public ObjectKind getKind() {
                    return this.myCurrent.getKind();
                }

                @Override
                public String getName() {
                    return this.myCurrent.getName();
                }

                @Override
                public boolean isQuoted() {
                    return DbSqlUtilCore.isQuoted(this.myCurrent);
                }
            };
        }

        @Override
        public ObjectKind getKind() {
            return this.myElement.getKind();
        }

        @Override
        public String getName() {
            return this.myElement.getName();
        }

        @Override
        @Nullable
        public ObjectTracer<DasObject> getParent(int steps) {
            if (steps == 0) {
                return this;
            }
            DasObject parent2 = this.myElement;
            for (int i2 = 0; i2 < steps && parent2 != null; parent2 = parent2.getDasParent(), ++i2) {
            }
            return parent2 == null ? null : SqlDialectImplUtilCore.trace(parent2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/SqlDialectImplUtilCore$DasObjectTracer", "<init>"));
        }
    }

    public static abstract class ObjectTracer<T> {
        public abstract ObjectTraceIt<T> trace();

        public abstract ObjectKind getKind();

        public abstract String getName();

        @Nullable
        public abstract ObjectTracer<T> getParent(int var1);

        public static abstract class ObjectTraceIt<T>
        implements Iterator<T> {
            private final JBIterator<? extends T> myIt;

            public ObjectTraceIt(Iterator<? extends T> it2) {
                this.myIt = JBIterator.from(it2);
            }

            @Override
            public boolean hasNext() {
                return this.myIt.hasNext();
            }

            @Override
            public T next() {
                return (T)this.myIt.next();
            }

            @Override
            public void remove() {
                this.myIt.remove();
            }

            public abstract ObjectKind getKind();

            public abstract String getName();

            public abstract boolean isQuoted();
        }
    }
}

