/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.types.DasType;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlDialectImplUtil
extends SqlDialectImplUtilCore {
    private SqlDialectImplUtil() {
    }

    @NotNull
    public static String getDialectHelpResource(Class<?> dialectClass, @NonNls String name) throws IOException {
        String text2;
        @NonNls String resourceName = null;
        InputStream zipIs = null;
        for (Class<?> c2 = dialectClass; c2 != null; c2 = c2.getSuperclass()) {
            String specificResourceName = "help/" + SqlDialectImplUtil.getSqlDialectName(c2) + "-help.zip";
            ClassLoader loader = c2.getClassLoader();
            zipIs = loader == null ? null : loader.getResourceAsStream(specificResourceName);
            String string = resourceName = zipIs != null || resourceName == null ? specificResourceName : resourceName;
            if (zipIs != null) break;
        }
        if (zipIs == null) {
            throw new IOException(SqlBundle.message("help.file.0.not.found", StringUtil.notNullize(resourceName)));
        }
        try {
            text2 = SqlDialectImplUtil.loadFileFromZip(zipIs, name);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new IOException(SqlBundle.message("help.file.0.not.found", name) + "\n" + e.getMessage(), e);
        }
        if (text2 == null) {
            throw new IOException(SqlBundle.message("help.file.0.not.found", resourceName + "!/" + name));
        }
        String string = text2;
        if (string == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String loadFileFromZip(InputStream stream, @NonNls String fileName) throws IOException {
        if (stream == null) {
            return null;
        }
        try (ZipInputStream zip = new ZipInputStream(stream);){
            ZipEntry zipEntry = zip.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().equalsIgnoreCase(fileName)) {
                    String string = new String(FileUtil.adaptiveLoadText((Reader)new InputStreamReader((InputStream)zip, StandardCharsets.UTF_8)));
                    return string;
                }
                zipEntry = zip.getNextEntry();
            }
        }
        return null;
    }

    @NotNull
    private static String getSqlDialectName(@NotNull Class<?> dialectClass) {
        if (dialectClass == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(1);
        }
        String className = dialectClass.getName();
        int endIndex = className.indexOf("Dialect");
        String string = StringUtil.toLowerCase((String)className.substring(className.lastIndexOf(46) + 1, endIndex > -1 ? endIndex : className.length()));
        if (string == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static Map<String, ReservedEntity> buildEntities(@NotNull Dbms dbms, @NotNull ObjectKind kind, String ... names) {
        if (dbms == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(3);
        }
        if (kind == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(4);
        }
        LinkedHashMap<String, ReservedEntity> result = new LinkedHashMap<String, ReservedEntity>();
        for (String name : names) {
            result.put(name, new ReservedEntity(dbms, name, kind));
        }
        LinkedHashMap<String, ReservedEntity> linkedHashMap = result;
        if (linkedHashMap == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(5);
        }
        return linkedHashMap;
    }

    public static Set<String> loadSystemVars(SqlLanguageDialect dialect) {
        return SqlDialectImplUtil.loadTokens(dialect, "systemVars.txt");
    }

    public static <T> JBIterable<T> staticFields(@NotNull Class<?> clazz, @NotNull Class<T> fieldC) {
        if (clazz == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(6);
        }
        if (fieldC == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(7);
        }
        return JBIterable.of((Object[])clazz.getFields()).filter(field -> Modifier.isStatic(field.getModifiers()) && fieldC.isAssignableFrom(field.getType())).transform(field -> {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }).filter(Conditions.notNull()).filter(fieldC);
    }

    public static List<ReservedEntity.Typed> loadEntities(SqlLanguageDialectEx dialect) {
        ArrayList<ReservedEntity.Typed> result = new ArrayList<ReservedEntity.Typed>();
        String invalid = null;
        THashMap kindMap = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (ObjectKind kind : SqlDialectImplUtil.staticFields(SqlDbElementType.class, ObjectKind.class)) {
            kindMap.put(kind.name(), kind);
        }
        THashMap typeMap = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        try {
            String tokens = SqlDialectImplUtil.loadDialectResource(((Object)((Object)dialect)).getClass(), "simpleEntities.txt");
            if (StringUtil.isNotEmpty((String)tokens)) {
                for (String typed : tokens.split("(?m)\\n")) {
                    String[] split = typed.split(":");
                    String name = split[0].trim();
                    ObjectKind objectType = (ObjectKind)kindMap.get(split[1].trim());
                    String typeName = split.length < 3 ? null : split[2].trim();
                    SqlType type = null;
                    if (typeName != null) {
                        type = (SqlType)typeMap.get(typeName);
                        if (type == null) {
                            type = SqlTypeFactory.of(DataTypeFactory.of(typeName), dialect);
                            typeMap.put(typeName, type);
                        }
                        if (split.length != 3 || objectType == null) {
                            if (invalid != null) continue;
                            invalid = typed;
                            continue;
                        }
                    }
                    result.add(new ReservedEntity.Typed(dialect.getDbms(), name, objectType, type));
                }
            }
            if (invalid != null) {
                LOG.error("Invalid entity: `" + invalid + "`");
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    public static List<ReservedEntity> loadObjects(SqlLanguageDialect dialect, String fileName) {
        ArrayList<ReservedEntity> arrayList;
        InputStream stream = SqlDialectImplUtil.openDialectResource(dialect.getClass(), fileName);
        if (stream == null) {
            return Collections.emptyList();
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        try {
            ArrayList<ReservedEntity> res2 = new ArrayList<ReservedEntity>();
            String cur2 = r.readLine();
            while (cur2 != null) {
                if (StringUtil.isEmptyOrSpaces((String)cur2)) {
                    cur2 = r.readLine();
                    continue;
                }
                ObjectKind kind = (ObjectKind)ObjectKind.ourKinds.get(cur2 = StringUtil.trimEnd((String)cur2, (String)":"));
                if (kind == null) {
                    kind = SqlDbElementType.ourSqlKinds.get(cur2);
                }
                if (kind == null) {
                    LOG.error("Unknown kind: " + cur2);
                }
                while ((cur2 = r.readLine()) != null && cur2.startsWith(" - ")) {
                    if (kind == null) continue;
                    cur2 = StringUtil.trimStart((String)cur2, (String)" - ");
                    res2.add(new ReservedEntity(dialect.getDbms(), cur2, kind));
                }
            }
            arrayList = res2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return Collections.emptyList();
            }
        }
        r.close();
        return arrayList;
    }

    public static Set<String> loadTokens(SqlLanguageDialect dialect, String fileName) {
        THashSet result = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        try {
            String tokens = SqlDialectImplUtil.loadDialectResource(dialect.getClass(), fileName);
            if (StringUtil.isNotEmpty((String)tokens)) {
                Collections.addAll(result, tokens.split("(?m)\\s+"));
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    public static TreePattern refPatternExpandedToSchema(@NotNull TreePattern prev, @NotNull SqlReferenceExpression ref, @NotNull SqlLanguageDialectEx dialect) {
        if (prev == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(8);
        }
        if (ref == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(9);
        }
        if (dialect == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(10);
        }
        ObjectName refName = new ObjectName(ref.getName(), ref.isQuotedIdentifier());
        SearchPath refPath = SearchPath.of((ObjectPath)ObjectPath.create((String)refName.name, (ObjectKind)ObjectKind.DATABASE, (boolean)refName.quoted, null, null));
        TreePatternNode.Group dsGroup = prev.root.getGroup(SqlImportUtil.DATA_SOURCE);
        if (dsGroup == null) {
            return dialect.forcedContextPattern(null, refPath);
        }
        NotNullLazyValue anyGroups = NotNullLazyValue.lazy(() -> {
            TreePatternNode.Group d2 = dialect.forcedContextPattern(null, (SearchPath)refPath).root.getGroup(SqlImportUtil.DATA_SOURCE);
            TreePatternNode<TreePatternNode.NegativeNaming> dc = d2 == null ? null : d2.negativeChild;
            return dc == null ? TreePatternNode.NO_GROUPS : dc.groups;
        });
        TreePattern n = null;
        if (dsGroup.negativeChild != null) {
            TreePatternNode.Group[] any = (TreePatternNode.Group[])anyGroups.getValue();
            n = any.length == 0 ? null : new TreePattern(new TreePatternNode.Group(SqlImportUtil.DATA_SOURCE, null, new TreePatternNode<TreePatternNode.NegativeNaming>((TreePatternNode.NegativeNaming)dsGroup.negativeChild.naming, any)));
        }
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)ref.getProject());
        SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)ref.getContainingFile(), SqlFile.class);
        TreePattern scopePattern = file == null ? null : SqlImportUtil.getResolveScopePattern(file);
        ArrayList matched = new ArrayList();
        ArrayList matched2 = new ArrayList();
        Casing casing = dialect.getCasing(ObjectKind.DATABASE, null);
        return TreePatternUtils.union((Iterable<TreePattern>)JBIterable.of((Object[])dsGroup.positiveChildren).flatten(c2 -> JBIterable.of((Object[])((TreePatternNode.PositiveNaming)c2.naming).getNames())).filterMap(dsName -> {
            matched.clear();
            if (scopePattern != null) {
                scopePattern.root.matchedChildren((ObjectName)dsName, Casing.EXACT, SqlImportUtil.DATA_SOURCE, matched);
            }
            matched2.clear();
            for (TreePatternNode node : matched) {
                node.matchedChildren(refName, casing, ObjectKind.DATABASE, matched2);
            }
            if (!matched2.isEmpty()) {
                TreePatternNode.PositiveNaming naming = new TreePatternNode.PositiveNaming(refName);
                return new TreePattern(TreePatternUtils.create(dsName, SqlImportUtil.DATA_SOURCE, TreePatternUtils.create(refName, ObjectKind.DATABASE, TreePatternUtils.UNION_PROCESSOR.mergeNodes(naming, ObjectKind.DATABASE, matched2))));
            }
            DbDataSource ds = facade.findDataSource(dsName.name);
            if (ds != null) {
                return dialect.forcedContextPattern(ds, refPath);
            }
            if (dsName != SqlImportUtil.NON_MATCHING_NAME) {
                return null;
            }
            TreePatternNode.Group[] any = (TreePatternNode.Group[])anyGroups.getValue();
            return any.length == 0 ? null : new TreePattern(TreePatternUtils.create(dsName, SqlImportUtil.DATA_SOURCE, any));
        }).append((Object)n).collect());
    }

    @NotNull
    public static TreePattern forcedContextExpandedToSchemas(@Nullable DbDataSource dataSource2, @NotNull Dbms dbms, @Nullable SearchPath searchPath, TreePatternNode.Group[] schemas, TreePatternNode.Group[] databases) {
        if (dbms == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(11);
        }
        ObjectName[] dsNames = SqlImportUtil.getRealDsNames(dataSource2);
        Function expandPath = n -> {
            TreePatternNode.Group[] tail = null;
            if (n == null || n.kind == ObjectKind.NONE) {
                tail = databases;
            } else if (n.kind == ObjectKind.DATABASE) {
                ObjectName[] currentSchemas = SqlDialectImplUtil.getCurrentSchemasFor(dataSource2, n);
                tail = currentSchemas == null ? schemas : SqlImportUtil.optAr(TreePatternUtils.create(currentSchemas, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            }
            return SqlDialectImplUtil.createObjectPattern(dsNames, dbms, n, tail);
        };
        List elements = SearchPath.getElements((SearchPath)searchPath);
        if (elements.isEmpty()) {
            TreePattern treePattern = dsNames == null ? TreePattern.EMPTY : (TreePattern)expandPath.fun(null);
            if (treePattern == null) {
                SqlDialectImplUtil.$$$reportNull$$$0(12);
            }
            return treePattern;
        }
        TreePattern treePattern = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from((Iterable)elements).transform(expandPath));
        if (treePattern == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(13);
        }
        return treePattern;
    }

    @Nullable
    private static ObjectName[] getCurrentSchemasFor(@Nullable DbDataSource dataSource2, @NotNull ObjectPath db) {
        if (db == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(14);
        }
        if (dataSource2 == null) {
            return null;
        }
        List names = DbSqlUtil.findObjects(dataSource2, db).filter(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE)).flatten(o -> o.getDasChildren(ObjectKind.SCHEMA).filter(BasicMateNamespace.class).filter(n -> n.isCurrent())).map(o -> new ObjectName(o.getName(), DbSqlUtilCore.isQuoted(o))).toList();
        return names.isEmpty() ? null : ObjectName.toArray((Iterable)names);
    }

    public static boolean isLabelOrRoutineQualification(@Nullable PsiElement element2, ObjectKind type, @Nullable PsiElement place, boolean isCompletion) {
        if (type == SqlDbElementType.LABEL || type == ObjectKind.ROUTINE) {
            if (place == null) {
                return false;
            }
            SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
            if (element2 != null) {
                PsiElement sc;
                PsiElement psiElement = sc = type == SqlDbElementType.LABEL ? element2.getParent() : element2;
                if (!SqlDialectImplUtil.isAncestorOrOriginalAncestor(sc, place)) {
                    ref = null;
                }
            }
            if (ref != null && (isCompletion || ref.getQualifierExpression() == null && ref.getParent() instanceof SqlReferenceExpression)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isAncestorOrOriginalAncestor(@NotNull PsiElement ancestor, @NotNull PsiElement place) {
        if (ancestor == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(15);
        }
        if (place == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(16);
        }
        PsiFile placeFile = place.getContainingFile();
        PsiFile ancestorFile = ancestor.getContainingFile();
        if (ancestorFile == placeFile) {
            return PsiTreeUtil.isContextAncestor((PsiElement)ancestor, (PsiElement)place, (boolean)true);
        }
        if (placeFile != null && ancestorFile == placeFile.getOriginalFile()) {
            return ancestor.getTextRange().contains(place.getTextRange().getStartOffset());
        }
        return false;
    }

    public static SqlImplUtil.Column col(@NotNull PsiElement element2, @Nullable PsiElement object, @NotNull String name, @NotNull SqlType type, @NotNull DasType dasType) {
        if (element2 == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(17);
        }
        if (name == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(18);
        }
        if (type == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(19);
        }
        if (dasType == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(20);
        }
        return SqlDialectImplUtil.col(element2, object, name, type, dasType, true);
    }

    public static SqlImplUtil.Column col(final @NotNull PsiElement element2, final @Nullable PsiElement object, @NotNull String name, @NotNull SqlType type, @NotNull DasType dasType, final boolean isQuoted) {
        if (element2 == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(21);
        }
        if (name == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(22);
        }
        if (type == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(23);
        }
        if (dasType == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(24);
        }
        return new SqlImplUtil.Column(name, type, dasType, (PsiElement)new SqlFileImpl.FakeDefinition(element2, name){

            @Override
            @NotNull
            public Dbms getDbms() {
                Dbms dbms = SqlImplUtil.getSqlDialectDbms(element2);
                if (dbms == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dbms;
            }

            @NotNull
            public ObjectKind getKind() {
                ObjectKind objectKind = ObjectKind.COLUMN;
                if (objectKind == null) {
                    1.$$$reportNull$$$0(1);
                }
                return objectKind;
            }

            @Override
            @Nullable
            public DasObject getDasParent() {
                return (DasObject)ObjectUtils.chooseNotNull((Object)((DasObject)ObjectUtils.tryCast((Object)object, DasObject.class)), (Object)((DasObject)ObjectUtils.tryCast((Object)element2, DasObject.class)));
            }

            public boolean isNameQuoted() {
                return isQuoted;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/dialects/SqlDialectImplUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDbms";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKind";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlDialectImplUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectClass";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldC";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "db";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectHelpResource";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlDialectImplUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEntities";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextExpandedToSchemas";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialectName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildEntities";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "staticFields";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "refPatternExpandedToSchema";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forcedContextExpandedToSchemas";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentSchemasFor";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAncestorOrOriginalAncestor";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "col";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

