/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.util.SqlDialects;
import com.intellij.lang.LanguageExtension;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.editor.QuoteIdentifierQuickFix;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialectHelper {
    public static final LanguageExtension<SqlDialectHelper> EP = new LanguageExtension("com.intellij.sql.dialectHelper", (Object)new SqlDialectHelper((SqlLanguageDialectEx)SqlDialects.getGenericDialect()));
    private final SqlLanguageDialectEx myDialect;

    protected SqlDialectHelper(SqlLanguageDialectEx dialect) {
        this.myDialect = dialect;
    }

    public final SqlLanguageDialectEx getDialect() {
        return this.myDialect;
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return null;
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return null;
    }

    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        return this.checkIdentifierIsKeyword(o, manager, onTheFly, false);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierIsKeyword(SqlIdentifier o, InspectionManager manager, boolean onTheFly, boolean pl) {
        IElementType type = PsiUtilCore.getElementType((PsiElement)o.getFirstChild());
        if (!(type instanceof SqlKeywordTokenType) || !(!pl ? this.myDialect.isReservedKeyword(type) : this.myDialect.isReservedKeywordPL(type))) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)o, SqlBundle.message("identifier.1.should.be.quoted", o.getName()), (LocalQuickFix)new QuoteIdentifierQuickFix(this.myDialect), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierStartsWithLetter(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        String text2 = o.getText();
        if (text2.length() <= 0 || Character.isLetter(text2.charAt(0))) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)o, SqlBundle.message("identifier.should.start.with.letter", new Object[0]), (LocalQuickFix)new QuoteIdentifierQuickFix(this.myDialect), ProblemHighlightType.GENERIC_ERROR, onTheFly);
    }

    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return null;
    }

    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        return new DFABuildingVisitor(this.myDialect);
    }

    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        SqlErrorSpecHelper sqlErrorSpecHelper = SqlErrorSpecHelper.DEFAULT_INSTANCE;
        if (sqlErrorSpecHelper == null) {
            SqlDialectHelper.$$$reportNull$$$0(0);
        }
        return sqlErrorSpecHelper;
    }

    @Nullable
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectHelper", "getErrorSpecHelper"));
    }
}

