/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.providers.SqlFunctionDefinitionCompletions;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.slicer.SqlPsiUtilCoreKt;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlReferenceExpressionCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        LookupElement element2;
        PsiElement position;
        if (parameters == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((position = parameters.getPosition()).getParent() instanceof PsiErrorElement) {
            return;
        }
        PsiElement prevLeaf = SqlReferenceExpressionCompletionProvider.getNonWSPrecedingLeaf(position);
        if (prevLeaf instanceof PsiErrorElement && ((PsiErrorElement)prevLeaf).getErrorDescription().endsWith(" expected, got '" + position.getText() + "'")) {
            return;
        }
        SqlExpression expression = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{SqlReferenceExpression.class, SqlStringLiteralExpression.class});
        if (expression == null) {
            return;
        }
        if (PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)expression) instanceof PsiErrorElement) {
            return;
        }
        PsiElement parent2 = expression.getParent();
        ObjectKind inDefinitionNameKind = parent2 instanceof SqlDefinition && ((SqlDefinition)parent2).getNameElement() == expression ? ((SqlDefinition)parent2).getKind() : null;
        PsiReference ref = expression.getReference();
        if (!(ref instanceof SqlReferenceImpl) || SqlPsiMiscUtil.isJoinUsingColumn(position)) {
            return;
        }
        Set strictExpectedTargetTypes = inDefinitionNameKind != null ? ((SqlReferenceImpl)ref).getExpectedTargetTypes(false, true) : Collections.emptySet();
        Project project = expression.getProject();
        SqlReferenceImpl sqlRef = (SqlReferenceImpl)ref;
        SqlReferenceElementType refType = sqlRef.getReferenceElementType();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)expression);
        Dbms dbms = SqlImplUtil.getDbms((PsiElement)expression);
        NamingService namingService = NamingServices.getNamingService(dbms);
        THashSet columnsNamesFromSelectForTableRef = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        THashSet columnsNamesFromSelectForColumnRef = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        Ref fromType = Ref.create();
        SqlReferenceExpression qualifier = expression instanceof SqlReferenceExpression ? (SqlReferenceExpression)ObjectUtils.tryCast((Object)((SqlReferenceExpression)expression).getQualifierExpression(), SqlReferenceExpression.class) : null;
        CompletionResultSet resultSet = result.caseInsensitive();
        if (refType == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) {
            String basePrefix;
            String qPrefix;
            String fullPrefix;
            List<String> items2;
            int index2;
            SqlTableExpression tableExpression;
            SqlSelectClause selectClause = (SqlSelectClause)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlSelectClause.class);
            SqlQueryExpression query = (SqlQueryExpression)ObjectUtils.tryCast((Object)(selectClause == null ? null : selectClause.getParent()), SqlQueryExpression.class);
            SqlTableExpression sqlTableExpression = tableExpression = query == null ? null : query.getTableExpression();
            if (tableExpression != null) {
                fromType.set((Object)tableExpression.getSqlType());
            }
            if (parent2 instanceof SqlGroupByClause && (qualifier != null || SqlImplUtil.sqlTraverser(parent2).children((Object)parent2).filter(SqlReferenceExpression.class).single() != null) && (index2 = ContainerUtil.indexOf(items2 = SqlReferenceExpressionCompletionProvider.collectGroupByItems((SqlGroupByClause)parent2), arg_0 -> SqlReferenceExpressionCompletionProvider.lambda$addCompletions$0(fullPrefix = (qPrefix = qualifier != null ? qualifier.getText() + "." : "") + (basePrefix = resultSet.getPrefixMatcher().getPrefix()), arg_0))) >= 0) {
                ContainerUtil.swapElements(items2, (int)0, (int)index2);
                String suggestion = StringUtil.join(items2, (String)", ");
                resultSet.addElement(SqlCompletionUtil.createTextLookup(suggestion.substring(qPrefix.length()), suggestion, 200.0));
            }
        }
        if (refType == SqlCompositeElementTypes.SQL_TABLE_REFERENCE && (parent2 instanceof SqlFromClause || parent2 instanceof SqlJoinExpression)) {
            SqlReferenceExpressionCompletionProvider.collectColumnsFromSelect(expression, namingService, (Set<String>)columnsNamesFromSelectForTableRef);
        }
        boolean triggerFunctionExpected = SqlCompletionUtil.isTriggerFunctionExpected(expression);
        boolean isValidSelectClause = refType == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE && expression.getParent() instanceof SqlSelectClause && !SqlCompletionUtil.hasMissingFrom((SqlElement)expression);
        PsiElement qualifyingEntity = SqlReferenceExpressionCompletionProvider.getQualifyingEntity(qualifier);
        DasTable qualifierTable = SqlReferenceExpressionCompletionProvider.getQualifyingTable(qualifyingEntity);
        PsiElement originalPosition = parameters.getOriginalPosition();
        LinkedHashSet columnsAtOnce = new LinkedHashSet();
        ArrayList<PsiElement> qualifiers = new ArrayList<PsiElement>();
        Ref hasSourceColumns = Ref.create((Object)false);
        HashSet<String> existingFunctionNames = new HashSet<String>();
        ArrayList restrainedElements = new ArrayList();
        Set<ObjectKind> strictTypes = sqlRef.getExpectedTargetTypesStrict(dialect);
        boolean restrainNonStrict = dbms.isPostgres() && refType.getTargetKind() == ObjectKind.TABLE;
        SqlCompletionUtil.addReferenceCompletionVariants(sqlRef, resultSet.getPrefixMatcher(), (Consumer<LookupElement>)((Consumer)arg_0 -> SqlReferenceExpressionCompletionProvider.lambda$addCompletions$1(inDefinitionNameKind, strictExpectedTargetTypes, refType, triggerFunctionExpected, dialect, hasSourceColumns, originalPosition, namingService, (Set)columnsNamesFromSelectForTableRef, fromType, strictTypes, restrainNonStrict, restrainedElements, resultSet, arg_0)), parameters, (arg_0, arg_1) -> SqlReferenceExpressionCompletionProvider.lambda$addCompletions$2(isValidSelectClause, namingService, (Set)columnsNamesFromSelectForColumnRef, qualifierTable, columnsAtOnce, qualifiers, existingFunctionNames, arg_0, arg_1));
        for (LookupElement restrainedElement : restrainedElements) {
            resultSet.addElement(restrainedElement);
        }
        if (columnsAtOnce.size() > 1 && (element2 = SqlCompletionUtil.createAllColumnsLookupElement(columnsAtOnce, project, dialect, columnsNamesFromSelectForColumnRef.size() > 0 && SqlReferenceExpressionCompletionProvider.requiresFullSpecInOrderBy(dbms) ? 149 : ((Boolean)hasSourceColumns.get() != false ? 10 : 5), false, SqlCompletionUtil.canQualify((IElementType)refType), qualifiers, dbms)) != null) {
            resultSet.addElement(element2);
        }
        SqlFunctionDefinitionCompletions.addFunctionDefinitionCompletions(parameters, result, existingFunctionNames);
    }

    @Nullable
    private static PsiElement getNonWSPrecedingLeaf(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(3);
        }
        PsiElement result = element2;
        while ((result = PsiTreeUtil.prevLeaf((PsiElement)result)) instanceof PsiWhiteSpace || result instanceof PsiComment) {
        }
        return result;
    }

    private static List<String> collectGroupByItems(SqlGroupByClause groupByClause) {
        SqlQueryExpression queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)groupByClause, SqlQueryExpression.class);
        if (queryExpression == null) {
            return Collections.emptyList();
        }
        SqlSelectClause selectClause = queryExpression.getSelectClause();
        JBIterable expressions2 = selectClause != null ? JBIterable.from((Iterable)selectClause.getExpressions()) : JBIterable.empty();
        return (List)JBIterable.from((Iterable)expressions2).filter(e -> {
            final boolean[] isAggregate = new boolean[]{false};
            if (SqlImplUtil.isAsteriskRef((PsiElement)e)) {
                return false;
            }
            e.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element2 instanceof SqlFunctionCallExpression && SqlPsiUtilCoreKt.isAggregateCall((SqlFunctionCallExpression)element2)) {
                        isAggregate[0] = true;
                        this.stopWalking();
                    }
                    super.visitElement(element2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/completion/providers/SqlReferenceExpressionCompletionProvider$1", "visitElement"));
                }
            });
            return !isAggregate[0];
        }).map(e -> {
            SqlExpression unwrapped = e instanceof SqlAsExpression ? ((SqlAsExpression)e).getExpression() : e;
            return unwrapped != null ? unwrapped.getText() : null;
        }).filter(Conditions.notNull()).addAllTo(new ArrayList());
    }

    private static boolean isQueryExpression(@Nullable SqlExpression expression) {
        if (expression instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)expression).getReferenceElementType().getTargetKind() != ObjectKind.COLUMN;
        }
        if (expression instanceof SqlResultSetExpression) {
            return true;
        }
        if (!(expression instanceof SqlParenthesizedExpression)) {
            return false;
        }
        List expressions2 = ((SqlParenthesizedExpression)expression).getExpressionList();
        if (expressions2.size() != 1) {
            return false;
        }
        return SqlReferenceExpressionCompletionProvider.isQueryExpression((SqlExpression)expressions2.get(0));
    }

    private static boolean requiresFullSpecInOrderBy(@NotNull Dbms dbms) {
        if (dbms == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(4);
        }
        return dbms.isMicrosoft() || dbms.isOracle();
    }

    private static PsiElement getQualifyingEntity(@Nullable SqlReferenceExpression qualifier) {
        return qualifier == null ? null : qualifier.resolve();
    }

    private static DasTable getQualifyingTable(@Nullable PsiElement qualifyingElement) {
        SqlExpression expression;
        PsiElement qualifier = qualifyingElement instanceof SqlAsExpression ? ((expression = ((SqlAsExpression)qualifyingElement).getExpression()) instanceof SqlReferenceExpression ? ((SqlReferenceExpression)expression).resolve() : null) : qualifyingElement;
        return (DasTable)ObjectUtils.tryCast((Object)qualifier, DasTable.class);
    }

    private static boolean acceptBySelectAndQualifier(NamingService namingService, Set<String> columnsNamesFromSelectForColumnRef, DasObject element2, DasTable qualifierTable) {
        if (!SqlReferenceExpressionCompletionProvider.isStar(columnsNamesFromSelectForColumnRef, namingService) && !columnsNamesFromSelectForColumnRef.contains(namingService.enquote(element2.getName(), element2.getKind()))) {
            return false;
        }
        return qualifierTable == null || qualifierTable.equals(element2.getDasParent());
    }

    private static boolean isStar(Set<String> columnRefs, NamingService namingService) {
        return columnRefs.size() == 1 && namingService.enquote("*", ObjectKind.COLUMN).equals(columnRefs.iterator().next());
    }

    private static void collectColumnsFromSelect(@NotNull SqlExpression expression, final @NotNull NamingService namingService, final @NotNull Set<String> columnsNamesFromSelect) {
        SqlQueryExpression query;
        SqlSelectClause select;
        if (expression == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(5);
        }
        if (namingService == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(6);
        }
        if (columnsNamesFromSelect == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(7);
        }
        SqlSelectClause sqlSelectClause = select = (query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlQueryExpression.class)) != null ? query.getSelectClause() : null;
        if (select != null) {
            select.accept(new SqlVisitor(){

                public void visitSqlReferenceExpression(SqlReferenceExpression e) {
                    if (e.getQualifierExpression() == null && e.getReferenceElementType() == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) {
                        columnsNamesFromSelect.add(namingService.enquote(e.getName(), e.getKind()));
                    }
                }

                public void visitSqlElement(SqlElement e) {
                    for (PsiElement element2 = e.getFirstChild(); element2 != null; element2 = element2.getNextSibling()) {
                        if (!(element2 instanceof SqlElement)) continue;
                        ((SqlElement)element2).accept((SqlVisitor)this);
                    }
                }
            });
        }
    }

    private static int getInitialSimilarity(@Nullable SqlTableType fromType, @Nullable DasObject tgt) {
        if (fromType == null) {
            return 0;
        }
        boolean isColumn = tgt instanceof DasColumn;
        boolean isTable = tgt instanceof DasTable;
        if (!isColumn && !isTable) {
            return 0;
        }
        for (int i2 = 0; i2 < fromType.getColumnCount(); ++i2) {
            if (isColumn && fromType.getColumnElement(i2).equals(tgt)) {
                return 2;
            }
            if (!isTable || !Comparing.equal((Object)fromType.getColumnQualifier(i2), (Object)tgt)) continue;
            return 1;
        }
        return 0;
    }

    private static int getSimilarity(@NotNull NamingService namingService, @NotNull Set<String> columnsNamesFromSelect, @Nullable SqlTableType fromType, @Nullable DasObject tgt) {
        if (namingService == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(8);
        }
        if (columnsNamesFromSelect == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(9);
        }
        int similarity = SqlReferenceExpressionCompletionProvider.getInitialSimilarity(fromType, tgt);
        if (columnsNamesFromSelect.isEmpty() || !(tgt instanceof DasTable)) {
            return similarity;
        }
        for (DasColumn c2 : DasUtil.getColumns((DasObject)tgt)) {
            if (!columnsNamesFromSelect.contains(namingService.enquote(c2.getName(), c2.getKind()))) continue;
            ++similarity;
        }
        return similarity;
    }

    @NotNull
    private static LookupElement adjustBySimilarity(@NotNull LookupElement element2, int similarity) {
        if (element2 == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(10);
        }
        if (similarity == 0) {
            LookupElement lookupElement = element2;
            if (lookupElement == null) {
                SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(11);
            }
            return lookupElement;
        }
        int factorizedSimilarity = similarity * 10;
        double priority = element2 instanceof PrioritizedLookupElement ? ((PrioritizedLookupElement)element2).getPriority() : 0.0;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)element2, (double)(priority + (double)factorizedSimilarity));
        if (lookupElement == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(12);
        }
        return lookupElement;
    }

    private static /* synthetic */ void lambda$addCompletions$2(boolean isValidSelectClause, NamingService namingService, Set columnsNamesFromSelectForColumnRef, DasTable qualifierTable, Set columnsAtOnce, List qualifiers, Set existingFunctionNames, DasObject element2, PsiElement q) {
        if ((element2 instanceof DasColumn || element2 instanceof SqlAsExpression && !SqlReferenceExpressionCompletionProvider.isQueryExpression(((SqlAsExpression)element2).getExpression())) && (isValidSelectClause || SqlReferenceExpressionCompletionProvider.acceptBySelectAndQualifier(namingService, columnsNamesFromSelectForColumnRef, element2, qualifierTable))) {
            if (columnsAtOnce.add(element2)) {
                qualifiers.add(q);
            }
        } else if (element2 instanceof DasRoutine && element2 instanceof PsiNamedElement) {
            existingFunctionNames.add(element2.getName());
        }
    }

    private static /* synthetic */ void lambda$addCompletions$1(ObjectKind inDefinitionNameKind, Set strictExpectedTargetTypes, SqlReferenceElementType refType, boolean triggerFunctionExpected, SqlLanguageDialectEx dialect, Ref hasSourceColumns, PsiElement originalPosition, NamingService namingService, Set columnsNamesFromSelectForTableRef, Ref fromType, Set strictTypes, boolean restrainNonStrict, List restrainedElements, CompletionResultSet resultSet, LookupElement element2) {
        ObjectKind targetKind;
        SqlNameElement ne;
        DasObject dasObject;
        DasSymbol symbol = SqlCompletionUtil.getTargetSymbol(element2);
        DasObject dasObject2 = dasObject = symbol != null ? symbol.getDasObject() : null;
        if (dasObject != null) {
            ObjectKind kind;
            ObjectKind objectKind = dasObject.getKind();
            if (!(inDefinitionNameKind == null || objectKind != inDefinitionNameKind && strictExpectedTargetTypes.contains(objectKind))) {
                return;
            }
            if (!refType.isQualified() && (kind = refType.getTargetKind()) != SqlDbElementType.ANY && objectKind != kind) {
                return;
            }
        }
        if (triggerFunctionExpected) {
            if (!(dasObject instanceof DasRoutine)) {
                return;
            }
            DasArgument returnArgument = ((DasRoutine)dasObject).getReturnArgument();
            if (returnArgument == null) {
                return;
            }
            if (!dialect.getTypeSystem().isTriggerFunctionType(returnArgument.getDataType())) {
                return;
            }
        }
        if (dasObject instanceof DasColumn && element2 instanceof PrioritizedLookupElement && ((PrioritizedLookupElement)element2).getPriority() >= 10.0) {
            hasSourceColumns.set((Object)true);
        }
        if (originalPosition != null && symbol instanceof SqlDefinition && (ne = ((SqlDefinition)symbol).getNameElement()) != null && PsiTreeUtil.isContextAncestor((PsiElement)ne, (PsiElement)originalPosition, (boolean)false)) {
            return;
        }
        LookupElement lookupElement = SqlReferenceExpressionCompletionProvider.adjustBySimilarity(element2, SqlReferenceExpressionCompletionProvider.getSimilarity(namingService, columnsNamesFromSelectForTableRef, (SqlTableType)fromType.get(), dasObject));
        if (dasObject != null && !strictTypes.contains(targetKind = dasObject.getKind()) && (restrainNonStrict || targetKind == ObjectKind.SCHEMA || targetKind == ObjectKind.DATABASE)) {
            restrainedElements.add(lookupElement);
            return;
        }
        resultSet.addElement(lookupElement);
    }

    private static /* synthetic */ boolean lambda$addCompletions$0(String fullPrefix, String item) {
        return StringUtil.startsWithIgnoreCase((String)item, (String)fullPrefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namingService";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsNamesFromSelect";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/providers/SqlReferenceExpressionCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/providers/SqlReferenceExpressionCompletionProvider";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustBySimilarity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNonWSPrecedingLeaf";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requiresFullSpecInOrderBy";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectColumnsFromSelect";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSimilarity";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "adjustBySimilarity";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

