/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.sql.SqlRoutineIndex;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.ExecutionFlowAnalyzer;
import com.intellij.sql.psi.IsImpure;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer;", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myDdlAnalyzer", "Lcom/intellij/sql/psi/SqlDdlStatement;", "myDmlAnalyzer", "Lcom/intellij/sql/psi/SqlDmlStatement;", "myRoutineAnalyzer", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "mySideEffectsProducingAnalyzer", "analyze", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "element", "isAcceptable", "", "DdlAnalyzer", "DmlAnalyzer", "RoutineFlowAnalyzer", "SideEffectsProducingAnalyzer", "intellij.database.sql.impl"})
public final class SqlGeneralExecutionFlowAnalyzer
implements ExecutionFlowAnalyzer<PsiElement> {
    private final ExecutionFlowAnalyzer<SqlFunctionCallExpression> myRoutineAnalyzer;
    private final ExecutionFlowAnalyzer<SqlDmlStatement> myDmlAnalyzer;
    private final ExecutionFlowAnalyzer<SqlDdlStatement> myDdlAnalyzer;
    private final ExecutionFlowAnalyzer<PsiElement> mySideEffectsProducingAnalyzer;

    @NotNull
    public ExecutionFlowAnalyzer.Flow analyze(@NotNull PsiElement element2) {
        ExecutionFlowAnalyzer.Flow flow;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (this.myRoutineAnalyzer.isAcceptable(element2)) {
            ExecutionFlowAnalyzer.Flow flow2 = this.myRoutineAnalyzer.analyze((PsiElement)((SqlFunctionCallExpression)element2));
            flow = flow2;
            Intrinsics.checkNotNullExpressionValue((Object)flow2, (String)"myRoutineAnalyzer.analyz\u2026qlFunctionCallExpression)");
        } else if (this.myDdlAnalyzer.isAcceptable(element2)) {
            ExecutionFlowAnalyzer.Flow flow3 = this.myDdlAnalyzer.analyze((PsiElement)((SqlDdlStatement)element2));
            flow = flow3;
            Intrinsics.checkNotNullExpressionValue((Object)flow3, (String)"myDdlAnalyzer.analyze(element as SqlDdlStatement)");
        } else if (this.myDmlAnalyzer.isAcceptable(element2)) {
            ExecutionFlowAnalyzer.Flow flow4 = this.myDmlAnalyzer.analyze((PsiElement)((SqlDmlStatement)element2));
            flow = flow4;
            Intrinsics.checkNotNullExpressionValue((Object)flow4, (String)"myDmlAnalyzer.analyze(element as SqlDmlStatement)");
        } else if (this.mySideEffectsProducingAnalyzer.isAcceptable(element2)) {
            ExecutionFlowAnalyzer.Flow flow5 = this.mySideEffectsProducingAnalyzer.analyze(element2);
            flow = flow5;
            Intrinsics.checkNotNullExpressionValue((Object)flow5, (String)"mySideEffectsProducingAnalyzer.analyze(element)");
        } else {
            ExecutionFlowAnalyzer.Flow flow6 = ExecutionFlowAnalyzer.UnknownFlow;
            flow = flow6;
            Intrinsics.checkNotNullExpressionValue((Object)flow6, (String)"ExecutionFlowAnalyzer.UnknownFlow");
        }
        return flow;
    }

    public boolean isAcceptable(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.myRoutineAnalyzer.isAcceptable(element2) || this.myDdlAnalyzer.isAcceptable(element2) || this.myDmlAnalyzer.isAcceptable(element2) || this.mySideEffectsProducingAnalyzer.isAcceptable(element2);
    }

    public SqlGeneralExecutionFlowAnalyzer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.myRoutineAnalyzer = new RoutineFlowAnalyzer(project);
        this.myDmlAnalyzer = new DmlAnalyzer();
        this.myDdlAnalyzer = new DdlAnalyzer();
        this.mySideEffectsProducingAnalyzer = new SideEffectsProducingAnalyzer();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$DmlAnalyzer;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer;", "Lcom/intellij/sql/psi/SqlDmlStatement;", "()V", "analyze", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "element", "isAcceptable", "", "e", "Lcom/intellij/psi/PsiElement;", "DmlFlow", "intellij.database.sql.impl"})
    private static final class DmlAnalyzer
    implements ExecutionFlowAnalyzer<SqlDmlStatement> {
        @NotNull
        public ExecutionFlowAnalyzer.Flow analyze(@NotNull SqlDmlStatement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            return (ExecutionFlowAnalyzer.Flow)DmlFlow.INSTANCE;
        }

        public boolean isAcceptable(@NotNull PsiElement e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return e instanceof SqlDmlStatement;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$DmlAnalyzer$DmlFlow;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$SimpleFlow;", "()V", "transform", "T", "transformer", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;", "(Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;)Ljava/lang/Object;", "intellij.database.sql.impl"})
        public static final class DmlFlow
        extends ExecutionFlowAnalyzer.SimpleFlow {
            @NotNull
            public static final DmlFlow INSTANCE;

            public <T> T transform(@NotNull ExecutionFlowAnalyzer.FlowTransformer<T> transformer) {
                Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
                return (T)transformer.dml();
            }

            private DmlFlow() {
                super(ThreeState.NO);
            }

            static {
                DmlFlow dmlFlow;
                INSTANCE = dmlFlow = new DmlFlow();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$DdlAnalyzer;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer;", "Lcom/intellij/sql/psi/SqlDdlStatement;", "()V", "analyze", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "element", "isAcceptable", "", "e", "Lcom/intellij/psi/PsiElement;", "DdlFlow", "intellij.database.sql.impl"})
    private static final class DdlAnalyzer
    implements ExecutionFlowAnalyzer<SqlDdlStatement> {
        @NotNull
        public ExecutionFlowAnalyzer.Flow analyze(@NotNull SqlDdlStatement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            return (ExecutionFlowAnalyzer.Flow)DdlFlow.INSTANCE;
        }

        public boolean isAcceptable(@NotNull PsiElement e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return e instanceof SqlDdlStatement;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$DdlAnalyzer$DdlFlow;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$SimpleFlow;", "()V", "transform", "T", "transformer", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;", "(Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;)Ljava/lang/Object;", "intellij.database.sql.impl"})
        public static final class DdlFlow
        extends ExecutionFlowAnalyzer.SimpleFlow {
            @NotNull
            public static final DdlFlow INSTANCE;

            public <T> T transform(@NotNull ExecutionFlowAnalyzer.FlowTransformer<T> transformer) {
                Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
                return (T)transformer.ddl();
            }

            private DdlFlow() {
                super(ThreeState.NO);
            }

            static {
                DdlFlow ddlFlow;
                INSTANCE = ddlFlow = new DdlFlow();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$SideEffectsProducingAnalyzer;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer;", "Lcom/intellij/psi/PsiElement;", "()V", "analyze", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "element", "isAcceptable", "", "e", "CommonFlow", "intellij.database.sql.impl"})
    private static final class SideEffectsProducingAnalyzer
    implements ExecutionFlowAnalyzer<PsiElement> {
        @NotNull
        public ExecutionFlowAnalyzer.Flow analyze(@NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            return (ExecutionFlowAnalyzer.Flow)CommonFlow.INSTANCE;
        }

        public boolean isAcceptable(@NotNull PsiElement e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            IElementType type = PsiUtilBase.getElementType((PsiElement)e);
            return type instanceof IsImpure;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$SideEffectsProducingAnalyzer$CommonFlow;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$SimpleFlow;", "()V", "transform", "T", "transformer", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;", "(Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;)Ljava/lang/Object;", "intellij.database.sql.impl"})
        public static final class CommonFlow
        extends ExecutionFlowAnalyzer.SimpleFlow {
            @NotNull
            public static final CommonFlow INSTANCE;

            public <T> T transform(@NotNull ExecutionFlowAnalyzer.FlowTransformer<T> transformer) {
                Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
                return (T)transformer.common();
            }

            private CommonFlow() {
                super(ThreeState.NO);
            }

            static {
                CommonFlow commonFlow;
                INSTANCE = commonFlow = new CommonFlow();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015*\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R/\u0010\b\u001a#\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f0\t\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$RoutineFlowAnalyzer;", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer;", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "invalidateCache", "", "myCachedValues", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/database/psi/DbRoutine;", "kotlin.jvm.PlatformType", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "Lorg/jetbrains/annotations/NotNull;", "myProject", "analyze", "call", "isAcceptable", "value", "Lcom/intellij/psi/PsiElement;", "dbResolve", "", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "FlowEvaluator", "RoutineFlow", "intellij.database.sql.impl"})
    private static final class RoutineFlowAnalyzer
    implements ExecutionFlowAnalyzer<SqlFunctionCallExpression> {
        private volatile boolean invalidateCache;
        private final ConcurrentMap<DbRoutine, ExecutionFlowAnalyzer.Flow> myCachedValues;
        private final Project myProject;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public ExecutionFlowAnalyzer.Flow analyze(@NotNull SqlFunctionCallExpression call) {
            ExecutionFlowAnalyzer.Flow flow;
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Object object = call.getNameElement();
            if (object == null || (object = this.dbResolve((SqlReferenceExpression)object)) == null) {
                ExecutionFlowAnalyzer.Flow flow2 = ExecutionFlowAnalyzer.UnknownFlow;
                Intrinsics.checkNotNullExpressionValue((Object)flow2, (String)"ExecutionFlowAnalyzer.UnknownFlow");
                return flow2;
            }
            Object routines = object;
            if (routines.isEmpty()) {
                ExecutionFlowAnalyzer.Flow flow3 = ExecutionFlowAnalyzer.UnknownFlow;
                Intrinsics.checkNotNullExpressionValue((Object)flow3, (String)"ExecutionFlowAnalyzer.UnknownFlow");
                return flow3;
            }
            LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DbRoutine)CollectionsKt.first((List)routines)).getDataSource());
            if (localDataSource == null) {
                ExecutionFlowAnalyzer.Flow flow4 = ExecutionFlowAnalyzer.UnknownFlow;
                Intrinsics.checkNotNullExpressionValue((Object)flow4, (String)"ExecutionFlowAnalyzer.UnknownFlow");
                return flow4;
            }
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"DbImplUtil.getMaybeLocal\u2026nFlowAnalyzer.UnknownFlow");
            LocalDataSource dataSource2 = localDataSource;
            RoutineFlowAnalyzer routineFlowAnalyzer = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (routineFlowAnalyzer) {
                boolean bl3 = false;
                flow = new FlowEvaluator(this.myProject, (List<? extends DbRoutine>)routines, (SqlElement)call, dataSource2).evaluate();
            }
            return flow;
        }

        public boolean isAcceptable(@NotNull PsiElement value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return value2 instanceof SqlFunctionCallExpression;
        }

        /*
         * WARNING - void declaration
         */
        private final List<DbRoutine> dbResolve(SqlReferenceExpression $this$dbResolve) {
            void $this$mapNotNullTo$iv$iv;
            ResolveResult[] resolveResultArray = $this$dbResolve.multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(false)");
            ResolveResult[] $this$mapNotNull$iv = resolveResultArray;
            boolean $i$f$mapNotNull = false;
            ResolveResult[] resolveResultArray2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            void var9_9 = $this$forEach$iv$iv$iv;
            int n = ((void)var9_9).length;
            for (int j = 0; j < n; ++j) {
                DbRoutine dbRoutine;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = var9_9[j];
                boolean bl = false;
                void it2 = element$iv$iv;
                boolean bl2 = false;
                void v1 = it2;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                PsiElement psiElement = v1.getElement();
                if (!(psiElement instanceof DbRoutine)) {
                    psiElement = null;
                }
                if ((DbRoutine)psiElement == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                DbRoutine it$iv$iv = dbRoutine;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public RoutineFlowAnalyzer(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ContainerUtil.createConc\u2026utionFlowAnalyzer.Flow>()");
            this.myCachedValues = concurrentMap;
            this.myProject = project;
            project.getMessageBus().connect().subscribe(SqlRoutineIndex.Companion.getTopic(), (Object)new SqlRoutineIndex.SqlRoutineIndexListener(){

                @Override
                public void built() {
                    invalidateCache = true;
                }
            });
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0011J\u0016\u0010\u0018\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005H\u0002J\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005*\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$RoutineFlowAnalyzer$FlowEvaluator;", "", "project", "Lcom/intellij/openapi/project/Project;", "routines", "", "Lcom/intellij/database/psi/DbRoutine;", "context", "Lcom/intellij/sql/psi/SqlElement;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "(Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$RoutineFlowAnalyzer;Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/sql/psi/SqlElement;Lcom/intellij/database/dataSource/LocalDataSource;)V", "myDialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "myVisited", "Lit/unimi/dsi/fastutil/objects/ReferenceOpenHashSet;", "analyze", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "analyzeRoutine", "routine", "analyzeValue", "value", "Lcom/intellij/sql/SqlRoutineIndex$Value;", "evaluate", "mergeFlows", "flows", "asReference", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "Lcom/intellij/sql/SqlRoutineIndex$Call;", "dialect", "getValues", "Lcom/intellij/sql/SqlRoutineIndex$IdentifiablePath;", "intellij.database.sql.impl"})
        private final class FlowEvaluator {
            private final SqlLanguageDialect myDialect;
            private final ReferenceOpenHashSet<DbRoutine> myVisited;
            private final Project project;
            private final List<DbRoutine> routines;
            private final SqlElement context;

            @NotNull
            public final ExecutionFlowAnalyzer.Flow evaluate() {
                if (RoutineFlowAnalyzer.this.invalidateCache) {
                    RoutineFlowAnalyzer.this.myCachedValues.clear();
                    RoutineFlowAnalyzer.this.invalidateCache = false;
                }
                Object object = ReadAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<ExecutionFlowAnalyzer.Flow, Exception>(this){
                    final /* synthetic */ FlowEvaluator this$0;

                    public final ExecutionFlowAnalyzer.Flow compute() {
                        return FlowEvaluator.access$analyze(this.this$0, FlowEvaluator.access$getRoutines$p(this.this$0));
                    }
                    {
                        this.this$0 = flowEvaluator;
                    }
                }));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ReadAction.compute<Execu\u2026on> { analyze(routines) }");
                return (ExecutionFlowAnalyzer.Flow)object;
            }

            /*
             * WARNING - void declaration
             */
            private final ExecutionFlowAnalyzer.Flow analyze(List<? extends DbRoutine> routines) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = routines;
                FlowEvaluator flowEvaluator = this;
                boolean $i$f$mapNotNull = false;
                void var4_5 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ExecutionFlowAnalyzer.Flow flow;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    DbRoutine it2 = (DbRoutine)element$iv$iv;
                    boolean bl2 = false;
                    if (this.analyzeRoutine(it2) == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    ExecutionFlowAnalyzer.Flow it$iv$iv = flow;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                return flowEvaluator.mergeFlows(list);
            }

            /*
             * WARNING - void declaration
             */
            private final ExecutionFlowAnalyzer.Flow analyzeRoutine(DbRoutine routine) {
                ExecutionFlowAnalyzer.Flow flow;
                ExecutionFlowAnalyzer.Flow cached = (ExecutionFlowAnalyzer.Flow)RoutineFlowAnalyzer.this.myCachedValues.get(routine);
                if (cached != null) {
                    return cached;
                }
                if (this.myVisited.contains((Object)routine)) {
                    return null;
                }
                this.myVisited.add((Object)routine);
                DasObject dasObject = (DasObject)routine;
                DbDataSource dbDataSource = routine.getDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"routine.dataSource");
                ObjectPath path = ObjectPaths.of(dasObject, (CasingProvider)dbDataSource.getModel());
                Object object = DbImplUtil.getMaybeLocalDataSource((DasDataSource)routine.getDataSource());
                if (object == null || (object = ((AbstractDataSource)((Object)object)).getUniqueId()) == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DbImplUtil.getMaybeLocal\u2026?.uniqueId ?: return null");
                Object dataSource2 = object;
                ObjectPath objectPath = path;
                Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"path");
                List<SqlRoutineIndex.Value> values2 = this.getValues(new SqlRoutineIndex.IdentifiablePath((String)dataSource2, objectPath), this.project);
                if (values2.isEmpty()) {
                    flow = RoutineFlow.PURE;
                } else {
                    Collection<ExecutionFlowAnalyzer.Flow> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = values2;
                    FlowEvaluator flowEvaluator = this;
                    boolean $i$f$map = false;
                    void var9_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        SqlRoutineIndex.Value value2 = (SqlRoutineIndex.Value)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        ExecutionFlowAnalyzer.Flow flow2 = this.analyzeValue((SqlRoutineIndex.Value)it2);
                        collection.add(flow2);
                    }
                    collection = (List)destination$iv$iv;
                    flow = flowEvaluator.mergeFlows((List<? extends ExecutionFlowAnalyzer.Flow>)collection);
                }
                ExecutionFlowAnalyzer.Flow flow3 = flow;
                ((Map)RoutineFlowAnalyzer.this.myCachedValues).put(routine, flow3);
                return flow3;
            }

            private final ExecutionFlowAnalyzer.Flow analyzeValue(SqlRoutineIndex.Value value2) {
                if (!value2.getPure()) {
                    return RoutineFlow.NOT_PURE;
                }
                SqlRoutineIndex.Call[] callArray = value2.getCalls();
                int n = 0;
                if (callArray.length == 0) {
                    return RoutineFlow.PURE;
                }
                for (SqlRoutineIndex.Call call : value2.getCalls()) {
                    SqlReferenceExpression reference;
                    if (this.asReference(call, this.context, this.myDialect) == null) {
                        continue;
                    }
                    List resolved = RoutineFlowAnalyzer.this.dbResolve(reference);
                    if (resolved.isEmpty()) {
                        return RoutineFlow.UNSURE;
                    }
                    ExecutionFlowAnalyzer.Flow result = this.analyze(resolved);
                    if (result.isPure() != ThreeState.NO && result.isPure() != ThreeState.UNSURE) continue;
                    return result;
                }
                return RoutineFlow.PURE;
            }

            private final ExecutionFlowAnalyzer.Flow mergeFlows(List<? extends ExecutionFlowAnalyzer.Flow> flows) {
                ExecutionFlowAnalyzer.Flow flow;
                ExecutionFlowAnalyzer.Flow it2;
                boolean bl;
                boolean $i$f$all;
                Iterable $this$all$iv;
                block8: {
                    $this$all$iv = flows;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it2 = (ExecutionFlowAnalyzer.Flow)element$iv;
                            boolean bl2 = false;
                            if (it2.isPure() == ThreeState.YES) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    flow = RoutineFlow.PURE;
                } else {
                    boolean bl3;
                    block9: {
                        $this$all$iv = flows;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl3 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                it2 = (ExecutionFlowAnalyzer.Flow)element$iv;
                                boolean bl4 = false;
                                if (it2.isPure() == ThreeState.NO) continue;
                                bl3 = false;
                                break block9;
                            }
                            bl3 = true;
                        }
                    }
                    flow = bl3 ? (ExecutionFlowAnalyzer.Flow)RoutineFlow.NOT_PURE : (ExecutionFlowAnalyzer.Flow)RoutineFlow.UNSURE;
                }
                return flow;
            }

            private final SqlReferenceExpression asReference(SqlRoutineIndex.Call $this$asReference, SqlElement context, SqlLanguageDialect dialect) {
                SqlReferenceElementType sqlReferenceElementType;
                IElementType iElementType = SqlTokenRegistry.findCompositeType((String)$this$asReference.getType());
                if (!(iElementType instanceof SqlReferenceElementType)) {
                    iElementType = null;
                }
                if ((sqlReferenceElementType = (SqlReferenceElementType)iElementType) == null) {
                    sqlReferenceElementType = SqlCompositeElementTypes.SQL_FUNCTION_REFERENCE;
                }
                SqlReferenceElementType refType = sqlReferenceElementType;
                return SqlPsiElementFactory.createReferenceFromText($this$asReference.getText(), dialect, refType, (PsiElement)context);
            }

            private final List<SqlRoutineIndex.Value> getValues(SqlRoutineIndex.IdentifiablePath $this$getValues, Project project) {
                ID<SqlRoutineIndex.IdentifiablePath, List<SqlRoutineIndex.Value>> id = SqlRoutineIndex.Companion.getIndexId();
                List list = FileBasedIndex.getInstance().getValues(id, (Object)$this$getValues, GlobalSearchScope.projectScope((Project)project));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"FileBasedIndex.getInstan\u2026pe.projectScope(project))");
                return CollectionsKt.flatten((Iterable)list);
            }

            public FlowEvaluator(@NotNull Project project, @NotNull List<? extends DbRoutine> routines, @NotNull SqlElement context, LocalDataSource dataSource2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(routines, (String)"routines");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
                this.project = project;
                this.routines = routines;
                this.context = context;
                SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(dataSource2);
                Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"DbSqlUtil.getSqlDialect(dataSource)");
                this.myDialect = sqlLanguageDialect;
                this.myVisited = new ReferenceOpenHashSet();
            }

            public static final /* synthetic */ ExecutionFlowAnalyzer.Flow access$analyze(FlowEvaluator $this, List routines) {
                return $this.analyze(routines);
            }

            public static final /* synthetic */ List access$getRoutines$p(FlowEvaluator $this) {
                return $this.routines;
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0004H\u0016J!\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\nH\u0016\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/SqlGeneralExecutionFlowAnalyzer$RoutineFlowAnalyzer$RoutineFlow;", "", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$Flow;", "pure", "Lcom/intellij/util/ThreeState;", "(Ljava/lang/String;ILcom/intellij/util/ThreeState;)V", "isPure", "transform", "T", "transformer", "Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;", "(Lcom/intellij/sql/psi/ExecutionFlowAnalyzer$FlowTransformer;)Ljava/lang/Object;", "PURE", "NOT_PURE", "UNSURE", "intellij.database.sql.impl"})
        private static final class RoutineFlow
        extends Enum<RoutineFlow>
        implements ExecutionFlowAnalyzer.Flow {
            public static final /* enum */ RoutineFlow PURE;
            public static final /* enum */ RoutineFlow NOT_PURE;
            public static final /* enum */ RoutineFlow UNSURE;
            private static final /* synthetic */ RoutineFlow[] $VALUES;
            private final ThreeState pure;

            static {
                RoutineFlow[] routineFlowArray = new RoutineFlow[3];
                RoutineFlow[] routineFlowArray2 = routineFlowArray;
                routineFlowArray[0] = PURE = new RoutineFlow(ThreeState.YES);
                routineFlowArray[1] = NOT_PURE = new RoutineFlow(ThreeState.NO);
                routineFlowArray[2] = UNSURE = new RoutineFlow(ThreeState.UNSURE);
                $VALUES = routineFlowArray;
            }

            @NotNull
            public ThreeState isPure() {
                return this.pure;
            }

            public <T> T transform(@NotNull ExecutionFlowAnalyzer.FlowTransformer<T> transformer) {
                Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
                return (T)transformer.routine();
            }

            private RoutineFlow(ThreeState pure2) {
                this.pure = pure2;
            }

            public static RoutineFlow[] values() {
                return (RoutineFlow[])$VALUES.clone();
            }

            public static RoutineFlow valueOf(String string) {
                return Enum.valueOf(RoutineFlow.class, string);
            }
        }
    }
}

