/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class TableDialogSettings {
    @NotNull
    private final Consumer<? super Settings> mySettingsConsumer;
    private JPanel myPanel;
    private ComboBox<Settings.CodeType> myGenTypeBox;
    private ComboBox<Settings.FinalAction> myFinalActionBox;
    private JPanel myGenTypePanel;
    private JPanel myRenamePanel;
    private JCheckBox myCommentAndStrings;
    private JCheckBox myTextOccurrences;
    private JCheckBox myLoadedSources;
    private boolean myUpdating;
    private final Settings mySettings;

    private void createUIComponents() {
        final Font small = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
        this.myGenTypeBox = new ComboBox((Object[])Settings.CodeType.values());
        this.myGenTypeBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Settings.CodeType>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Settings.CodeType> list, Settings.CodeType value2, int index2, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setFont(small);
                SimpleTextAttributes attributes2 = TableDialogSettings.this.myGenTypeBox.isEnabled() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
                switch (value2) {
                    case ALTER_CODE: {
                        this.append(DatabaseBundle.message((String)"TableDialogSettings.modify.existing.objects", (Object[])new Object[0]), attributes2);
                        break;
                    }
                    case CREATE_NEW_CODE: {
                        this.append(DatabaseBundle.message((String)"TableDialogSettings.create.modified.objects", (Object[])new Object[0]), attributes2);
                        break;
                    }
                    case CREATE_ALL_CODE: {
                        this.append(DatabaseBundle.message((String)"TableDialogSettings.create.all.objects", (Object[])new Object[0]), attributes2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/view/ui/TableDialogSettings$1", "customizeCellRenderer"));
            }
        });
        this.myFinalActionBox = new ComboBox((Object[])Settings.FinalAction.values());
        this.myFinalActionBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Settings.FinalAction>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Settings.FinalAction> list, Settings.FinalAction value2, int index2, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.setFont(small);
                switch (value2) {
                    case APPEND_DDL: {
                        this.append(DatabaseBundle.message((String)"TableDialogSettings.open.in.editor", (Object[])new Object[0]));
                        break;
                    }
                    case EXEC_IN_DB: {
                        this.append(DatabaseBundle.message((String)"TableDialogSettings.execute.in.database", (Object[])new Object[0]));
                        break;
                    }
                    case REPLACE_DDL: {
                        this.append(DatabaseBundle.message((String)"TableDialogSettings.replace.existing.ddl", (Object[])new Object[0]));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/view/ui/TableDialogSettings$2", "customizeCellRenderer"));
            }
        });
    }

    public TableDialogSettings(@NotNull Consumer<? super Settings> settingsConsumer, @NotNull Settings settings) {
        if (settingsConsumer == null) {
            TableDialogSettings.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            TableDialogSettings.$$$reportNull$$$0(1);
        }
        this.myUpdating = false;
        this.mySettingsConsumer = settingsConsumer;
        this.mySettings = new Settings(settings);
        this.$$$setupUI$$$();
        this.myFinalActionBox.addItemListener(e -> {
            if (this.myUpdating || e.getStateChange() != 1) {
                return;
            }
            Settings.FinalAction type = (Settings.FinalAction)((Object)((Object)ObjectUtils.tryCast((Object)e.getItem(), Settings.FinalAction.class)));
            if (type != null) {
                this.processSettingsChange((Object)type);
            }
        });
        this.myGenTypeBox.addItemListener(e -> {
            if (this.myUpdating || e.getStateChange() != 1) {
                return;
            }
            Settings.CodeType type = (Settings.CodeType)((Object)((Object)ObjectUtils.tryCast((Object)e.getItem(), Settings.CodeType.class)));
            if (type != null) {
                this.processSettingsChange((Object)type);
            }
        });
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        this.processSettingsChange((Object)this.mySettings.finalAction);
        Font small = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
        for (Component component : UIUtil.uiTraverser((Component)this.myPanel).traverse()) {
            component.setFont(small);
        }
        this.myCommentAndStrings.addActionListener(e -> {
            this.mySettings.renameInCommentsAndLiterals = this.myCommentAndStrings.isSelected();
            this.mySettingsConsumer.consume((Object)this.mySettings);
        });
        this.myTextOccurrences.addActionListener(e -> {
            this.mySettings.renameTextOccurrences = this.myTextOccurrences.isSelected();
            this.mySettingsConsumer.consume((Object)this.mySettings);
        });
        this.myLoadedSources.addActionListener(e -> {
            this.mySettings.renameInStorage = this.myLoadedSources.isSelected();
            this.mySettingsConsumer.consume((Object)this.mySettings);
        });
    }

    public void setAvailability(boolean db, boolean ddl, boolean rename2) {
        ArrayList<Settings.FinalAction> items2 = new ArrayList<Settings.FinalAction>();
        if (db) {
            items2.add(Settings.FinalAction.EXEC_IN_DB);
        }
        if (ddl) {
            items2.add(Settings.FinalAction.REPLACE_DDL);
        }
        items2.add(Settings.FinalAction.APPEND_DDL);
        Settings.FinalAction action2 = this.mySettings.finalAction;
        if (action2 == Settings.FinalAction.EXEC_IN_DB && !db) {
            action2 = Settings.FinalAction.APPEND_DDL;
        }
        if (action2 == Settings.FinalAction.REPLACE_DDL && !ddl) {
            action2 = Settings.FinalAction.APPEND_DDL;
        }
        this.myFinalActionBox.setModel((ComboBoxModel)new CollectionComboBoxModel(items2, (Object)action2));
        this.myRenamePanel.setVisible(rename2);
        if (action2 != this.mySettings.finalAction) {
            this.processSettingsChange((Object)action2);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            TableDialogSettings.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        ComboBox<Settings.FinalAction> comboBox = this.myFinalActionBox;
        if (comboBox == null) {
            TableDialogSettings.$$$reportNull$$$0(3);
        }
        return comboBox;
    }

    private void processSettingsChange(@NotNull Object prop) {
        if (prop == null) {
            TableDialogSettings.$$$reportNull$$$0(4);
        }
        this.myUpdating = true;
        try {
            this.updateSettings(prop);
            this.updateButtons();
            this.mySettingsConsumer.consume((Object)this.mySettings);
        }
        finally {
            this.myUpdating = false;
        }
    }

    private void updateButtons() {
        this.myFinalActionBox.setSelectedItem((Object)this.mySettings.finalAction);
        this.myGenTypeBox.setSelectedItem((Object)this.mySettings.codeType);
        this.myLoadedSources.setSelected(this.mySettings.renameInStorage);
        this.myTextOccurrences.setSelected(this.mySettings.renameTextOccurrences);
        this.myCommentAndStrings.setSelected(this.mySettings.renameInCommentsAndLiterals);
    }

    private void updateSettings(@NotNull Object prop) {
        if (prop == null) {
            TableDialogSettings.$$$reportNull$$$0(5);
        }
        assert (prop instanceof Settings.CodeType || prop instanceof Settings.FinalAction);
        if (prop instanceof Settings.FinalAction) {
            this.setFinalAction((Settings.FinalAction)((Object)prop));
        } else {
            this.setCodeType((Settings.CodeType)((Object)prop));
        }
    }

    private void setFinalAction(@NotNull Settings.FinalAction finalAction) {
        if (finalAction == null) {
            TableDialogSettings.$$$reportNull$$$0(6);
        }
        this.mySettings.finalAction = finalAction;
        boolean enableCodeType = finalAction == Settings.FinalAction.APPEND_DDL;
        this.myGenTypePanel.setVisible(enableCodeType);
        if (finalAction == Settings.FinalAction.EXEC_IN_DB) {
            this.setCodeType(Settings.CodeType.ALTER_CODE);
        } else if (finalAction == Settings.FinalAction.REPLACE_DDL) {
            this.setCodeType(Settings.CodeType.CREATE_NEW_CODE);
        } else {
            this.setCodeType(this.mySettings.codeType);
        }
    }

    private void setCodeType(@NotNull Settings.CodeType codeType) {
        if (codeType == null) {
            TableDialogSettings.$$$reportNull$$$0(7);
        }
        this.mySettings.codeType = codeType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsConsumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/TableDialogSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/TableDialogSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processSettingsChange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFinalAction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCodeType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 3, 1, 2, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myRenamePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 5, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", TableDialogSettings.class).getString("TableDialogSettings.rename.in"));
        Component component = jPanel2.add(jLabel);
        this.myCommentAndStrings = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", TableDialogSettings.class).getString("TableDialogSettings.comments.and.strings"));
        Component component2 = jPanel2.add(jCheckBox3);
        this.myTextOccurrences = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", TableDialogSettings.class).getString("TableDialogSettings.text.occurrences"));
        Component component3 = jPanel2.add(jCheckBox2);
        this.myLoadedSources = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", TableDialogSettings.class).getString("TableDialogSettings.loaded.sources"));
        Component component4 = jPanel2.add(jCheckBox);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(5, 0));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", TableDialogSettings.class).getString("TableDialogSettings.action"));
        jPanel4.add((Component)jLabel2, "West");
        ComboBox<Settings.FinalAction> comboBox = this.myFinalActionBox;
        jPanel4.add((Component)comboBox, "Center");
        this.myGenTypePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 2, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", TableDialogSettings.class).getString("TableDialogSettings.script"));
        jPanel.add((Component)jLabel3, "West");
        ComboBox<Settings.CodeType> comboBox2 = this.myGenTypeBox;
        jPanel.add((Component)comboBox2, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static class Settings {
        public FinalAction finalAction;
        public CodeType codeType;
        public boolean renameTextOccurrences;
        public boolean renameInCommentsAndLiterals;
        public boolean renameInStorage;

        public Settings() {
            this.finalAction = FinalAction.EXEC_IN_DB;
            this.codeType = CodeType.ALTER_CODE;
        }

        public Settings(@NotNull Settings settings) {
            if (settings == null) {
                Settings.$$$reportNull$$$0(0);
            }
            this.finalAction = FinalAction.EXEC_IN_DB;
            this.codeType = CodeType.ALTER_CODE;
            this.assign(settings);
        }

        public Settings(@NotNull FinalAction finalAction, @NotNull CodeType codeType) {
            if (finalAction == null) {
                Settings.$$$reportNull$$$0(1);
            }
            if (codeType == null) {
                Settings.$$$reportNull$$$0(2);
            }
            this(new Settings().assign(finalAction, codeType));
        }

        public Settings assign(@NotNull FinalAction finalAction, @NotNull CodeType codeType) {
            if (finalAction == null) {
                Settings.$$$reportNull$$$0(3);
            }
            if (codeType == null) {
                Settings.$$$reportNull$$$0(4);
            }
            this.finalAction = finalAction;
            this.codeType = codeType;
            return this;
        }

        public Settings assign(@NotNull Settings settings) {
            if (settings == null) {
                Settings.$$$reportNull$$$0(5);
            }
            this.assign(settings.finalAction, settings.codeType);
            this.renameTextOccurrences = settings.renameTextOccurrences;
            this.renameInCommentsAndLiterals = settings.renameInCommentsAndLiterals;
            this.renameInStorage = settings.renameInStorage;
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "finalAction";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codeType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/view/ui/TableDialogSettings$Settings";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "assign";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static enum CodeType {
            CREATE_ALL_CODE,
            CREATE_NEW_CODE,
            ALTER_CODE;

        }

        public static enum FinalAction {
            EXEC_IN_DB,
            REPLACE_DDL,
            APPEND_DDL;

        }
    }
}

