/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.view.ui.MultiSeparatorListCellRenderer;
import com.intellij.openapi.roots.ui.configuration.SidePanelCountLabel;
import com.intellij.openapi.roots.ui.configuration.SidePanelSeparator;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.JBList;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TObjectIntHashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSidePanel {
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final JList<Place> myList;
    private final CollectionListModel<Place> myModel;
    private final ListWithFilter<Place> myListWithFilter;
    private final MyGroupedItemsListRenderer myRenderer;
    private final JScrollPane myScroll;
    private final List<Pair<String, Integer>> mySeparators = new ArrayList<Pair<String, Integer>>();
    private final TObjectIntHashMap<Place> myItems = new TObjectIntHashMap();

    public DataSourceSidePanel(ComponentConfigurator componentConfigurator, Function<Place, String> filterSupplier) {
        this.myModel = new CollectionListModel((Object[])new Place[0]);
        this.myList = new JBList(this.myModel);
        this.myScroll = ScrollPaneFactory.createScrollPane(null, (boolean)true);
        this.myScroll.setViewport((JViewport)((Object)new MyGradientViewport()));
        this.myScroll.setCorner("LOWER_RIGHT_CORNER", null);
        this.myScroll.setCorner("LOWER_LEFT_CORNER", null);
        this.myScroll.setCorner("UPPER_RIGHT_CORNER", null);
        this.myScroll.setCorner("UPPER_LEFT_CORNER", null);
        this.myList.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.myRenderer = new MyGroupedItemsListRenderer(this.myList, componentConfigurator);
        this.myList.setCellRenderer(this.myRenderer);
        this.myList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index2;
                if (SwingUtilities.isRightMouseButton(e) && (index2 = DataSourceSidePanel.this.myList.locationToIndex(e.getPoint())) != -1 && !DataSourceSidePanel.this.myList.isSelectedIndex(index2)) {
                    DataSourceSidePanel.this.myList.setSelectedIndex(index2);
                }
                super.mousePressed(e);
            }
        });
        this.myListWithFilter = (ListWithFilter)ListWithFilter.wrap(this.myList, (JScrollPane)this.myScroll, o -> o == null ? null : (String)filterSupplier.fun(o));
        this.myPanel.add((Component)this.myListWithFilter, "Center");
        this.myList.setSelectionMode(2);
        UIUtil.setBackgroundRecursively((Component)this.myPanel, (Color)UIUtil.SIDE_PANEL_BACKGROUND);
    }

    public int getItemWidth(Place place) {
        JComponent component = this.myRenderer.getItemCellRendererComponent(this.myList, place, -1, true, true);
        this.myList.add(component);
        if (component instanceof CellRendererPanel) {
            ((CellRendererPanel)component).forceInvalidate();
        } else {
            component.invalidate();
        }
        int width = (int)component.getPreferredSize().getWidth();
        this.myList.remove(component);
        return width;
    }

    public void setMinimumWidth(int w) {
        this.myScroll.getViewport().setMinimumSize(new Dimension(w, -1));
    }

    public JList<Place> getList() {
        return this.myList;
    }

    public void addPlace(Place place) {
        this.myItems.put((Object)place, this.myModel.getSize());
        this.myModel.add((Object)place);
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    public void clear() {
        this.myModel.removeAll();
        this.mySeparators.clear();
    }

    public Matcher getSpeedSearchMatcher() {
        return this.myListWithFilter.getSpeedSearch().getMatcher();
    }

    public void addSeparator(@NotNull String text2) {
        if (text2 == null) {
            DataSourceSidePanel.$$$reportNull$$$0(0);
        }
        this.mySeparators.add((Pair<String, Integer>)Pair.create((Object)text2, (Object)this.myModel.getSize()));
    }

    public void resetSelection() {
        if (this.myList.getSelectedValue() == null) {
            return;
        }
        this.myList.getSelectionModel().setValueIsAdjusting(true);
        this.myList.setSelectedValue(null, false);
        this.myList.getSelectionModel().setAnchorSelectionIndex(-1);
        this.myList.getSelectionModel().setLeadSelectionIndex(-1);
        this.myList.getSelectionModel().setValueIsAdjusting(false);
    }

    public void select(Place place) {
        this.myList.setSelectedValue(place, true);
        int index2 = this.myList.getSelectedIndex();
        if (index2 < 0) {
            return;
        }
        int count = this.myList.getVisibleRowCount();
        Rectangle bounds = this.myList.getCellBounds(Math.max(0, index2 - count / 2), index2);
        if (bounds == null) {
            return;
        }
        this.myList.scrollRectToVisible(bounds);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    @NotNull
    public SeparatorWithText doCreateSeparator() {
        SidePanelSeparator separator = new SidePanelSeparator(){

            public Dimension getMaximumSize() {
                Dimension size = super.getMaximumSize();
                int width = (int)DataSourceSidePanel.this.myScroll.getViewport().getExtentSize().getWidth();
                return new Dimension(width, (int)size.getHeight());
            }
        };
        separator.setBorder((Border)new JBEmptyBorder(0, 0, 12, 0));
        separator.setAlignmentX(0.0f);
        SidePanelSeparator sidePanelSeparator = separator;
        if (sidePanelSeparator == null) {
            DataSourceSidePanel.$$$reportNull$$$0(1);
        }
        return sidePanelSeparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DataSourceSidePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DataSourceSidePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSeparator";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyGradientViewport
    extends GradientViewport {
        private final SeparatorWithText myHeader;

        MyGradientViewport() {
            super(DataSourceSidePanel.this.myList, (Insets)JBUI.insetsTop((int)5), true);
            this.myHeader = DataSourceSidePanel.this.doCreateSeparator();
            this.myHeader.setBorder(BorderFactory.createEmptyBorder(4, 10, 0, 0));
        }

        protected Component getHeader() {
            int y = DataSourceSidePanel.this.myList.getY();
            if (y == 0) {
                return null;
            }
            String group = this.findGroupNameAt(-y);
            if (group == null) {
                return null;
            }
            this.myHeader.setCaption(group);
            return this.myHeader;
        }

        @Nls
        @Nullable
        private String findGroupNameAt(int y) {
            int headerW = this.myHeader.getPreferredSize().height;
            int baseIndex = DataSourceSidePanel.this.myList.locationToIndex(new Point(0, y + headerW));
            if (baseIndex < 0) {
                return null;
            }
            int sepIndex = -1;
            int len = DataSourceSidePanel.this.mySeparators.size();
            for (int i2 = 0; i2 < len; ++i2) {
                if (baseIndex >= (Integer)DataSourceSidePanel.this.mySeparators.get((int)i2).second) continue;
                sepIndex = i2 - 1;
                break;
            }
            if (sepIndex < 0) {
                return null;
            }
            int index2 = (Integer)DataSourceSidePanel.this.mySeparators.get((int)sepIndex).second;
            String result = null;
            JComponent component = (JComponent)DataSourceSidePanel.this.myRenderer.getListCellRendererComponent(DataSourceSidePanel.this.myList, DataSourceSidePanel.this.myList.getModel().getElementAt(index2), index2, false, false);
            int delta = DataSourceSidePanel.this.myList.getCellBounds((int)index2, (int)index2).y - DataSourceSidePanel.this.myList.getInsets().top - y - this.myHeader.getInsets().top;
            for (int i3 = 0; i3 < component.getComponentCount(); ++i3) {
                Component c2 = component.getComponent(i3);
                if (!(c2 instanceof SeparatorWithText)) continue;
                String caption = ((SeparatorWithText)c2).getCaption();
                int height = c2.getHeight();
                if (!caption.startsWith("-")) {
                    result = caption;
                    delta += height - ((SeparatorWithText)c2).getInsets().bottom;
                    break;
                }
                delta += height;
            }
            return delta > 0 ? null : result;
        }
    }

    private class MyGroupedItemsListRenderer
    extends MultiSeparatorListCellRenderer<Place> {
        private final SidePanelCountLabel myCountLabel;
        private final ComponentConfigurator myConfigurator;
        private final JLabel myIconComponent;
        private final CellRendererPanel myItemComponent;
        private final SimpleColoredComponent myTextComponent;
        private final Icon myEmptyIcon;

        MyGroupedItemsListRenderer(@NotNull JList<Place> list, ComponentConfigurator configurator) {
            if (configurator == null) {
                MyGroupedItemsListRenderer.$$$reportNull$$$0(0);
            }
            super(list);
            this.myCountLabel = new SidePanelCountLabel();
            this.myIconComponent = new JLabel();
            this.myItemComponent = new CellRendererPanel();
            this.myTextComponent = new SimpleColoredComponent();
            this.myEmptyIcon = JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)16, (int)16));
            this.myConfigurator = configurator;
            this.myIconComponent.setBorder((Border)JBUI.Borders.empty((int)0, (int)15, (int)0, (int)3));
            this.myItemComponent.setLayout((LayoutManager)new BoxLayout((Container)this.myItemComponent, 0));
            this.myItemComponent.add((Component)this.myIconComponent);
            this.myItemComponent.add((Component)this.myTextComponent);
            this.myItemComponent.add((Component)this.myCountLabel);
            this.myItemComponent.add(Box.createHorizontalGlue());
            this.myItemComponent.setAlignmentX(0.0f);
            this.myTextComponent.setBorder(JBUI.Borders.empty((int)2));
        }

        @Override
        @NotNull
        public SeparatorWithText createSeparator() {
            SeparatorWithText separatorWithText = DataSourceSidePanel.this.doCreateSeparator();
            if (separatorWithText == null) {
                MyGroupedItemsListRenderer.$$$reportNull$$$0(1);
            }
            return separatorWithText;
        }

        List<Object> merge(boolean fromBeginning, List<Object> separators) {
            if (separators.size() > 1) {
                Object last = separators.get(separators.size() - 1);
                if (!last.equals("--")) {
                    Object preLast = separators.get(separators.size() - 2);
                    if (!fromBeginning && preLast.equals("--") && !last.equals("---")) {
                        return Arrays.asList("--", this.canonize(last));
                    }
                    return Collections.singletonList(this.canonize(last));
                }
                for (int i2 = separators.size() - 2; i2 >= 0; --i2) {
                    Object sep = separators.get(i2);
                    if (sep.equals("--")) continue;
                    return Collections.singletonList(this.canonize(sep));
                }
                return Collections.singletonList(this.canonize(last));
            }
            return separators;
        }

        @Override
        public Collection<Object> getSeparatorsAbove(int viewIndex) {
            int index2 = DataSourceSidePanel.this.myItems.get((Object)((Place)DataSourceSidePanel.this.myListWithFilter.getList().getModel().getElementAt(viewIndex)));
            int prev = viewIndex > 0 ? DataSourceSidePanel.this.myItems.get((Object)((Place)DataSourceSidePanel.this.myListWithFilter.getList().getModel().getElementAt(viewIndex - 1))) : -1;
            List<Object> separators = new ArrayList<Object>();
            for (Pair<String, Integer> separator : DataSourceSidePanel.this.mySeparators) {
                if ((Integer)separator.getSecond() > prev && (Integer)separator.getSecond() <= index2) {
                    separators.add(separator.getFirst());
                    continue;
                }
                if ((Integer)separator.getSecond() <= index2) continue;
                break;
            }
            if (!(separators = this.merge(index2 == 0, separators)).isEmpty() && separators.get(separators.size() - 1).equals("--") && index2 == 0) {
                return Collections.emptyList();
            }
            return separators;
        }

        private Object canonize(Object s2) {
            return s2.equals("---") ? "--" : s2;
        }

        @Override
        public void configureSeparator(@NotNull SeparatorWithText component, @NotNull Object separator) {
            if (component == null) {
                MyGroupedItemsListRenderer.$$$reportNull$$$0(2);
            }
            if (separator == null) {
                MyGroupedItemsListRenderer.$$$reportNull$$$0(3);
            }
            component.setCaption(String.valueOf(this.canonize(separator)));
        }

        @Override
        protected JComponent getItemCellRendererComponent(JList<? extends Place> list, Place value2, int index2, boolean isSelected, boolean focus) {
            Color bg = isSelected ? UIUtil.getListSelectionBackground((boolean)true) : UIUtil.SIDE_PANEL_BACKGROUND;
            Color fg = isSelected ? UIUtil.getListSelectionForeground((boolean)true) : UIUtil.getLabelForeground();
            this.myCountLabel.setVisible(false);
            this.myTextComponent.clear();
            this.myTextComponent.setBackground(bg);
            this.myTextComponent.setForeground(fg);
            this.myConfigurator.configure(this.myTextComponent, value2, isSelected);
            this.myConfigurator.updateCount(this.myCountLabel, value2);
            this.myIconComponent.setIcon((Icon)ObjectUtils.chooseNotNull((Object)this.myTextComponent.getIcon(), (Object)this.myEmptyIcon));
            this.myTextComponent.setIcon(null);
            this.myTextComponent.setMaximumSize(null);
            this.myTextComponent.setMaximumSize(this.myTextComponent.getPreferredSize());
            this.myCountLabel.setSelected(isSelected);
            this.myItemComponent.setSelected(isSelected);
            this.myItemComponent.setBackground(bg);
            return this.myItemComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourceSidePanel$MyGroupedItemsListRenderer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourceSidePanel$MyGroupedItemsListRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSeparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "configureSeparator";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ComponentConfigurator {
        public void configure(@NotNull SimpleColoredComponent var1, @NotNull Place var2, boolean var3);

        public void updateCount(@NotNull SidePanelCountLabel var1, @NotNull Place var2);
    }
}

