/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DataSourceProblemsHolder;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.view.ui.DatabaseConfigEditorImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceErrorsConfigurable
implements Configurable,
DataSourceProblemsHolder,
Disposable,
Runnable {
    private final DatabaseConfigEditorImpl myEditor;
    private final Set<DataSourceProblem> myErrors;
    private final Alarm myAlarm;
    private final Runnable myErrorsChanged;
    private final List<Object> myActions;
    private boolean myInvalid;
    private final JPanel myPanel;
    private final JTextPane myContent;

    public DataSourceErrorsConfigurable(@NotNull DatabaseConfigEditorImpl editor, @NotNull Runnable errorsChanged) {
        if (editor == null) {
            DataSourceErrorsConfigurable.$$$reportNull$$$0(0);
        }
        if (errorsChanged == null) {
            DataSourceErrorsConfigurable.$$$reportNull$$$0(1);
        }
        this.myErrors = new HashSet<DataSourceProblem>();
        this.myActions = new ArrayList<Object>();
        this.myInvalid = true;
        this.myEditor = editor;
        this.myErrorsChanged = errorsChanged;
        this.myPanel = new JPanel(new BorderLayout());
        this.myContent = new JTextPane();
        this.myContent.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myContent.setEditable(false);
        this.myContent.setBackground(UIUtil.getListBackground());
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myContent, (boolean)true);
        pane.setHorizontalScrollBarPolicy(31);
        this.myPanel.add((Component)pane, "Center");
        this.myAlarm = new Alarm((Disposable)this);
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)this.myPanel, new Activatable(){

            public void showNotify() {
                DataSourceErrorsConfigurable.this.updateErrors();
            }
        }));
        this.myContent.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                String desc = e.getDescription();
                Object action2 = DataSourceProblem.extractAction(desc, DataSourceErrorsConfigurable.this.myActions);
                if (action2 != null) {
                    DataSourceErrorsConfigurable.this.myEditor.processAction(action2);
                } else if ("fixall".equals(desc)) {
                    DataSourceErrorsConfigurable.this.fixAll();
                }
            }
        });
    }

    private void fixAll() {
        new Task.Modal(null, DatabaseBundle.message((String)"progress.title.fixing.problems", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                NamedProgressive fix;
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                HashSet<DataSourceProblem> fixed = new HashSet<DataSourceProblem>();
                while (!indicator.isCanceled() && (fix = DataSourceErrorsConfigurable.this.findSomethingToFix(fixed)) != null) {
                    ProgressWindow window = (ProgressWindow)ObjectUtils.tryCast((Object)indicator, ProgressWindow.class);
                    if (window != null) {
                        window.setTitle(fix.getName());
                    }
                    this.setTitle(fix.getName());
                    fix.run(indicator);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/DataSourceErrorsConfigurable$3", "run"));
            }
        }.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private NamedProgressive findSomethingToFix(@NotNull Set<DataSourceProblem> fixed) {
        if (fixed == null) {
            DataSourceErrorsConfigurable.$$$reportNull$$$0(2);
        }
        DataSourceProblem toFix = null;
        Set<DataSourceProblem> set = this.myErrors;
        synchronized (set) {
            for (DataSourceProblem error2 : this.myErrors) {
                if (error2.getFix() == null || fixed.contains(error2)) continue;
                toFix = error2;
            }
        }
        if (toFix != null) {
            fixed.add(toFix);
            return toFix.getFix();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrorsCount() {
        Set<DataSourceProblem> set = this.myErrors;
        synchronized (set) {
            return this.myErrors.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addError(@NotNull DataSourceProblem error2) {
        if (error2 == null) {
            DataSourceErrorsConfigurable.$$$reportNull$$$0(3);
        }
        Set<DataSourceProblem> set = this.myErrors;
        synchronized (set) {
            if (this.myErrors.contains(error2)) {
                return;
            }
            this.myErrors.add(error2);
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeError(@NotNull DataSourceProblem error2) {
        if (error2 == null) {
            DataSourceErrorsConfigurable.$$$reportNull$$$0(4);
        }
        Set<DataSourceProblem> set = this.myErrors;
        synchronized (set) {
            this.myErrors.remove(error2);
            this.refresh();
        }
    }

    private void refresh() {
        this.myInvalid = true;
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest((Runnable)this, 100);
    }

    public void dispose() {
    }

    @Override
    public void run() {
        if (this.myPanel.isShowing()) {
            this.updateErrors();
        }
        this.myErrorsChanged.run();
    }

    @NotNull
    private List<DataSourceProblem> getSortedProblems() {
        ArrayList<DataSourceProblem> result = new ArrayList<DataSourceProblem>(this.myErrors);
        result.sort((o1, o2) -> {
            int res2 = Comparing.compare((int)this.myEditor.getDataSourceGroup(o1.getOwner()), (int)this.myEditor.getDataSourceGroup(o2.getOwner()));
            if (res2 != 0) {
                return res2;
            }
            res2 = Comparing.compare((Comparable)((Object)this.myEditor.getObjectName(o1.getOwner())), (Comparable)((Object)this.myEditor.getObjectName(o2.getOwner())));
            if (res2 != 0) {
                return res2;
            }
            return Comparing.compare((Comparable)((Object)o1.getText().getTitle()), (Comparable)((Object)o2.getText().getTitle()));
        });
        ArrayList<DataSourceProblem> arrayList = result;
        if (arrayList == null) {
            DataSourceErrorsConfigurable.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateErrors() {
        List<DataSourceProblem> problems;
        Set<DataSourceProblem> set = this.myErrors;
        synchronized (set) {
            if (!this.myInvalid) {
                return;
            }
            this.myInvalid = false;
            problems = this.getSortedProblems();
        }
        this.myActions.clear();
        @NlsSafe StringBuilder html = new StringBuilder(DataSourceErrorsConfigurable.getHtmlPrefix());
        String ulWithoutBullets = "<ul style=\"list-style-type:none;list-style-image:none\">";
        html.append(ulWithoutBullets);
        int fixCount = 0;
        for (DataSourceProblem error2 : problems) {
            String description = error2.getText().getDescription();
            html.append("<li> \u2014&nbsp;");
            if (description.startsWith("<html>") && description.endsWith("<html>")) {
                description = description.substring("<html>".length(), description.length() - "</html>".length());
            }
            DataSourceProblem.formatText(html, this.myActions, description, error2.getText().getLinkActions());
            if (error2.getFix() != null) {
                DataSourceProblem.formatText(html, this.myActions, DatabaseBundle.message((String)"a.href.action0.fix.a", (Object[])new Object[0]), error2.getFix());
                ++fixCount;
            }
            html.append("</li>");
        }
        html.append("</ul>");
        if (fixCount > 1) {
            html.append(ulWithoutBullets).append(DatabaseBundle.message((String)"li.a.href.fixall.fix.all.a.li.ul", (Object[])new Object[0]));
        }
        html.append("</body></html>");
        this.myContent.setText(html.toString());
    }

    @NotNull
    public static String getHtmlPrefix() {
        String string = "<html><header><style type='text/css'>body {  color: #" + ColorUtil.toHex((Color)new JBColor((Color)Gray.x33, UIUtil.getLabelForeground())) + ";  font-family: '" + StartupUiUtil.getLabelFont().getName() + ",serif';  font-size: " + StartupUiUtil.getLabelFont().getSize() + ";}li {  margin-bottom: 5;}ol {}a { text-decoration: none;}</style></header><body>";
        if (string == null) {
            DataSourceErrorsConfigurable.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return DatabaseBundle.message((String)"configurable.DataSourceErrorsConfigurable.display.name", (Object[])new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public void reset() {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorsChanged";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixed";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DataSourceErrorsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DataSourceErrorsConfigurable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedProblems";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSomethingToFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addError";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeError";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

