/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DdlPreviewBase;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.EditorTextField;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlPreview
extends DdlPreviewBase {
    public static final Condition<DeObject> LIGHT_EXPORTED = object -> object.lightExported;

    @NotNull
    public static JBIterable<ObjectAction> basicTraversal(@NotNull DeModel model) {
        if (model == null) {
            DdlPreview.$$$reportNull$$$0(0);
        }
        JBIterable jBIterable = ((JBTreeTraverser)model.traverser().expandAndSkip(LIGHT_EXPORTED)).bfsTraversal().filter(DeObject.class).transform(object -> new ObjectAction(object.hasEdited() ? ObjectAction.Action.ALTER : ObjectAction.Action.CREATE, (DeObject)object));
        if (jBIterable == null) {
            DdlPreview.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    public DdlPreview(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            DdlPreview.$$$reportNull$$$0(2);
        }
        super(context);
    }

    public boolean updatePreview(@Nullable ModelTraverser traverser) {
        if (traverser != null) {
            ScriptingResult res2 = traverser.generate();
            this.updatePreview(res2.getScriptText());
            for (CompositeText.Fragment f : res2.getScript().getFragments()) {
                if (f.getError() == null) continue;
                return false;
            }
            return true;
        }
        this.myPreview.setText("-- No editor");
        this.scrollToBeginning();
        return false;
    }

    @Override
    @NotNull
    public String getPreviewText() {
        String string = this.myPreview.getText();
        if (string == null) {
            DdlPreview.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public EditorTextField getTextField() {
        EditorTextField editorTextField2 = this.myPreview;
        if (editorTextField2 == null) {
            DdlPreview.$$$reportNull$$$0(4);
        }
        return editorTextField2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DdlPreview";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DdlPreview";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "basicTraversal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "basicTraversal";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ObjectAction {
        public final Action action;
        public final DeObject object;

        public ObjectAction(Action action2, DeObject object) {
            this.action = action2;
            this.object = object;
        }

        public static enum Action {
            CREATE,
            ALTER,
            DROP;

        }
    }

    public static class ModelTraverser {
        public final DeModel model;

        public ModelTraverser(DeModel model) {
            this.model = model;
        }

        @NotNull
        public ScriptingResult generate() {
            return new ScriptingResult(){

                @Override
                @NotNull
                public String[] getScriptStatements() {
                    String[] stringArray = new String[]{this.getScriptText()};
                    if (stringArray == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return stringArray;
                }

                @Override
                @NotNull
                public String getScriptText() {
                    return "-- fail";
                }

                @Override
                @NotNull
                public CompositeText getScript() {
                    return new SimpleCompositeText((CharSequence)this.getScriptText(), CompositeText.Kind.COMMENT);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DdlPreview$ModelTraverser$1", "getScriptStatements"));
                }
            };
        }

        @NotNull
        public JBIterable<ObjectAction> traverse() {
            JBIterable<ObjectAction> jBIterable = DdlPreview.basicTraversal(this.model);
            if (jBIterable == null) {
                ModelTraverser.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }

        public void setOptions(@NotNull ScriptingOptions options) {
            if (options == null) {
                ModelTraverser.$$$reportNull$$$0(1);
            }
        }

        @Nullable
        public ScriptingTask getTask() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DdlPreview$ModelTraverser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "traverse";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DdlPreview$ModelTraverser";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setOptions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

