/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseIndexEditor;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.IndexEditorModel;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.TableEditorToolbarsDecorator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ui.ListTableModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DatabaseTableIndicesEditor
extends DatabaseTableEditor.TabProvider {
    private final DatabaseEditorUtil.DbListTableWithEditor<DatabaseIndexEditor> myTable;
    private final JPanel myTablePanel;
    private final ListTableModel<DatabaseIndexEditor> myIndexModel;
    private final DatabaseTableEditor myTableEditor;
    private final DatabaseEditorCapabilities.TableEditorCaps myCaps;

    public DatabaseTableIndicesEditor(@NotNull DatabaseTableEditor tableEditor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorToolbarsDecorator toolbarsDecorator) {
        if (tableEditor == null) {
            DatabaseTableIndicesEditor.$$$reportNull$$$0(0);
        }
        if (caps == null) {
            DatabaseTableIndicesEditor.$$$reportNull$$$0(1);
        }
        if (toolbarsDecorator == null) {
            DatabaseTableIndicesEditor.$$$reportNull$$$0(2);
        }
        this.myTableEditor = tableEditor;
        this.myCaps = caps;
        this.myIndexModel = DatabaseEditorUtil.createTableModel(this.getTableModel(), new DatabaseEditorUtil.EditorModelHelper<DatabaseIndexEditor>(){

            @Override
            @Nullable
            public DatabaseIndexEditor createRow() {
                if (!DatabaseTableIndicesEditor.this.myCaps.getIndices().canAdd()) {
                    return null;
                }
                DeIndex index2 = DatabaseTableIndicesEditor.this.getTableModel().createIndex(new DeIndex.Item[0]);
                DatabaseTableIndicesEditor.this.getTableModel().addIndex(index2);
                return DatabaseTableIndicesEditor.this.createIndexEditor(index2);
            }

            @Override
            public boolean removeRow(DatabaseIndexEditor item, int idx) {
                if (!DatabaseTableIndicesEditor.this.myCaps.getIndices().canRemove()) {
                    return false;
                }
                DeIndex index2 = (DeIndex)((ObjectEditorModel)item.getModel()).getObject();
                DatabaseTableIndicesEditor.this.getTableModel().removeIndex(index2);
                Disposer.dispose((Disposable)item);
                return true;
            }
        }, false);
        this.myTable = DatabaseEditorUtil.createTableWithEditor(this.myIndexModel, this.myTableEditor, null);
        this.myTable.setVisibleRowCount(8);
        this.myTable.getTable().getEmptyText().setText(DatabaseBundle.message((String)"status.text.no.indices", (Object[])new Object[0]));
        ToolbarDecorator decorator = toolbarsDecorator.decorateIndices(caps, tableEditor, (JTable)this.myTable.getTable());
        this.myTablePanel = decorator.createPanel();
        DatabaseEditorUtil.setTableDecoratorMinSize(this.myTablePanel, (JTable)this.myTable.getTable());
        this.myTablePanel.setBorder(this.myTableEditor.getTabComponentBorder());
    }

    @Override
    public void configure(@NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (caps == null) {
            DatabaseTableIndicesEditor.$$$reportNull$$$0(3);
        }
        this.setTabEnabled(caps.getIndices().isSupported());
    }

    @Override
    @Nullable
    public DatabaseIndexEditor startItemEditing(@NotNull DeObject index2) {
        if (index2 == null) {
            DatabaseTableIndicesEditor.$$$reportNull$$$0(4);
        }
        return DatabaseEditorUtil.startItemEditing(index2, this.myTable, this.myIndexModel);
    }

    @Override
    public boolean isMyObject(@NotNull DeObject object) {
        if (object == null) {
            DatabaseTableIndicesEditor.$$$reportNull$$$0(5);
        }
        return object instanceof DeIndex;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myTablePanel;
        if (jPanel == null) {
            DatabaseTableIndicesEditor.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableEditor.getTableModel();
        if (tableEditorModel == null) {
            DatabaseTableIndicesEditor.$$$reportNull$$$0(7);
        }
        return tableEditorModel;
    }

    @NotNull
    private DatabaseIndexEditor createIndexEditor(@NotNull DeIndex index2) {
        if (index2 == null) {
            DatabaseTableIndicesEditor.$$$reportNull$$$0(8);
        }
        DatabaseIndexEditor editor = new DatabaseIndexEditor(this.myTableEditor.getState(), this.getTableModel().modelsCache.get(index2, IndexEditorModel.class), this.myCaps.getIndexCaps(index2.hasEdited()));
        Disposer.register((Disposable)this.myTableEditor, (Disposable)editor);
        editor.getIndexModel().addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseTableIndicesEditor.this.myTableEditor.fromModelToUi();
            }
        }, this.myTableEditor);
        DatabaseIndexEditor databaseIndexEditor = editor;
        if (databaseIndexEditor == null) {
            DatabaseTableIndicesEditor.$$$reportNull$$$0(9);
        }
        return databaseIndexEditor;
    }

    @Override
    public void updateFromModel() {
        DatabaseEditorUtil.cleanupEditors(this.myIndexModel, this.getTableModel().getIndices(), this::createIndexEditor);
        this.myTable.getTable().repaint();
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            DatabaseTableIndicesEditor.$$$reportNull$$$0(10);
        }
        return deTable;
    }

    @Override
    @NotNull
    public String getTabTitle() {
        int count = this.getTableModel().getIndicesCount();
        String string = DatabaseBundle.message((String)"DatabaseTableIndicesEditor.indices", (Object[])new Object[]{count, count == 0 ? 0 : 1});
        if (string == null) {
            DatabaseTableIndicesEditor.$$$reportNull$$$0(11);
        }
        return string;
    }

    @TestOnly
    @NotNull
    public ListTableModel<DatabaseIndexEditor> getIndicesListModel() {
        ListTableModel<DatabaseIndexEditor> listTableModel = this.myIndexModel;
        if (listTableModel == null) {
            DatabaseTableIndicesEditor.$$$reportNull$$$0(12);
        }
        return listTableModel;
    }

    @Override
    @Nullable
    public DatabaseEditorBaseEx getActiveEditor() {
        return DatabaseEditorUtil.getEditedItem(this.myTable, this.myIndexModel);
    }

    @NotNull
    public DatabaseEditorCapabilities.ListCapability getCaps() {
        DatabaseEditorCapabilities.ListCapability listCapability = this.myCaps.getIndices();
        if (listCapability == null) {
            DatabaseTableIndicesEditor.$$$reportNull$$$0(13);
        }
        return listCapability;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableEditor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbarsDecorator";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableIndicesEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableIndicesEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndexEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicesListModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startItemEditing";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMyObject";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createIndexEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

