/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.DasSchemaExporters;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.database.schemaEditor.DbObjectGrantsEditor;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeGrant;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseForeignKeyEditor;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.StatusText;
import gnu.trove.TIntObjectHashMap;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableGrantsEditor<G extends Grants.Grant>
extends DatabaseTableEditor.TabProvider {
    @Nullable
    private final Grants.Controller<G, ?> myController;
    @Nullable
    private final DbObjectGrantsEditor<G, ?> myEditor;
    private final DatabaseTableEditor myTableEditor;
    private final JComponent myComponent;
    private final BasicMetaObject<?> myMeta;
    private boolean myUpdating;

    public DatabaseTableGrantsEditor(@NotNull DatabaseTableEditor tableEditor) {
        if (tableEditor == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(0);
        }
        this.myTableEditor = tableEditor;
        Dbms dbms = tableEditor.getContext().getDbms();
        this.myMeta = (BasicMetaObject)DbImplUtilCore.getMetaModel(dbms).findMetaObjects(ObjectKind.TABLE).first();
        this.myController = tableEditor.getTable().model.getExportHelper().getContext().myGrantController;
        DbObjectGrantsEditor<G, ?> dbObjectGrantsEditor = this.myEditor = this.myMeta == null || this.myController == null ? null : DbObjectEditorFactory.createGrantsEditor(tableEditor.getProject(), this.myMeta, this.myController);
        if (this.myEditor == null) {
            this.myComponent = new JPanel();
            StatusText text2 = new StatusText(){

                protected boolean isStatusVisible() {
                    return true;
                }
            };
            text2.setText(DatabaseBundle.message((String)"status.text.no.grants", (Object[])new Object[0]));
            text2.attachTo((Component)this.myComponent);
        } else {
            this.myComponent = this.myEditor.getComponent();
            DbDataSource ds = tableEditor.getContext().getDataSource();
            this.myEditor.setEditedPath(this.getTable().getPath());
            if (ds != null) {
                this.myEditor.initCompletion(ds, null);
            }
            UserActivityWatcher watcher = new UserActivityWatcher();
            watcher.register((Component)this.myComponent);
            watcher.addUserActivityListener(() -> {
                if (this.myUpdating) {
                    return;
                }
                this.updateFromEditor();
            });
        }
        this.myComponent.setBorder(this.myTableEditor.getTabComponentBorder());
    }

    @Override
    public void configure(@NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (caps == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(1);
        }
        this.setTabEnabled(caps.getGrants().isSupported());
    }

    @Override
    @Nullable
    public DatabaseForeignKeyEditor startItemEditing(@NotNull DeObject any) {
        if (any == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Override
    public boolean isMyObject(@NotNull DeObject object) {
        if (object == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(3);
        }
        return false;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableEditor.getTableModel();
        if (tableEditorModel == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(5);
        }
        return tableEditorModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFromModel() {
        if (this.myEditor == null) {
            return;
        }
        this.myUpdating = true;
        try {
            TIntObjectHashMap colNames = new TIntObjectHashMap();
            for (DeColumn column2 : this.getTable().columns) {
                colNames.put((int)column2.getPosition(), (Object)column2.name);
            }
            this.myEditor.updateStructure(this.myMeta, (TIntObjectHashMap<String>)colNames);
            this.myEditor.reset(DasSchemaExporters.convertGrants(this.getTable(), this.myController));
        }
        finally {
            this.myUpdating = false;
        }
    }

    public void updateFromEditor() {
        if (this.myEditor == null) {
            return;
        }
        List<DbObjectGrantsEditor.GrantForUser<G>> grants = this.myEditor.getGrants();
        MultiMap<Integer, DeGrant<G>> res2 = DasSchemaExporters.convertGrants(grants);
        List<DeColumn> columns = this.getTableModel().getColumns();
        for (DeColumn column2 : columns) {
            ColumnEditorModel model = this.getTableModel().modelsCache.get(column2, ColumnEditorModel.class);
            model.setGrants((List)res2.get((Object)column2.getPosition()));
        }
        this.getTableModel().setGrants((List)res2.get(null));
        for (DeColumn column2 : columns) {
            this.getTableModel().modelsCache.get(column2, ColumnEditorModel.class).commit();
        }
        this.getTableModel().commit();
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(6);
        }
        return deTable;
    }

    public int getGrantsCount() {
        if (this.myController == null) {
            return 0;
        }
        return this.allGrants().filter((Condition)new DbImplUtil.HashingStrategyUnique<DeGrant<G>>(){

            public int computeHashCode(DeGrant<G> object) {
                return Objects.hash(object.userText, DatabaseTableGrantsEditor.this.myController.getGranteeStrategy().computeHashCode(object.userKey));
            }

            public boolean equals(DeGrant<G> o1, DeGrant<G> o2) {
                return Objects.equals(o1.userText, o2.userText) || DatabaseTableGrantsEditor.this.myController.getGranteeStrategy().equals(o1.userKey, o2.userKey);
            }
        }).size();
    }

    @NotNull
    private JBIterable<DeGrant<G>> allGrants() {
        JBIterable jBIterable = JBIterable.from(this.getTable().columns).flatten(c2 -> c2.grants).append(this.getTable().grants).map(o -> o);
        if (jBIterable == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public String getTabTitle() {
        int count = this.getGrantsCount();
        String string = DatabaseBundle.message((String)"DatabaseTableGrantsEditor.grants", (Object[])new Object[]{count, count == 0 ? 0 : 1});
        if (string == null) {
            DatabaseTableGrantsEditor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    public DatabaseEditorBaseEx getActiveEditor() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "any";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableGrantsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableGrantsEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "allGrants";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startItemEditing";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMyObject";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

