/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbSynonymImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTrigger;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.LanguageUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbNavigationUtils {
    public static boolean isLegacyNavigateToCodeFromTree() {
        return Registry.is((String)"database.legacy.navigate.to.code.from.tree", (boolean)false);
    }

    public static boolean canNavigateToData(DbElement element2) {
        DbElement adjusted = DbNavigationUtils.adjustForDataNavigation(element2);
        return DatabaseEditorHelper.isTableDataAvailable(adjusted);
    }

    public static void navigateToData(DbElement element2, boolean requestFocus, String @Nullable [] columnNames, @Nullable TriConsumer<DdlBuilder, List<DasColumn>, Dbms> whereCondition) {
        VirtualFile virtualFile;
        DbElement adjusted;
        if (columnNames == null && element2.getKind() == ObjectKind.COLUMN) {
            columnNames = new String[]{element2.getName()};
        }
        if (DatabaseEditorHelper.isTableDataAvailable(adjusted = DbNavigationUtils.adjustForDataNavigation(element2)) && (virtualFile = adjusted.getVirtualFile()) != null) {
            new OpenDataFileDescriptor(element2.getProject(), virtualFile, columnNames, null, null, whereCondition).navigate(requestFocus);
        }
    }

    @NotNull
    public static DbElement adjustForDataNavigation(DbElement element2) {
        DbElement adjusted = DbNavigationUtils.adjustForNavigation(element2);
        if (adjusted instanceof DbSynonymImpl) {
            adjusted = (DbElement)ObjectUtils.notNull((Object)((DbSynonymImpl)adjusted).resolveTarget(), (Object)adjusted);
        }
        DbElement dbElement = adjusted;
        if (dbElement == null) {
            DbNavigationUtils.$$$reportNull$$$0(0);
        }
        return dbElement;
    }

    @NotNull
    public static NavigatablePsiElement createToDatabaseViewNavigatable(@NotNull DbElement element2) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(1);
        }
        return new MyNavigationWrapper(element2){

            public void navigate(boolean requestFocus) {
                DbNavigationUtils.navigateToDatabaseView(this.myElement, requestFocus);
            }
        };
    }

    @NotNull
    public static NavigatablePsiElement createToDataOrSourceNavigatable(@NotNull DbElement element2) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(2);
        }
        if (DbNavigationUtils.canNavigateToData(element2)) {
            return DbNavigationUtils.createToDataNavigatable(element2);
        }
        return DbNavigationUtils.createToSourceNavigatable(element2);
    }

    @NotNull
    public static MyNavigationWrapper createToDataNavigatable(@NotNull DbElement element2) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(3);
        }
        return new MyNavigationWrapper(element2){

            public void navigate(boolean requestFocus) {
                DbNavigationUtils.navigateToData(this.myElement, requestFocus, null, null);
            }
        };
    }

    @NotNull
    public static NavigatablePsiElement createToDataSourceFileNavigatable(@NotNull DbElement element2) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(4);
        }
        return new MyNavigationWrapper(element2){

            public void navigate(boolean requestFocus) {
                DbNavigationUtils.navigateToDataSourceFile(this.myElement, requestFocus);
            }
        };
    }

    @NotNull
    public static NavigatablePsiElement createToSourceNavigatable(final @NotNull DbElement element2) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(5);
        }
        if (!DatabaseEditorHelper.isTableDataAvailable(element2)) {
            DbElement dbElement = element2;
            if (dbElement == null) {
                DbNavigationUtils.$$$reportNull$$$0(6);
            }
            return dbElement;
        }
        return new MyNavigationWrapper(element2){

            public void navigate(boolean requestFocus) {
                element2.navigate(requestFocus);
            }

            @Override
            public String getPresentableText() {
                return super.getPresentableText() + " (DDL)";
            }
        };
    }

    @NotNull
    public static NavigatablePsiElement createFromTreeNavigatable(@NotNull DbElement element2) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(7);
        }
        if (DbNavigationUtils.isLegacyNavigateToCodeFromTree()) {
            if (DbNavigationUtils.canNavigateToDataSourceFile(element2)) {
                return DbNavigationUtils.createToDataSourceFileNavigatable(element2);
            }
            return DbNavigationUtils.createToSourceNavigatable(element2);
        }
        if (DbNavigationUtils.canNavigateToData(element2)) {
            return DbNavigationUtils.createToDataNavigatable(element2);
        }
        if (DbNavigationUtils.canNavigateToDataSourceFile(element2)) {
            return DbNavigationUtils.createToDataSourceFileNavigatable(element2);
        }
        return DbNavigationUtils.createToSourceNavigatable(element2);
    }

    @Contract(value="!null->!null; null->null")
    public static PsiElement unwrapNavWrapper(@Nullable PsiElement element2) {
        return element2 instanceof MyNavigationWrapper ? ((MyNavigationWrapper)element2).myElement : element2;
    }

    @Nullable
    public static DbElement extractDbElement(@Nullable Navigatable navigatable) {
        return (DbElement)ObjectUtils.tryCast((Object)DbNavigationUtils.unwrapNavWrapper((PsiElement)ObjectUtils.tryCast((Object)navigatable, PsiElement.class)), DbElement.class);
    }

    public static VirtualFile getContainingFile(@NotNull DbElement dbElement, boolean refresh) {
        if (dbElement == null) {
            DbNavigationUtils.$$$reportNull$$$0(8);
        }
        DbElement navigateTo = DbNavigationUtils.adjustForNavigation(dbElement);
        return DbImplUtil.findSourceVirtualFile(navigateTo, refresh);
    }

    public static void navigateToDatabaseView(@NotNull DbElement element2, boolean requestFocus) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(9);
        }
        DatabaseView.select(element2.getProject(), Collections.singleton(element2), requestFocus);
    }

    public static void navigateToSource(@NotNull DbElement dbElement, boolean requestFocus) {
        if (dbElement == null) {
            DbNavigationUtils.$$$reportNull$$$0(10);
        }
        if (DbNavigationUtils.navigateToSqlElement(dbElement, requestFocus)) {
            return;
        }
        VirtualFile file = DbNavigationUtils.getContainingFile(dbElement, true);
        if (file != null) {
            Project project = dbElement.getProject();
            Runnable runnable = () -> {
                int offset = DbNavigationUtils.calcTargetOffset(project, file, (DasObject)dbElement);
                PsiNavigationSupport.getInstance().createNavigatable(project, file, offset).navigate(requestFocus);
            };
            DatabaseElementVirtualFileImpl vf = (DatabaseElementVirtualFileImpl)((Object)ObjectUtils.tryCast((Object)file, DatabaseElementVirtualFileImpl.class));
            if (vf != null && DatabaseEditorHelper.needsReload(vf)) {
                DatabaseEditorHelper.reloadIfNeeded(project, (DatabaseElementVirtualFileImpl)file).onSuccess(unused -> ApplicationManager.getApplication().invokeLater(runnable, project.getDisposed()));
                PsiNavigationSupport.getInstance().createNavigatable(project, file, 0).navigate(requestFocus);
            } else {
                runnable.run();
            }
        } else {
            DatabaseView.select((PsiElement)dbElement, requestFocus);
        }
    }

    public static boolean canNavigateToDataSourceFile(@NotNull DbElement element2) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(11);
        }
        return element2 instanceof DbDataSource || element2 instanceof DasNamespace && DbImplUtil.getMaybeLocalDataSource((DasDataSource)element2.getDataSource()) != null;
    }

    public static void navigateToDataSourceFile(@NotNull DbElement element2, boolean requestFocus) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(12);
        }
        if (element2 instanceof DbDataSource) {
            VirtualFile virtualFile;
            DatabaseSystem delegate = ((DbDataSource)element2).getDelegate();
            if (delegate instanceof SqlDataSource) {
                virtualFile = (VirtualFile)ContainerUtil.getFirstItem((List)((SqlDataSource)delegate).getRoots());
            } else {
                virtualFile = DatabaseEditorHelper.findExistingConsoleVirtualFile((DasDataSource)delegate);
                if (virtualFile == null) {
                    virtualFile = DatabaseEditorHelper.getConsoleVirtualFile((DasDataSource)delegate);
                }
            }
            if (virtualFile != null) {
                PsiNavigationSupport.getInstance().createNavigatable(element2.getProject(), virtualFile, -1).navigate(requestFocus);
            } else {
                String message2 = delegate instanceof SqlDataSource ? DatabaseBundle.message((String)"dialog.message.no.source.for.ddl.data.source", (Object[])new Object[0]) : DatabaseBundle.message((String)"dialog.message.no.console.for.data.source", (Object[])new Object[0]);
                CommonRefactoringUtil.showErrorHint((Project)element2.getProject(), null, (String)message2, (String)DatabaseBundle.message((String)"dialog.title.unable.to.navigate", (Object[])new Object[0]), null);
            }
        } else if (element2 instanceof DasNamespace && DbImplUtil.getMaybeLocalDataSource((DasDataSource)element2.getDataSource()) != null) {
            DbDataSource dataSource2 = element2.getDataSource();
            VirtualFile virtualFile = DatabaseEditorHelper.getConsoleVirtualFile((DasDataSource)dataSource2.getDelegate());
            if (virtualFile != null) {
                DatabaseEditorHelper.openConsoleForFile(element2.getProject(), (DasDataSource)dataSource2, (DasNamespace)element2.getDelegate(), virtualFile);
            } else {
                CommonRefactoringUtil.showErrorHint((Project)element2.getProject(), null, (String)DatabaseBundle.message((String)"dialog.message.no.console.for.data.source", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"dialog.title.unable.to.navigate", (Object[])new Object[0]), null);
            }
        }
    }

    private static boolean navigateToSqlElement(@NotNull DbElement dbElement, boolean requestFocus) {
        Navigatable descriptor2;
        if (dbElement == null) {
            DbNavigationUtils.$$$reportNull$$$0(13);
        }
        if (!DbSqlUtil.isSqlElement(dbElement)) {
            return false;
        }
        DasObject source = DbSqlUtil.getSqlSourceElement(dbElement);
        PsiElement psi = source instanceof PsiElement ? (PsiElement)source : (source instanceof DasSymbol ? ((DasSymbol)source).getNavigationElement() : null);
        Navigatable navigatable = descriptor2 = psi == null ? null : PsiNavigationSupport.getInstance().getDescriptor(psi);
        if (descriptor2 != null) {
            descriptor2.navigate(requestFocus);
        } else {
            CommonRefactoringUtil.showErrorHint((Project)dbElement.getProject(), null, (String)DatabaseBundle.message((String)"dialog.message.no.code.for.item", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"dialog.title.unable.to.navigate", (Object[])new Object[0]), null);
        }
        return true;
    }

    @NotNull
    public static DbElement adjustForNavigation(@NotNull DbElement element2) {
        DbElement parent2;
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(14);
        }
        if ((parent2 = element2.getParent()) instanceof DbTable) {
            if (!(element2 instanceof DbTrigger || element2 instanceof DbIndex || element2.getDelegate() instanceof BasicSourceAware)) {
                DbElement dbElement = parent2;
                if (dbElement == null) {
                    DbNavigationUtils.$$$reportNull$$$0(15);
                }
                return dbElement;
            }
            DbElement dbElement = element2;
            if (dbElement == null) {
                DbNavigationUtils.$$$reportNull$$$0(16);
            }
            return dbElement;
        }
        if (parent2 != null && parent2.getDelegate() instanceof BasicSourceAware) {
            if (element2.getDelegate() instanceof BasicSourceAware && element2.getKind() != ObjectKind.ROUTINE) {
                DbElement dbElement = element2;
                if (dbElement == null) {
                    DbNavigationUtils.$$$reportNull$$$0(17);
                }
                return dbElement;
            }
            DbElement dbElement = parent2;
            if (dbElement == null) {
                DbNavigationUtils.$$$reportNull$$$0(18);
            }
            return dbElement;
        }
        DbElement dbElement = element2;
        if (dbElement == null) {
            DbNavigationUtils.$$$reportNull$$$0(19);
        }
        return dbElement;
    }

    public static int calcTargetOffset(@NotNull Project project, @NotNull VirtualFile file, @NotNull DasObject template) {
        DasObject target;
        if (project == null) {
            DbNavigationUtils.$$$reportNull$$$0(20);
        }
        if (file == null) {
            DbNavigationUtils.$$$reportNull$$$0(21);
        }
        if (template == null) {
            DbNavigationUtils.$$$reportNull$$$0(22);
        }
        return (target = DbNavigationUtils.calcTarget(project, file, template)) instanceof PsiElement ? ((PsiElement)target).getTextOffset() : -1;
    }

    @Nullable
    public static DasObject calcTarget(@NotNull Project project, @NotNull VirtualFile file, final @NotNull DasObject template) {
        if (project == null) {
            DbNavigationUtils.$$$reportNull$$$0(23);
        }
        if (file == null) {
            DbNavigationUtils.$$$reportNull$$$0(24);
        }
        if (template == null) {
            DbNavigationUtils.$$$reportNull$$$0(25);
        }
        ObjectKind kind = template.getKind();
        ObjectKind parentKind = DasUtil.getKind((DasObject)template.getDasParent());
        if (kind == ObjectKind.BODY) {
            kind = ObjectKind.PACKAGE;
        } else if (kind == ObjectKind.ALIAS_TYPE && parentKind == ObjectKind.PACKAGE) {
            kind = ObjectKind.OBJECT_TYPE;
        }
        String name = template.getName();
        Condition condition = DbNavigationUtils.matchObject(name, DbSqlUtilCore.isQuoted(template), kind, DbNavigationUtils.getCasingProvider(project, template, file));
        if (kind == ObjectKind.ROUTINE) {
            condition = Conditions.and2(condition, (Condition)new Condition<DasObject>(){

                public boolean value(DasObject object) {
                    Iterator it1 = this.getRoutineArgs(template).iterator();
                    Iterator it2 = this.getRoutineArgs(object).iterator();
                    while (it1.hasNext() && it2.hasNext()) {
                        DasTypedObject o1 = (DasTypedObject)it1.next();
                        DasTypedObject o2 = (DasTypedObject)it2.next();
                        if (o1.getKind() != o2.getKind()) {
                            return false;
                        }
                        if (Comparing.equal((String)o1.getName(), (String)o2.getName(), (boolean)false)) continue;
                        return false;
                    }
                    return it1.hasNext() == it2.hasNext();
                }

                JBIterable<DasTypedObject> getRoutineArgs(DasObject template2) {
                    if (!(template2 instanceof DasRoutine)) {
                        return JBIterable.empty();
                    }
                    DasRoutine r = (DasRoutine)template2;
                    return JBIterable.from((Iterable)DasUtil.getParameters((DasRoutine)r)).filter(a2 -> a2.getArgumentDirection() != ArgumentDirection.SELF).append((Object)r.getReturnArgument()).filter(DasTypedObject.class);
                }
            });
        }
        return DbNavigationUtils.calcTarget(project, file, condition);
    }

    @NotNull
    private static CasingProvider getCasingProvider(@NotNull Project project, @NotNull DasObject object, @NotNull VirtualFile file) {
        SqlLanguageDialect dialect;
        if (project == null) {
            DbNavigationUtils.$$$reportNull$$$0(26);
        }
        if (object == null) {
            DbNavigationUtils.$$$reportNull$$$0(27);
        }
        if (file == null) {
            DbNavigationUtils.$$$reportNull$$$0(28);
        }
        if (object instanceof DbElement) {
            DasModel dasModel = ((DbElement)object).getDataSource().getModel();
            if (dasModel == null) {
                DbNavigationUtils.$$$reportNull$$$0(29);
            }
            return dasModel;
        }
        SqlLanguageDialect sqlLanguageDialect = dialect = object instanceof PsiElement ? DbSqlUtilCore.getSqlDialect((PsiElement)object) : null;
        if (dialect == null) {
            dialect = (SqlLanguageDialect)ObjectUtils.tryCast((Object)LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file), SqlLanguageDialect.class);
        }
        DatabaseDialectEx databaseDialectEx = dialect != null ? (DatabaseDialectEx)dialect.getDatabaseDialect() : DatabaseDialects.getGenericDialect();
        if (databaseDialectEx == null) {
            DbNavigationUtils.$$$reportNull$$$0(30);
        }
        return databaseDialectEx;
    }

    public static Condition<DasObject> matchObject(String name, boolean quoted, ObjectKind kind, CasingProvider provider) {
        return Conditions.and2((Condition)DasUtil.byKind((ObjectKind)kind), DbSqlUtilCore.byName(name, quoted, null, provider));
    }

    private static DasObject calcTarget(@NotNull Project project, @NotNull VirtualFile file, @NotNull Condition<? super DasObject> equality) {
        if (project == null) {
            DbNavigationUtils.$$$reportNull$$$0(31);
        }
        if (file == null) {
            DbNavigationUtils.$$$reportNull$$$0(32);
        }
        if (equality == null) {
            DbNavigationUtils.$$$reportNull$$$0(33);
        }
        return (DasObject)ReadAction.compute(() -> {
            PsiFile psiFile;
            PsiFile psiFile2 = psiFile = !file.isValid() ? null : PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof SqlFile)) {
                return null;
            }
            return (DasObject)((SqlFile)psiFile).traverser().traverse().filter(equality).first();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DbNavigationUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
            case 20: 
            case 23: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: 
            case 24: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustForDataNavigation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DbNavigationUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToSourceNavigatable";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustForNavigation";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createToDatabaseViewNavigatable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createToDataOrSourceNavigatable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createToDataNavigatable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createToDataSourceFileNavigatable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createToSourceNavigatable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFromTreeNavigatable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "navigateToDatabaseView";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSource";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateToDataSourceFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "navigateToDataSourceFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSqlElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "adjustForNavigation";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "calcTargetOffset";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "calcTarget";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCasingProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class MyNavigationWrapper
    extends FakePsiElement {
        @NotNull
        protected final DbElementImpl<?, ?> myElement;

        public MyNavigationWrapper(@NotNull DbElement element2) {
            if (element2 == null) {
                MyNavigationWrapper.$$$reportNull$$$0(0);
            }
            this.myElement = (DbElementImpl)element2;
        }

        public PsiElement getParent() {
            return null;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myElement.getProject();
            if (project == null) {
                MyNavigationWrapper.$$$reportNull$$$0(1);
            }
            return project;
        }

        public boolean isValid() {
            return this.myElement.isValid();
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return true;
        }

        public ItemPresentation getPresentation() {
            return this;
        }

        public String getName() {
            return this.myElement.getName();
        }

        public PsiFile getContainingFile() {
            return null;
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof PsiElement && this.isEquivalentTo((PsiElement)obj);
        }

        public boolean isEquivalentTo(PsiElement another) {
            return ((Object)((Object)this)).getClass() == another.getClass() && this.myElement.isEquivalentTo((PsiElement)((MyNavigationWrapper)another).myElement);
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return this.myElement.getIcon(open);
        }

        public String getPresentableText() {
            return this.myElement.getPresentableText();
        }

        @NlsSafe
        @Nullable
        public String getLocationString() {
            return this.myElement.getLocationString();
        }

        public boolean isWritable() {
            return this.myElement.isWritable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DbNavigationUtils$MyNavigationWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DbNavigationUtils$MyNavigationWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

