/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.actions.DdlActions;
import com.intellij.database.console.DatabaseServiceViewContributor;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.dbimport.DbElementDnDTarget;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.DatabaseCopyPasteProvider;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseTreeContext;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.SelectInDatabaseView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.actions.SelectInContextImpl;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.PlatformEditorBundle;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializer;
import icons.DatabaseIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@State(name="DatabaseView", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public final class DatabaseView
extends SimpleToolWindowPanel
implements PersistentStateComponent<Element>,
Disposable {
    public static final DataKey<DatabaseView> DATABASE_VIEW_KEY = DataKey.create((String)"DATABASE_VIEW_KEY");
    public static final DataKey<Object[]> DATABASE_NODES = DataKey.create((String)"DATABASE_NODES");
    public static final DataKey<DeleteProvider> DROP_ELEMENT_PROVIDER = DataKey.create((String)"DROP_ELEMENT_PROVIDER");
    static final String DATABASE_VIEW_POPUP_MENU = "DatabaseViewPopupMenu";
    @NotNull
    private final DatabaseTreeContext myContext;
    @NotNull
    private final Project myProject;
    @NotNull
    private final DbPsiFacade myDbFacade;
    @NotNull
    private final Tree myTree;
    @NotNull
    private final DatabaseCopyPasteProvider myCopyPasteProvider;
    @NotNull
    private final DatabaseStructure myStructure;
    private final DatabaseViewOptions myViewOptions;
    private final MyAutoScrollFromSourceHandler myAutoScrollHandler;

    public static DatabaseView getDatabaseView(@NotNull Project project) {
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        return (DatabaseView)((Object)project.getService(DatabaseView.class));
    }

    public DatabaseView(@NotNull Project project) {
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(1);
        }
        super(true, true);
        this.myProject = project;
        this.myContext = new DatabaseTreeContext(project, this::invokeRefresh);
        this.myViewOptions = DatabaseViewOptions.getInstance(project);
        project.getMessageBus().connect().subscribe(DatabaseViewOptions.TOPIC, this::refreshView);
        this.myDbFacade = DbPsiFacade.getInstance((Project)this.myProject);
        this.myAutoScrollHandler = new MyAutoScrollFromSourceHandler(this.myProject, this);
        this.myStructure = new DatabaseStructure(this.myContext, this.myDbFacade, this.myViewOptions);
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)((Object)this.myStructure), (Disposable)this);
        this.myTree = new DnDAwareTree((TreeModel)asyncTreeModel){
            {
                MyRenderer cellRenderer = new MyRenderer();
                this.setCellRenderer(cellRenderer);
                this.addMouseMotionListener(cellRenderer);
                this.addMouseListener(cellRenderer);
                HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
                this.putClientProperty(AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, true);
            }

            public int getToggleClickCount() {
                TreePath path = this.getSelectionPath();
                Object object = path == null ? null : path.getLastPathComponent();
                return object instanceof DasSchemaChild ? -1 : super.getToggleClickCount();
            }

            @Nullable
            public Color getFileColorFor(Object object) {
                throw new UnsupportedOperationException();
            }

            @Nullable
            public Color getFileColorForPath(@NotNull TreePath path) {
                if (path == null) {
                    1.$$$reportNull$$$0(0);
                }
                DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(DatabaseView.this.getProject()).getState();
                if (!state.useColors || !state.inDatabaseView) {
                    return null;
                }
                DbDataSource dataSource2 = (DbDataSource)TreeUtil.findObjectInPath((TreePath)path, DbDataSource.class);
                DasObject o = (DasObject)TreeUtil.findObjectInPath((TreePath)path, DasObject.class);
                DbElement e = DbImplUtil.findElement(dataSource2, o);
                return DatabaseColorManager.getColor(e);
            }

            public boolean isFileColorsEnabled() {
                if (DatabaseView.this.myProject.isDisposed()) {
                    return false;
                }
                DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(DatabaseView.this.getProject()).getState();
                boolean enabled = state.useColors && state.inDatabaseView;
                boolean opaque = DatabaseView.this.myTree.isOpaque();
                if (enabled && opaque) {
                    DatabaseView.this.myTree.setOpaque(false);
                } else if (!enabled && !opaque) {
                    DatabaseView.this.myTree.setOpaque(true);
                }
                return enabled;
            }

            protected void processKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 27 && DatabaseView.this.myContext.isSomethingCut()) {
                    DatabaseView.this.myCopyPasteProvider.undoCut();
                    e.consume();
                    return;
                }
                super.processKeyEvent(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/view/DatabaseView$1", "getFileColorForPath"));
            }
        };
        this.myCopyPasteProvider = new DatabaseCopyPasteProvider(this.myContext, this.myTree);
        this.initComponents();
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(DbPsiFacade.TOPIC, o -> this.refreshView());
        JdbcDriverManager.getDriverManager(this.myProject).addModificationTrackerListener((ModificationTrackerListener<JdbcDriverManager>)((ModificationTrackerListener)source -> this.refreshView()), this);
        this.enableDnD();
        MessageBusConnection connection2 = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection2.subscribe(DatabaseSettings.TOPIC, this::refreshView);
        connection2.subscribe(DatabaseConnectionManager.TOPIC, (c2, f) -> this.refreshView());
    }

    @NotNull
    public DatabaseCopyPasteProvider getCopyPasteProvider() {
        DatabaseCopyPasteProvider databaseCopyPasteProvider = this.myCopyPasteProvider;
        if (databaseCopyPasteProvider == null) {
            DatabaseView.$$$reportNull$$$0(2);
        }
        return databaseCopyPasteProvider;
    }

    @NotNull
    public DatabaseViewOptions getViewOptions() {
        DatabaseViewOptions databaseViewOptions = this.myViewOptions;
        if (databaseViewOptions == null) {
            DatabaseView.$$$reportNull$$$0(3);
        }
        return databaseViewOptions;
    }

    @NotNull
    public Tree getTree() {
        Tree tree = this.myTree;
        if (tree == null) {
            DatabaseView.$$$reportNull$$$0(4);
        }
        return tree;
    }

    @NotNull
    public Object getTreeRoot() {
        Object object = this.myStructure.getRoot();
        if (object == null) {
            DatabaseView.$$$reportNull$$$0(5);
        }
        return object;
    }

    @NotNull
    private AsyncTreeModel getAsyncModel() {
        AsyncTreeModel asyncTreeModel = (AsyncTreeModel)this.myTree.getModel();
        if (asyncTreeModel == null) {
            DatabaseView.$$$reportNull$$$0(6);
        }
        return asyncTreeModel;
    }

    @NotNull
    public JBIterable<Object> getSelectedElements() {
        JBIterable jBIterable = JBIterable.of((Object[])this.myTree.getSelectionPaths()).map(TreePath::getLastPathComponent);
        if (jBIterable == null) {
            DatabaseView.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    public static <T extends DbElement> Set<T> getSelectedElements(@NotNull DataContext dataContext, Class<T> aClass) {
        if (dataContext == null) {
            DatabaseView.$$$reportNull$$$0(8);
        }
        Set set = (Set)DatabaseView.getSelectedElements(dataContext).filter(aClass).addAllTo(new LinkedHashSet());
        if (set == null) {
            DatabaseView.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public static JBIterable<PsiElement> getSelectedElements(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DatabaseView.$$$reportNull$$$0(10);
        }
        Object[] psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        JBIterable elements = JBIterable.of((Object[])psiElements);
        JBIterable jBIterable = elements.append((Iterable)elements.filterMap(DataGridPomTarget::unwrapElements).flatMap((Function)Functions.id()).filter(PsiElement.class));
        if (jBIterable == null) {
            DatabaseView.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DbElement> getSelectedElementsNoGroups(@NotNull DataContext dataContext, boolean useParentForFamilies) {
        if (dataContext == null) {
            DatabaseView.$$$reportNull$$$0(12);
        }
        return DatabaseView.getSelectedElements(dataContext, (Condition<? super DatabaseStructure.Group>)((Condition)o -> !useParentForFamilies || !(o instanceof DatabaseStructure.FamilyGroup)));
    }

    @NotNull
    public static JBIterable<DbElement> getSelectedElements(@NotNull DataContext dataContext, @NotNull Condition<? super DatabaseStructure.Group> expand) {
        JBIterable<PsiElement> elements;
        if (dataContext == null) {
            DatabaseView.$$$reportNull$$$0(13);
        }
        if (expand == null) {
            DatabaseView.$$$reportNull$$$0(14);
        }
        if (!(elements = DatabaseView.getSelectedElements(dataContext)).isEmpty()) {
            JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(o -> o instanceof DatabaseStructure.Group ? ((DatabaseStructure.Group)((Object)o)).iterateChildren() : JBIterable.empty()).expandAndSkip(o -> o instanceof DatabaseStructure.Group && expand.value((Object)((DatabaseStructure.Group)((Object)o))))).withRoots(elements)).map(o -> o instanceof DatabaseStructure.FamilyGroup ? o.getParent() : o).filter(DbElement.class);
            if (jBIterable == null) {
                DatabaseView.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        FileEditor fileEditor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        DbElement element2 = project == null || fileEditor == null ? null : DatabaseView.getSelectedElementFromEditor(dataContext);
        JBIterable jBIterable = JBIterable.of((Object)element2);
        if (jBIterable == null) {
            DatabaseView.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @Nullable
    static DbElement getSelectedElementFromEditor(@NotNull DataContext dataContext) {
        AnActionEvent event;
        SelectInContext context;
        if (dataContext == null) {
            DatabaseView.$$$reportNull$$$0(17);
        }
        return (context = SelectInContextImpl.createContext((AnActionEvent)(event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext)))) == null ? null : SelectInDatabaseView.askProviders(context);
    }

    private void initComponents() {
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.setShowsRootHandles(true);
        this.updateEmptyText();
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        new TreeSpeedSearch(this.myTree, o -> {
            Object node = o.getLastPathComponent();
            ItemPresentation presentation = Objects.requireNonNull((ItemPresentation)ReadAction.compute(() -> ((MyRenderer)this.myTree.getCellRenderer()).getPresentationInner(node)));
            return presentation.getPresentableText();
        });
        this.myTree.setRootVisible(false);
        PopupHandler.installPopupHandler((JComponent)this.myTree, (String)DATABASE_VIEW_POPUP_MENU, (String)"DatabaseViewPopup");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(null);
        scrollPane.setViewport((JViewport)((Object)new MyGradientViewport()));
        this.setContent(scrollPane);
        this.setToolbar(this.createToolbar().getComponent());
        this.myAutoScrollHandler.install();
    }

    private void updateEmptyText() {
        String shortcut;
        String emptyText = this.myDbFacade.getDataSources().isEmpty() ? (StringUtil.isNotEmpty((String)(shortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("NewElement")))) ? DatabaseBundle.message((String)"status.text.create.data.source.with", (Object[])new Object[]{shortcut}) : DatabaseBundle.message((String)"status.text.create.data.source.with.context.menu", (Object[])new Object[0])) : CommonBundle.getLoadingTreeNodeText();
        this.myTree.getEmptyText().setText(emptyText);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(18);
        }
        return project;
    }

    public void refreshView() {
        this.updateEmptyText();
        this.myStructure.refreshAll();
    }

    private void invokeRefresh() {
        ApplicationManager.getApplication().invokeLater(() -> this.myStructure.refreshAll());
    }

    @NotNull
    public final Promise<Void> selectElement(@Nullable Object element2) {
        return element2 == null ? Promises.resolvedPromise() : this.selectElements(Collections.singleton(element2));
    }

    @NotNull
    public final Promise<Void> selectElements(@NotNull Collection<?> elements) {
        if (elements == null) {
            DatabaseView.$$$reportNull$$$0(19);
        }
        List promises = JBIterable.from(elements).map(o -> this.getAsyncModel().getTreePath(DatabaseStructure.unwrap(o))).toList();
        Promise collectedPromise = Promises.collectResults((Collection)promises, (boolean)true);
        Promise promise = collectedPromise.onProcessed(paths -> {
            if (paths != null) {
                TreeUtil.selectPaths((JTree)this.myTree, (Collection)paths);
            }
        }).then(o -> null);
        if (promise == null) {
            DatabaseView.$$$reportNull$$$0(20);
        }
        return promise;
    }

    private void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DnDManager.getInstance().registerTarget((DnDTarget)new MyDnDTarget(), (JComponent)this.myTree);
            DnDManager.getInstance().registerSource((DnDSource)new MyDnDSource(), (JComponent)this.myTree);
        }
    }

    @NotNull
    private ActionToolbar createToolbar() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("DatabaseViewToolbar");
        ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("DatabaseViewToolbar", group, true);
        toolbar2.setTargetComponent((JComponent)this.myTree);
        ActionToolbar actionToolbar = toolbar2;
        if (actionToolbar == null) {
            DatabaseView.$$$reportNull$$$0(21);
        }
        return actionToolbar;
    }

    public void dispose() {
        this.removeAll();
    }

    public void setupToolWindow(@NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            DatabaseView.$$$reportNull$$$0(22);
        }
        this.setupGearMenu(toolWindow);
        DumbAwareAction consoleTitleAction = new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                e.getPresentation().setVisible(!DatabaseView.this.isToolbarVisible());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                JBIterable.of((Object[])DatabaseView.this.myTree.getSelectionPaths()).map(path -> (DbDataSource)TreeUtil.findObjectInPath((TreePath)path, DbDataSource.class)).filter(Conditions.notNull()).unique().forEach(DatabaseEditorHelper::openConsoleFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/view/DatabaseView$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        consoleTitleAction.getTemplatePresentation().setText(DatabaseBundle.messagePointer((String)"action.OpenConsole.text", (Object[])new Object[0]));
        consoleTitleAction.getTemplatePresentation().setIcon(DatabaseIcons.ConsoleRun);
        DumbAwareAction refreshTitleAction = new DumbAwareAction(){
            final AnAction baseAction = ActionManager.getInstance().getAction("DatabaseView.Refresh");
            {
                ActionUtil.copyFrom((AnAction)this, (String)"DatabaseView.Refresh");
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Refresh);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabledAndVisible(!DatabaseView.this.isToolbarVisible());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.baseAction.actionPerformed(new AnActionEvent(e.getInputEvent(), DataManager.getInstance().getDataContext((Component)((Object)DatabaseView.this)), e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/view/DatabaseView$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DumbAwareAction scrollFromEditorAction = new DumbAwareAction(DatabaseBundle.messagePointer((String)"action.DatabaseView.scroll.from.editor.text", (Object[])new Object[0]), DatabaseBundle.messagePointer((String)"action.DatabaseView.select.database.element.open.in.active.editor.description", (Object[])new Object[0]), AllIcons.General.Locate){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabledAndVisible(!DatabaseView.this.myAutoScrollHandler.isAutoScrollEnabled());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                FileEditor fileEditor;
                EditorWindow window;
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                EditorWithProviderComposite editorComposite = (window = FileEditorManagerEx.getInstanceEx((Project)DatabaseView.this.myProject).getCurrentWindow()) == null ? null : window.getSelectedEditor();
                FileEditor fileEditor2 = fileEditor = editorComposite == null ? null : editorComposite.getSelectedWithProvider().getFileEditor();
                if (fileEditor == null) {
                    return;
                }
                DatabaseView.this.myAutoScrollHandler.selectElementFromEditorInner(fileEditor, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/view/DatabaseView$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        toolWindow.setTitleActions(Arrays.asList(refreshTitleAction, consoleTitleAction, scrollFromEditorAction, actionsManager.createExpandAllHeaderAction((JTree)this.myTree), actionsManager.createCollapseAllHeaderAction((JTree)this.myTree)));
    }

    private void setupGearMenu(@NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            DatabaseView.$$$reportNull$$$0(23);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        DatabaseViewOptions opts = this.myViewOptions;
        Runnable fireChanged = () -> DatabaseViewOptions.fireChanged(this.myProject);
        group.addAction((AnAction)DatabaseViewActions.toggle(DatabaseBundle.message((String)"database.view.action.settings.group.data.sources", (Object[])new Object[0]), (Getter<Boolean>)((Getter)() -> opts.GROUP_DATA_SOURCES), (Setter<Boolean>)((Setter)b1 -> {
            opts.GROUP_DATA_SOURCES = b1;
        }), () -> {
            DatabaseViewOptions.fireChanged(this.myProject);
            DatabaseServiceViewContributor.refreshView(this.myProject);
        }));
        group.addAction((AnAction)DatabaseViewActions.toggle(DatabaseBundle.message((String)"database.view.action.settings.group.namespaces", (Object[])new Object[0]), (Getter<Boolean>)((Getter)() -> opts.GROUP_NAMESPACES), (Setter<Boolean>)((Setter)b1 -> {
            opts.GROUP_NAMESPACES = b1;
        }), fireChanged));
        group.addAction((AnAction)DatabaseViewActions.toggle(DatabaseBundle.message((String)"database.view.action.settings.group.aux.objects", (Object[])new Object[0]), (Getter<Boolean>)((Getter)() -> opts.GROUP_AUX_OBJECTS && !opts.GROUP_NAMESPACES), (Setter<Boolean>)((Setter)b1 -> {
            opts.GROUP_AUX_OBJECTS = b1;
        }), fireChanged, (Consumer<Presentation>)((Consumer)p2 -> p2.setEnabled(!opts.GROUP_NAMESPACES))));
        group.addAction((AnAction)DatabaseViewActions.toggle(DatabaseBundle.message((String)"database.view.action.settings.group.schema", (Object[])new Object[0]), (Getter<Boolean>)((Getter)() -> opts.GROUP_SCHEMA), (Setter<Boolean>)((Setter)b2 -> {
            opts.GROUP_SCHEMA = b2;
        }), fireChanged));
        group.addAction((AnAction)DatabaseViewActions.toggle(DatabaseBundle.message((String)"database.view.action.settings.group.contents", (Object[])new Object[0]), (Getter<Boolean>)((Getter)() -> opts.GROUP_CONTENTS), (Setter<Boolean>)((Setter)b2 -> {
            opts.GROUP_CONTENTS = b2;
        }), fireChanged));
        group.addAction((AnAction)DatabaseViewActions.toggle(DatabaseBundle.message((String)"database.view.action.settings.show.all.namespaces", (Object[])new Object[0]), (Getter<Boolean>)((Getter)() -> opts.SHOW_ALL_NAMESPACES), (Setter<Boolean>)((Setter)b2 -> {
            opts.SHOW_ALL_NAMESPACES = b2;
        }), fireChanged));
        group.addAction((AnAction)DatabaseViewActions.toggle(DatabaseBundle.message((String)"database.view.action.settings.show.empty.groups", (Object[])new Object[0]), (Getter<Boolean>)((Getter)() -> opts.SHOW_EMPTY_GROUPS), (Setter<Boolean>)((Setter)b2 -> {
            opts.SHOW_EMPTY_GROUPS = b2;
        }), fireChanged, (Consumer<Presentation>)((Consumer)p2 -> p2.setVisible(opts.GROUP_CONTENTS || opts.GROUP_SCHEMA))));
        group.addAction((AnAction)DatabaseViewActions.toggle(DatabaseBundle.message((String)"database.view.action.settings.show.intermediate.nodes", (Object[])new Object[0]), (Getter<Boolean>)((Getter)() -> opts.SHOW_INTERMEDIATE), (Setter<Boolean>)((Setter)b2 -> {
            opts.SHOW_INTERMEDIATE = b2;
        }), fireChanged));
        group.addAction((AnAction)DatabaseViewActions.toggle(DatabaseBundle.message((String)"database.view.action.settings.show.generated.objects", (Object[])new Object[0]), (Getter<Boolean>)((Getter)() -> opts.SHOW_GENERATED_OBJECTS), (Setter<Boolean>)((Setter)b2 -> {
            opts.SHOW_GENERATED_OBJECTS = b2;
        }), fireChanged));
        group.addAction((AnAction)DatabaseViewActions.toggle(PlatformEditorBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), (Getter<Boolean>)((Getter)() -> opts.SORT_POSITIONED), (Setter<Boolean>)((Setter)b2 -> {
            opts.SORT_POSITIONED = b2;
        }), fireChanged));
        group.addAction((AnAction)DatabaseViewActions.toggle(DatabaseBundle.message((String)"database.view.action.settings.autoscroll.from.editor", (Object[])new Object[0]), (Getter<Boolean>)((Getter)this.myAutoScrollHandler::isAutoScrollEnabled), (Setter<Boolean>)((Setter)this.myAutoScrollHandler::setAutoScrollEnabled)));
        group.addAction((AnAction)JdbcConsole.createToggleConsoleToolbarAction(this.myProject)).setAsSecondary(true);
        toolWindow.setAdditionalGearActions((ActionGroup)group);
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            DatabaseView.$$$reportNull$$$0(24);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        Object data = super.getData(dataId);
        if (data != null) {
            return data;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (DATABASE_VIEW_KEY.is(dataId)) {
            return this;
        }
        if (DatabaseDataKeysCore.DB_PSI_FACADE.is(dataId)) {
            return this.myDbFacade;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.tools.datasource";
        }
        if (DROP_ELEMENT_PROVIDER.is(dataId)) {
            Collection c2 = this.getDataFromSelectedPaths(CommonDataKeys.PSI_ELEMENT);
            if (c2.isEmpty()) {
                return null;
            }
            if (JBIterable.from(c2).filter(DbDataSource.class).size() == c2.size()) {
                return new DdlActions.DeleteProvider1();
            }
            return new DdlActions.DeleteProvider2();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteProvider;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteProvider;
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteProvider;
        }
        if (DATABASE_NODES.is(dataId)) {
            JBIterable<Object> selectedElements = this.getSelectedElements();
            if (selectedElements.isEmpty()) {
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            return selectedElements.toArray(new Object[0]);
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            Collection<PsiElement> c3 = this.getDataFromSelectedPaths(CommonDataKeys.PSI_ELEMENT);
            return c3.isEmpty() ? null : c3.toArray(PsiElement.EMPTY_ARRAY);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            Collection<Navigatable> c4 = this.getDataFromSelectedPaths(CommonDataKeys.NAVIGATABLE);
            return c4.isEmpty() ? null : c4.toArray(new Navigatable[0]);
        }
        return DatabaseView.getDataFromPath(dataId, this.myProject, this.myTree.getSelectionPath());
    }

    @NotNull
    private <T> Collection<T> getDataFromSelectedPaths(@NotNull DataKey<T> key) {
        TreePath[] paths;
        if (key == null) {
            DatabaseView.$$$reportNull$$$0(25);
        }
        if ((paths = this.myTree.getSelectionPaths()) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                DatabaseView.$$$reportNull$$$0(26);
            }
            return list;
        }
        LinkedHashSet result = new LinkedHashSet();
        for (TreePath path : paths) {
            ContainerUtil.addIfNotNull(result, DatabaseView.getDataFromPath(key.getName(), this.myProject, path));
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            DatabaseView.$$$reportNull$$$0(27);
        }
        return linkedHashSet;
    }

    private static <T> T getDataFromPath(@NotNull String dataId, @NotNull Project project, @Nullable TreePath path) {
        if (dataId == null) {
            DatabaseView.$$$reportNull$$$0(28);
        }
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(29);
        }
        Object node = path == null ? null : path.getLastPathComponent();
        Object result = DbNodeDescriptor.getData(dataId, project, node);
        return (T)result;
    }

    @Nullable
    private DnDTarget findDndTargetAt(@NotNull Point point, boolean strict) {
        Object element2;
        TreePath path;
        if (point == null) {
            DatabaseView.$$$reportNull$$$0(30);
        }
        TreePath treePath = path = strict ? this.myTree.getPathForLocation(point.x, point.y) : this.myTree.getClosestPathForLocation(point.x, point.y);
        if (path == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        DbDataSource dataSource2 = (DbDataSource)TreeUtil.findObjectInPath((TreePath)path, DbDataSource.class);
        DasObject o = (DasObject)TreeUtil.findObjectInPath((TreePath)path, DasObject.class);
        Object object = element2 = o == null ? node : DbImplUtil.findElement(dataSource2, o);
        if (node instanceof DatabaseStructure.FamilyGroup && element2 instanceof DasNamespace && ((DatabaseStructure.FamilyGroup)((Object)node)).getChildrenKind() != ObjectKind.TABLE) {
            return null;
        }
        return DatabaseView.getDnDTarget(element2);
    }

    @Nullable
    private static DnDTarget getDnDTarget(Object element2) {
        if (element2 instanceof DbDataSourceImpl) {
            DnDTarget target = ((DbDataSourceImpl)((Object)element2)).getDbManager().createDnDTarget((DasDataSource)((DbDataSourceImpl)((Object)element2)).getDelegate());
            if (target != null) {
                return target;
            }
            return new DbElementDnDTarget.DataSourceDnDTarget((DbDataSource)element2);
        }
        if (element2 instanceof DbNamespaceImpl) {
            return new DbElementDnDTarget.NamespaceDnDTarget((DbNamespaceImpl)((Object)element2));
        }
        if (element2 instanceof DbTableImpl) {
            return new DbElementDnDTarget.DbTableDnDTarget((DbTableImpl)((Object)element2));
        }
        if (element2 instanceof DatabaseStructure.FamilyGroup) {
            PsiElement parent2 = ((DatabaseStructure.FamilyGroup)((Object)element2)).getParent();
            if (parent2 instanceof DbNamespaceImpl) {
                return new DbElementDnDTarget.FamilyGroupDnDTarget((DbNamespaceImpl)parent2, ((DatabaseStructure.FamilyGroup)((Object)element2)).getChildrenKind());
            }
        } else if (element2 instanceof DatabaseStructure.DbGroup) {
            return new DataSourceUiUtil.DbGroupDropTarget(((DatabaseStructure.DbGroup)((Object)element2)).getQualifiedName());
        }
        return null;
    }

    public static void refreshViewAndSelect(@NotNull Project project, @NotNull Collection<?> selection) {
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(31);
        }
        if (selection == null) {
            DatabaseView.$$$reportNull$$$0(32);
        }
        DataSourceStorage.getProjectStorage(project).incModificationCount();
        DataSourceStorage.getStorage().incModificationCount();
        DatabaseView view2 = DatabaseView.getDatabaseView(project);
        view2.refreshView();
        view2.selectElements(selection);
        DatabaseServiceViewContributor.refreshView(project);
    }

    @NotNull
    public static Promise<Void> select(@NotNull PsiElement element2, boolean requestFocus) {
        if (element2 == null) {
            DatabaseView.$$$reportNull$$$0(33);
        }
        return DatabaseView.select(element2.getProject(), Collections.singleton(element2), requestFocus);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public static void select(@NotNull Project project, boolean requestFocus, @NotNull Collection<?> elements) {
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(34);
        }
        if (elements == null) {
            DatabaseView.$$$reportNull$$$0(35);
        }
        DatabaseView.select(project, elements, requestFocus);
    }

    @NotNull
    public static Promise<Void> select(@NotNull Project project, @NotNull Collection<?> elements, boolean requestFocus) {
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(36);
        }
        if (elements == null) {
            DatabaseView.$$$reportNull$$$0(37);
        }
        ToolWindow window = DatabaseView.getDatabaseToolWindow(project);
        DatabaseView databaseView = DatabaseView.getDatabaseView(project);
        if (requestFocus) {
            AsyncPromise res2 = new AsyncPromise();
            window.activate(() -> databaseView.selectElements(elements).processed((Promise)res2));
            AsyncPromise asyncPromise = res2;
            if (asyncPromise == null) {
                DatabaseView.$$$reportNull$$$0(38);
            }
            return asyncPromise;
        }
        return databaseView.selectElements(elements);
    }

    @NotNull
    public static ToolWindow getDatabaseToolWindow(@NotNull Project project) {
        if (project == null) {
            DatabaseView.$$$reportNull$$$0(39);
        }
        ToolWindow toolWindow = Objects.requireNonNull(ToolWindowManager.getInstance((Project)project).getToolWindow("Database"));
        if (toolWindow == null) {
            DatabaseView.$$$reportNull$$$0(40);
        }
        return toolWindow;
    }

    @NotNull
    public Element getState() {
        Element element2 = new Element("TreeState");
        TreeState.createOn((JTree)this.myTree).writeExternal(element2);
        Element element3 = element2;
        if (element3 == null) {
            DatabaseView.$$$reportNull$$$0(41);
        }
        return element3;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            DatabaseView.$$$reportNull$$$0(42);
        }
        XmlSerializer.deserializeInto((Object)((Object)this.myViewOptions), (Element)state);
        TreeState treeState = TreeState.createFrom((Element)state);
        DataSourceStorage.getProjectStorage(this.myProject).doWhenInitialized(() -> treeState.applyTo((JTree)this.myTree, this.myStructure.getRoot()));
    }

    public void showSchemaManagerGotIt(@Nullable DbDataSource ds) {
        if (ds == null) {
            return;
        }
        GotItTooltip tip = new GotItTooltip("database.schema.control.got.it", DatabaseBundle.message((String)"click.here.to.display.other.schemas.got.it", (Object[])new Object[0]), (Disposable)this);
        if (!tip.canShow()) {
            return;
        }
        AsyncTreeModel model = this.getAsyncModel();
        model.getTreePath((Object)ds).thenAsync(p2 -> model.resolve(p2)).then(path -> {
            Tree tree = this.getTree();
            Point pt = DatabaseView.getSchemaControlLocation(path, tree);
            if (pt != null) {
                tree.scrollRectToVisible(new Rectangle(pt));
            }
            tip.show((JComponent)tree, c2 -> {
                Point loc = DatabaseView.getSchemaControlLocation(path, tree);
                return loc == null ? new Point() : loc;
            });
            return null;
        });
    }

    @Nullable
    private static Point getSchemaControlLocation(TreePath path, Tree tree) {
        Rectangle b2 = tree.getPathBounds(path);
        if (b2 == null) {
            return null;
        }
        double x = b2.getMaxX() - b2.getHeight() / 2.0;
        return new Point((int)x, (int)b2.getMaxY());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 38: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 38: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 38: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseView";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expand";
                break;
            }
            case 19: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopyPasteProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewOptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsyncModel";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "selectElements";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFromSelectedPaths";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseToolWindow";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseView";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 38: 
            case 40: 
            case 41: {
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElementsNoGroups";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElementFromEditor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "selectElements";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setupToolWindow";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setupGearMenu";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromSelectedPaths";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromPath";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findDndTargetAt";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "refreshViewAndSelect";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseToolWindow";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 38: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        final DatabaseView myView;

        MyAutoScrollFromSourceHandler(@NotNull Project project, @NotNull DatabaseView view2) {
            if (project == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(0);
            }
            if (view2 == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(1);
            }
            super(project, (JComponent)((Object)view2), (Disposable)view2);
            this.myView = view2;
        }

        public void install() {
            super.install();
            EditorFactory.getInstance().getEventMulticaster().addCaretListener(new CaretListener(){

                public void caretPositionChanged(@NotNull CaretEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.selectInView(event.getEditor());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/view/DatabaseView$MyAutoScrollFromSourceHandler$1", "caretPositionChanged"));
                }
            }, (Disposable)this.myView);
        }

        private void selectInView(@NotNull Editor editor) {
            VirtualFile file1;
            if (editor == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(2);
            }
            if (!this.myView.isShowing() || !this.isAutoScrollEnabled()) {
                return;
            }
            FileEditor selectedEditor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor();
            VirtualFile virtualFile = file1 = selectedEditor == null ? null : selectedEditor.getFile();
            if (file1 == null) {
                return;
            }
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (!file1.equals(file2)) {
                return;
            }
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> this.selectElementFromEditor(selectedEditor), this.getAlarmDelay(), this.getModalityState());
        }

        protected boolean isAutoScrollEnabled() {
            return this.myView.myViewOptions.AUTO_SCROLL_FROM_SOURCE;
        }

        protected void setAutoScrollEnabled(boolean enabled) {
            FileEditorManager fileEditorManager;
            FileEditor[] editors;
            this.myView.myViewOptions.AUTO_SCROLL_FROM_SOURCE = enabled;
            if (enabled && (editors = (fileEditorManager = FileEditorManager.getInstance((Project)this.myProject)).getSelectedEditors()).length != 0) {
                this.selectElementFromEditor(editors[0]);
            }
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(3);
            }
            this.selectElementFromEditorInner(editor, false);
        }

        void selectElementFromEditorInner(@NotNull FileEditor editor, boolean force) {
            if (editor == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(4);
            }
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
            DbElement element2 = DatabaseView.getSelectedElementFromEditor(dataContext);
            PsiElement selection = (PsiElement)DatabaseView.getSelectedElements(DataManager.getInstance().getDataContext((Component)((Object)this.myView))).first();
            if (element2 != null && (force || selection == null || !PsiTreeUtil.isAncestor((PsiElement)element2, (PsiElement)selection, (boolean)false))) {
                DatabaseView.select(this.myProject, Collections.singleton(element2), false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/view/DatabaseView$MyAutoScrollFromSourceHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectInView";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementFromEditor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementFromEditorInner";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyTransferable
    implements Transferable {
        final Object[] objects;

        MyTransferable(Object @NotNull [] objects2) {
            if (objects2 == null) {
                MyTransferable.$$$reportNull$$$0(0);
            }
            this.objects = objects2;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.stringFlavor, DnDEventImpl.ourDataFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return true;
        }

        @Override
        @NotNull
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (DataFlavor.stringFlavor.equals(flavor)) {
                StringBuilder sb = new StringBuilder();
                for (Object object : this.objects) {
                    if (!(object instanceof PsiNamedElement)) continue;
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(((PsiNamedElement)object).getName());
                }
                String string = sb.toString();
                if (string == null) {
                    MyTransferable.$$$reportNull$$$0(1);
                }
                return string;
            }
            if (DnDEventImpl.ourDataFlavor.equals(flavor)) {
                if (this.objects == null) {
                    MyTransferable.$$$reportNull$$$0(2);
                }
                return this.objects;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objects";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseView$MyTransferable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseView$MyTransferable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTransferData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyDnDSource
    implements DnDSource {
        private MyDnDSource() {
        }

        public boolean canStartDragging(DnDAction action2, Point dragOrigin) {
            return !JBIterable.of((Object[])DatabaseView.this.myTree.getSelectionPaths()).isEmpty();
        }

        @NotNull
        public DnDDragStartBean startDragging(DnDAction action2, Point dragOrigin) {
            Object[] selection = JBIterable.of((Object[])DatabaseView.this.myTree.getSelectionPaths()).map(path -> {
                DbDataSource dataSource2 = (DbDataSource)TreeUtil.findObjectInPath((TreePath)path, DbDataSource.class);
                DasObject o = (DasObject)TreeUtil.findObjectInPath((TreePath)path, DasObject.class);
                DbElement e = DbImplUtil.findElement(dataSource2, o);
                return ObjectUtils.notNull((Object)e, (Object)path.getLastPathComponent());
            }).unique().toList().toArray();
            return new DnDDragStartBean((Object)(selection.length == 0 ? null : new MyTransferable(selection)), dragOrigin);
        }

        @NotNull
        public Pair<Image, Point> createDraggedImage(DnDAction action2, Point dragOrigin, @NotNull DnDDragStartBean bean) {
            if (bean == null) {
                MyDnDSource.$$$reportNull$$$0(0);
            }
            Object[] objects2 = ((MyTransferable)bean.getAttachedObject()).objects;
            ItemPresentation presentation = Objects.requireNonNull((ItemPresentation)ReadAction.compute(() -> ((MyRenderer)DatabaseView.this.myTree.getCellRenderer()).getPresentationInner(objects2[0])));
            SimpleColoredComponent c2 = new SimpleColoredComponent();
            c2.setForeground(RenderingUtil.getForeground((JTree)DatabaseView.this.myTree));
            c2.setBackground(RenderingUtil.getBackground((JTree)DatabaseView.this.myTree));
            c2.setIcon(presentation.getIcon(false));
            if (presentation instanceof PresentationData) {
                for (PresentableNodeDescriptor.ColoredFragment fragment : ((PresentationData)presentation).getColoredText()) {
                    c2.append(fragment.getText(), fragment.getAttributes());
                }
            }
            if (objects2.length > 1) {
                c2.append(" +" + (objects2.length - 1), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
            Dimension size = c2.getPreferredSize();
            c2.setSize(size);
            BufferedImage image = UIUtil.createImage((Component)c2, (int)size.width, (int)size.height, (int)2);
            c2.setOpaque(false);
            Graphics2D g = image.createGraphics();
            c2.paint((Graphics)g);
            g.dispose();
            Pair pair = Pair.create((Object)image, (Object)new Point(0, 0));
            if (pair == null) {
                MyDnDSource.$$$reportNull$$$0(1);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseView$MyDnDSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseView$MyDnDSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDraggedImage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createDraggedImage";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyDnDTarget
    implements DnDNativeTarget {
        private MyDnDTarget() {
        }

        public boolean update(DnDEvent aEvent) {
            boolean canCreateDataSource;
            Point point = aEvent.getPointOn((Component)DatabaseView.this.myTree);
            DnDTarget target = DatabaseView.this.findDndTargetAt(point, canCreateDataSource = this.hasDdlDataSourceFiles(aEvent));
            boolean targetOk = target != null && aEvent.delegateUpdateTo(target);
            boolean ok = targetOk || canCreateDataSource;
            aEvent.setDropPossible(ok);
            if (ok) {
                RelativeRectangle rectangle;
                if (targetOk) {
                    Rectangle bounds = Objects.requireNonNull(DatabaseView.this.myTree.getPathBounds(DatabaseView.this.myTree.getClosestPathForLocation(point.x, point.y)));
                    rectangle = new RelativeRectangle((Component)DatabaseView.this.myTree, bounds);
                } else {
                    Rectangle bounds = DatabaseView.this.getBounds();
                    rectangle = new RelativeRectangle((Component)((Object)DatabaseView.this), bounds);
                }
                aEvent.setHighlighting(rectangle, 1);
            }
            return ok;
        }

        public void drop(DnDEvent aEvent) {
            boolean canCreateDataSource = this.hasDdlDataSourceFiles(aEvent);
            DnDTarget target = DatabaseView.this.findDndTargetAt(aEvent.getPointOn((Component)DatabaseView.this.myTree), canCreateDataSource);
            if (target != null && aEvent.delegateUpdateTo(target)) {
                aEvent.delegateDropTo(target);
            } else {
                DataSourceUiUtil.createDataSourceFromFiles(DatabaseView.this.myProject, FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)aEvent.getAttachedObject()));
            }
        }

        private boolean hasDdlDataSourceFiles(DnDEvent aEvent) {
            List files = FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)aEvent.getAttachedObject());
            for (DataSourceManager manager : DataSourceManager.getManagers((Project)DatabaseView.this.myProject)) {
                if (!manager.canCreateDataSourceByFiles((Collection)files)) continue;
                return true;
            }
            return SystemInfo.isMac && files.isEmpty();
        }
    }

    private class MyGradientViewport
    extends GradientViewport {
        MyRenderer myHeaderRenderer;

        MyGradientViewport() {
            super((Component)DatabaseView.this.myTree, (Insets)JBUI.insetsTop((int)5), true);
            this.myHeaderRenderer = new MyRenderer(){

                @Override
                @NotNull
                protected NodeRenderer createRenderer() {
                    return new NodeRenderer(){
                        {
                            UIUtil.putClientProperty((JComponent)((Object)this), (Key)AnimatedIcon.REFRESH_DELEGATE, () -> MyGradientViewport.this.repaint(this.getBounds()));
                        }

                        @Nullable
                        protected ItemPresentation getPresentation(Object node) {
                            return (ItemPresentation)ReadAction.compute(() -> this.getPresentationInner(node));
                        }

                        public boolean isShowing() {
                            return MyGradientViewport.this.isShowing() && MyGradientViewport.this.getHeaderPath() != null;
                        }
                    };
                }

                @Override
                @Nullable
                ItemPresentation getPresentationInner(Object node) {
                    return node instanceof DatabaseStructure.DbGroup ? ((DatabaseStructure.DbGroup)((Object)node)).getQualifiedPresentation() : super.getPresentationInner(node);
                }
            };
        }

        private TreePath getHeaderPath() {
            int x = DatabaseView.this.myTree.getX();
            int y = DatabaseView.this.myTree.getY();
            if (y == 0) {
                return null;
            }
            NodeRenderer headerComponent = this.myHeaderRenderer.nodeRenderer;
            int height = headerComponent.getPreferredSize().height;
            TreePath path = this.findDataSourceOrGroupAt(-x, height + 3 - y);
            if (path == null) {
                return null;
            }
            TreePath pathAlt = this.findDataSourceOrGroupAt(-x, -y);
            if (pathAlt != null && pathAlt.getLastPathComponent() != path.getLastPathComponent()) {
                return null;
            }
            return path;
        }

        protected Component getHeader() {
            TreePath path = this.getHeaderPath();
            if (path == null) {
                return null;
            }
            NodeRenderer headerComponent = this.myHeaderRenderer.nodeRenderer;
            this.myHeaderRenderer.getTreeCellRendererComponent((JTree)DatabaseView.this.myTree, path.getLastPathComponent(), false, false, true, 0, false);
            Color color = DatabaseView.this.myTree.getFileColorForPath(path);
            headerComponent.setBackground(color);
            headerComponent.setOpaque(color != null);
            headerComponent.setTransparentIconBackground(color == null);
            return headerComponent;
        }

        @Nullable
        private TreePath findDataSourceOrGroupAt(int x, int y) {
            TreePath path = DatabaseView.this.myTree.getClosestPathForLocation(x, y);
            TreePath treePath = path = path == null ? null : path.getParentPath();
            while (path != null) {
                Object o = path.getLastPathComponent();
                TreePath parentPath = path.getParentPath();
                if (o instanceof DasDataSource || o instanceof DatabaseStructure.DbGroup) {
                    return parentPath == null ? null : path;
                }
                path = parentPath;
            }
            return null;
        }
    }

    private class MyRenderer
    extends MouseAdapter
    implements TreeCellRenderer {
        PresentationData presentation = new PresentationData();
        TreePath pathUnderMouse;
        NodeRenderer nodeRenderer = this.createRenderer();

        private MyRenderer() {
        }

        @NotNull
        protected NodeRenderer createRenderer() {
            return new NodeRenderer(){

                @Nullable
                protected ItemPresentation getPresentation(Object node) {
                    return (ItemPresentation)ReadAction.compute(() -> MyRenderer.this.getPresentationInner(node));
                }
            };
        }

        @Nullable
        ItemPresentation getPresentationInner(Object node) {
            if (node instanceof DasObject) {
                DbNodeDescriptor.updatePresentation(this.presentation, (DasObject)node, DatabaseView.this.myProject, DatabaseView.this.myViewOptions, this.pathUnderMouse);
                if (this.isNodeCut(node)) {
                    this.presentation.setForcedTextForeground((Color)JBColor.LIGHT_GRAY);
                }
                return this.presentation;
            }
            if (node instanceof DatabaseStructure.EmptyScopeLeaf) {
                DbNodeDescriptor.updatePresentation(this.presentation, (DatabaseStructure.EmptyScopeLeaf)((Object)node), DatabaseView.this.myProject, DatabaseView.this.myViewOptions, this.pathUnderMouse);
                return this.presentation;
            }
            return node instanceof NavigationItem ? ((NavigationItem)node).getPresentation() : null;
        }

        private boolean isNodeCut(@NotNull Object node) {
            if (node == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            return DatabaseView.this.myCopyPasteProvider.isNodeCut(node);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            SimpleColoredComponent component = (SimpleColoredComponent)this.nodeRenderer.getTreeCellRendererComponent(tree, value2, selected, expanded, leaf, row, hasFocus);
            component.setOpaque(false);
            component.setIconOpaque(false);
            component.setTransparentIconBackground(true);
            component.setIconTextGap(JBUIScale.scale((int)5));
            return component;
        }

        boolean checkMouseOnTheLink(@NotNull MouseEvent e) {
            SimpleColoredComponent.ColoredIterator it2;
            Object o;
            if (e == null) {
                MyRenderer.$$$reportNull$$$0(1);
            }
            this.pathUnderMouse = null;
            TreePath path = DatabaseView.this.myTree.getPathForLocation(e.getX(), e.getY());
            Object object = o = path == null ? null : path.getLastPathComponent();
            if (!(o instanceof DasDataSource || o instanceof BasicNamespaceOwner || o instanceof DatabaseStructure.EmptyScopeLeaf)) {
                return false;
            }
            LocalDataSource dataSource2 = DbImplUtil.getMaybeLocalDataSource((DasDataSource)TreeUtil.findObjectInPath((TreePath)path, DbDataSource.class));
            if (dataSource2 == null) {
                return false;
            }
            Rectangle bounds = DatabaseView.this.myTree.getPathBounds(path);
            if (bounds == null) {
                return false;
            }
            int row = DatabaseView.this.myTree.getRowForPath(path);
            SimpleColoredComponent component = (SimpleColoredComponent)this.getTreeCellRendererComponent((JTree)DatabaseView.this.myTree, o, false, false, false, row, false);
            int index2 = component.findFragmentAt(e.getX() - bounds.x);
            SimpleColoredComponent.ColoredIterator coloredIterator = it2 = index2 < 0 ? null : component.iterator(index2);
            if (it2 != null && it2.hasNext()) {
                it2.next();
                if (it2.getTextAttributes().isClickable()) {
                    this.pathUnderMouse = path;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!UIUtil.isActionClick((MouseEvent)e, (int)500)) {
                return;
            }
            if (!this.checkMouseOnTheLink(e)) {
                return;
            }
            LocalDataSource dataSource2 = DbImplUtil.getMaybeLocalDataSource((DasDataSource)TreeUtil.findObjectInPath((TreePath)this.pathUnderMouse, DbDataSource.class));
            Object o = this.pathUnderMouse.getLastPathComponent();
            BasicElement selection = o instanceof BasicElement ? (BasicElement)o : (o instanceof DatabaseStructure.EmptyScopeLeaf ? (BasicElement)ObjectUtils.tryCast((Object)((DatabaseStructure.EmptyScopeLeaf)((Object)o)).getDasParent(), BasicElement.class) : null);
            JBPopup popup2 = DataSourceUiUtil.buildHiddenNamespacesPopup(DatabaseView.this.myProject, Objects.requireNonNull(dataSource2), selection);
            Rectangle bounds = Objects.requireNonNull(DatabaseView.this.myTree.getPathBounds(this.pathUnderMouse));
            popup2.show(new RelativePoint((Component)DatabaseView.this.myTree, new Point(e.getX(), bounds.y + bounds.height)));
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Rectangle r1;
            TreePath p0 = this.pathUnderMouse;
            this.checkMouseOnTheLink(e);
            TreePath p1 = this.pathUnderMouse;
            if (p0 == null && p1 == null) {
                return;
            }
            Rectangle r0 = p0 == null ? null : DatabaseView.this.myTree.getPathBounds(p0);
            Rectangle rectangle = r1 = p1 == null ? null : DatabaseView.this.myTree.getPathBounds(p1);
            if (r0 == null && r1 == null) {
                return;
            }
            DatabaseView.this.myTree.setCursor(Cursor.getPredefinedCursor(p1 != null ? 12 : 0));
            Rectangle clip = r0 == null ? r1 : (r1 == null ? r0 : r0.union(r1));
            DatabaseView.this.myTree.repaint(clip);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.pathUnderMouse == null) {
                return;
            }
            DatabaseView.this.myTree.setCursor(Cursor.getPredefinedCursor(0));
            Rectangle clip = DatabaseView.this.myTree.getPathBounds(this.pathUnderMouse);
            if (clip != null) {
                DatabaseView.this.myTree.repaint(clip);
            }
            this.pathUnderMouse = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/view/DatabaseView$MyRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isNodeCut";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkMouseOnTheLink";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

