/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.codeInsight.TargetElementEvaluatorEx;
import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTargetElementEvaluator
extends TargetElementEvaluatorEx2
implements TargetElementEvaluatorEx {
    public static boolean isLegacyNavigateToSchema() {
        return Registry.is((String)"database.legacy.navigate.to.schema", (boolean)false);
    }

    @Nullable
    public PsiElement getGotoDeclarationTarget(@NotNull PsiElement element2, @Nullable PsiElement navElement) {
        if (element2 == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(0);
        }
        if (!(element2 instanceof DbElement)) {
            return null;
        }
        if (DatabaseTargetElementEvaluator.isLegacyNavigateToSchema()) {
            return DbNavigationUtils.createToDatabaseViewNavigatable((DbElement)element2);
        }
        return DbNavigationUtils.createToSourceNavigatable((DbElement)element2);
    }

    public boolean isIdentifierPart(@NotNull PsiFile element2, @NotNull CharSequence text2, int offset) {
        PsiElement e;
        if (element2 == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(1);
        }
        if (text2 == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(2);
        }
        return (e = element2.findElementAt(offset)) != null && e.getParent() instanceof SqlIdentifier;
    }

    @Nullable
    public static OpenFileDescriptor getDescriptor(@NotNull DbElement dbElement) {
        VirtualFile file;
        if (dbElement == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(3);
        }
        if ((file = DbNavigationUtils.getContainingFile(dbElement, true)) == null) {
            return null;
        }
        Project project = dbElement.getProject();
        int offset = DbNavigationUtils.calcTargetOffset(project, file, (DasObject)dbElement);
        return new OpenFileDescriptor(project, file, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/view/DatabaseTargetElementEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getGotoDeclarationTarget";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isIdentifierPart";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

