/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.AuxiliaryFamilyGroup;
import com.intellij.database.view.AuxiliaryObjectsGroup;
import com.intellij.database.view.DatabaseTreeContext;
import com.intellij.database.view.DatabaseTreeKeys;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DatabaseViewStructureProvider;
import com.intellij.database.view.DatabaseViewTreeFun;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.Searchable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class DatabaseStructure
extends BaseTreeModel<Object>
implements InvokerSupplier,
Searchable {
    private static final boolean ourShowMiniCat = Registry.is((String)"database.view.show.mini.cat");
    @NotNull
    private final DatabaseTreeContext myContext;
    @NotNull
    private final Invoker myInvoker;
    @NotNull
    private final DbRootGroup myRootGroup;

    DatabaseStructure(@NotNull DatabaseTreeContext context, DbPsiFacade facade, DatabaseViewOptions viewOptions) {
        if (context == null) {
            DatabaseStructure.$$$reportNull$$$0(0);
        }
        this.myInvoker = Invoker.forBackgroundThreadWithReadAction((Disposable)this);
        this.myContext = context;
        this.myRootGroup = DatabaseStructure.getRootGroup(facade, viewOptions);
    }

    public void refreshAll() {
        this.treeStructureChanged(null, null, null);
    }

    public Object getRoot() {
        return this.myRootGroup;
    }

    public boolean isLeaf(Object node) {
        return DatabaseStructure.isAlwaysLeafImpl(node);
    }

    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.myInvoker;
        if (invoker == null) {
            DatabaseStructure.$$$reportNull$$$0(1);
        }
        return invoker;
    }

    @NotNull
    public Promise<TreePath> getTreePath(Object object) {
        BasicRoot root2;
        DbDataSource dbDataSource;
        BasicModel model;
        DbPsiFacade psiFacade = this.myRootGroup.facade;
        LinkedList<Object> result = new LinkedList<Object>();
        Object target = object;
        if (target instanceof BasicDatabase && (model = ((BasicDatabase)target).getModel()) != null && ((Boolean)DatabaseTreeKeys.DATABASE_IS_COLLAPSED.get((UserDataHolder)(dbDataSource = psiFacade.findDataSource((DasObject)(root2 = model.getRoot()))), (Object)false)).booleanValue()) {
            target = dbDataSource;
        }
        Object cur2 = target;
        while (cur2 != null) {
            result.addFirst(cur2);
            cur2 = DatabaseStructure.getParentImpl(cur2, this.myRootGroup.viewOptions, psiFacade);
        }
        TreePath treePath = new TreePath(ArrayUtil.toObjectArray(result));
        Promise promise = Promises.resolvedPromise((Object)treePath);
        if (promise == null) {
            DatabaseStructure.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private int compareNodes(@NotNull Object o1, @NotNull Object o2) {
        int weightDiff;
        if (o1 == null) {
            DatabaseStructure.$$$reportNull$$$0(3);
        }
        if (o2 == null) {
            DatabaseStructure.$$$reportNull$$$0(4);
        }
        return (weightDiff = DbPresentation.getWeight(o1, this.myRootGroup.viewOptions.SORT_POSITIONED) - DbPresentation.getWeight(o2, this.myRootGroup.viewOptions.SORT_POSITIONED)) != 0 ? weightDiff : DbPresentation.NAMES_COMPARATOR.compare(DatabaseStructure.getName(o1), DatabaseStructure.getName(o2));
    }

    boolean isNodeCut(@Nullable Object node) {
        return node != null && this.myContext.isNodeCut(node);
    }

    @NotNull
    public List<Object> getChildren(Object parent2) {
        ArrayList<Object> children2 = new ArrayList<Object>();
        for (Object o : this.getChildElements(parent2)) {
            if (children2.size() % 10 == 0) {
                ProgressManager.checkCanceled();
            }
            children2.add(o);
        }
        children2.sort(this::compareNodes);
        ArrayList<Object> arrayList = children2;
        if (arrayList == null) {
            DatabaseStructure.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static String getName(@NotNull Object o) {
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(6);
        }
        return o instanceof DasObject ? DbPresentation.getPresentableName((DasObject)o, true) : (o instanceof PsiNamedElement ? ((PsiNamedElement)o).getName() : null);
    }

    @NotNull
    private JBIterable<?> getChildElements(Object element2) {
        if (this.isNodeCut(element2)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }
        if (element2 instanceof PsiElement && !((PsiElement)element2).isValid()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }
        return DatabaseStructure.getChildrenImpl(element2, this.myRootGroup.viewOptions, this.myRootGroup.facade);
    }

    public static boolean isAlwaysLeafImpl(Object o) {
        if (o instanceof EmptyScopeLeaf) {
            return true;
        }
        BasicElement basic = o instanceof DasObject ? DbImplUtilCore.getMaybeBasicElement((DasObject)o) : null;
        List<ObjectKind> familyKinds = basic == null ? null : DatabaseStructure.getFamilyKinds(basic);
        return familyKinds != null && familyKinds.isEmpty() || o instanceof DasObject && (((DasObject)o).getKind() == ObjectKind.SEQUENCE || o instanceof DasTableChild && (familyKinds == null || familyKinds.isEmpty()) || o instanceof DasRoutine || o instanceof DasSynonym);
    }

    @NotNull
    private static JBIterable<? extends DasObject> getChildren(@NotNull DasObject object, @NotNull ObjectKind kidKind, @NotNull DatabaseViewOptions viewOptions) {
        if (object == null) {
            DatabaseStructure.$$$reportNull$$$0(9);
        }
        if (kidKind == null) {
            DatabaseStructure.$$$reportNull$$$0(10);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(11);
        }
        if (object instanceof BasicElement) {
            BasicElement element2 = (BasicElement)object;
            JBIterable<? extends BasicElement> jBIterable = DatabaseViewStructureProvider.forDbms(DbImplUtil.getDbms(element2)).getChildren(element2, kidKind, viewOptions);
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }
        JBIterable jBIterable = object.getDasChildren(kidKind);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @NotNull
    private static List<ObjectKind> getFamilyKinds(@NotNull BasicElement element2) {
        if (element2 == null) {
            DatabaseStructure.$$$reportNull$$$0(14);
        }
        List<ObjectKind> list = DatabaseViewStructureProvider.forDbms(DbImplUtil.getDbms(element2)).getFamilyKinds(element2);
        if (list == null) {
            DatabaseStructure.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Nullable
    private static DasObject getParent(@NotNull DasObject o) {
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(16);
        }
        if (o instanceof BasicElement) {
            BasicElement element2 = (BasicElement)o;
            return DatabaseViewStructureProvider.forDbms(DbImplUtil.getDbms(element2)).getParent(element2);
        }
        return o.getDasParent();
    }

    public static boolean isDatabaseObject(Object element2) {
        return element2 instanceof DasObject || element2 instanceof Group;
    }

    @NotNull
    public static JBIterable<?> getChildrenImpl(@NotNull Object o, @NotNull DatabaseViewOptions viewOptions, @NotNull DbPsiFacade facade) {
        ObjectKind nspChild;
        DasObject root0;
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(17);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(18);
        }
        if (facade == null) {
            DatabaseStructure.$$$reportNull$$$0(19);
        }
        if (o instanceof DbGroup) {
            return DatabaseStructure.getDbGroupChildrenImpl((DbGroup)((Object)o), viewOptions);
        }
        boolean groupNamespaces = viewOptions.GROUP_NAMESPACES;
        boolean showIntermediate = viewOptions.SHOW_INTERMEDIATE;
        Object object = o instanceof FamilyGroup ? ((FamilyGroup)((Object)o)).dasParent : (o instanceof AuxiliaryObjectsGroup ? ((AuxiliaryObjectsGroup)((Object)o)).getParent() : (o instanceof DbDataSource && !groupNamespaces ? DatabaseViewTreeFun.getSimpleDataSourceRoot((DbDataSource)o) : (o instanceof DbDataSource && !showIntermediate ? DatabaseStructure.getTopSingleRoot((DbDataSource)o, viewOptions) : (o instanceof DasNamespace && !showIntermediate ? DatabaseStructure.getTopSingleRoot(facade.findDataSource((DasObject)((DasNamespace)o)), (DasObject)o, viewOptions) : (root0 = o instanceof DasObject ? (DasObject)o : null)))));
        if (root0 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(20);
            }
            return jBIterable;
        }
        DasObject root2 = root0;
        DbDataSource dataSource2 = facade.findDataSource(root2);
        if (dataSource2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(21);
            }
            return jBIterable;
        }
        if (!groupNamespaces) {
            if (o instanceof DbDataSource && root2 instanceof BasicRoot) {
                JBIterable<? extends Object> jBIterable = DatabaseViewTreeFun.listSimpleRootContent(dataSource2, (BasicRoot)root2, viewOptions);
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(22);
                }
                return jBIterable;
            }
            if (o instanceof BasicDatabase) {
                JBIterable<? extends Object> jBIterable = DatabaseViewTreeFun.listSimpleDatabaseContent(dataSource2, (BasicDatabase)o, viewOptions);
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(23);
                }
                return jBIterable;
            }
            if (o instanceof AuxiliaryObjectsGroup) {
                JBIterable<? extends PsiElement> jBIterable = ((AuxiliaryObjectsGroup)((Object)o)).iterateChildren();
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(24);
                }
                return jBIterable;
            }
        }
        ObjectKind kidKind = o instanceof FamilyGroup ? ((FamilyGroup)((Object)o)).kidKind : ObjectKind.NONE;
        ObjectKind rootKind = root2.getKind();
        MetaModel metaModel = DbImplUtil.getMetaModel(dataSource2);
        boolean isNamespace = DatabaseStructure.isNamespace(metaModel, rootKind);
        boolean groupOption = isNamespace && viewOptions.GROUP_SCHEMA || !isNamespace && viewOptions.GROUP_CONTENTS;
        Dbms dbms = dataSource2.getDbms();
        if (groupOption && kidKind == ObjectKind.NONE) {
            SmartList groups = new SmartList();
            int count = 0;
            DatabaseViewStructureProvider.PresentationToModelConverter converter = DatabaseViewStructureProvider.forDbms(dbms).getConverter();
            for (ObjectKind childKind : DatabaseStructure.getChildKinds(root2, metaModel, rootKind)) {
                int weight = DatabaseStructure.getWeight(childKind, dbms, ++count);
                JBIterable<? extends DasObject> kids = DatabaseStructure.getChildObjects(dataSource2, viewOptions, root2, childKind);
                if (viewOptions.HIDDEN_KINDS.contains(childKind.code()) || viewOptions.HIDDEN_KINDS.contains(converter.toModelObjectKind(childKind).code()) || !DatabaseStructure.shouldShowEmptyGroup(viewOptions, DatabaseStructure.isNamespace(metaModel, childKind)) && kids.isEmpty()) continue;
                RegularFamilyGroup group = DatabaseStructure.getOrCreateRegularFamilyGroup(root2, childKind, weight, dbms, dataSource2);
                group.setSize(kids.size());
                groups.add(group);
            }
            if (groups.size() > 1 || viewOptions.SHOW_INTERMEDIATE) {
                JBIterable jBIterable = JBIterable.from((Iterable)groups);
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(25);
                }
                return jBIterable;
            }
        }
        JBIterable children2 = DatabaseStructure.getChildObjects(dataSource2, viewOptions, root2, kidKind);
        if (!viewOptions.HIDDEN_KINDS.isEmpty()) {
            children2 = children2.filter(oo -> !viewOptions.HIDDEN_KINDS.contains(oo.getKind().code()));
        }
        if (DatabaseStructure.isNamespace(metaModel, kidKind) && children2.isEmpty()) {
            JBIterable jBIterable = JBIterable.of((Object)((Object)((FamilyGroup)((Object)o)).getEmptyScopeLeaf()));
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(26);
            }
            return jBIterable;
        }
        if (isNamespace && kidKind == ObjectKind.NONE && children2.find(it2 -> DatabaseStructure.isNamespace(metaModel, it2.getKind())) == null && (nspChild = (ObjectKind)metaModel.getChildKinds(rootKind).find(it2 -> DatabaseStructure.isNamespace(metaModel, it2))) != null) {
            RegularFamilyGroup extra = DatabaseStructure.getOrCreateRegularFamilyGroup(root2, nspChild, DatabaseStructure.getWeight(nspChild, dbms, 0), dbms, dataSource2);
            JBIterable jBIterable = JBIterable.of((Object)((Object)extra.getEmptyScopeLeaf())).append((Iterable)children2);
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(27);
            }
            return jBIterable;
        }
        JBIterable jBIterable = children2;
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(28);
        }
        return jBIterable;
    }

    private static boolean isNamespace(@NotNull MetaModel metaModel, @NotNull ObjectKind rootKind) {
        if (metaModel == null) {
            DatabaseStructure.$$$reportNull$$$0(29);
        }
        if (rootKind == null) {
            DatabaseStructure.$$$reportNull$$$0(30);
        }
        return rootKind == ObjectKind.ROOT || metaModel.getNamespaces().contains(rootKind);
    }

    private static int getWeight(@NotNull ObjectKind kind, @NotNull Dbms dbms, int groupCount) {
        int weight;
        if (kind == null) {
            DatabaseStructure.$$$reportNull$$$0(31);
        }
        if (dbms == null) {
            DatabaseStructure.$$$reportNull$$$0(32);
        }
        return (weight = DatabaseViewStructureProvider.forDbms(dbms).getWeight(kind, groupCount)) == -1 ? DbPresentation.getWeight(kind, groupCount) : weight;
    }

    @NotNull
    private static JBIterable<? extends PsiElement> getDbGroupChildrenImpl(@NotNull DbGroup group, @NotNull DatabaseViewOptions viewOptions) {
        if (group == null) {
            DatabaseStructure.$$$reportNull$$$0(33);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(34);
        }
        JBIterable parentGroups = JBIterable.generate((Object)((Object)group), o -> o.parent);
        DbRootGroup root2 = Objects.requireNonNull((DbRootGroup)((Object)parentGroups.filter(DbRootGroup.class).first()));
        JBIterable dataSources = JBIterable.from((Iterable)root2.facade.getDataSources());
        if (!viewOptions.GROUP_DATA_SOURCES) {
            JBIterable jBIterable = group instanceof DbRootGroup ? dataSources : JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(35);
            }
            return jBIterable;
        }
        String fullName = group.getQualifiedName();
        Map groups = (Map)((Map)DatabaseTreeKeys.DATABASE_GROUPS.getRequired((UserDataHolder)root2)).get((Object)group);
        HashSet<String> subNames = new HashSet<String>();
        ArrayList<Object> result = new ArrayList<Object>();
        for (DbDataSource dataSource2 : dataSources) {
            String subName;
            String groupName = StringUtil.notNullize((String)((AbstractDataSource)dataSource2.getDelegate()).getGroupName());
            if (!groupName.startsWith(fullName)) continue;
            if (groupName.equals(fullName)) {
                result.add(dataSource2);
                continue;
            }
            if (fullName.length() != 0 && groupName.charAt(fullName.length()) != '/') continue;
            String substring = StringUtil.trimStart((String)groupName.substring(fullName.length()), (String)"/");
            int idx = substring.indexOf("/");
            String string = subName = idx < 0 ? substring : substring.substring(0, idx);
            if (subName.isEmpty()) continue;
            DbGroup subGroup = (DbGroup)((Object)groups.get(subName));
            if (!subNames.add(subName)) {
                subGroup.incSize();
                continue;
            }
            result.add((Object)subGroup);
            subGroup.setSize(1);
        }
        JBIterable jBIterable = JBIterable.from(result);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(36);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<? extends DasObject> getChildObjects(DbDataSource ds, DatabaseViewOptions viewOptions, DasObject element2, ObjectKind kidKind) {
        LocalDataSource lds = DbImplUtil.getMaybeLocalDataSource((DasDataSource)ds);
        TreePattern scope = lds == null || viewOptions.SHOW_ALL_NAMESPACES ? null : lds.getIntrospectionScope();
        DasModel model = element2 instanceof DbDataSource ? ((DbDataSource)element2).getModel() : null;
        Condition condition = null;
        if (element2 instanceof DasNamespace || element2 instanceof DbDataSource || element2 instanceof BasicRoot) {
            if (element2 instanceof BasicMateNamespace && ((BasicMateNamespace)element2).isSubstituted() && !ourShowMiniCat) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(37);
                }
                return jBIterable;
            }
            condition = DbImplUtilCore.buildFilter((DasDataSource)ds);
            Condition displayed = o -> scope == null || !(o instanceof DasNamespace) || DataSourceSchemaMapping.matches(scope, o);
            Condition condition2 = condition = condition == null ? displayed : Conditions.and((Condition)condition, (Condition)displayed);
        }
        JBIterable res2 = model instanceof BasicModel ? ((BasicModel)model).getRoot().getDasChildren(kidKind) : (model != null ? model.getModelRoots().filter(DasUtil.byKind((ObjectKind)kidKind)) : DatabaseStructure.getChildren(element2, kidKind, viewOptions));
        JBIterable jBIterable = condition == null ? res2 : res2.filter(condition);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(38);
        }
        return jBIterable;
    }

    @NotNull
    private static Iterable<ObjectKind> getChildKinds(@NotNull Object element2, @NotNull MetaModel mm, @NotNull ObjectKind parentKind) {
        DasModel model;
        if (element2 == null) {
            DatabaseStructure.$$$reportNull$$$0(39);
        }
        if (mm == null) {
            DatabaseStructure.$$$reportNull$$$0(40);
        }
        if (parentKind == null) {
            DatabaseStructure.$$$reportNull$$$0(41);
        }
        DasModel dasModel = model = element2 instanceof DbDataSource ? ((DbDataSource)element2).getModel() : null;
        Object delegate = model instanceof BasicModel ? ((BasicModel)model).getRoot() : (element2 instanceof DbElement ? ((DbElement)element2).getDelegate() : element2);
        JBIterable jBIterable = delegate instanceof BasicElement ? DatabaseStructure.getFamilyKinds((BasicElement)delegate) : mm.getChildKinds(parentKind);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(42);
        }
        return jBIterable;
    }

    @Nullable
    public static <T extends DasModel> T getModel(DasDataSource ds, Class<T> clazz) {
        LocalDataSource local = DbImplUtil.getMaybeLocalDataSource(ds);
        return (T)(local == null ? null : (DasModel)ObjectUtils.tryCast((Object)local.getModel(), clazz));
    }

    @Nullable
    public static PsiElement getParentImpl(@NotNull PsiElement o, DatabaseViewOptions viewOptions) {
        PsiElement delegate;
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(43);
        }
        if (!o.isValid()) {
            return null;
        }
        Project project = o.getProject();
        Object object = o instanceof DbDataSource ? o : (o instanceof DbElement ? ((DbElement)o).getDelegate() : (delegate = o instanceof Group ? o : null));
        if (delegate == null) {
            return null;
        }
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        Object parent2 = DatabaseStructure.getParentImpl(delegate, viewOptions, facade);
        if (parent2 instanceof DasObject && !(parent2 instanceof DbDataSource)) {
            DbDataSource dataSource2 = facade.findDataSource((DasObject)parent2);
            return dataSource2 == null ? null : DbImplUtil.findElement(dataSource2, (DasObject)parent2);
        }
        return parent2 instanceof PsiElement ? (PsiElement)parent2 : null;
    }

    private static boolean shouldShowEmptyGroup(@NotNull DatabaseViewOptions viewOptions, boolean isNamespace) {
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(44);
        }
        return viewOptions.SHOW_EMPTY_GROUPS || isNamespace;
    }

    @Nullable
    private static Object getParentImpl(@NotNull Object o, @NotNull DatabaseViewOptions viewOptions, @NotNull DbPsiFacade facade) {
        DasObject grandPa;
        FamilyGroup result;
        Object p2;
        boolean groupOption;
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(45);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(46);
        }
        if (facade == null) {
            DatabaseStructure.$$$reportNull$$$0(47);
        }
        if (o instanceof DbGroup) {
            return ((DbGroup)((Object)o)).parent;
        }
        if (o instanceof DbDataSource) {
            return DatabaseStructure.getDbGroup(facade, ((AbstractDataSource)((DbDataSource)o).getDelegate()).getGroupName(), viewOptions);
        }
        if (o instanceof AuxiliaryObjectsGroup) {
            return ((AuxiliaryObjectsGroup)((Object)o)).getParentNode();
        }
        if (o instanceof AuxiliaryFamilyGroup) {
            return ((AuxiliaryFamilyGroup)((Object)o)).getParentNode();
        }
        Object root0 = o instanceof FamilyGroup ? ((FamilyGroup)((Object)o)).dasParent : (o instanceof DasObject ? DatabaseStructure.getParent((DasObject)o) : null);
        DasObject root1 = root0;
        if (root1 == null) {
            return null;
        }
        DbDataSource dataSource2 = facade.findDataSource(root1);
        if (dataSource2 == null) {
            return JBIterable.empty();
        }
        DbDataSource root2 = root1.getKind() == ObjectKind.ROOT ? dataSource2 : root1;
        ObjectKind kidKind = o instanceof DasObject ? ((DasObject)o).getKind() : ObjectKind.NONE;
        ObjectKind rootKind = root2.getKind();
        MetaModel metaModel = DbImplUtil.getMetaModel(dataSource2);
        boolean isNamespace = DatabaseStructure.isNamespace(metaModel, rootKind);
        boolean bl = groupOption = isNamespace && viewOptions.GROUP_SCHEMA || !isNamespace && viewOptions.GROUP_CONTENTS;
        if (!viewOptions.GROUP_NAMESPACES && (p2 = DatabaseViewTreeFun.getSimpleParent(o, dataSource2, viewOptions)) != null) {
            return p2;
        }
        if (groupOption && kidKind != ObjectKind.NONE && (result = DatabaseStructure.obtainFamilyGroup(dataSource2, o, kidKind, (DasObject)root2, rootKind, viewOptions)) != null) {
            return result;
        }
        while (root1 instanceof DasNamespace && (grandPa = root1.getDasParent()) != null && !viewOptions.SHOW_INTERMEDIATE && DatabaseStructure.getTopSingleRoot(dataSource2, grandPa, viewOptions) != grandPa) {
            root1 = grandPa;
        }
        Object object = root2 = root1.getKind() == ObjectKind.ROOT ? dataSource2 : root1;
        if (root2 instanceof BasicRoot) {
            return dataSource2;
        }
        return root2;
    }

    @Nullable
    static FamilyGroup obtainFamilyGroup(@NotNull DbDataSource dbDataSource, @NotNull Object o, @NotNull ObjectKind kidKind, @NotNull DasObject parent2, @NotNull ObjectKind parentKind, @NotNull DatabaseViewOptions viewOptions) {
        if (dbDataSource == null) {
            DatabaseStructure.$$$reportNull$$$0(48);
        }
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(49);
        }
        if (kidKind == null) {
            DatabaseStructure.$$$reportNull$$$0(50);
        }
        if (parent2 == null) {
            DatabaseStructure.$$$reportNull$$$0(51);
        }
        if (parentKind == null) {
            DatabaseStructure.$$$reportNull$$$0(52);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(53);
        }
        RegularFamilyGroup result = null;
        int visible = 0;
        int count = 0;
        Dbms dbms = dbDataSource.getDbms();
        DatabaseViewStructureProvider.PresentationToModelConverter converter = DatabaseViewStructureProvider.forDbms(dbms).getConverter();
        BasicElement basic = (BasicElement)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap((DasObject)ObjectUtils.tryCast((Object)o, DasObject.class)), BasicElement.class);
        ObjectKind groupKind = basic == null ? kidKind : converter.getGroupKind(basic);
        MetaModel metaModel = DbImplUtil.getMetaModel(dbDataSource);
        int needVisibles = viewOptions.SHOW_INTERMEDIATE ? 1 : 2;
        for (ObjectKind kind : DatabaseStructure.getChildKinds(parent2, metaModel, parentKind)) {
            ++count;
            visible += viewOptions.HIDDEN_KINDS.contains(kind.code()) ? 0 : (DatabaseStructure.shouldShowEmptyGroup(viewOptions, DatabaseStructure.isNamespace(metaModel, kind)) ? 1 : DatabaseStructure.getChildObjects(dbDataSource, viewOptions, parent2, kind).take(1).size());
            if (kind != groupKind) continue;
            int weight = DatabaseStructure.getWeight(kind, dbms, count);
            result = DatabaseStructure.getOrCreateRegularFamilyGroup(parent2, kind, weight, dbms, dbDataSource);
            if (visible < needVisibles) continue;
            break;
        }
        if (visible >= needVisibles && result != null) {
            return result;
        }
        return null;
    }

    @NotNull
    static DasObject getTopSingleRoot(@NotNull DbDataSource databaseSystem, DatabaseViewOptions options) {
        DasObject single;
        DatabaseSystem delegate;
        DasModel model;
        if (databaseSystem == null) {
            DatabaseStructure.$$$reportNull$$$0(54);
        }
        if ((model = (delegate = databaseSystem.getDelegate()).getModel()) instanceof BasicModel) {
            BasicRoot root2 = ((BasicModel)model).getRoot();
            single = DatabaseStructure.getSingleChild(databaseSystem, root2, options);
        } else {
            DasObject singleRoot = (DasObject)model.getModelRoots().single();
            single = singleRoot != null && !options.HIDDEN_KINDS.contains(singleRoot.getKind().code()) ? singleRoot : null;
        }
        Object object = single instanceof DasNamespace ? DatabaseStructure.getTopSingleRoot(databaseSystem, single, options) : databaseSystem;
        if (object == null) {
            DatabaseStructure.$$$reportNull$$$0(55);
        }
        return object;
    }

    @Nullable
    private static DasObject getSingleChild(@NotNull DbDataSource databaseSystem, DasObject element2, DatabaseViewOptions options) {
        if (databaseSystem == null) {
            DatabaseStructure.$$$reportNull$$$0(56);
        }
        if (options.SHOW_INTERMEDIATE) {
            return null;
        }
        JBIterable kinds = element2 instanceof BasicElement ? JBIterable.from(((BasicElement)element2).getFamilyKinds()) : element2.getDasChildren(null).map(DasNamed::getKind).unique();
        ObjectKind singleKind = (ObjectKind)kinds.filter(kind -> !options.HIDDEN_KINDS.contains(kind.code()) && DatabaseStructure.getChildObjects(databaseSystem, options, element2, kind).isNotEmpty()).single();
        return singleKind == null ? null : (DasObject)DatabaseStructure.getChildObjects(databaseSystem, options, element2, singleKind).single();
    }

    static DasObject getTopSingleRoot(@Nullable DbDataSource databaseSystem, @NotNull DasObject element2, @NotNull DatabaseViewOptions options) {
        if (element2 == null) {
            DatabaseStructure.$$$reportNull$$$0(57);
        }
        if (options == null) {
            DatabaseStructure.$$$reportNull$$$0(58);
        }
        if (databaseSystem == null) {
            return null;
        }
        return (DasObject)JBIterable.generate((Object)element2, cur2 -> {
            DasObject single = DatabaseStructure.getSingleChild(databaseSystem, cur2, options);
            return single instanceof DasNamespace ? single : null;
        }).last();
    }

    @NotNull
    static DbRootGroup getRootGroup(@NotNull DbPsiFacade facade, @NotNull DatabaseViewOptions options) {
        UserDataHolderEx project;
        DbRootGroup root2;
        if (facade == null) {
            DatabaseStructure.$$$reportNull$$$0(59);
        }
        if (options == null) {
            DatabaseStructure.$$$reportNull$$$0(60);
        }
        if ((root2 = (DbRootGroup)((Object)(project = (UserDataHolderEx)facade.getProject()).getUserData(DatabaseTreeKeys.ROOT_GROUP))) == null) {
            root2 = (DbRootGroup)((Object)project.putUserDataIfAbsent(DatabaseTreeKeys.ROOT_GROUP, (Object)new DbRootGroup(facade, options)));
        }
        DbRootGroup dbRootGroup = root2;
        if (dbRootGroup == null) {
            DatabaseStructure.$$$reportNull$$$0(61);
        }
        return dbRootGroup;
    }

    @NotNull
    static RegularFamilyGroup getOrCreateRegularFamilyGroup(@NotNull DasObject parentElement, @NotNull ObjectKind childKind, int weight, @NotNull Dbms dbms, @NotNull DbDataSource dataSource2) {
        ConcurrentMap groupMap;
        RegularFamilyGroup result;
        if (parentElement == null) {
            DatabaseStructure.$$$reportNull$$$0(62);
        }
        if (childKind == null) {
            DatabaseStructure.$$$reportNull$$$0(63);
        }
        if (dbms == null) {
            DatabaseStructure.$$$reportNull$$$0(64);
        }
        if (dataSource2 == null) {
            DatabaseStructure.$$$reportNull$$$0(65);
        }
        if ((result = (RegularFamilyGroup)((Object)(groupMap = (ConcurrentMap)((Map)DatabaseTreeKeys.FAMILY_GROUPS.getRequired((UserDataHolder)dataSource2)).get(parentElement)).get(childKind))) == null || result.weight != weight) {
            String name = StringUtil.pluralize((String)DbPresentationCore.getPresentableName(childKind, dbms));
            RegularFamilyGroup candidateGroup = new RegularFamilyGroup(name, childKind, parentElement, dataSource2, weight);
            result = (RegularFamilyGroup)((Object)ConcurrencyUtil.cacheOrGet((ConcurrentMap)groupMap, (Object)childKind, (Object)((Object)candidateGroup)));
        }
        RegularFamilyGroup regularFamilyGroup = result;
        if (regularFamilyGroup == null) {
            DatabaseStructure.$$$reportNull$$$0(66);
        }
        return regularFamilyGroup;
    }

    @NotNull
    public static PsiElement getDbGroup(@NotNull DbPsiFacade facade, @Nullable String groupName, @NotNull DatabaseViewOptions viewOptions) {
        if (facade == null) {
            DatabaseStructure.$$$reportNull$$$0(67);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(68);
        }
        DbRootGroup root2 = DatabaseStructure.getRootGroup(facade, viewOptions);
        if (!viewOptions.GROUP_DATA_SOURCES) {
            DbRootGroup dbRootGroup = root2;
            if (dbRootGroup == null) {
                DatabaseStructure.$$$reportNull$$$0(69);
            }
            return dbRootGroup;
        }
        Map map2 = (Map)DatabaseTreeKeys.DATABASE_GROUPS.getRequired((UserDataHolder)root2);
        if (StringUtil.isEmpty((String)groupName)) {
            DbRootGroup dbRootGroup = root2;
            if (dbRootGroup == null) {
                DatabaseStructure.$$$reportNull$$$0(70);
            }
            return dbRootGroup;
        }
        PsiElement psiElement = (PsiElement)JBIterable.from((Iterable)StringUtil.split((String)groupName, (String)"/")).reduce((Object)root2, (p2, s2) -> (DbGroup)((Object)((Object)((Map)map2.get(p2)).get(s2))));
        if (psiElement == null) {
            DatabaseStructure.$$$reportNull$$$0(71);
        }
        return psiElement;
    }

    public static void renameGroup(@NotNull Project project, DbGroup group, @NotNull String newName) {
        if (project == null) {
            DatabaseStructure.$$$reportNull$$$0(72);
        }
        if (newName == null) {
            DatabaseStructure.$$$reportNull$$$0(73);
        }
        String fullname = group.getQualifiedName();
        String pathname = StringUtil.trimEnd((String)fullname, (String)group.name);
        String newFullname = pathname + newName;
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        for (DbDataSource dataSource2 : facade.getDataSources()) {
            AbstractDataSource ds = (AbstractDataSource)((Object)ObjectUtils.tryCast((Object)dataSource2.getDelegate(), AbstractDataSource.class));
            String cur2 = ds == null ? null : ds.getGroupName();
            if (cur2 == null || !cur2.startsWith(fullname)) continue;
            ds.setGroupName(newFullname + cur2.substring(fullname.length()));
        }
        PsiElement newGroup = DatabaseStructure.getDbGroup(facade, newFullname, DatabaseViewOptions.getInstance(project));
        DatabaseView.refreshViewAndSelect(project, Collections.singleton(newGroup));
    }

    @Contract(value="!null->!null")
    public static Object unwrap(@Nullable Object o) {
        return o instanceof DbElement && !(o instanceof DbDataSource) ? ((DbElement)o).getDelegate() : o;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 55: 
            case 61: 
            case 66: 
            case 69: 
            case 70: 
            case 71: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 55: 
            case 61: 
            case 66: 
            case 69: 
            case 70: 
            case 71: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 55: 
            case 61: 
            case 66: 
            case 69: 
            case 70: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseStructure";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 6: 
            case 16: 
            case 17: 
            case 43: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 10: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kidKind";
                break;
            }
            case 11: 
            case 18: 
            case 34: 
            case 44: 
            case 46: 
            case 53: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewOptions";
                break;
            }
            case 14: 
            case 39: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: 
            case 47: 
            case 59: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaModel";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootKind";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 32: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mm";
                break;
            }
            case 41: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentKind";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDataSource";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseSystem";
                break;
            }
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childKind";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreePath";
                break;
            }
            case 5: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenImpl";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbGroupChildrenImpl";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildObjects";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildKinds";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopSingleRoot";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootGroup";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateRegularFamilyGroup";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 55: 
            case 61: 
            case 66: 
            case 69: 
            case 70: 
            case 71: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compareNodes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFamilyKinds";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenImpl";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isNamespace";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getWeight";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDbGroupChildrenImpl";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getChildKinds";
                break;
            }
            case 43: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getParentImpl";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowEmptyGroup";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "obtainFamilyGroup";
                break;
            }
            case 54: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getTopSingleRoot";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getSingleChild";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getRootGroup";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateRegularFamilyGroup";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getDbGroup";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "renameGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 55: 
            case 61: 
            case 66: 
            case 69: 
            case 70: 
            case 71: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class EmptyScopeLeaf
    extends FakePsiElement {
        @NotNull
        public final DasObject host;
        @NotNull
        public final ObjectKind kind;
        @NotNull
        public final PsiElement parentNode;

        public EmptyScopeLeaf(@NotNull DasObject host, @NotNull ObjectKind kind, @NotNull PsiElement parentNode) {
            if (host == null) {
                EmptyScopeLeaf.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                EmptyScopeLeaf.$$$reportNull$$$0(1);
            }
            if (parentNode == null) {
                EmptyScopeLeaf.$$$reportNull$$$0(2);
            }
            this.host = host;
            this.kind = kind;
            this.parentNode = parentNode;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = this.kind;
            if (objectKind == null) {
                EmptyScopeLeaf.$$$reportNull$$$0(3);
            }
            return objectKind;
        }

        public DasObject getDasParent() {
            return this.host;
        }

        protected Icon getBaseIcon() {
            return AllIcons.Nodes.NodePlaceholder;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return this.getBaseIcon();
        }

        public PsiElement getParent() {
            return this.parentNode;
        }

        @NotNull
        public TextRange getTextRangeInParent() {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                EmptyScopeLeaf.$$$reportNull$$$0(4);
            }
            return textRange;
        }

        @NotNull
        public @NotNull Iterable<? extends @NotNull PsiSymbolReference> getOwnReferences() {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                EmptyScopeLeaf.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        public String toString() {
            return "No " + this.getKind().code();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentNode";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseStructure$EmptyScopeLeaf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseStructure$EmptyScopeLeaf";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRangeInParent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwnReferences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RegularFamilyGroup
    extends FamilyGroup {
        private int mySize;

        public RegularFamilyGroup(@NotNull String name, @NotNull ObjectKind kidKind, @NotNull DasObject dasParent, @NotNull DbDataSource dataSource2, int weight) {
            if (name == null) {
                RegularFamilyGroup.$$$reportNull$$$0(0);
            }
            if (kidKind == null) {
                RegularFamilyGroup.$$$reportNull$$$0(1);
            }
            if (dasParent == null) {
                RegularFamilyGroup.$$$reportNull$$$0(2);
            }
            if (dataSource2 == null) {
                RegularFamilyGroup.$$$reportNull$$$0(3);
            }
            super(name, kidKind, dasParent, dataSource2, weight);
            this.mySize = 0;
        }

        @Override
        public int getSize() {
            return this.mySize;
        }

        void setSize(int size) {
            this.mySize = size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kidKind";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dasParent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSource";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/view/DatabaseStructure$RegularFamilyGroup";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class FamilyGroup
    extends Group
    implements WeighedItem {
        public final DbDataSource dataSource;
        public final DasObject dasParent;
        private WeakReference<EmptyScopeLeaf> myEmptyScopeLeaf;
        final ObjectKind kidKind;
        final int weight;

        FamilyGroup(@NotNull String name, @NotNull ObjectKind kidKind, @NotNull DasObject dasParent, @NotNull DbDataSource dataSource2, int weight) {
            if (name == null) {
                FamilyGroup.$$$reportNull$$$0(0);
            }
            if (kidKind == null) {
                FamilyGroup.$$$reportNull$$$0(1);
            }
            if (dasParent == null) {
                FamilyGroup.$$$reportNull$$$0(2);
            }
            if (dataSource2 == null) {
                FamilyGroup.$$$reportNull$$$0(3);
            }
            super(name);
            this.myEmptyScopeLeaf = new WeakReference<Object>(null);
            this.dataSource = dataSource2;
            this.kidKind = kidKind;
            this.dasParent = dasParent;
            this.weight = weight;
        }

        public PsiElement getParent() {
            return DbImplUtil.findElement(this.dataSource, this.dasParent);
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        @NotNull
        public JBIterable<? extends DbElement> iterateChildren() {
            DatabaseViewStructureProvider.PresentationToModelConverter provider = this.converter();
            DasObject modelParent = this.dasParent instanceof BasicElement ? provider.toModelParent((BasicElement)this.dasParent) : this.dasParent;
            DbElement parent2 = DbImplUtil.findElement(this.dataSource, modelParent);
            JBIterable<? extends DbElement> children2 = parent2 == null ? JBIterable.empty() : parent2.getDasChildren(this.getChildrenKind());
            JBIterable<? extends DbElement> jBIterable = this.dasParent instanceof BasicElement ? provider.pickOnlyGroupChildren((BasicElement)this.dasParent, children2, this.kidKind) : children2;
            if (jBIterable == null) {
                FamilyGroup.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @NotNull
        public ObjectKind getChildrenKind() {
            ObjectKind objectKind = this.converter().toModelObjectKind(this.kidKind);
            if (objectKind == null) {
                FamilyGroup.$$$reportNull$$$0(5);
            }
            return objectKind;
        }

        @NotNull
        private DatabaseViewStructureProvider.PresentationToModelConverter converter() {
            DatabaseViewStructureProvider.PresentationToModelConverter presentationToModelConverter = DatabaseViewStructureProvider.forDbms(this.dataSource.getDbms()).getConverter();
            if (presentationToModelConverter == null) {
                FamilyGroup.$$$reportNull$$$0(6);
            }
            return presentationToModelConverter;
        }

        @NotNull
        public EmptyScopeLeaf getEmptyScopeLeaf() {
            EmptyScopeLeaf leaf = (EmptyScopeLeaf)((Object)this.myEmptyScopeLeaf.get());
            if (leaf == null) {
                BasicElement modelParent = DatabaseViewTreeFun.getModelElement(this.dasParent);
                leaf = new EmptyScopeLeaf((DasObject)ObjectUtils.notNull((Object)modelParent, (Object)this.dasParent), this.kidKind, (PsiElement)this);
                this.myEmptyScopeLeaf = new WeakReference<EmptyScopeLeaf>(leaf);
            }
            EmptyScopeLeaf emptyScopeLeaf = leaf;
            if (emptyScopeLeaf == null) {
                FamilyGroup.$$$reportNull$$$0(7);
            }
            return emptyScopeLeaf;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kidKind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dasParent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseStructure$FamilyGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseStructure$FamilyGroup";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateChildren";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenKind";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "converter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEmptyScopeLeaf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbRootGroup
    extends DbGroup {
        public final DbPsiFacade facade;
        public final DatabaseViewOptions viewOptions;

        public DbRootGroup(@NotNull DbPsiFacade facade, @NotNull DatabaseViewOptions options) {
            if (facade == null) {
                DbRootGroup.$$$reportNull$$$0(0);
            }
            if (options == null) {
                DbRootGroup.$$$reportNull$$$0(1);
            }
            super("Database", null);
            this.facade = facade;
            this.viewOptions = options;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = this.facade.getProject();
            if (project == null) {
                DbRootGroup.$$$reportNull$$$0(2);
            }
            return project;
        }

        public PsiManager getManager() {
            return PsiManager.getInstance((Project)this.getProject());
        }

        @Override
        public String getQualifiedName() {
            return "";
        }

        public PsiFile getContainingFile() {
            return null;
        }

        @Override
        public PsiElement getParent() {
            return null;
        }

        public boolean isValid() {
            return !this.getProject().isDisposed();
        }

        @Override
        protected Icon getBaseIcon() {
            return DatabaseIcons.Dbms;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseStructure$DbRootGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseStructure$DbRootGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbGroup
    extends Group {
        final DbGroup parent;
        private int mySize = 0;

        public DbGroup(String name, DbGroup parent2) {
            super(name);
            this.parent = parent2;
        }

        @Override
        public int getSize() {
            return this.mySize;
        }

        void setSize(int size) {
            this.mySize = size;
        }

        void incSize() {
            ++this.mySize;
        }

        @Override
        protected Icon getBaseIcon() {
            return DatabaseIcons.ObjectGroup;
        }

        public PsiElement getParent() {
            return this.parent;
        }

        @NotNull
        public Project getProject() {
            Project project = this.getParent().getProject();
            if (project == null) {
                DbGroup.$$$reportNull$$$0(0);
            }
            return project;
        }

        @Override
        @NotNull
        public JBIterable<? extends PsiElement> iterateChildren() {
            DbRootGroup root2 = Objects.requireNonNull((DbRootGroup)((Object)SyntaxTraverser.psiApi().parents((Object)this).filter(DbRootGroup.class).first()));
            JBIterable<? extends PsiElement> jBIterable = DatabaseStructure.getDbGroupChildrenImpl(this, root2.viewOptions);
            if (jBIterable == null) {
                DbGroup.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        public String getQualifiedName() {
            StringBuilder sb = new StringBuilder(this.name);
            DbGroup cur2 = this.parent;
            while (cur2 != null && !(cur2 instanceof DbRootGroup)) {
                sb.insert(0, cur2.name + "/");
                cur2 = cur2.parent;
            }
            return sb.toString();
        }

        @NotNull
        public ItemPresentation getQualifiedPresentation() {
            PresentationData presentation = (PresentationData)this.getPresentation();
            presentation.getColoredText().set(0, new PresentableNodeDescriptor.ColoredFragment(this.getQualifiedName(), SimpleTextAttributes.REGULAR_ATTRIBUTES));
            PresentationData presentationData = presentation;
            if (presentationData == null) {
                DbGroup.$$$reportNull$$$0(2);
            }
            return presentationData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/view/DatabaseStructure$DbGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifiedPresentation";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static abstract class Group
    extends FakePsiElement
    implements NavigationItem {
        public final String name;
        final PresentationData presentation;

        public Group(@NotNull String name) {
            if (name == null) {
                Group.$$$reportNull$$$0(0);
            }
            this.presentation = new PresentationData();
            this.name = name;
        }

        @NotNull
        public abstract JBIterable<? extends PsiElement> iterateChildren();

        @NotNull
        public ItemPresentation getPresentation() {
            this.presentation.clear();
            this.presentation.setIcon(this.getIcon(false));
            this.presentation.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            int theSize = this.getSize();
            if (theSize > 0) {
                this.presentation.addText("  " + theSize, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
            PresentationData presentationData = this.presentation;
            if (presentationData == null) {
                Group.$$$reportNull$$$0(1);
            }
            return presentationData;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                Group.$$$reportNull$$$0(2);
            }
            return string;
        }

        public abstract int getSize();

        public void navigate(boolean requestFocus) {
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        protected Icon getBaseIcon() {
            return DatabaseIcons.ObjectGroup;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return this.getBaseIcon();
        }

        public int getWeight() {
            return -1;
        }

        public String toString() {
            return this.name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseStructure$Group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseStructure$Group";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

