/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.actions.DdlActions;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.view.AuxiliaryObjectsGroup;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseNavBarExtension
extends AbstractNavBarModelExtension {
    @Nullable
    public String getPopupMenuGroup(@NotNull DataProvider provider) {
        PsiElement object;
        if (provider == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(0);
        }
        if (!DatabaseStructure.isDatabaseObject(object = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(provider))) {
            return null;
        }
        return "DatabaseViewPopupMenu";
    }

    @Nullable
    public Object getData(@NotNull String dataId, @NotNull DataProvider provider) {
        PsiElement object;
        if (dataId == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(2);
        }
        if ((object = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(provider)) instanceof DatabaseStructure.DbRootGroup) {
            return null;
        }
        if (!DatabaseStructure.isDatabaseObject(object)) {
            return null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && object instanceof DbElement) {
            return DbNavigationUtils.createFromTreeNavigatable((DbElement)object);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            List<PsiElement> c2 = Collections.singletonList(object);
            if (JBIterable.from(c2).filter(DbDataSource.class).size() == c2.size()) {
                return new DdlActions.DeleteProvider1();
            }
            return new DdlActions.DeleteProvider2();
        }
        return DbNodeDescriptor.getData(dataId, object.getProject(), object);
    }

    @Nullable
    public String getPresentableText(Object object) {
        if (!DatabaseStructure.isDatabaseObject(object)) {
            return null;
        }
        return object instanceof DbElement ? DbPresentation.getPresentableName((DasObject)((DbElement)object), true) : (object instanceof PsiNamedElement ? ((PsiNamedElement)object).getName() : null);
    }

    @Nullable
    public PsiElement getParent(PsiElement psiElement) {
        if (psiElement instanceof AuxiliaryObjectsGroup) {
            return ((AuxiliaryObjectsGroup)psiElement).getParent();
        }
        if (!DatabaseStructure.isDatabaseObject(psiElement)) {
            return null;
        }
        DatabaseViewOptions options = DatabaseViewOptions.getInstance(psiElement.getProject());
        return DatabaseStructure.getParentImpl(psiElement, options);
    }

    @Nullable
    public PsiElement adjustElement(final @NotNull PsiElement psiElement) {
        if (psiElement == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(3);
        }
        if (psiElement instanceof DbElement || psiElement instanceof DatabaseStructure.Group) {
            return psiElement;
        }
        final VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
        if (DbImplUtil.isDatabaseVirtualFile(file)) {
            DbElement element2 = DbImplUtil.findElement(psiElement.getProject(), file);
            if (element2 != null) {
                return element2;
            }
            if (DbSrcUtilsCore.isDbSrcFile(file)) {
                PsiElement group = DbSrcFileSystemCore.processPath(file.getPath(), new DbSrcFileSystemCore.ItemProcessor<PsiElement>(){

                    @Override
                    public PsiElement processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                        DbElement parent2;
                        if (dataSourceId == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        DbElement dbElement = parent2 = group == null ? null : DbImplUtil.findElement(psiElement.getProject(), file.getParent());
                        if (parent2 == null) {
                            return null;
                        }
                        DbDataSource dataSource2 = parent2.getDataSource();
                        DatabaseStructure.RegularFamilyGroup familyGroup = DatabaseStructure.getOrCreateRegularFamilyGroup((DasObject)parent2, group, 0, dataSource2.getDbms(), dataSource2);
                        return familyGroup;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/view/DatabaseNavBarExtension$1", "processFolder"));
                    }
                });
                if (group != null) {
                    return group;
                }
                return DbPsiFacade.getInstance((Project)psiElement.getProject()).findDataSource(DbSrcUtilsCore.getDataSource(file));
            }
        } else {
            DataGrid dataGrid = DataGridPomTarget.unwrapDataGrid(psiElement);
            if (dataGrid != null) {
                VirtualFile virtualFile = DataGridUtil.getVirtualFile(dataGrid);
                return virtualFile == null ? null : psiElement.getManager().findFile(virtualFile);
            }
        }
        return psiElement;
    }

    public boolean processChildren(Object object, Object rootElement, Processor<Object> processor) {
        Object adjusted;
        if (!(object instanceof PsiElement) || !((PsiElement)object).isValid()) {
            return true;
        }
        Object object2 = adjusted = object instanceof DbElement && !(object instanceof DbDataSource) ? ((DbElement)object).getDelegate() : object;
        if (!DatabaseStructure.isDatabaseObject(adjusted)) {
            return true;
        }
        if (DatabaseStructure.isAlwaysLeafImpl(adjusted)) {
            return true;
        }
        Project project = ((PsiElement)object).getProject();
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        DbDataSource dataSource2 = object instanceof DbElement ? ((DbElement)object).getDataSource() : (object instanceof DatabaseStructure.FamilyGroup ? ((DatabaseStructure.FamilyGroup)((Object)object)).dataSource : null);
        DatabaseViewOptions options = DatabaseViewOptions.getInstance(project);
        JBIterable children2 = DatabaseStructure.getChildrenImpl(adjusted, options, facade).filterMap(o -> o instanceof DbDataSource ? o : (o instanceof DasObject ? DbImplUtil.findElement(dataSource2, (DasObject)o) : o));
        return ContainerUtil.process((Iterable)children2, processor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/view/DatabaseNavBarExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPopupMenuGroup";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

