/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceCore;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.ex.dummy.DummyCachingFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.JBIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseVirtualFileSystem
extends DummyCachingFileSystem<VirtualFile> {
    private static final String PROTOCOL = "das";
    private static final String SRC_PREFIX = "src:";
    private static final String PROTOCOL_SEPARATOR = ":/";
    private final ConcurrentMap<VirtualFile, Boolean> myRemoved = CollectionFactory.createConcurrentWeakIdentityMap();

    public static DatabaseVirtualFileSystem getDatabaseFileSystem() {
        return (DatabaseVirtualFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public DatabaseVirtualFileSystem() {
        super(PROTOCOL);
    }

    public void onProjectOpened(@NotNull Project project) {
        if (project == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(0);
        }
        super.onProjectOpened(project);
        project.getMessageBus().connect().subscribe(DbPsiFacade.TOPIC, o -> this.refreshFiles(project));
    }

    protected String getPresentableUrl(@NotNull VirtualFile file) {
        if (file == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(1);
        }
        if (file instanceof VirtualFilePathWrapper) {
            return ((VirtualFilePathWrapper)file).getPresentablePath();
        }
        return super.getPresentableUrl(file);
    }

    protected VirtualFile findFileByPathInner(@NotNull String path) {
        int separatorIdx;
        if (path == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(2);
        }
        if ((separatorIdx = path.indexOf(PROTOCOL_SEPARATOR)) != -1) {
            return this.migrateOldPath(path, separatorIdx);
        }
        return DatabaseVirtualFileSystem.findFileByNewPath(path);
    }

    private VirtualFile migrateOldPath(@NotNull String path, int separatorIdx) {
        if (path == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(3);
        }
        int separatorEnd = separatorIdx + PROTOCOL_SEPARATOR.length();
        boolean source = path.startsWith(SRC_PREFIX);
        int elementTypeStart = source ? SRC_PREFIX.length() : 0;
        int projectIdEnd = path.indexOf(47, separatorEnd);
        String projectId = path.substring(separatorEnd, projectIdEnd);
        int dataSourceEnd = path.indexOf(47, projectIdEnd + 1);
        if (dataSourceEnd == -1) {
            return null;
        }
        int nameStart = path.lastIndexOf(47);
        if (nameStart == -1 || nameStart <= projectIdEnd) {
            return null;
        }
        String name = DatabaseVirtualFileSystem.unescapeSlash((String)path.substring(nameStart + 1));
        String dataSourceId = path.substring(projectIdEnd + 1, nameStart);
        Project project = this.getProject(projectId);
        if (project == null) {
            return null;
        }
        DbDataSource dataSource2 = DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
        if (dataSource2 == null) {
            return null;
        }
        MetaModel meta = DbImplUtil.getMetaModel(dataSource2);
        ObjectKind kind = meta.findKind(path.substring(elementTypeStart, separatorIdx));
        if (kind == null) {
            return null;
        }
        ObjectPath objectPath = (ObjectPath)ObjectPaths.getObjectPaths(meta, name, kind).first();
        if (objectPath == null) {
            return null;
        }
        return this.findFileByPath(DatabaseVirtualFileSystem.getPath(dataSourceId, objectPath, source));
    }

    private static VirtualFile findFileByNewPath(@NotNull String path) {
        boolean src;
        JBIterator it2;
        if (path == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(4);
        }
        if (!(it2 = JBIterator.from(DbSrcUtilsCore.splitPath((src = path.endsWith(".sql")) ? path.substring(0, path.length() - ".sql".length()) : path).iterator())).advance()) {
            return null;
        }
        String dataSourceId = (String)it2.current();
        DasDataSource dataSource2 = DatabaseVirtualFileSystem.findDataSource(dataSourceId);
        if (dataSource2 == null) {
            return null;
        }
        ObjectPath objectPath = null;
        while (it2.advance()) {
            ObjectKind kind = (ObjectKind)ObjectKind.ourKinds.get(DbSrcUtils.unescapeChars((String)it2.current()));
            if (kind == null || !it2.advance()) {
                return null;
            }
            String name = (String)it2.current();
            int idStart = name.indexOf("@");
            String id = idStart == -1 ? null : DbSrcUtils.unescapeChars(name.substring(idStart + 1));
            name = DbSrcUtils.unescapeChars(id != null ? name.substring(0, idStart) : name);
            objectPath = ObjectPath.create((String)name, (ObjectKind)kind, (boolean)true, (String)id, objectPath);
        }
        DatabaseElementVirtualFileImpl file = new DatabaseElementVirtualFileImpl(dataSourceId, objectPath, src);
        file.setWritableInner(!(dataSource2 instanceof LocalDataSource) || !((LocalDataSource)dataSource2).isReadOnly());
        return file.shouldBeValid() ? file : null;
    }

    @Nullable
    static DasDataSource findDataSource(@NotNull String id) {
        Project[] projects;
        LocalDataSourceCore res2;
        if (id == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(5);
        }
        if ((res2 = DbSrcUtilsCore.findDataSource(null, id)) != null) {
            return res2;
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            res2 = DbSrcUtilsCore.findDataSource(project, id);
            if (res2 == null) continue;
            return res2;
        }
        for (Project project : projects) {
            for (DataSourceManager extension : DataSourceManager.EP_NAME.getExtensions((AreaInstance)project)) {
                if (extension instanceof LocalDataSourceManager) continue;
                for (DasDataSource o : extension.getDataSources()) {
                    if (!Objects.equals(o.getUniqueId(), id)) continue;
                    return o;
                }
            }
        }
        return null;
    }

    @NotNull
    static String getPath(String dataSourceId, ObjectPath path, boolean source) {
        StringBuilder builder = new StringBuilder(dataSourceId);
        if (path != null) {
            path.reduce((Object)builder, (b2, p2) -> {
                b2.append("/").append(DbSrcUtils.escapeChars(p2.kind.code())).append("/").append(DbSrcUtils.escapeChars(p2.name));
                String id = p2.getIdentity();
                if (id != null) {
                    b2.append("@").append(DbSrcUtils.escapeChars(id));
                }
                return b2;
            });
        }
        if (source) {
            builder.append(".sql");
        }
        String string = builder.toString();
        if (string == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) {
        if (vFile == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(7);
        }
        if (newName == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(8);
        }
        throw new UnsupportedOperationException("rename not supported: " + vFile.getUrl());
    }

    private void refreshFiles(@NotNull Project project) {
        if (project == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(9);
        }
        LinkedHashSet<DatabaseElementVirtualFileImpl> removed = new LinkedHashSet<DatabaseElementVirtualFileImpl>();
        ArrayList<Object> events = new ArrayList<Object>();
        Map map2 = DataSourceStorage.getProjectStorage(project).getDataSourcesImpl().toMap(o -> o.getUniqueId(), o -> !o.isReadOnly());
        for (VirtualFile vf : this.getCachedFiles()) {
            Boolean writable;
            DatabaseElementVirtualFileImpl file = (DatabaseElementVirtualFileImpl)((Object)ObjectUtils.tryCast((Object)vf, DatabaseElementVirtualFileImpl.class));
            if (file == null || (writable = (Boolean)map2.get(file.getDataSourceId())) == null) continue;
            if (!file.shouldBeValid() && this.myRemoved.putIfAbsent(file, true) == null) {
                removed.add(file);
                events.add(new VFileDeleteEvent((Object)this, (VirtualFile)file, false));
            }
            if (file.isWritable() == writable.booleanValue()) continue;
            events.add(new VFilePropertyChangeEvent((Object)this, (VirtualFile)file, "writable", (Object)(writable == false ? 1 : 0), (Object)writable, false));
        }
        if (!events.isEmpty() || !removed.isEmpty()) {
            WriteAction.run(() -> {
                BulkFileListener listener2 = (BulkFileListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
                listener2.before(events);
                this.retainFiles(file -> !removed.contains(file));
                Iterator it2 = events.iterator();
                while (it2.hasNext()) {
                    VFileEvent event = (VFileEvent)it2.next();
                    DatabaseElementVirtualFileImpl file2 = (DatabaseElementVirtualFileImpl)Objects.requireNonNull(event.getFile());
                    if (event instanceof VFileDeleteEvent) {
                        if (!file2.isValid()) continue;
                        it2.remove();
                        continue;
                    }
                    if (!(event instanceof VFilePropertyChangeEvent)) continue;
                    file2.setWritable((Boolean)((VFilePropertyChangeEvent)event).getNewValue());
                }
                listener2.after(events);
            });
        } else {
            this.clearCache();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/vfs/DatabaseVirtualFileSystem";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/vfs/DatabaseVirtualFileSystem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpened";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableUrl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathInner";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "migrateOldPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFileByNewPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "refreshFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

