/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSourceCore;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SqlDialects;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSqlUtilCore {
    protected DbSqlUtilCore() {
    }

    public static boolean stringsAreEscapedWithSlash(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(0);
        }
        return dbms.isClickHouse() || dbms.isHive() || dbms.isSpark() || dbms.isMysql() || dbms.isRedshift() || dbms.isSnowflake() || dbms.isMongo() || dbms.isBigQuery();
    }

    public static boolean supportsEscapeStringLiterals(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(1);
        }
        return dbms.isGreenplum() || dbms == Dbms.POSTGRES || dbms.isVertica();
    }

    @Nullable
    public static SqlLanguageDialect getSqlDialect(@Nullable PsiElement element2) {
        SqlLanguageDialect language;
        if (element2 == null) {
            return null;
        }
        PsiFile containingFile = element2.getContainingFile();
        if (containingFile instanceof SqlFile) {
            language = ((SqlFile)containingFile).getSqlLanguage();
        } else if (containingFile instanceof DummyHolder) {
            language = containingFile.getLanguage();
        } else {
            if (element2 instanceof DbElement) {
                return DbSqlUtilCore.getSqlDialect((DbElement)element2);
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2);
            language = LanguageUtil.getLanguageForPsi((Project)element2.getProject(), (VirtualFile)virtualFile);
        }
        return language instanceof SqlLanguageDialect ? language : null;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DbElement element2) {
        DbDataSource dataSource2 = element2 == null ? null : (DbDataSource)ObjectUtils.tryCast((Object)element2.getDataSource(), DbDataSource.class);
        SqlLanguageDialect language = dataSource2 == null ? null : (SqlLanguageDialect)ObjectUtils.tryCast((Object)dataSource2.getQueryLanguage(), SqlLanguageDialect.class);
        SqlLanguageDialect sqlLanguageDialect = language == null ? SqlDialects.getGenericDialect() : language;
        if (sqlLanguageDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(2);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static <T> JBIterable.SFun<T, T> checkCancelled(final int every) {
        return new JBIterable.SFun<T, T>(){
            int cnt = 0;

            public T fun(T o) {
                if (++this.cnt % every == 0) {
                    ProgressManager.checkCanceled();
                }
                return o;
            }
        };
    }

    public static boolean isQuoted(@Nullable DasObject object) {
        if (object instanceof DbElement) {
            return DbSqlUtilCore.isQuoted((DasObject)ObjectUtils.tryCast((Object)((DbElement)object).getDelegate(), DasObject.class));
        }
        if (object instanceof SqlDefinition) {
            return ((SqlDefinition)object).isNameQuoted();
        }
        if (object instanceof SqlNameElement) {
            return DbSqlUtilCore.isQuoted((SqlNameElement)object);
        }
        if (object instanceof BasicElement) {
            return BasicPaths.isQuoted((BasicElement)object);
        }
        return true;
    }

    public static boolean isQuoted(@Nullable SqlNameElement element2) {
        return element2 != null && element2.isQuotedIdentifier();
    }

    @Nullable
    public static DasObject getDasObject(@NotNull DasNamed named) {
        if (named == null) {
            DbSqlUtilCore.$$$reportNull$$$0(3);
        }
        if (named instanceof DasObject) {
            return (DasObject)named;
        }
        if (named instanceof DasSymbol) {
            return ((DasSymbol)named).getDasObject();
        }
        return null;
    }

    @Nullable
    public static PsiElement getPsiDelegate(@Nullable DasObject info) {
        DasObject delegate = info instanceof DbElement ? ((DbElement)info).getDelegate() : info;
        return delegate instanceof PsiElement ? (PsiElement)delegate : null;
    }

    public static boolean isSqlObject(@Nullable DasObject object) {
        if (object instanceof DbElement) {
            return DbSqlUtilCore.isSqlObject((DasObject)ObjectUtils.tryCast((Object)((DbElement)object).getDelegate(), DasObject.class));
        }
        if (object instanceof SqlElement) {
            return true;
        }
        if (object instanceof BasicNamedElement) {
            return ((BasicNamedElement)object).isNameScripted();
        }
        return false;
    }

    @NotNull
    public static <C extends DasNamed> Condition<C> byName(@Nullable String name, boolean quoted, @Nullable String id, @NotNull CasingProvider provider) {
        if (provider == null) {
            DbSqlUtilCore.$$$reportNull$$$0(4);
        }
        if (name == null) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                DbSqlUtilCore.$$$reportNull$$$0(5);
            }
            return condition;
        }
        NameChecker checker = new NameChecker(name, quoted, provider, null);
        Condition condition = named -> {
            DasObject dasObject = DbSqlUtilCore.getDasObject(named);
            return (id == null || dasObject != null && id.equalsIgnoreCase(ObjectPaths.getIdentity(dasObject))) && checker.checkName((DasNamed)named, null);
        };
        if (condition == null) {
            DbSqlUtilCore.$$$reportNull$$$0(6);
        }
        return condition;
    }

    @NotNull
    public static JBIterable<DbDataSource> getDataSourcesForResolve(@NotNull PsiFile sqlFile) {
        if (sqlFile == null) {
            DbSqlUtilCore.$$$reportNull$$$0(7);
        }
        return DbSqlUtilCore.getAppropriateDataSources(sqlFile, true, true);
    }

    @NotNull
    public static JBIterable<DbDataSource> getAppropriateDataSources(@NotNull PsiFile sqlFile, boolean forResolve, boolean matchingOnly) {
        DatabaseDialect dialect;
        if (sqlFile == null) {
            DbSqlUtilCore.$$$reportNull$$$0(8);
        }
        if (DbSqlUtilCore.isJSLanguage(sqlFile.getLanguage())) {
            dialect = (DatabaseDialect)ObjectUtils.notNull((Object)((DatabaseDialect)DatabaseDialect.EP.forDbms(Dbms.MONGO)), (Object)SqlDialects.getGenericDialect().getDatabaseDialect());
        } else {
            SqlLanguageDialect sqlDialect = (SqlLanguageDialect)ObjectUtils.notNull((Object)DbSqlUtilCore.getSqlDialect((PsiElement)sqlFile), (Object)SqlDialects.getGenericDialect());
            dialect = sqlDialect.getDatabaseDialect();
        }
        return DbSqlUtilCore.getAppropriateDataSources(dialect, PsiUtilCore.getVirtualFile((PsiElement)sqlFile), sqlFile.getProject(), forResolve, matchingOnly);
    }

    @NotNull
    public static JBIterable<DbDataSource> getAppropriateDataSources(@NotNull DatabaseDialect databaseDialect, @Nullable VirtualFile virtualFile, @NotNull Project project, boolean forResolve, boolean matchingOnly) {
        JBIterable sqlDataSources;
        if (databaseDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(9);
        }
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(10);
        }
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        boolean isReadonly = virtualFile instanceof ReadOnlyLightVirtualFile;
        JBIterable resultAll = JBIterable.from((Iterable)facade.getDataSources()).filter(ds -> (!isReadonly || !(ds instanceof SqlDataSource)) && ds.isValid());
        JBIterable resultSelected = resultAll.filter(ds -> DbImplUtilCore.getDatabaseDialect((DbElement)ds).similarTo(databaseDialect));
        if (!isReadonly && forResolve && virtualFile != null && FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)SqlFileType.INSTANCE) && !(sqlDataSources = resultAll.filterMap(o -> o.getDelegate() instanceof SqlDataSource ? o : null).filter(o -> ((SqlDataSource)o.getDelegate()).containsFile(virtualFile)).collect()).isEmpty()) {
            JBIterable jBIterable = sqlDataSources;
            if (jBIterable == null) {
                DbSqlUtilCore.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }
        JBIterable jBIterable = !matchingOnly && resultSelected.isEmpty() ? resultAll : resultSelected;
        if (jBIterable == null) {
            DbSqlUtilCore.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    public static boolean isJSLanguage(@Nullable Language language) {
        if (language == MongoJSLanguage.INSTANCE) {
            return true;
        }
        while (language != null) {
            if (language.getID().equals("JavaScript")) {
                return true;
            }
            language = language.getBaseLanguage();
        }
        return false;
    }

    public static ObjectName getName(@Nullable DasObject object) {
        return object == null ? null : new ObjectName(object.getName(), DbSqlUtilCore.isQuoted(object));
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(13);
        }
        return DbSqlUtilCore.findSqlDialect(dialect.getDbms());
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(14);
        }
        return (SqlLanguageDialect)SqlLanguageDialect.EP.forDbms(dbms);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable LocalDataSourceCore dataSource2) {
        SqlLanguageDialect dialect = DbSqlUtilCore.findSqlDialect(dataSource2);
        SqlLanguageDialect sqlLanguageDialect = dialect == null ? SqlDialects.getGenericDialect() : dialect;
        if (sqlLanguageDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(15);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@Nullable LocalDataSourceCore dataSource2) {
        if (dataSource2 == null) {
            return null;
        }
        String defaultDialect = dataSource2.getDefaultDialect();
        SqlLanguageDialect result = StringUtil.isEmpty((String)defaultDialect) ? null : SqlDialects.findDialectById(defaultDialect);
        return result != null ? result : DbSqlUtilCore.guessSqlDialect(dataSource2);
    }

    @Nullable
    public static SqlLanguageDialect guessSqlDialect(@Nullable RawConnectionConfig connectionInfo) {
        DatabaseDialectEx dbDialect = connectionInfo == null ? null : DbImplUtilCore.guessDatabaseDialect(connectionInfo);
        return dbDialect == null ? null : DbSqlUtilCore.findSqlDialect(dbDialect);
    }

    @NotNull
    public static Dbms getDbms(@Nullable Language language) {
        Dbms dbms = language instanceof SqlLanguageDialect ? ((SqlLanguageDialect)language).getDbms() : (DbSqlUtilCore.isJSLanguage(language) ? Dbms.MONGO : Dbms.UNKNOWN);
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(16);
        }
        return dbms;
    }

    @NotNull
    public static <C extends DasObject> Condition<C> byName(@Nullable DasObject obj, @Nullable String id, @NotNull CasingProvider provider) {
        if (provider == null) {
            DbSqlUtilCore.$$$reportNull$$$0(17);
        }
        return DbSqlUtilCore.byName(obj == null ? null : obj.getName(), DbSqlUtilCore.isQuoted(obj), id, provider);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull Dbms dbms) {
        SqlLanguageDialect res2;
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(18);
        }
        SqlLanguageDialect sqlLanguageDialect = (res2 = DbSqlUtilCore.findSqlDialect(dbms)) == null ? SqlDialects.getGenericDialect() : res2;
        if (sqlLanguageDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(19);
        }
        return sqlLanguageDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbSqlUtilCore";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "named";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseDialect";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbSqlUtilCore";
                break;
            }
            case 2: 
            case 15: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "byName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppropriateDataSources";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stringsAreEscapedWithSlash";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "supportsEscapeStringLiterals";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDasObject";
                break;
            }
            case 4: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "byName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourcesForResolve";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAppropriateDataSources";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSqlDialect";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

