/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.util.Case;
import com.intellij.database.util.ColoredDdlBuilder;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFileAttributes;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbSqlUtil
extends DbSqlUtilCore {
    private DbSqlUtil() {
    }

    @NotNull
    public static Condition<VirtualFile> SQL_FILE_FILTER(@Nullable Project project) {
        if (project == null) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                DbSqlUtil.$$$reportNull$$$0(0);
            }
            return condition;
        }
        Condition condition = file -> {
            ObjectKind kind;
            if (file.isDirectory() || !file.isValid()) {
                return false;
            }
            ObjectKind objectKind = !(file instanceof DatabaseElementVirtualFileImpl) ? null : (kind = ((DatabaseElementVirtualFileImpl)((Object)file)).isBusy() ? ObjectKind.NONE : ((DatabaseElementVirtualFileImpl)((Object)file)).getObjectKind());
            if (kind == ObjectKind.NONE || kind == ObjectKind.DATABASE || kind == ObjectKind.SCHEMA) {
                return false;
            }
            return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SqlFileType.INSTANCE) || LanguageUtil.getLanguageFileType((Language)LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file)) == SqlFileType.INSTANCE;
        };
        if (condition == null) {
            DbSqlUtil.$$$reportNull$$$0(1);
        }
        return condition;
    }

    @Nullable
    public static <T> T getSqlFileAttributeAt(@NotNull PsiFile file, @NotNull Key<T> attr, int offset) {
        SqlFile sqlFile;
        if (file == null) {
            DbSqlUtil.$$$reportNull$$$0(2);
        }
        if (attr == null) {
            DbSqlUtil.$$$reportNull$$$0(3);
        }
        return (T)((sqlFile = (SqlFile)ObjectUtils.tryCast((Object)file, SqlFile.class)) != null ? sqlFile.getAttributeAt(attr, offset) : null);
    }

    @NotNull
    public static String getDelimiterAt(@Nullable PsiFile file, int offset) {
        String delim = file == null ? null : (String)DbSqlUtil.getSqlFileAttributeAt(file, SqlFileAttributes.DELIMITER, offset);
        String string = StringUtil.notNullize((String)delim, (String)";");
        if (string == null) {
            DbSqlUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean delimiterNeedsSpacing(@NotNull String delim) {
        if (delim == null) {
            DbSqlUtil.$$$reportNull$$$0(5);
        }
        return !delim.equals(";");
    }

    @NotNull
    public static String sql2Html(@NotNull Project project, @NotNull Language language, @NotNull CharSequence sequence) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(6);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(7);
        }
        if (sequence == null) {
            DbSqlUtil.$$$reportNull$$$0(8);
        }
        ColoredDdlBuilder colored = new ColoredDdlBuilder();
        DatabaseDialectEx dialect = language instanceof SqlLanguageDialect ? (DatabaseDialectEx)((SqlLanguageDialect)language).getDatabaseDialect() : DatabaseDialects.getGenericDialect();
        colored.withDialect(dialect);
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, null);
        Lexer lexer = highlighter.getHighlightingLexer();
        lexer.start(sequence);
        while (lexer.getTokenType() != null) {
            TextAttributesKey[] keys;
            boolean pushed = false;
            IElementType type = lexer.getTokenType();
            if (type != null && (keys = highlighter.getTokenHighlights(type)).length > 0) {
                pushed = true;
                colored.pushStyle(keys[0]);
            }
            colored.plain(StringUtil.escapeXmlEntities((String)lexer.getTokenText()));
            lexer.advance();
            if (!pushed) continue;
            colored.popStyle();
        }
        String string = colored.getStatement();
        if (string == null) {
            DbSqlUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<String> getQueries(@NotNull String text2, @NotNull Project project, @NotNull Language language) {
        if (text2 == null) {
            DbSqlUtil.$$$reportNull$$$0(10);
        }
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(11);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(12);
        }
        SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)project);
        ScriptModel model = facade.createScriptModel(DbSqlUtil.createTemporaryFile(text2, project, language));
        List list = model.statements().transform(ScriptModelUtilCore.TO_TEXT).toList();
        List list2 = list;
        if (list2 == null) {
            DbSqlUtil.$$$reportNull$$$0(13);
        }
        return list2;
        finally {
            Disposer.dispose((Disposable)model);
        }
    }

    @NotNull
    private static PsiFile createTemporaryFile(@NotNull String text2, @NotNull Project project, @NotNull Language language) {
        if (text2 == null) {
            DbSqlUtil.$$$reportNull$$$0(14);
        }
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(15);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(16);
        }
        ReadOnlyLightVirtualFile file = new ReadOnlyLightVirtualFile("a", language, (CharSequence)text2);
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file);
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(PsiManager.getInstance((Project)project), (VirtualFile)file, false);
        PsiFile psi = viewProvider.getPsi(language);
        if (psi == null) {
            throw new AssertionError((Object)("language: " + language.getID() + "; text length: " + text2.length()));
        }
        PsiFile psiFile = psi;
        if (psiFile == null) {
            DbSqlUtil.$$$reportNull$$$0(17);
        }
        return psiFile;
    }

    @Nullable
    public static DbDataSource getDbDataSource(@NotNull Project project, @NotNull DasDataSource dataSource2) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(18);
        }
        if (dataSource2 == null) {
            DbSqlUtil.$$$reportNull$$$0(19);
        }
        if (dataSource2 instanceof DbDataSource) {
            return (DbDataSource)dataSource2;
        }
        return DbPsiFacade.getInstance((Project)project).findDataSource(dataSource2.getUniqueId());
    }

    @Nullable
    public static DbElement findElement(@NotNull DbDataSource dbDataSource, @NotNull ObjectPath path) {
        if (dbDataSource == null) {
            DbSqlUtil.$$$reportNull$$$0(20);
        }
        if (path == null) {
            DbSqlUtil.$$$reportNull$$$0(21);
        }
        return ((DbDataSourceImpl)dbDataSource).findElement(path);
    }

    @NotNull
    public static JBIterable<DasObject> findObjects(@NotNull DbDataSource dbDataSource, @NotNull ObjectPath path) {
        if (dbDataSource == null) {
            DbSqlUtil.$$$reportNull$$$0(22);
        }
        if (path == null) {
            DbSqlUtil.$$$reportNull$$$0(23);
        }
        JBIterable<DasObject> jBIterable = ((DbDataSourceImpl)dbDataSource).findObjects(path);
        if (jBIterable == null) {
            DbSqlUtil.$$$reportNull$$$0(24);
        }
        return jBIterable;
    }

    @Nullable
    public static DasTable detectTable(@NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource2, @Nullable SearchPath searchPath, @Nullable String queryText2, @Nullable SqlTableType resultType, @NotNull List<? extends DataConsumer.Column> columns) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(25);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(26);
        }
        if (columns == null) {
            DbSqlUtil.$$$reportNull$$$0(27);
        }
        DataConsumer.Column tableColumn = null;
        if (!columns.isEmpty()) {
            for (DataConsumer.Column column2 : columns) {
                if (StringUtil.isNotEmpty((String)column2.table) && (tableColumn == null || Objects.equals(column2.catalog, tableColumn.catalog) && Objects.equals(column2.schema, tableColumn.schema) && Objects.equals(column2.table, tableColumn.table))) {
                    tableColumn = column2;
                    continue;
                }
                tableColumn = null;
                break;
            }
        }
        DasTable table = null;
        if (queryText2 != null) {
            SqlTableType sqlTableType = resultType != null ? resultType : DbSqlUtil.parseQueryTableType(project, language, dataSource2, searchPath, queryText2, null);
            PsiElement element2 = sqlTableType == null ? null : sqlTableType.getTypeElement();
            DasTable dasTable = table = element2 instanceof DasTable ? (DasTable)element2 : null;
            if (table == null && language instanceof SqlLanguageDialect && element2 instanceof SqlReferenceExpression) {
                SqlReferenceExpression ref = (SqlReferenceExpression)element2;
                String name = ref.getReferencePart(ObjectKind.TABLE);
                String refSchema = ref.getReferencePart(ObjectKind.SCHEMA);
                String refCatalog = ref.getReferencePart(ObjectKind.DATABASE);
                String schema = refSchema.isEmpty() && tableColumn != null && tableColumn.schema != null ? tableColumn.schema : refSchema;
                String catalog = refCatalog.isEmpty() && tableColumn != null && tableColumn.catalog != null ? tableColumn.catalog : refCatalog;
                table = DbImplUtil.getModelHelper(Dbms.UNKNOWN).sqlCreateFakeTable(catalog, schema, name);
            }
        }
        if (tableColumn != null && table != null) {
            String catalog;
            Dbms dbms = DbSqlUtil.getDbms(language);
            boolean checkTableName = dbms != Dbms.GREENPLUM || table.getKind() != ObjectKind.VIEW;
            boolean metadataMayReturnDifferentCase = dbms == Dbms.MYSQL;
            boolean dbIsSchema = dbms.isMysql() || dbms == Dbms.CLICKHOUSE;
            String schema = dbIsSchema ? DasUtil.NO_NAME : DasUtil.getSchema((DasObject)table);
            String string = catalog = dbIsSchema ? DasUtil.getSchema((DasObject)table) : DasUtil.getCatalog((DasObject)table);
            if (checkTableName && !DbSqlUtil.matches(tableColumn.table, table.getName(), metadataMayReturnDifferentCase) || !DbSqlUtil.matches(tableColumn.schema, schema, metadataMayReturnDifferentCase) || !catalog.isEmpty() && !DbSqlUtil.matches(tableColumn.catalog, catalog, metadataMayReturnDifferentCase)) {
                table = null;
            }
        }
        return table;
    }

    private static boolean matches(@Nullable String jdbcName, @Nullable String modelName, boolean metadataMayReturnDifferentCase) {
        return StringUtil.isEmpty((String)jdbcName) || StringUtilRt.equal((CharSequence)modelName, (CharSequence)jdbcName, (!metadataMayReturnDifferentCase ? 1 : 0) != 0);
    }

    @NotNull
    public static List<DataConsumer.Column> createColumnsFromType(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @Nullable String catalog, @Nullable String schema, @NotNull String tableName) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(28);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(29);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(30);
        }
        if (tableName == null) {
            DbSqlUtil.$$$reportNull$$$0(31);
        }
        ArrayList<DataConsumer.Column> columns = new ArrayList<DataConsumer.Column>(type.getColumnCount());
        List<String> columnNames = DbSqlUtil.getUnambiguousColumnNames(project, dialect, type, null);
        int count = type.getColumnCount();
        for (int i2 = 0; i2 < count; ++i2) {
            String name = columnNames.get(i2);
            String typeName = type.getColumnType(i2).getDisplayName();
            columns.add(new DataConsumer.Column(i2, name, 1111, typeName, null, 0, 0, catalog, schema, tableName));
        }
        ArrayList<DataConsumer.Column> arrayList = columns;
        if (arrayList == null) {
            DbSqlUtil.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(33);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(34);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(35);
        }
        List<String> columnNames = DbSqlUtil.getColumnNames(type);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(columnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, type, columnNames, duplicates, forceQualify);
        List<String> list = columnNames;
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(36);
        }
        return list;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType partType, @NotNull SqlTableType fullType, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(37);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(38);
        }
        if (partType == null) {
            DbSqlUtil.$$$reportNull$$$0(39);
        }
        if (fullType == null) {
            DbSqlUtil.$$$reportNull$$$0(40);
        }
        List<String> partColumnNames = DbSqlUtil.getColumnNames(partType);
        List<String> fullColumnNames = DbSqlUtil.getColumnNames(fullType);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(fullColumnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, partType, partColumnNames, duplicates, forceQualify);
        List<String> list = partColumnNames;
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(41);
        }
        return list;
    }

    private static void makeUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @NotNull List<String> columnNames, @NotNull Set<String> duplicates, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(42);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(43);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(44);
        }
        if (columnNames == null) {
            DbSqlUtil.$$$reportNull$$$0(45);
        }
        if (duplicates == null) {
            DbSqlUtil.$$$reportNull$$$0(46);
        }
        DdlBuilder builder = new DdlBuilder(new StringBuilder()).configureBuilder(project, DbSqlUtil.getSqlDialect(dialect)).withDialect(dialect);
        for (int i2 = 0; i2 < columnNames.size(); ++i2) {
            String name = columnNames.get(i2);
            String typeAlias = type.getColumnTypeAlias(i2);
            if (typeAlias != null && (duplicates.contains(name) || forceQualify != null && ((Boolean)forceQualify.fun((Object)type, (Object)i2)).booleanValue())) {
                builder.suppressQuoteIdentifiers(!type.isColumnTypeAliasQuoted(i2));
                builder.columnRef(typeAlias).symbol(".");
            }
            builder.suppressQuoteIdentifiers(!type.isColumnQuoted(i2));
            builder.columnRef(name);
            columnNames.set(i2, builder.getStatement());
            builder.clear();
        }
    }

    private static List<String> getColumnNames(SqlTableType type) {
        ArrayList<String> columnNames = new ArrayList<String>(type.getColumnCount());
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            columnNames.add(StringUtil.notNullize((String)type.getColumnName(i2)));
        }
        return columnNames;
    }

    private static Set<String> getDuplicateNames(List<String> names) {
        THashSet duplicates = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        THashSet distinctNames = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (String name : names) {
            if (distinctNames.add(name)) continue;
            duplicates.add(name);
        }
        return duplicates;
    }

    @NotNull
    public static List<PsiElement> resolveToColumnList(@NotNull SqlReferenceExpression ref) {
        String text2;
        if (ref == null) {
            DbSqlUtil.$$$reportNull$$$0(47);
        }
        if (!"*".equals(text2 = StringUtil.notNullize((String)ref.getText())) && !text2.endsWith(".*")) {
            PsiElement resolve = ref.getReference().resolve();
            List<Object> list = resolve == null ? Collections.emptyList() : Collections.singletonList(resolve);
            if (list == null) {
                DbSqlUtil.$$$reportNull$$$0(48);
            }
            return list;
        }
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)ref.getSqlType(), SqlTableType.class);
        if (type == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                DbSqlUtil.$$$reportNull$$$0(49);
            }
            return list;
        }
        ArrayList<PsiElement> res2 = new ArrayList<PsiElement>(type.getColumnCount());
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            res2.add(type.getColumnElement(i2));
        }
        ArrayList<PsiElement> arrayList = res2;
        if (arrayList == null) {
            DbSqlUtil.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    @Nullable
    public static SqlResultSetExpression parseSqlQuery(@NotNull Project project, @NotNull SqlLanguageDialect language, @NotNull String queryText2, @Nullable Language hostLanguage) {
        SqlBinaryExpression varAssigment;
        SqlSelectClause selectClause;
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(51);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(52);
        }
        if (queryText2 == null) {
            DbSqlUtil.$$$reportNull$$$0(53);
        }
        SqlPsiFacade psiFacade = SqlPsiFacade.getInstance((Project)project);
        SqlFile sql = psiFacade.createROFile(language, (CharSequence)queryText2, hostLanguage);
        SyntaxTraverser traverser = (SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)sql);
        SqlResultSetExpression queryExpression = (SqlResultSetExpression)traverser.filter(SqlResultSetExpression.class).first();
        if (queryExpression == null || queryExpression.getTextRange().getStartOffset() != 0) {
            return null;
        }
        SqlSelectIntoClause selectIntoClause = (SqlSelectIntoClause)traverser.filter(SqlSelectIntoClause.class).first();
        if (selectIntoClause != null) {
            return null;
        }
        if (language.getDbms().isTransactSql() && queryExpression instanceof SqlQueryExpression && (selectClause = ((SqlQueryExpression)queryExpression).getSelectClause()) != null && (varAssigment = (SqlBinaryExpression)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)selectClause)).filter(SqlBinaryExpression.class).filter(expr -> {
            SqlExpression lOperand = expr.getLOperand();
            boolean isVarLOperand = lOperand instanceof SqlReferenceExpression && ((SqlReferenceExpression)lOperand).getReferenceElementType().getTargetKind() == ObjectKind.VARIABLE;
            return isVarLOperand && expr.getOpSign() == SqlCommonTokens.SQL_OP_EQ;
        }).first()) != null) {
            return null;
        }
        return queryExpression;
    }

    @Nullable
    public static SqlTableType parseQueryTableType(@NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull String queryText2, @Nullable Language hostLanguage) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(54);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(55);
        }
        if (queryText2 == null) {
            DbSqlUtil.$$$reportNull$$$0(56);
        }
        if (!(language instanceof SqlLanguageDialect)) {
            return null;
        }
        SqlResultSetExpression sql = DbSqlUtil.parseSqlQuery(project, (SqlLanguageDialect)language, queryText2, hostLanguage);
        if (sql == null) {
            return null;
        }
        sql.getContainingFile().putUserData(DatabaseDataKeysCore.DATA_SOURCE_KEY, (Object)dataSource2);
        sql.getContainingFile().putUserData(DatabaseDataKeysCore.SEARCH_PATH_KEY, (Object)searchPath);
        return (SqlTableType)ObjectUtils.tryCast((Object)sql.getSqlType(), SqlTableType.class);
    }

    @Nullable
    public static SqlTableType parseQueryTableType(@NotNull JdbcConsole console, @NotNull Language language, @NotNull String queryText2) {
        if (console == null) {
            DbSqlUtil.$$$reportNull$$$0(57);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(58);
        }
        if (queryText2 == null) {
            DbSqlUtil.$$$reportNull$$$0(59);
        }
        return DbSqlUtil.parseQueryTableType(console.getProject(), language, DbSqlUtil.getDbDataSource(console.getProject(), console.getDataSource()), console.getSearchPath(), queryText2, null);
    }

    public static boolean isResultEditable(@Nullable DataRequest request, SqlTableType tableType, DasTable detectedTable) {
        DasTable table;
        if (!(request instanceof DataRequest.QueryRequest)) {
            return false;
        }
        if (!(request instanceof ConsoleDataRequest)) {
            return true;
        }
        if (tableType == null) {
            return false;
        }
        PsiElement element2 = tableType.getTypeElement();
        Object object = element2 instanceof DasTable ? (DasTable)element2 : (table = element2 instanceof SqlReferenceExpression ? detectedTable : null);
        if (table == null || DasUtil.getColumns((DasObject)table).isEmpty()) {
            return false;
        }
        return DbImplUtilCore.isDataTable(table.getKind());
    }

    @Nullable
    public static IntrospectionScopeUpdater getScopeUpdater(@NotNull SyntaxTraverser<PsiElement> s2, @Nullable ObjectPath ns, @NotNull DasModel model) {
        if (s2 == null) {
            DbSqlUtil.$$$reportNull$$$0(60);
        }
        if (model == null) {
            DbSqlUtil.$$$reportNull$$$0(61);
        }
        IntrospectionScopeUpdater res2 = null;
        ObjectPath db = ns != null ? DbSqlUtil.getCurrentDatabase(ns) : DbSqlUtil.getCurrentDatabase(model);
        for (SqlStatement statement : s2.filter(SqlStatement.class)) {
            SqlDropStatement dropStatement;
            SqlReferenceExpression expression;
            ObjectPath objectName;
            ObjectKind kind;
            if (statement instanceof SqlAlterStatement) {
                for (SqlSynonymDefinition synonymDefinition : SyntaxTraverser.psiApi().children((Object)statement).filter(SqlSynonymDefinition.class)) {
                    kind = synonymDefinition.getKind();
                    if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) continue;
                    SqlNameElement newName = synonymDefinition.getNameElement();
                    SqlReferenceExpression oldName = synonymDefinition.getTargetReference();
                    if (newName == null || oldName == null) continue;
                    if (res2 == null) {
                        res2 = new IntrospectionScopeUpdater();
                    }
                    ObjectPath parent2 = kind == ObjectKind.SCHEMA ? db : null;
                    ObjectPath oldObjectName = ObjectPath.create((String)oldName.getName(), (ObjectKind)kind, (boolean)oldName.isQuotedIdentifier(), null, (ObjectPath)parent2);
                    ObjectPath newObjectName = ObjectPath.create((String)newName.getName(), (ObjectKind)kind, (boolean)newName.isQuotedIdentifier(), null, (ObjectPath)parent2);
                    res2.toRemove(oldObjectName);
                    res2.toAdd(newObjectName);
                }
                continue;
            }
            if (statement instanceof SqlCreateStatement) {
                SqlNameElement element2;
                SqlCreateStatement createStatement = (SqlCreateStatement)statement;
                ObjectKind kind2 = createStatement.getKind();
                if (kind2 != ObjectKind.DATABASE && kind2 != ObjectKind.SCHEMA || (element2 = createStatement.getNameElement()) == null) continue;
                if (res2 == null) {
                    res2 = new IntrospectionScopeUpdater();
                }
                objectName = ObjectPath.create((String)element2.getName(), (ObjectKind)kind2, (boolean)element2.isQuotedIdentifier(), null, (ObjectPath)(kind2 == ObjectKind.SCHEMA ? db : null));
                res2.toAdd(objectName);
                continue;
            }
            if (!(statement instanceof SqlDropStatement) || (expression = (dropStatement = (SqlDropStatement)statement).getTargetExpression()) == null || (kind = expression.getReferenceElementType().getTargetKind()) != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) continue;
            if (res2 == null) {
                res2 = new IntrospectionScopeUpdater();
            }
            objectName = ObjectPath.create((String)expression.getName(), (ObjectKind)kind, (boolean)expression.isQuotedIdentifier(), null, (ObjectPath)(kind == ObjectKind.SCHEMA ? db : null));
            res2.toRemove(objectName);
        }
        return res2;
    }

    @Nullable
    public static ObjectPath getCurrentDatabase(@NotNull DasModel model) {
        DasNamespace cur2;
        if (model == null) {
            DbSqlUtil.$$$reportNull$$$0(62);
        }
        if ((cur2 = model.getCurrentRootNamespace()) == null) {
            Iterator it2 = model.getModelRoots().filter(DasNamespace.class).iterator();
            if (!it2.hasNext()) {
                return null;
            }
            cur2 = (DasNamespace)it2.next();
            if (it2.hasNext()) {
                return null;
            }
        }
        return cur2.getKind() == ObjectKind.DATABASE ? ObjectPaths.of((DasObject)cur2) : null;
    }

    @Nullable
    private static ObjectPath getCurrentDatabase(@NotNull ObjectPath ns) {
        if (ns == null) {
            DbSqlUtil.$$$reportNull$$$0(63);
        }
        return ns.findParent(ObjectKind.DATABASE, false);
    }

    public static boolean isSqlElement(@NotNull DbElement element2) {
        DbDataSource dataSource2;
        if (element2 == null) {
            DbSqlUtil.$$$reportNull$$$0(64);
        }
        return element2 != (dataSource2 = element2.getDataSource()) && dataSource2.getDelegate() instanceof SqlDataSource;
    }

    @Nullable
    public static DasObject getSqlSourceElement(@Nullable DbElement element2) {
        DasObject dasObject;
        DasObject dasObject2 = dasObject = element2 == null ? null : (DasObject)ObjectUtils.tryCast((Object)element2.getDelegate(), DasObject.class);
        if (dasObject == null) {
            return null;
        }
        return DbSqlUtil.getSqlSourceElement(element2.getDataSource(), dasObject);
    }

    @Nullable
    public static DasObject getSqlSourceElement(@Nullable DbDataSource dataSource2, @Nullable DasObject dasObject) {
        if (dataSource2 == null || dasObject == null) {
            return null;
        }
        SqlDataSource source = (SqlDataSource)ObjectUtils.tryCast((Object)dataSource2.getDelegate(), SqlDataSource.class);
        return source == null ? null : source.fromModel(dasObject);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull DatabaseDialect dialect) {
        SqlLanguageDialect res2;
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(65);
        }
        SqlLanguageDialect sqlLanguageDialect = (res2 = DbSqlUtil.findSqlDialect(dialect)) == null ? SqlDialects.getGenericDialect() : res2;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(66);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static Language getLanguage(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtil.$$$reportNull$$$0(67);
        }
        MongoJSLanguage mongoJSLanguage = dbms == Dbms.MONGO ? MongoJSLanguage.INSTANCE : DbSqlUtil.getSqlDialect(dbms);
        if (mongoJSLanguage == null) {
            DbSqlUtil.$$$reportNull$$$0(68);
        }
        return mongoJSLanguage;
    }

    @NotNull
    public static Language getLanguage(@Nullable LocalDataSource dataSource2) {
        Language language = DbSqlUtil.findLanguage(dataSource2);
        Object object = language == null ? SqlDialects.getGenericDialect() : language;
        if (object == null) {
            DbSqlUtil.$$$reportNull$$$0(69);
        }
        return object;
    }

    @NotNull
    public static Language getLanguage(@Nullable DbDataSource dataSource2) {
        Language language = dataSource2 == null ? null : dataSource2.getQueryLanguage();
        Object object = language == null ? SqlDialects.getGenericDialect() : language;
        if (object == null) {
            DbSqlUtil.$$$reportNull$$$0(70);
        }
        return object;
    }

    @Nullable
    public static Language findLanguage(@Nullable LocalDataSource dataSource2) {
        if (dataSource2 != null) {
            String defaultDialect = dataSource2.getDefaultDialect();
            if (MongoJSLanguage.INSTANCE.getID().equals(defaultDialect) || dataSource2.getDbms() == Dbms.MONGO) {
                return MongoJSLanguage.INSTANCE;
            }
        }
        return DbSqlUtil.findSqlDialect(dataSource2);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull Project project, @NotNull DasDataSource databaseSystem) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(71);
        }
        if (databaseSystem == null) {
            DbSqlUtil.$$$reportNull$$$0(72);
        }
        if (databaseSystem instanceof DbDataSource) {
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((DbElement)((DbDataSource)databaseSystem));
            if (sqlLanguageDialect == null) {
                DbSqlUtil.$$$reportNull$$$0(73);
            }
            return sqlLanguageDialect;
        }
        if (databaseSystem instanceof LocalDataSource) {
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((LocalDataSource)databaseSystem);
            if (sqlLanguageDialect == null) {
                DbSqlUtil.$$$reportNull$$$0(74);
            }
            return sqlLanguageDialect;
        }
        DbDataSource dataSource2 = DbPsiFacade.getInstance((Project)project).findDataSource(databaseSystem.getUniqueId());
        SqlLanguageDialect sqlLanguageDialect = dataSource2 == null ? SqlDialects.getGenericDialect() : DbSqlUtil.getSqlDialect((DbElement)dataSource2);
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(75);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DatabaseDriver driver) {
        SqlLanguageDialect dialect = DbSqlUtil.findSqlDialect(driver);
        SqlLanguageDialect sqlLanguageDialect = dialect == null ? SqlDialects.getGenericDialect() : dialect;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(76);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@Nullable DatabaseDriver driver) {
        if (driver == null) {
            return null;
        }
        String dialectId = driver.getSqlDialect();
        SqlLanguageDialect result = StringUtil.isEmpty((String)dialectId) ? null : SqlDialects.findDialectById(dialectId);
        return result != null ? result : DbSqlUtil.getSqlDialect(DbImplUtil.getDbms(driver));
    }

    @Deprecated
    public static boolean areKeywordsLowerCase(@Nullable Project project) {
        SqlCodeStyleSettings codeStyleSettings = SqlCodeStyles.getGeneralSqlSettings((Project)project);
        Case keywordCaseMode = codeStyleSettings.getKeywordCase();
        return keywordCaseMode == Case.LOWER || keywordCaseMode == Case.MIXED;
    }

    public static boolean areKeywordsLowerCase(@Nullable Project project, @NotNull Language dialect) {
        SqlCodeStyleSettings codeStyleSettings;
        Case keywordCaseMode;
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(77);
        }
        return (keywordCaseMode = (codeStyleSettings = SqlCodeStyles.getSqlSettings((Project)project, (Language)dialect)).getKeywordCase()) == Case.LOWER || keywordCaseMode == Case.MIXED;
    }

    public static boolean isSqlFile(@NotNull PsiFile file) {
        if (file == null) {
            DbSqlUtil.$$$reportNull$$$0(78);
        }
        return file instanceof SqlFile || file.getFileType() == SqlFileType.INSTANCE;
    }

    @Nullable
    @Contract(value="!null, _, _, _, _, _ -> !null")
    public static String toStringLiteral(@Nullable String value2, @NotNull Dbms dbms, boolean escapeSqlRegexSymbols, @Nullable String prefix, @Nullable String suffix, @NotNull JdbcHelper helper) {
        SqlRegexDecorator sqlRegexDecorator;
        if (dbms == null) {
            DbSqlUtil.$$$reportNull$$$0(79);
        }
        if (helper == null) {
            DbSqlUtil.$$$reportNull$$$0(80);
        }
        if (value2 == null) {
            return null;
        }
        SqlRegexDecorator sqlRegexDecorator2 = escapeSqlRegexSymbols && helper.supportsEscape() ? SqlRegexDecorator.WITH_ESCAPE_CLAUSE : (sqlRegexDecorator = escapeSqlRegexSymbols ? SqlRegexDecorator.DEFAULT : SqlRegexDecorator.NONE);
        String string = dbms.isMongo() ? (prefix == null && escapeSqlRegexSymbols ? "^" : "") : (prefix = prefix);
        suffix = dbms.isMongo() ? (suffix == null && escapeSqlRegexSymbols ? "$" : "") : suffix;
        return DbSqlUtil.toStringLiteralInner(value2, dbms, sqlRegexDecorator, StringUtil.notNullize((String)prefix), StringUtil.notNullize((String)suffix));
    }

    @NotNull
    private static String toStringLiteralInner(@NotNull String value2, @NotNull Dbms dbms, @NotNull SqlRegexDecorator sqlRegexDecorator, @NotNull String prefix, @NotNull String suffix) {
        char quote;
        if (value2 == null) {
            DbSqlUtil.$$$reportNull$$$0(81);
        }
        if (dbms == null) {
            DbSqlUtil.$$$reportNull$$$0(82);
        }
        if (sqlRegexDecorator == null) {
            DbSqlUtil.$$$reportNull$$$0(83);
        }
        if (prefix == null) {
            DbSqlUtil.$$$reportNull$$$0(84);
        }
        if (suffix == null) {
            DbSqlUtil.$$$reportNull$$$0(85);
        }
        char c2 = quote = dbms.isMongo() ? (char)'\"' : '\'';
        if ((((String)value2).contains("\n") || ((String)value2).contains("\t") || ((String)value2).contains("\r")) && (DbSqlUtil.stringsAreEscapedWithSlash(dbms) || DbSqlUtil.supportsEscapeStringLiterals(dbms))) {
            value2 = StringUtil.escapeBackSlashes((String)value2);
            value2 = sqlRegexDecorator.decorateInner((String)value2, dbms);
            value2 = StringUtil.escapeChar((String)value2, (char)quote);
            value2 = StringUtil.escapeLineBreak((String)value2);
            value2 = StringUtil.replace((String)value2, (String)"\t", (String)"\\t");
            value2 = quote + prefix + (String)value2 + suffix + quote;
            value2 = DbSqlUtil.supportsEscapeStringLiterals(dbms) ? "e" + (String)value2 : value2;
        } else {
            value2 = sqlRegexDecorator.decorateInner((String)value2, dbms);
            String escapeChar = DbSqlUtil.stringsAreEscapedWithSlash(dbms) ? "\\" : "'";
            value2 = StringUtil.replace((String)value2, (String)String.valueOf(quote), (String)(escapeChar + quote));
            value2 = quote + prefix + (String)value2 + suffix + quote;
            value2 = dbms.isMicrosoft() ? "N" + (String)value2 : value2;
        }
        String string = sqlRegexDecorator.decorateOuter((String)value2, dbms);
        if (string == null) {
            DbSqlUtil.$$$reportNull$$$0(86);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 71: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 71: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbSqlUtil";
                break;
            }
            case 2: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delim";
                break;
            }
            case 6: 
            case 11: 
            case 15: 
            case 18: 
            case 25: 
            case 28: 
            case 33: 
            case 37: 
            case 42: 
            case 51: 
            case 54: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 12: 
            case 16: 
            case 26: 
            case 52: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDataSource";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 29: 
            case 34: 
            case 38: 
            case 43: 
            case 65: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 30: 
            case 35: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partType";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullType";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 53: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 67: 
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseSystem";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlRegexDecorator";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "SQL_FILE_FILTER";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 71: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbSqlUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelimiterAt";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sql2Html";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueries";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findObjects";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnsFromType";
                break;
            }
            case 36: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnambiguousColumnNames";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToColumnList";
                break;
            }
            case 66: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringLiteralInner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSqlFileAttributeAt";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "delimiterNeedsSpacing";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sql2Html";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDbDataSource";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findObjects";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "detectTable";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createColumnsFromType";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getUnambiguousColumnNames";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "makeUnambiguousColumnNames";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "resolveToColumnList";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "parseSqlQuery";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "parseQueryTableType";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getScopeUpdater";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentDatabase";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isSqlElement";
                break;
            }
            case 65: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "areKeywordsLowerCase";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isSqlFile";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteral";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteralInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 71: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SqlRegexDecorator {
        NONE(false, false),
        DEFAULT(true, false),
        WITH_ESCAPE_CLAUSE(true, true);

        private final boolean escapeSqlRegex;
        private final boolean appendEscapeClause;

        private SqlRegexDecorator(boolean escapeSqlRegex, boolean appendEscapeClause) {
            this.escapeSqlRegex = escapeSqlRegex;
            this.appendEscapeClause = appendEscapeClause;
        }

        @NotNull
        String decorateInner(@NotNull String value2, @NotNull Dbms dbms) {
            if (value2 == null) {
                SqlRegexDecorator.$$$reportNull$$$0(0);
            }
            if (dbms == null) {
                SqlRegexDecorator.$$$reportNull$$$0(1);
            }
            if (!this.escapeSqlRegex) {
                String string = value2;
                if (string == null) {
                    SqlRegexDecorator.$$$reportNull$$$0(2);
                }
                return string;
            }
            JdbcHelper helper = DbImplUtilCore.getJdbcHelper(dbms);
            if (!DbSqlUtilCore.stringsAreEscapedWithSlash(dbms) && !helper.supportsEscape()) {
                value2 = StringUtil.escapeBackSlashes((String)value2);
            }
            String string = (String)helper.escapeSqlRegex((Object)value2, true);
            if (string == null) {
                SqlRegexDecorator.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        String decorateOuter(@NotNull String value2, @NotNull Dbms dbms) {
            if (value2 == null) {
                SqlRegexDecorator.$$$reportNull$$$0(4);
            }
            if (dbms == null) {
                SqlRegexDecorator.$$$reportNull$$$0(5);
            }
            if (!this.appendEscapeClause) {
                String string = value2;
                if (string == null) {
                    SqlRegexDecorator.$$$reportNull$$$0(6);
                }
                return string;
            }
            JdbcHelper helper = DbImplUtilCore.getJdbcHelper(dbms);
            if (value2.indexOf(helper.getEscapeChar()) == -1) {
                String string = value2;
                if (string == null) {
                    SqlRegexDecorator.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = value2 + this.getTail(dbms);
            if (string == null) {
                SqlRegexDecorator.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        public String getTail(@NotNull Dbms dbms) {
            if (dbms == null) {
                SqlRegexDecorator.$$$reportNull$$$0(9);
            }
            if (!this.appendEscapeClause) {
                return "";
            }
            JdbcHelper helper = DbImplUtilCore.getJdbcHelper(dbms);
            String string = " ESCAPE '" + helper.getEscapeChar() + "'";
            if (string == null) {
                SqlRegexDecorator.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/DbSqlUtil$SqlRegexDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/DbSqlUtil$SqlRegexDecorator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorateInner";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorateOuter";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTail";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "decorateInner";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "decorateOuter";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getTail";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

