/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.LocalDataSourceCore;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageCore;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFacadeCore;
import com.intellij.database.model.ModelHelperCore;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.VirtualFileDataSourceProvider;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbImplUtilCore {
    public static final Map<String, ObjectKind> FILTER_BY_NAME = ContainerUtil.immutableMapBuilder().put((Object)"table", (Object)ObjectKind.TABLE).put((Object)"vtable", (Object)ObjectKind.VIRTUAL_TABLE).put((Object)"ftable", (Object)ObjectKind.FOREIGN_TABLE).put((Object)"view", (Object)ObjectKind.VIEW).put((Object)"mview", (Object)ObjectKind.MAT_VIEW).put((Object)"routine", (Object)ObjectKind.ROUTINE).put((Object)"aggregate", (Object)ObjectKind.AGGREGATE).put((Object)"package", (Object)ObjectKind.PACKAGE).put((Object)"sequence", (Object)ObjectKind.SEQUENCE).put((Object)"synonym", (Object)ObjectKind.SYNONYM).put((Object)"operator", (Object)ObjectKind.OPERATOR).put((Object)"collation", (Object)ObjectKind.COLLATION).put((Object)"role", (Object)ObjectKind.ROLE).put((Object)"user", (Object)ObjectKind.USER).put((Object)"fdw", (Object)ObjectKind.FOREIGN_DATA_WRAPPER).put((Object)"event", (Object)ObjectKind.SCHEDULED_EVENT).build();
    protected static final VfsDependentEnum<String> myDialectAndDataSourcesEnumerator = new VfsDependentEnum("sql_dialects_and_data_sources", (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, 1);
    private static final DbmsExtension<JdbcHelper> JDBC_HELPER_EP = new DbmsExtension("com.intellij.database.jdbcHelper");

    protected DbImplUtilCore() {
    }

    public static boolean isTypeKind(@Nullable ObjectKind kind) {
        return kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.COLLECTION_TYPE || kind == ObjectKind.ALIAS_TYPE || kind == ObjectKind.TABLE_TYPE;
    }

    public static boolean isDataTable(@Nullable DasTable info) {
        if (info == null) {
            return false;
        }
        return DbImplUtilCore.isDataTable(info.getKind());
    }

    public static boolean isDataTable(@Nullable ObjectKind kind) {
        return ArrayUtil.contains((Object)kind, (Object[])new ObjectKind[]{ObjectKind.TABLE, ObjectKind.FOREIGN_TABLE, ObjectKind.VIRTUAL_TABLE, ObjectKind.VIEW, ObjectKind.MAT_VIEW});
    }

    @NotNull
    public static BasicMetaModel<?> getMetaModel(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(0);
        }
        BasicMetaModel<?> basicMetaModel = ModelFacadeCore.forDbms(dbms).getMetaModel();
        if (basicMetaModel == null) {
            DbImplUtilCore.$$$reportNull$$$0(1);
        }
        return basicMetaModel;
    }

    @Nullable
    public static DasNamespace getSearchPathObject(@NotNull DatabaseDialectEx dialect, @Nullable DasObject dasObject) {
        if (dialect == null) {
            DbImplUtilCore.$$$reportNull$$$0(2);
        }
        if (dialect.getDbms().isSqlite()) {
            return (DasNamespace)ObjectUtils.tryCast((Object)DasUtil.getSchemaObject((DasObject)dasObject), DasNamespace.class);
        }
        ObjectKind kind = dialect.getSearchPathObjectKind();
        List path = kind == null ? null : (List)DbImplUtilCore.getMetaModel(dialect.getDbms()).getPathsToRoot(kind).first();
        List pathsToRoot = path == null ? Collections.singletonList(kind) : path;
        return kind == null ? null : (DasNamespace)DasUtil.dasParents((DasObject)dasObject).filter(DasNamespace.class).find(o -> pathsToRoot.contains(o.getKind()));
    }

    @Nullable
    public static DbDataSource getDbDataSource(@NotNull Project project, @NotNull DasDataSource database) {
        if (project == null) {
            DbImplUtilCore.$$$reportNull$$$0(3);
        }
        if (database == null) {
            DbImplUtilCore.$$$reportNull$$$0(4);
        }
        return database instanceof DbDataSource ? (DbDataSource)database : DbPsiFacade.getInstance((Project)project).findDataSource(database.getUniqueId());
    }

    public static CascadeRule asCascadeRule(DasForeignKey.RuleAction ac) {
        if (ac == DasForeignKey.RuleAction.CASCADE) {
            return CascadeRule.cascade;
        }
        if (ac == DasForeignKey.RuleAction.NO_ACTION) {
            return CascadeRule.no_action;
        }
        if (ac == DasForeignKey.RuleAction.RESTRICT) {
            return CascadeRule.restrict;
        }
        if (ac == DasForeignKey.RuleAction.SET_DEFAULT) {
            return CascadeRule.set_default;
        }
        if (ac == DasForeignKey.RuleAction.SET_NULL) {
            return CascadeRule.set_null;
        }
        return CascadeRule.no_action;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull DbElement element2) {
        if (element2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(5);
        }
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)element2.getDataSource().getDatabaseDialect();
        if (databaseDialectEx == null) {
            DbImplUtilCore.$$$reportNull$$$0(6);
        }
        return databaseDialectEx;
    }

    @NotNull
    public static Dbms getDbms(@Nullable DasObject obj) {
        if (obj instanceof PsiElement) {
            return DbImplUtilCore.getDbms((PsiElement)obj);
        }
        if (obj instanceof BasicElement) {
            Dbms dbms = ((BasicElement)obj).getMetaObject().getModel().dbms;
            if (dbms == null) {
                DbImplUtilCore.$$$reportNull$$$0(7);
            }
            return dbms;
        }
        Dbms dbms = Dbms.UNKNOWN;
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(8);
        }
        return dbms;
    }

    @NotNull
    public static Dbms getDbms(@Nullable PsiElement e) {
        if (e instanceof DbElement) {
            return DbImplUtilCore.getDbms((DbElement)e);
        }
        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect(e);
        Dbms dbms = dialect == null ? Dbms.UNKNOWN : dialect.getDbms();
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(9);
        }
        return dbms;
    }

    @NotNull
    public static Dbms getDbms(@Nullable DbElement element2) {
        Dbms dbms = element2 == null ? Dbms.UNKNOWN : element2.getDataSource().getDbms();
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(10);
        }
        return dbms;
    }

    public static Condition<DasObject> buildFilter(DasDataSource ds) {
        LocalDataSourceCore source = DbImplUtilCore.getMaybeLocalDataSource(ds);
        if (source != null) {
            try {
                Condition<DasObject> c2 = DbImplUtilCore.buildObjectFilter(source);
                if (c2 == Conditions.alwaysTrue()) {
                    return null;
                }
                return o -> o instanceof DasNamespace || c2.value(o);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public static Condition<DasObject> buildObjectFilter(@Nullable DasDataSource database) throws PatternSyntaxException {
        DasDataSource delegate = database instanceof DbElement ? ((DbElement)database).getDelegate() : database;
        String filterText = delegate instanceof LocalDataSourceCore ? ((LocalDataSourceCore)delegate).getObjectPattern() : null;
        return DbImplUtilCore.buildObjectFilter(filterText);
    }

    @NotNull
    public static Condition<DasObject> buildObjectFilter(@Nullable String filterText) throws PatternSyntaxException {
        if (StringUtil.isEmptyOrSpaces((String)filterText)) {
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                DbImplUtilCore.$$$reportNull$$$0(11);
            }
            return condition;
        }
        HashMap<ObjectKind, Couple> builders = new HashMap<ObjectKind, Couple>();
        for (Object s2 : StringUtil.split((String)filterText, (String)"||")) {
            StringBuilder target;
            ObjectKind kind;
            String string = ((String)s2).trim();
            if (string.length() == 0) continue;
            int idx = string.indexOf(58);
            boolean exclude = string.charAt(idx + 1) == '-';
            String patternText = string.substring(idx + (exclude ? 2 : 1));
            if (idx < 0 || idx == string.length() - 1) {
                kind = ObjectKind.NONE;
            } else {
                String k = string.substring(0, idx);
                kind = (ObjectKind)ContainerUtil.getOrElse(FILTER_BY_NAME, (Object)k, (Object)ObjectKind.NONE);
                if (kind == ObjectKind.NONE) {
                    exclude = false;
                    patternText = string;
                }
            }
            Couple item = (Couple)builders.get(kind);
            if (item == null) {
                item = Couple.of((Object)new StringBuilder(), (Object)new StringBuilder());
                builders.put(kind, item);
            }
            StringBuilder stringBuilder = target = exclude ? (StringBuilder)item.second : (StringBuilder)item.first;
            if (target.length() != 0) {
                target.append("|");
            }
            target.append(patternText);
        }
        HashMap<ObjectKind, Condition> map2 = new HashMap<ObjectKind, Condition>();
        for (Map.Entry entry : builders.entrySet()) {
            Couple v = (Couple)entry.getValue();
            map2.put((ObjectKind)entry.getKey(), Conditions.and((Condition)((Condition)ObjectUtils.notNull(DbImplUtilCore.makeCondition((CharSequence)v.first), (Object)Conditions.alwaysTrue())), (Condition)Conditions.not((Condition)((Condition)ObjectUtils.notNull(DbImplUtilCore.makeCondition((CharSequence)v.second), (Object)Conditions.alwaysFalse())))));
        }
        Map.Entry item = (Map.Entry)ContainerUtil.getFirstItem(map2.entrySet());
        if (map2.size() == 1 && item != null && item.getKey() == ObjectKind.NONE) {
            Condition condition = Conditions.compose((Function)DasUtil.TO_NAME, (Condition)((Condition)item.getValue()));
            if (condition == null) {
                DbImplUtilCore.$$$reportNull$$$0(12);
            }
            return condition;
        }
        Condition condition = object -> {
            Condition c2 = object == null ? null : (Condition)map2.get(object.getKind());
            return c2 == null || c2.value((Object)object.getName());
        };
        if (condition == null) {
            DbImplUtilCore.$$$reportNull$$$0(13);
        }
        return condition;
    }

    @Nullable
    public static Condition<String> makeCondition(CharSequence regex) {
        if (StringUtil.isEmpty((CharSequence)regex)) {
            return null;
        }
        Pattern p2 = Pattern.compile(regex.toString(), 2);
        return s2 -> s2 == null || p2.matcher((CharSequence)s2).matches();
    }

    public static boolean isExpandable(@NotNull DasObject obj, @Nullable TreePattern scope) {
        DasObject unw;
        if (obj == null) {
            DbImplUtilCore.$$$reportNull$$$0(14);
        }
        return (unw = (DasObject)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(obj), DasObject.class)) == null || unw instanceof BasicNamespace && ((BasicNamespace)unw).isSubstituted() || DataSourceSchemaMapping.isIntrospected(scope, unw);
    }

    @Contract(value="null -> null")
    public static Object unwrap(@Nullable DasObject object) {
        Object tmp2 = object;
        while (tmp2 != null) {
            if (!(tmp2 instanceof DbElement)) {
                return tmp2;
            }
            tmp2 = ((DbElement)tmp2).getDelegate();
        }
        return object;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@Nullable Dbms dbms) {
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.chooseNotNull((Object)DbImplUtilCore.guessDatabaseDialect(dbms), (Object)DatabaseDialects.getGenericDialect());
        if (databaseDialectEx == null) {
            DbImplUtilCore.$$$reportNull$$$0(15);
        }
        return databaseDialectEx;
    }

    @Nullable
    public static DatabaseDialectEx guessDatabaseDialect(@Nullable RawConnectionConfig connectionInfo) {
        Dbms dbms = DbImplUtilCore.guessDbms(connectionInfo);
        return DbImplUtilCore.guessDatabaseDialect(dbms);
    }

    @NotNull
    public static CasingProvider getCasingProvider(@Nullable DasObject obj) {
        if (obj instanceof DbElement) {
            return DbImplUtilCore.getCasingProvider(DbImplUtilCore.getMaybeBasicElement(obj));
        }
        if (obj instanceof PsiElement) {
            CasingProvider casingProvider = (CasingProvider)ObjectUtils.notNull((Object)((CasingProvider)DbSqlUtilCore.getSqlDialect((PsiElement)obj)), (Object)DasUtil.NO_CASING_PROVIDER);
            if (casingProvider == null) {
                DbImplUtilCore.$$$reportNull$$$0(16);
            }
            return casingProvider;
        }
        if (obj instanceof BasicElement) {
            CasingProvider casingProvider = (CasingProvider)ObjectUtils.notNull((Object)BasicMixinElement.getCasingProvider((BasicElement)obj), (Object)DasUtil.NO_CASING_PROVIDER);
            if (casingProvider == null) {
                DbImplUtilCore.$$$reportNull$$$0(17);
            }
            return casingProvider;
        }
        CasingProvider casingProvider = DasUtil.NO_CASING_PROVIDER;
        if (casingProvider == null) {
            DbImplUtilCore.$$$reportNull$$$0(18);
        }
        return casingProvider;
    }

    @Nullable
    protected static DatabaseDialectEx guessDatabaseDialect(@Nullable Dbms dbms) {
        return dbms == Dbms.UNKNOWN || dbms == null ? null : DatabaseDialects.findByDbms(dbms);
    }

    @Nullable
    public static DbDataSource getForcedDataSource(@Nullable PsiFile psiFile) {
        DbDataSource res2;
        if (psiFile == null) {
            return null;
        }
        Project project = psiFile.getProject();
        VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = PsiUtilCore.getVirtualFile((PsiElement)InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)psiFile));
        }
        if ((res2 = DbImplUtilCore.getForcedDataSource(project, virtualFile)) != null) {
            return res2;
        }
        res2 = (DbDataSource)DatabaseDataKeysCore.DATA_SOURCE_KEY.get((UserDataHolder)psiFile);
        if (res2 == null && ApplicationManager.getApplication().isUnitTestMode()) {
            return (DbDataSource)DatabaseDataKeysCore.DATA_SOURCE_KEY.get((UserDataHolder)virtualFile);
        }
        return res2 != null && res2.isValid() ? res2 : null;
    }

    @Nullable
    public static DbDataSource getForcedDataSource(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            DbImplUtilCore.$$$reportNull$$$0(19);
        }
        if (virtualFile == null) {
            return null;
        }
        DbDataSource element2 = VirtualFileDataSourceProvider.findDataSource(project, virtualFile);
        return element2 != null && element2.isValid() ? element2 : null;
    }

    public static void performSrcOperation(@Nullable Project project, @Nullable DasModel model, @NotNull ModalityState modality, boolean asyncRefresh, @NotNull Runnable runnable) {
        BasicModModel basicModel;
        DbSrcModelStorageCore storage;
        if (modality == null) {
            DbImplUtilCore.$$$reportNull$$$0(20);
        }
        if (runnable == null) {
            DbImplUtilCore.$$$reportNull$$$0(21);
        }
        DbSrcModelStorageCore dbSrcModelStorageCore = storage = (basicModel = (BasicModModel)ObjectUtils.tryCast((Object)model, BasicModModel.class)) == null ? null : (DbSrcModelStorageCore)ObjectUtils.tryCast((Object)basicModel.getTextStorage(), DbSrcModelStorageCore.class);
        if (storage == null) {
            runnable.run();
        } else {
            try (GuardedRef<?> ignored = storage.startWriteSession(project, basicModel, modality, asyncRefresh);){
                runnable.run();
            }
        }
    }

    @Nullable
    public static String getCustomTypeShortDescription(@Nullable Object delegate) {
        JBIterable names;
        if (delegate instanceof DasTypedObject) {
            DataType type = ((DasTypedObject)delegate).getDataType();
            if (type != DataType.UNKNOWN) {
                return DbPresentationCore.arrow() + " " + type.toString();
            }
        } else if (delegate instanceof DasTable && !(names = DasUtil.getColumns((DasObject)((DasTable)delegate)).transform(DasUtil.TO_NAME)).isEmpty()) {
            return "(" + StringUtil.join((Iterable)names, (String)", ") + ")";
        }
        return null;
    }

    public static int enumerateDialectName(@Nullable String value2) throws IOException {
        return myDialectAndDataSourcesEnumerator.getId((Object)StringUtil.notNullize((String)value2));
    }

    public static String getDialectName(int id) throws IOException {
        return (String)myDialectAndDataSourcesEnumerator.getById(id);
    }

    @NotNull
    public static Dbms guessDbms(@Nullable RawConnectionConfig connectionInfo) {
        Dbms dbms = connectionInfo instanceof DasDataSource ? ((DasDataSource)connectionInfo).getDbms() : Dbms.forConnection((RawConnectionConfig)connectionInfo);
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(22);
        }
        return dbms;
    }

    public static boolean isRoutine(@NotNull ObjectKind kind) {
        if (kind == null) {
            DbImplUtilCore.$$$reportNull$$$0(23);
        }
        return kind == ObjectKind.ROUTINE || kind == ObjectKind.AGGREGATE;
    }

    @Nullable
    public static LocalDataSourceCore getMaybeLocalDataSource(@Nullable DasDataSource info) {
        DasDataSource dataSource2 = DbImplUtilCore.unwrapDS(info);
        return dataSource2 instanceof LocalDataSourceCore ? (LocalDataSourceCore)dataSource2 : null;
    }

    @Nullable
    public static DasDataSource unwrapDS(@Nullable DasDataSource database) {
        DasDataSource o;
        Object object = o = database instanceof DbDataSource ? ((DbDataSource)database).getDelegate() : database;
        if (o == null || o instanceof LocalDataSourceCore || o instanceof SqlDataSource) {
            return o;
        }
        throw new AssertionError(database);
    }

    @Nullable
    public static TreePattern getIntrospectionScope(@Nullable DasDataSource info) {
        LocalDataSourceCore ds = DbImplUtilCore.getMaybeLocalDataSource(info);
        return ds == null ? null : ds.getIntrospectionScope();
    }

    @Nullable
    public static BasicElement getMaybeBasicElement(@Nullable DasObject o) {
        Object delegate = DbImplUtilCore.unwrap(o);
        if (delegate instanceof DasDataSource) {
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)((DasDataSource)delegate).getModel(), BasicModel.class);
            return model == null ? null : model.getRoot();
        }
        return delegate instanceof BasicElement ? (BasicElement)delegate : null;
    }

    @NotNull
    public static JdbcHelper getJdbcHelper(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(24);
        }
        JdbcHelper jdbcHelper = (JdbcHelper)JDBC_HELPER_EP.forDbms(dbms);
        if (jdbcHelper == null) {
            DbImplUtilCore.$$$reportNull$$$0(25);
        }
        return jdbcHelper;
    }

    @NotNull
    public static ModelHelperCore getModelHelper(@NotNull BasicElement element2) {
        if (element2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(26);
        }
        return DbImplUtilCore.getModelHelper(DbImplUtilCore.getDbms(element2));
    }

    @NotNull
    public static ModelHelperCore getModelHelper(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(27);
        }
        ModelHelperCore modelHelperCore = ModelFacadeCore.forDbms(dbms).getModelHelper();
        if (modelHelperCore == null) {
            DbImplUtilCore.$$$reportNull$$$0(28);
        }
        return modelHelperCore;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbImplUtilCore";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 5: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbImplUtilCore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 6: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildObjectFilter";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "guessDbms";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdbcHelper";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetaModel";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathObject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDbDataSource";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isExpandable";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getForcedDataSource";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "performSrcOperation";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isRoutine";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getJdbcHelper";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getModelHelper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConcatenationProps {
        public String rowSep;
        public String colSep;
        public boolean lTrim;
        public boolean rTrim;
        public static final ConcatenationProps LINES = new ConcatenationProps("\n", " ", false, false);
        public static final ConcatenationProps TIGHT = new ConcatenationProps("", "", false, false);
        public static final ConcatenationProps NO_CONCAT = LINES;

        public ConcatenationProps(String rowSep, String colSep, boolean lTrim, boolean rTrim) {
            this.rowSep = rowSep;
            this.colSep = colSep;
            this.lTrim = lTrim;
            this.rTrim = rTrim;
        }

        public String toString() {
            return "ConcatenationProps{rowSep='" + this.rowSep + "', colSep='" + this.colSep + "', lTrim=" + this.lTrim + ", rTrim=" + this.rTrim + "}";
        }
    }
}

