/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ColumnRefKt;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.PredicateSpecKt;
import com.intellij.database.data.types.PredicateValuesKt;
import com.intellij.database.data.types.PredicatesHelperKt;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceCore;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialectHelper;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.JdbcInjection;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemoteClob;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteResultSetMetaData;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridDocumentationProvider;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.script.generator.dml.ValuesWhereClauseTask;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.Case;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.JdbcInjectable;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BooleanFunction;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import kotlin.Triple;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public final class DbImplUtil
extends DbImplUtilCore {
    private static final Logger LOG = Logger.getInstance(DbImplUtil.class);
    private static final String READ_ONLY_WARNING = "Read-only mode is not supported. Dbms: %s";
    public static final Condition<DbElement> CAN_CONNECT_TO = DbImplUtil::canConnectTo;
    private static final Set<Dbms> SUPPORTS_OFFSET_DBS = ContainerUtil.set((Object[])new Dbms[]{Dbms.CLICKHOUSE, Dbms.MONGO, Dbms.HIVE, Dbms.MYSQL, Dbms.MYSQL_AURORA, Dbms.MARIA, Dbms.COCKROACH, Dbms.POSTGRES, Dbms.GREENPLUM, Dbms.REDSHIFT, Dbms.VERTICA, Dbms.SQLITE, Dbms.BIGQUERY, Dbms.COUCHBASE_QUERY});
    private static final char ESCAPE_CHAR = '#';
    public static final ThrowableConvertor<RemoteResultSet, List<String>, Exception> RS_AS_STRING_LIST = rs -> {
        ArrayList<String> res2 = new ArrayList<String>();
        while (rs.next()) {
            res2.add(rs.getString(1));
        }
        return res2;
    };

    private DbImplUtil() {
    }

    public static boolean valuesEqual(Object v1, Object v2) {
        ThreeState result;
        if (v1 == ReservedCellValue.NULL) {
            v1 = null;
        }
        if (v2 == ReservedCellValue.NULL) {
            v2 = null;
        }
        if ((result = DbImplUtil.simpleEquals(v1, v2)) == ThreeState.UNSURE) {
            result = DbImplUtil.numberEquals(v1, v2);
        }
        if (result == ThreeState.UNSURE) {
            result = DbImplUtil.arrayEquals(v1, v2);
        }
        if (result == ThreeState.UNSURE) {
            result = DbImplUtil.clobEquals(v1, v2);
        }
        if (result == ThreeState.UNSURE) {
            result = ThreeState.NO;
        }
        return result.toBoolean();
    }

    @Nullable
    public static Charset guessCharsetFromContent(byte @NotNull [] content) {
        if (content == null) {
            DbImplUtil.$$$reportNull$$$0(0);
        }
        if (content.length == 0) {
            return StandardCharsets.UTF_8;
        }
        CharsetToolkit toolkit = new CharsetToolkit(content, Charset.defaultCharset(), false);
        Charset fromBOM = toolkit.guessFromBOM();
        if (fromBOM != null) {
            return fromBOM;
        }
        CharsetToolkit.GuessedEncoding guessedEncoding = toolkit.guessFromContent(content.length);
        switch (guessedEncoding) {
            case SEVEN_BIT: 
            case VALID_UTF8: {
                return StandardCharsets.UTF_8;
            }
        }
        return null;
    }

    @Nullable
    public static String validateDetectedString(@Nullable String string) {
        if (string == null) {
            return null;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t') continue;
            return null;
        }
        return string;
    }

    public static int valueHashCode(Object v) {
        if (v == ReservedCellValue.NULL) {
            v = null;
        }
        if (v instanceof Number) {
            Number n = (Number)v;
            return Long.valueOf(n.longValue()).hashCode() * 31 + Double.valueOf(n.doubleValue()).hashCode();
        }
        if (v instanceof byte[]) {
            return Arrays.hashCode((byte[])v);
        }
        if (v instanceof char[]) {
            return Arrays.hashCode((char[])v);
        }
        if (v instanceof LobInfo.ClobInfo) {
            return Comparing.hashcode((Object)((LobInfo.ClobInfo)v).data);
        }
        return Comparing.hashcode((Object)v);
    }

    private static ThreeState simpleEquals(Object v1, Object v2) {
        return Comparing.equal((Object)v1, (Object)v2) ? ThreeState.YES : ThreeState.UNSURE;
    }

    private static ThreeState numberEquals(Object v1, Object v2) {
        Number n1 = (Number)ObjectUtils.tryCast((Object)v1, Number.class);
        Number n2 = (Number)ObjectUtils.tryCast((Object)v2, Number.class);
        if (n1 != null && n2 != null) {
            long l1 = n1.longValue();
            long l2 = n2.longValue();
            double d1 = n1.doubleValue();
            double d2 = n2.doubleValue();
            return ThreeState.fromBoolean((l1 == l2 && (d1 == d2 || Double.isNaN(d1) && Double.isNaN(d2)) ? 1 : 0) != 0);
        }
        return ThreeState.UNSURE;
    }

    private static ThreeState arrayEquals(Object v1, Object v2) {
        if (v1 != null && v2 != null && v1.getClass() == v2.getClass() && v1.getClass().isArray()) {
            if (v1 instanceof byte[]) {
                return ThreeState.fromBoolean((boolean)Arrays.equals((byte[])v1, (byte[])v2));
            }
            if (v1 instanceof char[]) {
                return ThreeState.fromBoolean((boolean)Arrays.equals((char[])v1, (char[])v2));
            }
        }
        return ThreeState.UNSURE;
    }

    private static ThreeState clobEquals(Object v1, Object v2) {
        LobInfo.ClobInfo info1 = (LobInfo.ClobInfo)ObjectUtils.tryCast((Object)v1, LobInfo.ClobInfo.class);
        LobInfo.ClobInfo info2 = (LobInfo.ClobInfo)ObjectUtils.tryCast((Object)v2, LobInfo.ClobInfo.class);
        if (info1 != null && info2 != null) {
            return ThreeState.fromBoolean((!info2.isTruncated() && DbImplUtil.clobStringEquals(info1, info2.data) ? 1 : 0) != 0);
        }
        if (info1 != null && v2 instanceof String) {
            return ThreeState.fromBoolean((boolean)DbImplUtil.clobStringEquals(info1, (String)v2));
        }
        if (info2 != null && v1 instanceof String) {
            return ThreeState.fromBoolean((boolean)DbImplUtil.clobStringEquals(info2, (String)v1));
        }
        return ThreeState.UNSURE;
    }

    private static boolean clobStringEquals(@NotNull LobInfo.ClobInfo lob, @Nullable String s2) {
        if (lob == null) {
            DbImplUtil.$$$reportNull$$$0(1);
        }
        return !lob.isTruncated() && Objects.equals(lob.data, s2);
    }

    @Nullable
    public static DbElement findElement(@Nullable DbDataSource dataSource2, @Nullable DasObject object) {
        if (dataSource2 == null || object == null) {
            return null;
        }
        return ((DbDataSourceImpl)dataSource2).findElement(object);
    }

    public static DdlBuilder createBuilderForExec(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(2);
        }
        return new DdlBuilder().withDialect(dialect).qualifyReferences(true).quoteIdentifiers(true);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(3);
        }
        return DbImplUtil.createBuilderForUIExec(dbms, null);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(4);
        }
        return DbImplUtil.createBuilderForUIExec(dialect, null);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull Dbms dbms, @Nullable DasObject object) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(5);
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(dbms);
        return DbImplUtil.createBuilderForUIExec(dialect, object);
    }

    public static boolean omitSchemaQualifier() {
        return Registry.is((String)"database.query.generation.omit.schema.qualifier", (boolean)false);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull DatabaseDialectEx dialect, @Nullable DasObject object) {
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(6);
        }
        DdlBuilder builder = DbImplUtil.createBuilderForExec(dialect).qualifyReferences(!DbImplUtil.omitSchemaQualifier()).quoteIdentifiers(false);
        DbElement element2 = DbImplUtil.getDbElement(object);
        return element2 != null ? builder.withCasingFor(element2) : builder;
    }

    @Nullable
    private static DbElement getDbElement(@Nullable DasObject object) {
        return (DbElement)DasUtil.getParentOfClass((DasObject)object, DbDataSource.class, (boolean)false);
    }

    @NotNull
    public static String findFreeAlias(@NotNull Project project, @NotNull Dbms dbms, @NotNull String query, @NotNull String alias) {
        SqlResultSetExpression expression;
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(7);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(8);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(9);
        }
        if (alias == null) {
            DbImplUtil.$$$reportNull$$$0(10);
        }
        if ((expression = DbSqlUtil.parseSqlQuery(project, DbSqlUtilCore.getSqlDialect(dbms), query, null)) == null) {
            String string = alias;
            if (string == null) {
                DbImplUtil.$$$reportNull$$$0(11);
            }
            return string;
        }
        Set names = SyntaxTraverser.psiTraverser((PsiElement)expression).filter(SqlIdentifier.class).transform(SqlNameElement::getName).toSet();
        Object result = alias;
        int index2 = 1;
        while (names.contains(result)) {
            result = alias + index2++;
        }
        String string = result;
        if (string == null) {
            DbImplUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static void resultSetToString(String title, RemoteResultSet resultSet, int size, Dbms dbms, DataExtractor.Text extractor, CharOut out) throws Exception {
        DataConsumer.Column[] columns = JdbcEngine.getColumnDescriptors(resultSet, dbms);
        int maxLobLength = DatabaseSettings.getSettings().getBytesLimitPerValue();
        RemoteResultSet.DataRetrievingOptions options = new RemoteResultSet.DataRetrievingOptions(size, maxLobLength, false);
        List data = resultSet.getObjects(options);
        ArrayList<DataConsumer.Row> rows = new ArrayList<DataConsumer.Row>(data.size());
        if (data.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < data.size(); ++i2) {
            rows.add(DataConsumer.Row.create(i2 + 1, (Object[])data.get(i2)));
        }
        out.append(String.format(title, data.size()));
        ExtractorsUtil.extract(out, dbms, Arrays.asList(columns), extractor, rows, new int[0]);
    }

    public static boolean isConnected(@NotNull DbElement element2) {
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(13);
        }
        Object delegate = element2.getDelegate();
        Project project = element2.getProject();
        return delegate instanceof LocalDataSource && DbImplUtil.isConnected(project, (LocalDataSource)delegate);
    }

    @Nullable
    public static Domain getDomain(@Nullable DasTypedObject column2) {
        if (column2 == null) {
            return null;
        }
        DomainRegistry registry = BaseDomainRegistry.get(DbImplUtilCore.getDbms((DasObject)column2), null);
        return registry == null ? null : registry.getDomain(new TypeNameColumnDescriptor(column2.getDataType().typeName));
    }

    public static boolean isConnected(@NotNull Project project, @NotNull LocalDataSource delegate) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(14);
        }
        if (delegate == null) {
            DbImplUtil.$$$reportNull$$$0(15);
        }
        return !JdbcDriverManager.getDriverManager(project).getActiveConfigurations(delegate).isEmpty();
    }

    public static int getActiveConnectionCount(@NotNull LocalDataSource delegate) {
        if (delegate == null) {
            DbImplUtil.$$$reportNull$$$0(16);
        }
        int result = 0;
        for (DatabaseConnection connection2 : DatabaseConnectionManager.getInstance().getActiveConnections()) {
            if (delegate != connection2.getConnectionPoint().getDataSource()) continue;
            ++result;
        }
        return result;
    }

    public static boolean canConnectTo(@Nullable DbElement element2) {
        DatabaseSystem ds = element2 == null ? null : element2.getDataSource().getDelegate();
        return ds instanceof LocalDataSource && DbImplUtil.canConnectTo((LocalDataSource)ds);
    }

    public static boolean isInLocalDataSource(@Nullable DbElement element2) {
        DatabaseSystem ds = element2 == null ? null : element2.getDataSource().getDelegate();
        return ds instanceof LocalDataSource;
    }

    public static boolean hasDriverFiles(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DbImplUtil.$$$reportNull$$$0(17);
        }
        return !dataSource2.getClasspathElements().isEmpty();
    }

    public static boolean canConnectTo(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DbImplUtil.$$$reportNull$$$0(18);
        }
        if (StringUtil.isEmptyOrSpaces((String)dataSource2.getUrl())) {
            return false;
        }
        if (!DbImplUtil.hasDriverFiles(dataSource2)) {
            return false;
        }
        String driverClass = dataSource2.getDriverClass();
        return !StringUtil.isEmptyOrSpaces((String)driverClass);
    }

    public static boolean canConnectToAndModify(@Nullable DbElement element2) {
        return element2 != null && element2.isWritable() && DbImplUtil.canConnectTo(element2) && !DataImporter.isBusy(element2);
    }

    public static boolean canModify(@Nullable DbElement element2) {
        return element2 != null && element2.isWritable() && !DataImporter.isBusy(element2);
    }

    @Nullable
    public static GuardedRef<DatabaseConnection> getDatabaseConnection(@NotNull DbElement element2, @NotNull DatabaseDepartment department) throws Exception {
        DatabaseSystem ds;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(19);
        }
        if (department == null) {
            DbImplUtil.$$$reportNull$$$0(20);
        }
        if (!((ds = element2.getDataSource().getDelegate()) instanceof LocalDataSource)) {
            return null;
        }
        SearchPath path = SearchPath.of((ObjectPath)ObjectPaths.of((DasObject)DasUtil.getNamespace((DasObject)element2)));
        Project project = element2.getProject();
        LocalDataSource localDataSource = (LocalDataSource)ds;
        GuardedRef<DatabaseConnection> connection2 = DatabaseSessionManager.facade(project, localDataSource, null, path, false, null, department).connect();
        JdbcNativeUtil.performSafe(() -> ((DatabaseConnection)connection2.get()).getRemoteConnection().setCatalog(DasUtil.getCatalog((DasObject)element2)));
        return connection2;
    }

    public static boolean isRemoteProcessDown(@NotNull Throwable e) {
        if (e == null) {
            DbImplUtil.$$$reportNull$$$0(21);
        }
        if (ExceptionUtil.findCause((Throwable)e, ConnectException.class) != null) {
            return true;
        }
        UnmarshalException unmarshal = (UnmarshalException)ExceptionUtil.findCause((Throwable)e, UnmarshalException.class);
        return unmarshal != null && unmarshal.getCause() instanceof EOFException;
    }

    public static void setStatementParameter(@NotNull RemotePreparedStatement statement, @NotNull ColumnDescriptor column2, @Nullable Object value2, @NotNull Dbms dbms, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            DbImplUtil.$$$reportNull$$$0(22);
        }
        if (column2 == null) {
            DbImplUtil.$$$reportNull$$$0(23);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(24);
        }
        ColumnInfo info = new ColumnInfo(column2.getJavaClassName(), column2.getTypeName(), column2.getType(), idx);
        statement.setObject(DbImplUtil.prepareValue(dbms, value2), info, needsEscaping, idx);
    }

    @NotNull
    public static Dbms getDbms(@NotNull BasicElement element2) {
        BasicModel model;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(25);
        }
        Dbms dbms = (model = element2.getModel()) == null ? element2.getMetaObject().getModel().dbms : model.getDbms();
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(26);
        }
        return dbms;
    }

    @NotNull
    public static ModelHelper getModelHelper(@NotNull BasicElement element2) {
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(27);
        }
        ModelHelper modelHelper = (ModelHelper)ObjectUtils.tryCast((Object)DbImplUtilCore.getModelHelper(element2), ModelHelper.class);
        if (modelHelper == null) {
            DbImplUtil.$$$reportNull$$$0(28);
        }
        return modelHelper;
    }

    @NotNull
    public static ModelHelper getModelHelper(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(29);
        }
        ModelHelper modelHelper = (ModelHelper)ObjectUtils.tryCast((Object)DbImplUtilCore.getModelHelper(dbms), ModelHelper.class);
        if (modelHelper == null) {
            DbImplUtil.$$$reportNull$$$0(30);
        }
        return modelHelper;
    }

    public static <T extends BasicModElement> ModFamily<T> familyOf(@Nullable BasicModElement element2, @NotNull ObjectKind kind) {
        if (kind == null) {
            DbImplUtil.$$$reportNull$$$0(31);
        }
        ModFamily res2 = element2 == null ? null : element2.familyOf(kind);
        return res2 instanceof ModFamily ? res2 : null;
    }

    public static void resolveKey(@NotNull BasicModForeignKey fkey, @NotNull List<String> refColNames) {
        BasicTableOrView table;
        if (fkey == null) {
            DbImplUtil.$$$reportNull$$$0(32);
        }
        if (refColNames == null) {
            DbImplUtil.$$$reportNull$$$0(33);
        }
        if (!refColNames.isEmpty() && (table = fkey.getRefTable()) != null) {
            for (BasicKey key : JBIterable.from(table.familyOf(ObjectKind.KEY)).filter(BasicKey.class)) {
                if (!refColNames.equals(key.getColNames())) continue;
                fkey.setRefKeyName(key.getName());
                return;
            }
        }
        fkey.setRefKeyName(null);
    }

    public static boolean isSchemaDbMode(BasicModModel model, Dbms family) {
        return model.getRoot().familyOf(ObjectKind.DATABASE) == null && family.isMysql();
    }

    @Nullable
    public static Object prepareValue(@NotNull Dbms family, @Nullable Object value2) {
        if (family == null) {
            DbImplUtil.$$$reportNull$$$0(34);
        }
        return value2 == null || value2 == ReservedCellValue.NULL ? null : (value2 instanceof JdbcInjectable ? ((JdbcInjectable)value2).injection(family) : (value2 instanceof ObjectFormatter.ImageInfo ? (JdbcInjection)((ObjectFormatter.ImageInfo)value2).bytes : (value2 instanceof ObjectFormatter.TextInfo ? (JdbcInjection)((ObjectFormatter.TextInfo)value2).bytes : (value2 instanceof BitString ? (JdbcInjection)((BitString)value2).getBytes() : (value2 instanceof Date ? DbImplUtil.prepareDate((Date)value2) : value2)))));
    }

    @NotNull
    private static Object prepareDate(@NotNull Date value2) {
        if (value2 == null) {
            DbImplUtil.$$$reportNull$$$0(35);
        }
        return value2 instanceof Timestamp || value2 instanceof Time ? value2 : new JdbcInjection.DateInjection(JdbcNativeUtil.createSqlDate((Date)value2));
    }

    public static boolean canInsertBlob(@NotNull DataConsumer.Column column2, @Nullable Object value2, @NotNull Dbms dbms) {
        int type;
        if (column2 == null) {
            DbImplUtil.$$$reportNull$$$0(36);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(37);
        }
        return (type = ExtractorsUtil.guessJdbcType(column2, value2, dbms)) == -2 || type == 2004 || type == -4 || type == -3;
    }

    public static boolean canInsertClob(@NotNull DataConsumer.Column column2, @Nullable Object value2, @NotNull Dbms dbms) {
        int type;
        if (column2 == null) {
            DbImplUtil.$$$reportNull$$$0(38);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(39);
        }
        return (type = ExtractorsUtil.guessJdbcType(column2, value2, dbms)) == 2005 || type == 2011 || type == -1 || type == -16 || type == -15 || type == 1 || type == 12 || type == -9 || type == 2009;
    }

    public static LobInfo.FileClobInfo clobFromFile(@NotNull VirtualFile virtualFile) {
        Charset encoding;
        if (virtualFile == null) {
            DbImplUtil.$$$reportNull$$$0(40);
        }
        String charset = (encoding = EncodingManager.getInstance().getEncoding(virtualFile, true)) != null ? encoding.name() : null;
        File file = new File(virtualFile.getPath());
        return new LobInfo.FileClobInfo(file, charset);
    }

    @NotNull
    public static LobInfo.FileBlobInfo blobFromFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            DbImplUtil.$$$reportNull$$$0(41);
        }
        return new LobInfo.FileBlobInfo(new File(virtualFile.getPath()));
    }

    public static void tryLoadFirstNRows(DatabaseConnection connection2, String query, StringBuilder sb, int rows) {
        try {
            DbImplUtil.tryLoadFirstNRows("", connection2, query, CharOut.Util.newSink(sb), rows);
        }
        catch (Exception e) {
            DbImplUtil.exceptionToHtml(e, "Unable to load table data", sb);
        }
    }

    public static void tryLoadFirstNRows(String title, DatabaseConnection connection2, String query, CharOut sb, int rows) throws Exception {
        if (connection2 == null) {
            return;
        }
        SmartStatements.poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results((ThrowableConsumer<RemoteResultSet, Exception>)((ThrowableConsumer)rs -> {
            ObjectFormatter converter = new ObjectFormatter(){

                @Override
                @Nullable
                public String objectToString(@Nullable Object o, DataConsumer.Column column2, Dbms dbms, @NotNull ObjectFormatter.Mode mode) {
                    Object o1;
                    if (mode == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((o1 = 1.objectToObject(o, column2, dbms)) instanceof ObjectFormatter.ImageInfo) {
                        ObjectFormatter.ImageInfo info = (ObjectFormatter.ImageInfo)o1;
                        String s2 = super.objectToString(info.stripBytes(), column2, dbms, mode);
                        return DataGridDocumentationProvider.createImageRefTag(info, s2);
                    }
                    String s3 = super.objectToString(o1, column2, dbms, mode);
                    return HtmlValuesExtractor.escapeChars(s3);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/util/DbImplUtil$1", "objectToString"));
                }
            };
            Color color = Objects.requireNonNull(EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)DocumentationComponent.COLOR_KEY));
            DisplayHtmlValuesExtractor extractor = new DisplayHtmlValuesExtractor(color, converter);
            DbImplUtil.resultSetToString(title, rs, rows, connection2.getDbms(), extractor, sb);
        })));
    }

    public static StringBuilder exceptionToHtml(Exception e, String str, StringBuilder sb) {
        sb.append(str).append(":<br>");
        sb.append("<code>").append(e).append("</code><br>");
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadViewDefinition(ConnectionProvider provider, @NotNull DbTable element2, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(42);
        }
        if (!(dialect = DbImplUtil.getDatabaseDialect((DbElement)element2)).supportsViewDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            Dbms dbms = element2.getDataSource().getDbms();
            Pair<String, DbImplUtilCore.ConcatenationProps> query = dialect.sqlViewDefinition((DasObject)element2);
            if (query == null) {
                return;
            }
            int initialLength = sb.length();
            DbImplUtil.concatStringResults(provider.getConnection(), dbms, 0, (String)query.first, sb, (DbImplUtilCore.ConcatenationProps)query.second);
            if (sb.length() > initialLength) {
                if (dbms.isMysql() || dbms.isPostgres() || dbms.isOracle()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element2, false);
                    String fullDefinition = dialect.sqlCreateView(builder, (DasTable)element2, sb.substring(initialLength)).getStatement();
                    sb.setLength(initialLength);
                    sb.append(fullDefinition);
                } else if (dbms.isDerby()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element2, false);
                    sb.insert(initialLength, dialect.sqlDropView(builder, (DasTable)element2, true).getStatement() + ";\n");
                } else if (dbms.isMicrosoft()) {
                    DbImplUtil.replaceTokenInDefinition((DbElement)element2, sb, dbms, SqlCreateViewStatement.class, SqlCommonKeywords.SQL_CREATE, SqlCommonKeywords.SQL_ALTER);
                } else if (dbms.isSybase()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element2, false);
                    sb.insert(initialLength, dialect.sqlDropView(builder, (DasTable)element2, true).newLine().keyword("GO").getStatement() + "\n");
                } else if (dbms.isH2()) {
                    sb.insert(initialLength + "CREATE ".length(), "OR REPLACE ");
                }
            }
        }
        finally {
            provider.release();
        }
    }

    public static DasNamespace getSearchPathObjectForSwitch(@NotNull DbDataSource dataSource2, @Nullable DasObject dasObject) {
        if (dataSource2 == null) {
            DbImplUtil.$$$reportNull$$$0(43);
        }
        return DbImplUtil.getSearchPathObjectForSwitch(DbImplUtil.getMaybeLocalDataSource((DasDataSource)dataSource2), DbImplUtil.getDatabaseDialect((DbElement)dataSource2), dasObject);
    }

    public static DasNamespace getSearchPathObjectForSwitch(@Nullable LocalDataSourceCore dataSource2, @NotNull DatabaseDialectEx dialect, @Nullable DasObject dasObject) {
        SchemaControl control;
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(44);
        }
        if (dasObject == null) {
            return null;
        }
        SchemaControl schemaControl = control = dataSource2 == null ? SchemaControl.AUTOMATIC : dataSource2.getSchemaControl();
        if (control != SchemaControl.AUTOMATIC) {
            if (!dialect.getDbms().isPostgres()) {
                return null;
            }
            DasNamespace object = DbImplUtil.getSearchPathObject(dialect, dasObject);
            if (dasObject.getKind() == ObjectKind.DATABASE) {
                return (DasNamespace)ObjectUtils.tryCast((Object)dasObject, DasNamespace.class);
            }
            if (object == null || object.getKind() != ObjectKind.SCHEMA) {
                return object;
            }
            return (DasNamespace)ObjectUtils.tryCast((Object)object.getDasParent(), DasNamespace.class);
        }
        return DbImplUtil.getSearchPathObject(dialect, dasObject);
    }

    public static DasNamespace getSearchPathObjectForSwitch(@Nullable DbElement element2) {
        return element2 == null ? null : DbImplUtil.getSearchPathObjectForSwitch(element2.getDataSource(), (DasObject)element2);
    }

    @Nullable
    public static ObjectPath getSearchPathObject(@NotNull Dbms dbms, @Nullable ObjectPath objectPath) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(45);
        }
        if (objectPath == null) {
            return null;
        }
        if (dbms.isSqlite()) {
            return objectPath.findParent(ObjectKind.SCHEMA, false);
        }
        ObjectKind kind = DbImplUtil.getDatabaseDialect(dbms).getSearchPathObjectKind();
        List<ObjectKind> path = kind == null ? null : (List<ObjectKind>)DbImplUtil.getMetaModel(dbms).getPathsToRoot(kind).first();
        List<ObjectKind> pathsToRoot = path == null ? Collections.singletonList(kind) : path;
        return kind == null ? null : (ObjectPath)JBIterable.generate((Object)objectPath, p2 -> p2.parent).find(o -> pathsToRoot.contains(o.kind));
    }

    @Nullable
    public static DasNamespace getSearchPathObject(@Nullable DbElement element2) {
        return element2 == null ? null : DbImplUtil.getSearchPathObject(DbImplUtil.getDatabaseDialect(element2), (DasObject)element2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void tryLoadProcedureDefinition(@NotNull ConnectionProvider provider, @NotNull DbRoutine element2, @NotNull StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect;
        if (provider == null) {
            DbImplUtil.$$$reportNull$$$0(46);
        }
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(47);
        }
        if (sb == null) {
            DbImplUtil.$$$reportNull$$$0(48);
        }
        if (!((dialect = DbImplUtil.getDatabaseDialect((DbElement)element2)) instanceof DatabaseDialectEx)) {
            return;
        }
        if (!provider.acquire()) {
            provider.release();
            return;
        }
        String fromDialect = DatabaseDialectHelper.geInstance(dialect).tryToLoadProcedureDefinition((DasRoutine)element2, provider.getConnection());
        if (StringUtil.isNotEmpty((String)fromDialect)) {
            sb.append(fromDialect);
            provider.release();
            return;
        }
        if (!dialect.supportsProcedureDefinition()) {
            return;
        }
        Dbms dbms = DbImplUtil.getDbms((DbElement)element2);
        Pair<String, DbImplUtilCore.ConcatenationProps> query = dialect.sqlProcedureDefinition((DasRoutine)element2);
        StringBuilder definition = DbImplUtil.concatStringResults(provider.getConnection(), dbms, (String)query.first, 0, new StringBuilder(), (DbImplUtilCore.ConcatenationProps)query.second);
        if (StringUtil.isEmptyOrSpaces((String)definition.toString())) return;
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element2, false);
        if (dbms.isOracle()) {
            definition.insert(0, builder.keywords("create", "or", "replace").space().getStatement());
        } else if (dbms.isH2()) {
            definition.insert(0, builder.keywords("create", "alias").space().qualifiedRef((DasObject)element2).space().keyword("as").space().symbol("$$").getStatement()).append("$$");
        } else if (dbms.isDb2()) {
            definition.insert(0, dialect.sqlDropProcedure(builder, (DasRoutine)element2).getStatement() + ";\n");
        } else if (dbms.isMicrosoft()) {
            DbImplUtil.replaceTokenInDefinition((DbElement)element2, definition, dbms, SqlCreateStatement.class, SqlCommonKeywords.SQL_CREATE, SqlCommonKeywords.SQL_ALTER);
        } else if (dbms.isSybase()) {
            builder.keyword("drop").space().keyword(StringUtil.startsWithIgnoreCase((String)definition.toString().trim(), (String)"create function") ? "function" : "procedure").space();
            dialect.qualifiedIdentifier(builder, element2.getName(), (DasObject)element2, (DasObject)element2);
            builder.newLine();
            builder.keyword("go").newLine();
            definition.insert(0, builder.getStatement());
        }
        String trim = definition.toString().trim();
        sb.append(trim);
        if (dbms.isTransactSql()) {
            sb.append(DatabaseDialogsHelper.createDdlBuilder((DbElement)element2, false).clear().newLine().keyword("go").getStatement());
            return;
        }
        if (trim.endsWith(";")) return;
        sb.append(";");
        return;
    }

    private static void replaceTokenInDefinition(@NotNull DbElement element2, @NotNull StringBuilder sb, @NotNull Dbms dbms, @NotNull Class<? extends SqlDefinition> defClazz, @NotNull SqlTokenType fromToken, @NotNull SqlTokenType toToken) {
        SqlFile psi;
        SyntaxTraverser st;
        PsiElement keyword;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(49);
        }
        if (sb == null) {
            DbImplUtil.$$$reportNull$$$0(50);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(51);
        }
        if (defClazz == null) {
            DbImplUtil.$$$reportNull$$$0(52);
        }
        if (fromToken == null) {
            DbImplUtil.$$$reportNull$$$0(53);
        }
        if (toToken == null) {
            DbImplUtil.$$$reportNull$$$0(54);
        }
        if ((keyword = (PsiElement)(st = SyntaxTraverser.psiTraverser((PsiElement)(psi = SqlPsiFacade.getInstance((Project)element2.getProject()).createROFile(DbSqlUtilCore.getSqlDialect(dbms), (CharSequence)sb.toString())))).traverse().skipWhile(Conditions.notInstanceOf(defClazz)).filter(Conditions.compose((Function)st.api.TO_TYPE, (Condition)Conditions.equalTo((Object)fromToken))).first()) != null) {
            TextRange r = st.api.rangeOf((Object)keyword);
            int i0 = r.getStartOffset();
            int i1 = r.getEndOffset();
            String replacement = ((Case)ObjectUtils.notNull((Object)Case.forString((String)sb.substring(i0, i1)), (Object)Case.EXACT)).apply(toToken.toString());
            sb.replace(i0, i1, replacement);
        }
    }

    public static boolean isEditableTable(@NotNull Dbms dbms, @Nullable ObjectKind kind) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(55);
        }
        return ((DmlHelper)DmlHelper.Companion.getEP().forDbms(dbms)).isEditableTable(kind);
    }

    @NotNull
    public static MetaModel getMetaModel(@NotNull DbElement element2) {
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(56);
        }
        DbDataSource dataSource2 = element2.getDataSource();
        return DbImplUtil.getMetaModel(dataSource2);
    }

    @NotNull
    public static MetaModel getMetaModel(@NotNull DbDataSource dataSource2) {
        if (dataSource2 == null) {
            DbImplUtil.$$$reportNull$$$0(57);
        }
        return DbImplUtil.getMetaModel((DasDataSource)dataSource2);
    }

    @NotNull
    public static MetaModel getMetaModel(@NotNull DasDataSource dataSource2) {
        BaseModel model;
        if (dataSource2 == null) {
            DbImplUtil.$$$reportNull$$$0(58);
        }
        if ((model = (BaseModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BaseModel.class)) != null) {
            MetaModel metaModel = model.getMetaModel();
            if (metaModel == null) {
                DbImplUtil.$$$reportNull$$$0(59);
            }
            return metaModel;
        }
        BasicMetaModel<?> basicMetaModel = DbImplUtil.getMetaModel(dataSource2.getDbms());
        if (basicMetaModel == null) {
            DbImplUtil.$$$reportNull$$$0(60);
        }
        return basicMetaModel;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull DbElement element2) {
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(61);
        }
        DatabaseDialectEx databaseDialectEx = DbImplUtilCore.getDatabaseDialect(element2);
        if (databaseDialectEx == null) {
            DbImplUtil.$$$reportNull$$$0(62);
        }
        return databaseDialectEx;
    }

    @NotNull
    public static Dbms getDbms(@NotNull JdbcConsole console) {
        if (console == null) {
            DbImplUtil.$$$reportNull$$$0(63);
        }
        Dbms dbms = console.getDataSource().getDbms();
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(64);
        }
        return dbms;
    }

    public static boolean isGenericSupport(Dbms dbms) {
        if (dbms.in(Dbms.PSEUDO_SUPPORTED)) {
            return true;
        }
        DatabaseDialectEx db = DbImplUtil.getDatabaseDialect(dbms);
        SqlLanguageDialect sql = DbSqlUtilCore.getSqlDialect(dbms);
        return SqlDialects.isGenericDialect(sql) && DatabaseDialects.isGenericDialect(db);
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull JdbcConsole console) {
        if (console == null) {
            DbImplUtil.$$$reportNull$$$0(65);
        }
        return DbImplUtil.getDatabaseDialect(console.getDataSource());
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull RawConnectionConfig connectionInfo) {
        if (connectionInfo == null) {
            DbImplUtil.$$$reportNull$$$0(66);
        }
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(connectionInfo), (Object)DatabaseDialects.getGenericDialect());
        if (databaseDialectEx == null) {
            DbImplUtil.$$$reportNull$$$0(67);
        }
        return databaseDialectEx;
    }

    @Nullable
    protected static DatabaseDialectEx guessDatabaseDialect(@Nullable Dbms dbms) {
        return (DatabaseDialectEx)ObjectUtils.tryCast((Object)DbImplUtilCore.guessDatabaseDialect(dbms), DatabaseDialectEx.class);
    }

    @Nullable
    public static DatabaseDialect guessDatabaseDialect(@Nullable DasObject object) {
        return DbImplUtil.guessDatabaseDialect(DbImplUtil.guessDbms(object));
    }

    @Nullable
    public static Dbms guessDbms(@Nullable DasObject object) {
        Language language;
        BasicModel model;
        DasObject o;
        Object object2 = o = object instanceof DbElement ? ((DbElement)object).getDelegate() : object;
        Dbms dbms = o instanceof BasicElement ? ((model = ((BasicElement)o).getModel()) == null ? null : model.getDbms()) : (o instanceof SqlElement ? ((language = ((SqlElement)o).getContainingFile().getLanguage()) instanceof SqlLanguageDialect ? ((SqlLanguageDialect)language).getDbms() : null) : null);
        return dbms;
    }

    public static boolean hasUniqueIndex(@NotNull DasTable table) {
        if (table == null) {
            DbImplUtil.$$$reportNull$$$0(68);
        }
        return table.getDasChildren(ObjectKind.INDEX).filter(idx -> idx instanceof DasIndex && ((DasIndex)idx).isUnique()).isNotEmpty();
    }

    public static boolean supportsDynamicSchemaSwitching(@NotNull LocalDataSource dataSource2) {
        DatabaseDialectEx dialect;
        if (dataSource2 == null) {
            DbImplUtil.$$$reportNull$$$0(69);
        }
        return (dialect = DbImplUtil.guessDatabaseDialect(dataSource2)) == null || !dataSource2.getDbms().isMysql() || !dataSource2.isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadPackageDefinition(ConnectionProvider provider, @NotNull DbPackage element2, boolean spec, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect;
        if (element2 == null) {
            DbImplUtil.$$$reportNull$$$0(70);
        }
        if (!(dialect = DbImplUtil.getDatabaseDialect((DbElement)element2)).supportsPackageDefinition()) {
            return;
        }
        Dbms dbms = element2.getDataSource().getDbms();
        try {
            if (!provider.acquire()) {
                return;
            }
            Pair<String, DbImplUtilCore.ConcatenationProps> query = spec ? dialect.sqlPackageDefinition((DasObject)element2) : dialect.sqlPackageBodyDefinition((DasObject)element2);
            StringBuilder def = DbImplUtil.concatStringResults(provider.getConnection(), dbms, (String)query.first, 0, new StringBuilder(), (DbImplUtilCore.ConcatenationProps)query.second);
            Case caseMode = (Case)ObjectUtils.notNull((Object)Case.forString((String)def.substring(0, Math.min(sb.length(), 7))), (Object)Case.EXACT);
            if (StringUtil.startsWith((CharSequence)def, (CharSequence)"package") || StringUtil.startsWith((CharSequence)def, (CharSequence)"PACKAGE")) {
                def.insert(0, caseMode.apply("CREATE OR REPLACE "));
            }
            sb.append((CharSequence)def);
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadSequenceDefinition(ConnectionProvider provider, DbTable element2, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element2);
        if (!dialect.supportsSequenceDefinition()) {
            return;
        }
        Dbms dbms = element2.getDataSource().getDbms();
        StringBuilder builder = new StringBuilder();
        String drop = dialect.sqlDropSequence(DatabaseDialogsHelper.createDdlBuilder((DbElement)element2, false), (DasObject)element2, false).getStatement() + ";\n";
        builder.append(drop);
        try {
            if (!provider.acquire()) {
                return;
            }
            Pair<String, DbImplUtilCore.ConcatenationProps> query = dialect.sqlSequenceDefinition((DasObject)element2);
            DbImplUtil.concatStringResults(provider.getConnection(), dbms, (String)query.first, 0, builder, (DbImplUtilCore.ConcatenationProps)query.second);
            sb.append((CharSequence)builder);
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadTableDefinition(ConnectionProvider provider, DbTable element2, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element2);
        if (!(dialect instanceof DatabaseDialectEx)) {
            return;
        }
        if (!dialect.supportsTableDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            String sql = DatabaseDialectHelper.geInstance(dialect).tryToLoadTableDefinition((DasTable)element2, provider.getConnection());
            if (!StringUtil.isEmptyOrSpaces((String)sql)) {
                sb.append(sql);
            }
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> tryLoadTableInfo(ConnectionProvider provider, DbTable element2) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element2);
        if (!(dialect instanceof DatabaseDialectEx)) {
            return Collections.emptyMap();
        }
        if (!dialect.supportsTableInfo()) {
            return Collections.emptyMap();
        }
        try {
            if (!provider.acquire()) {
                Map<String, Object> map2 = Collections.emptyMap();
                return map2;
            }
            Map<String, Object> map3 = DatabaseDialectHelper.geInstance(dialect).tryToLoadTableInfo(element2, provider.getConnection());
            return map3;
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadSynonymDefinition(ConnectionProvider provider, DbTable element2, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element2);
        if (!(dialect instanceof DatabaseDialectEx)) {
            return;
        }
        if (!dialect.supportsTableDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            String sql = DatabaseDialectHelper.geInstance(dialect).tryToLoadSynonymDefinition((DasTable)element2, provider.getConnection());
            if (!StringUtil.isEmpty((String)sql)) {
                sb.append(sql);
            }
        }
        finally {
            provider.release();
        }
    }

    public static boolean isScriptFile(@Nullable Project project, @Nullable VirtualFile file) {
        return DbSqlUtil.SQL_FILE_FILTER(project).value((Object)file) || DbImplUtil.isJSScriptFile(project, file);
    }

    public static boolean isJSScriptFile(Project project, VirtualFile file) {
        if (!"js".equals(file.getExtension()) && !FileTypeRegistry.getInstance().getFileTypeByFile(file).getName().equals("JavaScript")) {
            return false;
        }
        for (LocalDataSourceCore localDataSourceCore : DbSrcUtilsCore.getDataSources(project)) {
            if (!localDataSourceCore.getDbms().isMongo()) continue;
            return true;
        }
        return false;
    }

    public static boolean isDatabaseVirtualFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return DbSrcUtilsCore.isDbSrcFile(file) || file instanceof DatabaseElementVirtualFileImpl;
    }

    @Nullable
    public static DbDataSource findDataSource(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(71);
        }
        if (DbSrcUtilsCore.isDbSrcFile(file)) {
            return DbPsiFacade.getInstance((Project)project).findDataSource(DbSrcUtilsCore.getDataSource(file));
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            DatabaseElementVirtualFileImpl dbFile = (DatabaseElementVirtualFileImpl)file;
            return dbFile.findDataSource(project);
        }
        return null;
    }

    @Nullable
    public static DbElement findElement(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(72);
        }
        if (DbSrcUtilsCore.isDbSrcFile(file)) {
            return DbSrcUtils.findDbElement(project, file.getPath(), DbElement.class);
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return ((DatabaseElementVirtualFileImpl)file).findElement(project);
        }
        return null;
    }

    @Nullable
    public static ObjectKind getKind(@NotNull VirtualFile file) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(73);
        }
        if (DbSrcUtilsCore.isDbSrcFile(file)) {
            return DbSrcUtils.getKind(file.getPath());
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return ((DatabaseElementVirtualFileImpl)file).getObjectKind();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findSourceVirtualFile(@NotNull DbElement o, boolean refresh) {
        if (o == null) {
            DbImplUtil.$$$reportNull$$$0(74);
        }
        ObjectKind kind = o.getKind();
        VirtualFile file = DbImplUtil.findVirtualFileInSourceStorage(o, false, refresh);
        if (file != null) {
            return file;
        }
        if (DbImplUtil.isDataTable(kind)) {
            return DatabaseElementVirtualFileImpl.findFile(o, true);
        }
        return o.getVirtualFile();
    }

    @Nullable
    public static VirtualFile findVirtualFileInSourceStorage(@Nullable DbElement o, boolean original, boolean refresh) {
        VirtualFile vf;
        Object delegate;
        Object object = delegate = o != null ? o.getDelegate() : null;
        if (delegate instanceof BasicSourceAware && (vf = DbSrcUtils.findDbSrcFile(o.getDataSource(), (DasObject)o, refresh)) != null) {
            return original ? DbSrcFileSystem.getInstance().getBaseFile(vf, false) : vf;
        }
        return null;
    }

    @Nullable
    public static String loadDefinitionFromStorage(@Nullable DbElement o) {
        VirtualFile file = DbImplUtil.findVirtualFileInSourceStorage(o, true, false);
        if (file == null) {
            return null;
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean canSwitchTo(@NotNull SearchPath to, @NotNull DatabaseDialectEx dialect) {
        if (to == null) {
            DbImplUtil.$$$reportNull$$$0(75);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(76);
        }
        return dialect.sqlSetSearchPath(to) != null;
    }

    @Nullable
    public static String getSearchPathSql(@NotNull SearchPath to, @NotNull LocalDataSource dataSource2, @NotNull DatabaseDialectEx dialect) {
        if (to == null) {
            DbImplUtil.$$$reportNull$$$0(77);
        }
        if (dataSource2 == null) {
            DbImplUtil.$$$reportNull$$$0(78);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(79);
        }
        if (dataSource2.getSchemaControl() == SchemaControl.FORBID) {
            return null;
        }
        String setSchemaSql = dialect.sqlSetSearchPath(to);
        if (setSchemaSql != null) {
            return setSchemaSql;
        }
        ObjectPath current = to.getCurrent();
        ObjectPath db = current.kind != ObjectKind.SCHEMA ? null : current.findParent(ObjectKind.DATABASE, true);
        return db == null ? null : dialect.sqlSetSearchPath(SearchPath.of((ObjectPath)db));
    }

    public static boolean switchSchemaThroughJdbc(@NotNull SearchPath path, @NotNull DatabaseConnection connection2, @NotNull LocalDataSource dataSource2) throws SQLException {
        if (path == null) {
            DbImplUtil.$$$reportNull$$$0(80);
        }
        if (connection2 == null) {
            DbImplUtil.$$$reportNull$$$0(81);
        }
        if (dataSource2 == null) {
            DbImplUtil.$$$reportNull$$$0(82);
        }
        if (dataSource2.getSchemaControl() == SchemaControl.FORBID) {
            return false;
        }
        if (!dataSource2.getDbms().isClickHouse() && !DatabaseDialects.isGenericDialect(DbImplUtil.getDatabaseDialect(dataSource2))) {
            return false;
        }
        ObjectPath schema = path.getCurrent().findParent(ObjectKind.SCHEMA, false);
        if (dataSource2.getDbms().isClickHouse()) {
            if (schema == null) {
                return false;
            }
            JdbcNativeUtil.performRemote(() -> connection2.getRemoteConnection().setCatalog(schema.name));
        } else {
            ObjectPath database = path.getCurrent().findParent(ObjectKind.DATABASE, false);
            if (schema == null && database == null) {
                return false;
            }
            JdbcNativeUtil.performRemote(() -> {
                if (database != null) {
                    connection2.getRemoteConnection().setCatalog(database.name);
                }
                if (schema != null) {
                    connection2.getRemoteConnection().setSchema(schema.name);
                }
            });
        }
        return true;
    }

    @NotNull
    public static <T extends ColumnDescriptor> List<T> getWhereClauseColumns(@Nullable DasTable table, @NotNull List<T> descriptors, @NotNull Dbms dbms) {
        ColumnDescriptor idColumn;
        if (descriptors == null) {
            DbImplUtil.$$$reportNull$$$0(83);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(84);
        }
        DasTableKey primaryKey = table == null ? null : DasUtil.getPrimaryKey((DasTable)table);
        ArrayList<ColumnDescriptor> result = new ArrayList<ColumnDescriptor>(descriptors.size());
        if (primaryKey != null) {
            THashSet set = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            ContainerUtil.addAll((Collection)set, (Iterable)primaryKey.getColumnsRef().names());
            result.addAll(ContainerUtil.filter(descriptors, arg_0 -> DbImplUtil.lambda$getWhereClauseColumns$8((Set)set, arg_0)));
        } else if (dbms.is(Dbms.MONGO) && (idColumn = (ColumnDescriptor)ContainerUtil.find(descriptors, d2 -> "_id".equals(d2.getName()))) != null) {
            result.add(idColumn);
        }
        if (!result.isEmpty()) {
            ArrayList<ColumnDescriptor> arrayList = result;
            if (arrayList == null) {
                DbImplUtil.$$$reportNull$$$0(85);
            }
            return arrayList;
        }
        result.addAll(ContainerUtil.filter(descriptors, descriptor2 -> DbImplUtil.isSuitable(descriptor2, dbms)));
        ArrayList<ColumnDescriptor> arrayList = result;
        if (arrayList == null) {
            DbImplUtil.$$$reportNull$$$0(86);
        }
        return arrayList;
    }

    public static boolean supportsDomainAuth(@Nullable DatabaseDriver driver) {
        return SystemInfo.isWindows && driver != null && ("sqlserver.ms".equals(driver.getId()) || "sqlserver.jtds".equals(driver.getId()) || "com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(driver.getDriverClass()) || "net.sourceforge.jtds.jdbc.Driver".equals(driver.getDriverClass()));
    }

    public static boolean supportsOffset(@Nullable Dbms dbms) {
        return dbms != null && SUPPORTS_OFFSET_DBS.contains(dbms);
    }

    public static boolean isSchema(@NotNull DasObject object) {
        if (object == null) {
            DbImplUtil.$$$reportNull$$$0(87);
        }
        return DbImplUtil.isSchema(object.getKind());
    }

    public static boolean isSchema(@NotNull ObjectKind kind) {
        if (kind == null) {
            DbImplUtil.$$$reportNull$$$0(88);
        }
        return kind == ObjectKind.SCHEMA || kind == ObjectKind.EXTERNAL_SCHEMA;
    }

    @Nullable
    public static DasNamespace getTopSingleNamespace(@Nullable DasObject object) {
        ObjectKind kind;
        ObjectKind objectKind = kind = object == null ? null : object.getKind();
        if (kind != ObjectKind.ROOT && kind != ObjectKind.DATABASE) {
            return (DasNamespace)DasUtil.dasParents((DasObject)object).filter(DasNamespace.class).first();
        }
        JBIterable ns = ((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)object)).expand(Conditions.compose((Function)DasUtil.TO_KIND, k -> k == ObjectKind.ROOT || k == ObjectKind.DATABASE))).traverse();
        DasObject result = (DasObject)ns.filter(DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA)).single();
        if (result == null) {
            result = (DasObject)ns.filter(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE)).single();
        }
        return result instanceof DasNamespace ? (DasNamespace)result : null;
    }

    public static boolean supportsReadOnlyChangeOnTheFly(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(89);
        }
        return !dbms.isSqlite() && !dbms.isHive() && dbms != Dbms.SNOWFLAKE && dbms != Dbms.COCKROACH;
    }

    public static void tryToSetReadOnly(@NotNull DatabaseConnection connection2, boolean isReadOnly) {
        if (connection2 == null) {
            DbImplUtil.$$$reportNull$$$0(90);
        }
        try {
            connection2.setReadOnly(isReadOnly);
        }
        catch (Throwable t) {
            LOG.warn(String.format(READ_ONLY_WARNING, connection2.getDbms()), t);
        }
    }

    public static void tryToSetReadOnly(@NotNull RemoteConnection remoteConnection, boolean isReadOnly, Dbms dbms) {
        if (remoteConnection == null) {
            DbImplUtil.$$$reportNull$$$0(91);
        }
        try {
            remoteConnection.setReadOnly(isReadOnly);
        }
        catch (Throwable t) {
            LOG.warn(String.format(READ_ONLY_WARNING, dbms), t);
        }
    }

    public static boolean supportsReadOnlyChangeDuringTx(@NotNull Dbms family) {
        if (family == null) {
            DbImplUtil.$$$reportNull$$$0(92);
        }
        return family == Dbms.MYSQL;
    }

    @Nullable
    public static DbDataSource findDataSourceByFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(93);
        }
        if (file == null) {
            return null;
        }
        for (DbDataSource dataSource2 : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            String adjusted;
            LocalDataSource d2 = DbImplUtil.getMaybeLocalDataSource((DasDataSource)dataSource2);
            JdbcUrlParser parsed = JdbcUrlParserUtil.parsed(d2);
            String path = parsed == null ? null : parsed.getParameter("file");
            if (path == null || !Objects.equals(adjusted = FileUtil.toSystemIndependentName((String)PathManager.getAbsolutePath((String)path)), file.getPath())) continue;
            return dataSource2;
        }
        return null;
    }

    public static boolean isTableFile(@NotNull VirtualFile file) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(94);
        }
        return file instanceof DatabaseElementVirtualFileImpl && !((DatabaseElementVirtualFileImpl)file).isSource() && DbImplUtil.isDataTable(DbImplUtil.getKind(file));
    }

    public static TriConsumer<DdlBuilder, List<DasColumn>, Dbms> defaultWhereCondition(@NotNull String[] columnNames, @NotNull String[] values2, @Nullable Version version) {
        if (columnNames == null) {
            DbImplUtil.$$$reportNull$$$0(95);
        }
        if (values2 == null) {
            DbImplUtil.$$$reportNull$$$0(96);
        }
        return (builder, columns, dbms) -> {
            List<ColumnRef> actualColumns = ColumnRefKt.toColumnsRef(columns, columnNames);
            ArrayList<Triple> v = new ArrayList<Triple>();
            for (int i2 = 0; i2 < actualColumns.size(); ++i2) {
                v.add(new Triple((Object)actualColumns.get(i2), (Object)PredicateValuesKt.predicateValue(values2[i2]), PredicateSpecKt.DEFAULT_OPS));
            }
            ValuesWhereClauseTask task = DmlTaskKt.whereClause(new ValuesWhereClause(v, "AND", null)).version(version).build((DdlBuilder)builder);
            DmlUtilKt.dmlGenerator(dbms).generate(task);
        };
    }

    public static String[] formatValues(@NotNull DataGrid dataGrid, @NotNull String[] columnNames, Object[] values2) {
        if (dataGrid == null) {
            DbImplUtil.$$$reportNull$$$0(97);
        }
        if (columnNames == null) {
            DbImplUtil.$$$reportNull$$$0(98);
        }
        ArrayList<String> formattedValues = new ArrayList<String>();
        GridModel model = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        Dbms dbms = DataGridUtil.getDbms(dataGrid);
        ObjectFormatter objectFormatter = new ObjectFormatter();
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            ModelIndex<DataConsumer.Column> idx = DataGridUtil.findColumn(dataGrid, columnNames[i2]);
            formattedValues.add(DbImplUtil.formatValue(model.getColumn(idx), objectFormatter, dbms, values2[i2]));
        }
        return ArrayUtil.toStringArray(formattedValues);
    }

    @Nullable
    public static String formatValue(@Nullable DataConsumer.Column column2, @NotNull ObjectFormatter objectFormatter, @NotNull Dbms dbms, @Nullable Object value2) {
        if (objectFormatter == null) {
            DbImplUtil.$$$reportNull$$$0(99);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(100);
        }
        return column2 == null ? (value2 == null ? null : value2.toString()) : objectFormatter.objectToString(value2, column2, dbms, PredicatesHelperKt.predicatesHelper(dbms).getMode());
    }

    public static void closeSafe(@Nullable AutoCloseable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String concatStringResults(DatabaseConnection connection2, Dbms dbms, String query, int forcedColumn, DbImplUtilCore.ConcatenationProps props) throws SQLException {
        return DbImplUtil.concatStringResults(connection2, dbms, query, forcedColumn, new StringBuilder(), props).toString().trim();
    }

    public static StringBuilder concatStringResults(DatabaseConnection connection2, Dbms dbms, int forcedColumn, String query, StringBuilder sb, DbImplUtilCore.ConcatenationProps props) throws SQLException {
        return DbImplUtil.concatStringResults(connection2, dbms, query, forcedColumn, sb, props);
    }

    public static StringBuilder concatStringResults(DatabaseConnection connection2, Dbms dbms, String query, int forcedColumn, StringBuilder sb, DbImplUtilCore.ConcatenationProps props) throws SQLException {
        SmartStatements.poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.allResults((ThrowableConsumer<RemoteResultSet, Exception>)((ThrowableConsumer)rs -> DbImplUtil.concatStringResults(rs, dbms, forcedColumn, sb, props))));
        return sb;
    }

    private static void concatStringResults(RemoteResultSet rs, Dbms dbms, int forcedColumn, StringBuilder sb, DbImplUtilCore.ConcatenationProps props) throws Exception {
        int trimmedLen;
        DataConsumer.Column[] columns = JdbcEngine.getColumnDescriptors(rs, dbms);
        int columnCount = columns.length;
        int start2 = sb.length();
        while (rs.next()) {
            if (start2 != sb.length()) {
                sb.append(props.rowSep);
            }
            int rowStart = sb.length();
            for (int i2 = forcedColumn > 0 ? forcedColumn : 1; i2 <= (forcedColumn > 0 ? forcedColumn : columnCount); ++i2) {
                CharSequence s2 = DbImplUtil.extractString(rs.getObject(i2));
                if (s2 == null) continue;
                if (props.lTrim) {
                    s2 = StringUtil.trimLeading((CharSequence)s2);
                }
                if (props.rTrim) {
                    s2 = StringUtil.trimTrailing((CharSequence)s2);
                }
                if (rowStart != sb.length()) {
                    sb.append(props.colSep);
                }
                sb.append(s2);
            }
        }
        for (trimmedLen = sb.length(); trimmedLen != 0 && sb.charAt(trimmedLen - 1) == ' '; --trimmedLen) {
        }
        sb.setLength(trimmedLen);
    }

    @Nullable
    private static CharSequence extractString(@Nullable Object object) throws SQLException {
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        if (object instanceof RemoteClob) {
            RemoteClob clob = (RemoteClob)object;
            try {
                return clob.getSubString(1L, (int)clob.length());
            }
            catch (RemoteException re) {
                ExceptionUtil.rethrow((Throwable)RemoteUtil.unwrap((Throwable)re));
            }
        } else if (object instanceof Clob) {
            Clob clob = (Clob)object;
            return clob.getSubString(1L, (int)clob.length());
        }
        return null;
    }

    public static <T> T executeAndGetResult(DatabaseConnection connection2, String query, ThrowableConvertor<RemoteResultSet, T, Exception> result) throws SQLException {
        return SmartStatements.poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.throwableResultsTransformer(result));
    }

    public static long getCount(@NotNull DatabaseConnection connection2, @NotNull String query) throws SQLException {
        if (connection2 == null) {
            DbImplUtil.$$$reportNull$$$0(101);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(102);
        }
        ExecutionEnvironmentHelper helper = (ExecutionEnvironmentHelper)ExecutionEnvironmentHelper.EP.forDbms(connection2.getDbms());
        Long result = (Long)DbImplUtil.executeAndGetResult(connection2, query, helper::getCountRows);
        if (result == null) {
            throw new AssertionError((Object)"Incorrect count query!");
        }
        return result;
    }

    public static Map<String, Object> resultRowAsMap(DatabaseConnection connection2, String query, String ... columnSelection) throws SQLException {
        return SmartStatements.poweredBy(connection2).simple().noisy().execute(query, StandardResultsProcessors.throwableResultsTransformer(rs -> {
            if (!rs.next()) {
                return Collections.emptyMap();
            }
            try {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                RemoteResultSetMetaData metaData = rs.getMetaData();
                int count = metaData.getColumnCount();
                for (int i2 = 1; i2 <= count; ++i2) {
                    result.put(metaData.getColumnName(i2), rs.getObject(i2));
                }
                if (columnSelection.length > 0 && !result.isEmpty()) {
                    assert (columnSelection.length % 2 == 0);
                    LinkedHashMap map2 = new LinkedHashMap();
                    for (int i3 = 0; i3 < columnSelection.length; i3 += 2) {
                        Object o = result.get(columnSelection[i3]);
                        if (o == null) continue;
                        map2.put(columnSelection[i3 + 1], o);
                    }
                    result = map2;
                }
                return result;
            }
            catch (Exception exception) {
                return Collections.emptyMap();
            }
        }, Collections.emptyMap()));
    }

    @NotNull
    public static JBIterable<DbDataSource> getDataSourcesForExec(@NotNull PsiFile file, boolean ignoreForced, boolean matchingOnly) {
        DbDataSource forced;
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(103);
        }
        DbDataSource dbDataSource = forced = ignoreForced ? null : DbImplUtil.getForcedDataSource(file);
        if (forced != null) {
            JBIterable jBIterable = JBIterable.of((Object)forced).filter(CAN_CONNECT_TO);
            if (jBIterable == null) {
                DbImplUtil.$$$reportNull$$$0(104);
            }
            return jBIterable;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        SqlLanguageDialect dialect = virtualFile == null ? null : (SqlLanguageDialect)ObjectUtils.chooseNotNull((Object)DbSqlUtilCore.getSqlDialect((PsiElement)file), (Object)SqlPsiFacade.getInstance((Project)file.getProject()).getConfiguredSqlLanguageDialect(virtualFile));
        DatabaseDialect databaseDialect = dialect == null ? null : dialect.getDatabaseDialect();
        JBIterable jBIterable = databaseDialect == null ? JBIterable.empty() : DbSqlUtilCore.getAppropriateDataSources(databaseDialect, PsiUtilCore.getVirtualFile((PsiElement)file), file.getProject(), false, matchingOnly).filter(CAN_CONNECT_TO);
        if (jBIterable == null) {
            DbImplUtil.$$$reportNull$$$0(105);
        }
        return jBIterable;
    }

    public static int composeWhereItemWithParameters(@NotNull DdlBuilder builder, @NotNull DataConsumer.Column column2, boolean isNull, @Nullable String alias, @NotNull Dbms dbms, boolean inUpdate) {
        boolean useLike;
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(106);
        }
        if (column2 == null) {
            DbImplUtil.$$$reportNull$$$0(107);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(108);
        }
        if (DbImplUtil.isRowId(column2)) {
            builder.plain(column2.name);
        } else {
            if (alias != null) {
                builder.alias(alias).symbol(".");
            }
            builder.identifier(column2.name);
        }
        builder.space();
        if (isNull) {
            builder.keywords("IS", "NULL");
            return 0;
        }
        JdbcHelper helper = DbImplUtil.getJdbcHelper(dbms);
        boolean bl = useLike = DbImplUtil.getDatabaseDialect(dbms).getLikeSupport(null).isSupported(inUpdate) && "java.lang.String".equals(column2.clazz);
        if (useLike) {
            builder.keyword("LIKE");
        } else if (dbms.isPostgres() && PgBaseJdbcHelper.isCustomOperatorType((String)column2.getTypeName())) {
            builder.symbol("~=");
        } else {
            builder.symbol("=");
        }
        builder.space().placeholder();
        if (useLike && helper.supportsEscape()) {
            builder.space().keyword("ESCAPE").space().plain("'#'");
        }
        return 1;
    }

    public static String escapeStr(String value2) {
        return StringUtil.notNullize((String)value2).replace("'", "''");
    }

    public static <T> T escapeSql(T value2, boolean needsEscaping, @NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(109);
        }
        return (T)DbImplUtil.getJdbcHelper(dbms).escapeSqlRegex(value2, needsEscaping);
    }

    public static boolean isRowId(DataConsumer.Column column2) {
        return column2 != null && column2.attributes.contains((Object)DataConsumer.Column.Attribute.ROW_ID);
    }

    public static DataConsumer.Column makeRowId(DataConsumer.Column column2) {
        if (column2.attributes.contains((Object)DataConsumer.Column.Attribute.ROW_ID)) {
            return column2;
        }
        EnumSet<DataConsumer.Column.Attribute> attributes2 = EnumSet.noneOf(DataConsumer.Column.Attribute.class);
        attributes2.addAll(column2.attributes);
        attributes2.add(DataConsumer.Column.Attribute.ROW_ID);
        return new DataConsumer.Column(column2.columnNum, column2.name, column2.type, column2.typeName, column2.clazz, -1, -1, column2.catalog, column2.schema, column2.table, attributes2);
    }

    public static boolean isPageSizeUnlimited(int pageSize) {
        return pageSize < 1;
    }

    public static int getPageSize() {
        return DbImplUtil.getPageSize(null);
    }

    public static int getPageSize(@Nullable Dbms dbms) {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        return settings.isLimitPageSize() ? DbImplUtil.adjustPageSize(settings.getPageSize(), dbms) : -1;
    }

    private static int adjustPageSize(int pageSize, @Nullable Dbms dbms) {
        if (dbms == null || !dbms.is(Dbms.MONGO)) {
            return pageSize;
        }
        int registrySize = Registry.intValue((String)"database.mongodb.page.size.limit", (int)20);
        return Math.min(Math.max(1, registrySize), pageSize);
    }

    public static boolean writeVFSAttributeSafe(@NotNull VirtualFile file, @NotNull FileAttribute attribute, @Nullable String value2) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(110);
        }
        if (attribute == null) {
            DbImplUtil.$$$reportNull$$$0(111);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return false;
        }
        try {
            return DbImplUtil.writeVFSAttribute(file, attribute, value2);
        }
        catch (IOException ex) {
            LOG.warn((Throwable)ex);
            return false;
        }
    }

    @Nullable
    public static String readVFSAttributeSafe(@NotNull VirtualFile file, @NotNull FileAttribute attribute) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(112);
        }
        if (attribute == null) {
            DbImplUtil.$$$reportNull$$$0(113);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return null;
        }
        try {
            return DbImplUtil.readVFSAttribute(file, attribute);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static boolean writeVFSAttribute(@NotNull VirtualFile fileOrDir, @NotNull FileAttribute attribute, @Nullable String value2) throws IOException {
        String oldValue;
        if (fileOrDir == null) {
            DbImplUtil.$$$reportNull$$$0(114);
        }
        if (attribute == null) {
            DbImplUtil.$$$reportNull$$$0(115);
        }
        if (Objects.equals(oldValue = DbImplUtil.readVFSAttribute(fileOrDir, attribute), value2)) {
            return false;
        }
        try (DataOutputStream oStream = attribute.writeAttribute(fileOrDir);){
            DataInputOutputUtil.writeINT((DataOutput)oStream, (int)DbImplUtil.enumerateDialectName(value2));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String readVFSAttribute(VirtualFile fileOrDir, FileAttribute attribute) throws IOException {
        DataInputStream iStream = attribute.readAttribute(fileOrDir);
        if (iStream != null) {
            try {
                String string = StringUtil.nullize((String)((String)myDialectAndDataSourcesEnumerator.getById(DataInputOutputUtil.readINT((DataInput)iStream))));
                return string;
            }
            finally {
                iStream.close();
            }
        }
        return null;
    }

    public static void initLanguageComboBox(JComboBox<Language> comboBox, boolean allowNull) {
        ArrayList<Object> languages2 = new ArrayList<Object>();
        if (allowNull) {
            languages2.add(null);
        }
        languages2.addAll(SqlDialects.getTopLevelSqlDialects());
        Language mongo = DbSqlUtil.getLanguage(Dbms.MONGO);
        if (DbSqlUtilCore.getDbms(mongo) == Dbms.MONGO) {
            languages2.add(mongo);
        }
        comboBox.setModel((ComboBoxModel<Language>)new CollectionComboBoxModel(languages2));
        comboBox.setEditable(false);
        comboBox.setRenderer((ListCellRenderer<Language>)SimpleListCellRenderer.create((label, language, index2) -> {
            if (language == null) {
                label.setText(DatabaseBundle.message((String)"label.default", (Object[])new Object[0]));
                label.setIcon(null);
            } else {
                if (language instanceof SqlLanguageDialect) {
                    label.setIcon(((SqlLanguageDialect)language).getIcon());
                } else {
                    LanguageFileType fileType = language.getAssociatedFileType();
                    label.setIcon(fileType == null ? null : fileType.getIcon());
                }
                label.setText(language.getDisplayName());
            }
        }));
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriver(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(116);
        }
        return dbms == Dbms.UNKNOWN ? null : (DatabaseDriver)JBIterable.from(DatabaseDriverManager.getInstance().getDrivers()).filter(o -> DbImplUtil.getDbms(o) == dbms).sort((o1, o2) -> o1.isPredefined() ? (o2.isPredefined() ? 0 : -1) : (o2.isPredefined() ? 1 : 0)).first();
    }

    @NotNull
    public static Dbms getDbms(@Nullable DatabaseDriver o) {
        if (o == null) {
            Dbms dbms = Dbms.UNKNOWN;
            if (dbms == null) {
                DbImplUtil.$$$reportNull$$$0(117);
            }
            return dbms;
        }
        if (o.getForcedDbms() != null) {
            Dbms dbms = o.getForcedDbms();
            if (dbms == null) {
                DbImplUtil.$$$reportNull$$$0(118);
            }
            return dbms;
        }
        if (o.isPredefined()) {
            Dbms dbms = Dbms.fromString((String)o.getId());
            if (dbms == Dbms.DB2) {
                SqlLanguageDialect dialect;
                String dialectId = o.getSqlDialect();
                SqlLanguageDialect sqlLanguageDialect = dialect = dialectId == null ? null : SqlDialects.findDialectById(dialectId);
                if (dialect != null && dialect.getDbms().isDb2()) {
                    Dbms dbms2 = dialect.getDbms();
                    if (dbms2 == null) {
                        DbImplUtil.$$$reportNull$$$0(119);
                    }
                    return dbms2;
                }
            }
            Dbms dbms3 = dbms;
            if (dbms3 == null) {
                DbImplUtil.$$$reportNull$$$0(120);
            }
            return dbms3;
        }
        Dbms dbms = Dbms.fromString((String)o.getDriverClass());
        if (dbms == Dbms.UNKNOWN || o.getSqlDialect() == null) {
            Dbms dbms4 = dbms;
            if (dbms4 == null) {
                DbImplUtil.$$$reportNull$$$0(121);
            }
            return dbms4;
        }
        if (SqlDialects.isGenericDialect(DbSqlUtilCore.getSqlDialect(dbms))) {
            Dbms dbms5 = dbms;
            if (dbms5 == null) {
                DbImplUtil.$$$reportNull$$$0(122);
            }
            return dbms5;
        }
        SqlLanguageDialect dialect = SqlDialects.findDialectById(o.getSqlDialect());
        Dbms dbms6 = dialect == null || SqlDialects.isGenericDialect(dialect) ? dbms : dialect.getDbms();
        if (dbms6 == null) {
            DbImplUtil.$$$reportNull$$$0(123);
        }
        return dbms6;
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriver(@NotNull RawConnectionConfig info) {
        if (info == null) {
            DbImplUtil.$$$reportNull$$$0(124);
        }
        return DbImplUtil.guessDatabaseDriver(DatabaseDriverManager.getInstance().getDrivers(), info);
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriver(@NotNull Collection<? extends DatabaseDriver> allDrivers, @NotNull RawConnectionConfig info) {
        if (allDrivers == null) {
            DbImplUtil.$$$reportNull$$$0(125);
        }
        if (info == null) {
            DbImplUtil.$$$reportNull$$$0(126);
        }
        SmartList matchedDrivers = new SmartList();
        if (info.getDriverClass() == null) {
            matchedDrivers.addAll(allDrivers);
        } else {
            for (DatabaseDriver databaseDriver : allDrivers) {
                if (!Objects.equals(info.getDriverClass(), databaseDriver.getDriverClass())) continue;
                matchedDrivers.add(databaseDriver);
            }
        }
        if (matchedDrivers.isEmpty()) {
            return null;
        }
        if (matchedDrivers.size() == 1) {
            return (DatabaseDriver)matchedDrivers.get(0);
        }
        String url = StringUtil.notNullize((String)info.getUrl());
        ArrayList<DatabaseDriver> arrayList = new ArrayList<DatabaseDriver>(matchedDrivers.size());
        for (DatabaseDriver driver : matchedDrivers) {
            if (!driver.matchesUrl(url)) continue;
            arrayList.add(driver);
        }
        if (arrayList.isEmpty()) {
            return (DatabaseDriver)matchedDrivers.get(0);
        }
        if (arrayList.size() == 1) {
            return (DatabaseDriver)arrayList.get(0);
        }
        return DbImplUtil.disambiguate(url, (JBIterable<DatabaseDriver>)JBIterable.from(arrayList));
    }

    @Nullable
    public static DatabaseDriver disambiguate(@NotNull String url, @NotNull JBIterable<DatabaseDriver> drivers) {
        if (url == null) {
            DbImplUtil.$$$reportNull$$$0(127);
        }
        if (drivers == null) {
            DbImplUtil.$$$reportNull$$$0(128);
        }
        if (StringUtil.containsIgnoreCase((String)url, (String)"database.windows.net")) {
            return (DatabaseDriver)drivers.filter(d2 -> DbImplUtil.likelyAzureDriver(d2)).append(drivers).first();
        }
        if (StringUtil.containsIgnoreCase((String)url, (String)"redshift.amazonaws.com")) {
            return (DatabaseDriver)drivers.filter(d2 -> DbImplUtil.likelyRedshiftDriver(d2)).append(drivers).first();
        }
        return (DatabaseDriver)drivers.filter(d2 -> !DbImplUtil.likelyAzureDriver(d2) && !DbImplUtil.likelyRedshiftDriver(d2) && !DbImplUtil.likelyGreenplumDriver(d2)).append(drivers).first();
    }

    private static boolean likelyRedshiftDriver(DatabaseDriver driver) {
        return DbImplUtil.getDbms(driver) == Dbms.REDSHIFT;
    }

    private static boolean likelyGreenplumDriver(DatabaseDriver driver) {
        return DbImplUtil.getDbms(driver) == Dbms.GREENPLUM;
    }

    private static boolean likelyAzureDriver(DatabaseDriver driver) {
        return DbImplUtil.getDbms(driver) == Dbms.AZURE || StringUtil.containsIgnoreCase((String)driver.getName(), (String)"azure");
    }

    @NotNull
    public static JBTreeTraverser<DasObject> traverseVisibleObjects(@NotNull DasDataSource ds) {
        if (ds == null) {
            DbImplUtil.$$$reportNull$$$0(129);
        }
        TreePattern scope = DbImplUtil.getIntrospectionScope(ds);
        JBTreeTraverser traverser = (JBTreeTraverser)DasUtil.dasTraverser().withRoots((Iterable)ds.getModel().getModelRoots());
        JBTreeTraverser jBTreeTraverser = scope == null ? traverser : (JBTreeTraverser)traverser.expandAndFilter(o -> DataSourceSchemaMapping.isIntrospected(scope, o));
        if (jBTreeTraverser == null) {
            DbImplUtil.$$$reportNull$$$0(130);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public static LocalDataSource getLocalDataSource(@Nullable DasDataSource info) {
        DasDataSource dataSource2 = DbImplUtil.unwrapDS(info);
        if (dataSource2 instanceof LocalDataSource) {
            LocalDataSource localDataSource = (LocalDataSource)dataSource2;
            if (localDataSource == null) {
                DbImplUtil.$$$reportNull$$$0(131);
            }
            return localDataSource;
        }
        throw new AssertionError(info);
    }

    public static void setActionCallbackDone(@Nullable AsyncPromise<Void> callback, boolean done, @Nullable String reason, @NotNull ModalityState modalityState) {
        if (modalityState == null) {
            DbImplUtil.$$$reportNull$$$0(132);
        }
        if (callback == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (done) {
                callback.setResult(null);
            } else {
                callback.setError(StringUtil.isEmptyOrSpaces((String)reason) ? "not done" : reason);
            }
        }, modalityState);
    }

    public static void setActionCallbackDone(@Nullable AsyncPromise<Void> callback, boolean done, @NotNull ModalityState state) {
        if (state == null) {
            DbImplUtil.$$$reportNull$$$0(133);
        }
        DbImplUtil.setActionCallbackDone(callback, done, null, state);
    }

    @NotNull
    public static EnumSet<ReservedCellValue> getSpecialValues(@Nullable DasColumn databaseColumn, @NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(134);
        }
        EnumSet<ReservedCellValue> result = EnumSet.noneOf(ReservedCellValue.class);
        if (dbms.in(Dbms.DOCUMENT_ORIENTED)) {
            result.add(ReservedCellValue.UNSET);
        }
        if (databaseColumn == null) {
            result.add(ReservedCellValue.NULL);
            EnumSet<ReservedCellValue> enumSet = result;
            if (enumSet == null) {
                DbImplUtil.$$$reportNull$$$0(135);
            }
            return enumSet;
        }
        if (DasUtil.isAutoGenerated((DasColumn)databaseColumn)) {
            result.add(ReservedCellValue.GENERATED);
        }
        if (DasUtil.isComputed((DasColumn)databaseColumn)) {
            result.add(ReservedCellValue.COMPUTED);
        }
        if (!databaseColumn.isNotNull()) {
            result.add(ReservedCellValue.NULL);
        }
        if (databaseColumn.getDefault() != null) {
            result.add(ReservedCellValue.DEFAULT);
        }
        EnumSet<ReservedCellValue> enumSet = result;
        if (enumSet == null) {
            DbImplUtil.$$$reportNull$$$0(136);
        }
        return enumSet;
    }

    public static boolean isZonedTimestampColumn(@NotNull ColumnDescriptor column2, @NotNull Dbms dbms) {
        if (column2 == null) {
            DbImplUtil.$$$reportNull$$$0(137);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(138);
        }
        return DbImplUtil.getJdbcHelper(dbms).isZonedTimestampColumn(column2.getTypeName(), column2.getType());
    }

    public static boolean isZonedTimeColumn(@NotNull ColumnDescriptor column2, @NotNull Dbms dbms) {
        if (column2 == null) {
            DbImplUtil.$$$reportNull$$$0(139);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(140);
        }
        return DbImplUtil.getJdbcHelper(dbms).isZonedTimeColumn(column2.getTypeName());
    }

    @Nullable
    public static SearchPath getAutoSwitchPath(@Nullable LocalDataSource dataSource2, @Nullable SearchPath path) {
        SchemaControl control;
        if (path == null) {
            return null;
        }
        SchemaControl schemaControl = control = dataSource2 == null ? SchemaControl.AUTOMATIC : dataSource2.getSchemaControl();
        if (control == SchemaControl.AUTOMATIC) {
            return path;
        }
        return DbImplUtil.getDatabaseToSwitch(dataSource2, path);
    }

    @Nullable
    public static SearchPath getDatabaseToSwitch(@Nullable LocalDataSource dataSource2, @Nullable SearchPath path) {
        return path == null ? null : SearchPath.of((ObjectPath)path.getCurrent().findParent(ObjectKind.DATABASE, false));
    }

    private static boolean isSuitable(@NotNull ColumnDescriptor descriptor2, @NotNull Dbms dbms) {
        if (descriptor2 == null) {
            DbImplUtil.$$$reportNull$$$0(141);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(142);
        }
        int type = descriptor2.getType();
        String typeName = descriptor2.getTypeName();
        return !(type == 2004 || type == 2005 || type == 2011 || StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"xml") && dbms.isMicrosoft() || type == 2009 && (dbms.isPostgres() || dbms.isOracle()) || dbms.isPostgres() && !PgBaseJdbcHelper.canCompare((String)typeName));
    }

    @Nullable
    public static Version getDatabaseVersion(@Nullable DasDataSource dataSource2) {
        return dataSource2 == null ? null : dataSource2.getVersion();
    }

    @Nullable
    public static Project getAnyProject() {
        return (Project)ContainerUtil.find((Object[])ProjectManager.getInstance().getOpenProjects(), p2 -> !p2.isDefault());
    }

    @NotNull
    public static String searchPathPresentation(List<ObjectPath> schemas) {
        StringBuilder res2 = new StringBuilder();
        int pos = 0;
        while (pos < schemas.size()) {
            if (res2.length() != 0) {
                res2.append("; ");
            }
            ObjectPath cur2 = schemas.get(pos);
            if (++pos < schemas.size() && cur2.parent != null && cur2.parent.equals(schemas.get((int)pos).parent)) {
                res2.append(cur2.parent.getDisplayName());
                res2.append(": ");
                res2.append(cur2.getName()).append(", ").append(schemas.get(pos).getName());
                ++pos;
                while (pos < schemas.size() && cur2.parent.equals(schemas.get((int)pos).parent)) {
                    res2.append(", ").append(schemas.get(pos).getName());
                    ++pos;
                }
                continue;
            }
            res2.append(cur2.getDisplayName());
        }
        String string = res2.toString();
        if (string == null) {
            DbImplUtil.$$$reportNull$$$0(143);
        }
        return string;
    }

    private static String getNameQuotingAware(@NotNull DasObject object, @NotNull NamingService namingService) {
        if (object == null) {
            DbImplUtil.$$$reportNull$$$0(144);
        }
        if (namingService == null) {
            DbImplUtil.$$$reportNull$$$0(145);
        }
        String name = object.getName();
        return object.isQuoted() ? namingService.enquote(name, object.getKind()) : name;
    }

    @NotNull
    @NonNls
    public static String renderRoutineHeader(@NotNull DasRoutine routine, @NotNull Dbms dbms) {
        if (routine == null) {
            DbImplUtil.$$$reportNull$$$0(146);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(147);
        }
        StringBuilder builder = new StringBuilder();
        NamingService namingService = NamingServices.getNamingService(dbms);
        builder.append(routine.getRoutineKind());
        builder.append(" ");
        builder.append(DbImplUtil.getNameQuotingAware((DasObject)routine, namingService));
        builder.append("(");
        for (DasArgument argument : routine.getArguments()) {
            builder.append(StringUtil.defaultIfEmpty((String)DbImplUtil.getNameQuotingAware((DasObject)argument, namingService), (String)"?"));
            builder.append(" ");
            builder.append(StringUtil.notNullize((String)argument.getDataType().getSpecification()));
        }
        builder.append(")");
        DasArgument returnArgument = routine.getReturnArgument();
        if (returnArgument != null) {
            builder.append(" ");
            builder.append(dbms.isOracle() || dbms.isVertica() ? "return" : "returns");
            builder.append(" ");
            builder.append(StringUtil.notNullize((String)returnArgument.getDataType().getSpecification()));
        }
        String string = builder.toString();
        if (string == null) {
            DbImplUtil.$$$reportNull$$$0(148);
        }
        return string;
    }

    private static boolean isChildrenAccessible(@Nullable DasObject parent2, @NotNull DasObject child, Map<DasObject, Boolean> cache, Condition<? super DasObject> expandCondition) {
        if (child == null) {
            DbImplUtil.$$$reportNull$$$0(149);
        }
        if (parent2 == null || parent2.getKind() == ObjectKind.ROOT) {
            return true;
        }
        Boolean res2 = cache.get(parent2);
        if (res2 == null) {
            res2 = DbImplUtil.isChildrenAccessible(parent2.getDasParent(), parent2, cache, expandCondition) && expandCondition.value((Object)parent2);
            cache.put(parent2, res2);
        }
        return res2;
    }

    public static boolean processCandidates(JBIterable<DasObject> candidates2, Condition<? super DasObject> expandCondition, BooleanFunction<? super DasObject> processor) {
        HashMap<DasObject, Boolean> cache = new HashMap<DasObject, Boolean>();
        for (DasObject candidate : candidates2) {
            if (!DbImplUtil.isChildrenAccessible(candidate.getDasParent(), candidate, cache, expandCondition) || processor.fun((Object)candidate)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static LocalDataSource getMaybeLocalDataSource(@Nullable DasDataSource info) {
        return (LocalDataSource)ObjectUtils.tryCast((Object)((Object)DbImplUtilCore.getMaybeLocalDataSource(info)), LocalDataSource.class);
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@Nullable Dbms dbms) {
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.tryCast((Object)DbImplUtilCore.getDatabaseDialect(dbms), DatabaseDialectEx.class);
        if (databaseDialectEx == null) {
            DbImplUtil.$$$reportNull$$$0(150);
        }
        return databaseDialectEx;
    }

    private static /* synthetic */ boolean lambda$getWhereClauseColumns$8(Set set, ColumnDescriptor descriptor2) {
        return set.contains(descriptor2.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 26: 
            case 28: 
            case 30: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 85: 
            case 86: 
            case 104: 
            case 105: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 143: 
            case 148: 
            case 150: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 26: 
            case 28: 
            case 30: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 85: 
            case 86: 
            case 104: 
            case 105: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 143: 
            case 148: 
            case 150: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lob";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 44: 
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 24: 
            case 29: 
            case 37: 
            case 39: 
            case 45: 
            case 51: 
            case 55: 
            case 84: 
            case 89: 
            case 100: 
            case 108: 
            case 109: 
            case 116: 
            case 134: 
            case 138: 
            case 140: 
            case 142: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 7: 
            case 14: 
            case 71: 
            case 72: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 11: 
            case 12: 
            case 26: 
            case 28: 
            case 30: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 85: 
            case 86: 
            case 104: 
            case 105: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 143: 
            case 148: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbImplUtil";
                break;
            }
            case 13: 
            case 19: 
            case 25: 
            case 27: 
            case 42: 
            case 47: 
            case 49: 
            case 56: 
            case 61: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 17: 
            case 18: 
            case 43: 
            case 57: 
            case 58: 
            case 69: 
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 23: 
            case 36: 
            case 38: 
            case 107: 
            case 137: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 31: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fkey";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refColNames";
                break;
            }
            case 34: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defClazz";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromToken";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toToken";
                break;
            }
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionInfo";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 73: 
            case 94: 
            case 103: 
            case 110: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 81: 
            case 90: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 87: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteConnection";
                break;
            }
            case 95: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectFormatter";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 111: 
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 124: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDrivers";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drivers";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namingService";
                break;
            }
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbImplUtil";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findFreeAlias";
                break;
            }
            case 26: 
            case 64: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelHelper";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 62: 
            case 67: 
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhereClauseColumns";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourcesForExec";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseVisibleObjects";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalDataSource";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialValues";
                break;
            }
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "searchPathPresentation";
                break;
            }
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "renderRoutineHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "guessCharsetFromContent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "clobStringEquals";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderForExec";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderForUIExec";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findFreeAlias";
                break;
            }
            case 11: 
            case 12: 
            case 26: 
            case 28: 
            case 30: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 85: 
            case 86: 
            case 104: 
            case 105: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 143: 
            case 148: 
            case 150: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isConnected";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getActiveConnectionCount";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasDriverFiles";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canConnectTo";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseConnection";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isRemoteProcessDown";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setStatementParameter";
                break;
            }
            case 25: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getDbms";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getModelHelper";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "familyOf";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "resolveKey";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "prepareValue";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "prepareDate";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "canInsertBlob";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "canInsertClob";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "clobFromFile";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "blobFromFile";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadViewDefinition";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathObjectForSwitch";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathObject";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadProcedureDefinition";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "replaceTokenInDefinition";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isEditableTable";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getMetaModel";
                break;
            }
            case 61: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "hasUniqueIndex";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "supportsDynamicSchemaSwitching";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadPackageDefinition";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "findSourceVirtualFile";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "canSwitchTo";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathSql";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "switchSchemaThroughJdbc";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getWhereClauseColumns";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "isSchema";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "supportsReadOnlyChangeOnTheFly";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "tryToSetReadOnly";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "supportsReadOnlyChangeDuringTx";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "findDataSourceByFile";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "isTableFile";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "defaultWhereCondition";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "formatValues";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "formatValue";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getCount";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourcesForExec";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "composeWhereItemWithParameters";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "escapeSql";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "writeVFSAttributeSafe";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "readVFSAttributeSafe";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "writeVFSAttribute";
                break;
            }
            case 116: 
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "guessDatabaseDriver";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "disambiguate";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "traverseVisibleObjects";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "setActionCallbackDone";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "getSpecialValues";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "isZonedTimestampColumn";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "isZonedTimeColumn";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "getNameQuotingAware";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "renderRoutineHeader";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "isChildrenAccessible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 26: 
            case 28: 
            case 30: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 67: 
            case 85: 
            case 86: 
            case 104: 
            case 105: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 143: 
            case 148: 
            case 150: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class HashingStrategyUnique<T>
    extends JBIterable.SCond<T>
    implements TObjectHashingStrategy<T> {
        private Set<T> myVisited;

        public boolean value(T t) {
            if (this.myVisited == null) {
                this.myVisited = new THashSet((TObjectHashingStrategy)this);
            }
            return this.myVisited.add(t);
        }
    }

    public static class ImmutableMap {
        public static <K, V> ContainerUtil.ImmutableMapBuilder<K, V> put(K key, V value2) {
            return ContainerUtil.immutableMapBuilder().put(key, value2);
        }
    }

    public static enum StringLiteralDecorator {
        CONTAINS("%", "%", true),
        STARTS_WITH(null, "%", true),
        ENDS_WITH("%", null, true),
        MATCHES(null, null, true),
        PLAIN(null, null, false);

        private final String myPrefix;
        private final String mySuffix;
        private final boolean myEscapeSqlRegexSymbols;

        private StringLiteralDecorator(String prefix, String suffix, boolean escapeSqlRegexSymbols) {
            this.myPrefix = prefix;
            this.mySuffix = suffix;
            this.myEscapeSqlRegexSymbols = escapeSqlRegexSymbols;
        }

        @NotNull
        public String decorate(@NotNull String text2, @NotNull Dbms dbms) {
            if (text2 == null) {
                StringLiteralDecorator.$$$reportNull$$$0(0);
            }
            if (dbms == null) {
                StringLiteralDecorator.$$$reportNull$$$0(1);
            }
            String string = this.decorate(text2, dbms, null);
            if (string == null) {
                StringLiteralDecorator.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String decorate(@NotNull String text2, @NotNull Dbms dbms, @Nullable JdbcHelper helper) {
            if (text2 == null) {
                StringLiteralDecorator.$$$reportNull$$$0(3);
            }
            if (dbms == null) {
                StringLiteralDecorator.$$$reportNull$$$0(4);
            }
            String string = DbSqlUtil.toStringLiteral(text2, dbms, this.myEscapeSqlRegexSymbols, this.myPrefix, this.mySuffix, helper != null ? helper : DbImplUtilCore.getJdbcHelper(dbms));
            if (string == null) {
                StringLiteralDecorator.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/DbImplUtil$StringLiteralDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/DbImplUtil$StringLiteralDecorator";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "decorate";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

