/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.intellij.openapi.util.Couple;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public abstract class CollectionUtils {
    @NotNull
    public static <T> ImmutableList<T> concat(@NotNull ImmutableList<T> listA, @NotNull ImmutableList<T> listB) {
        if (listA == null) {
            CollectionUtils.$$$reportNull$$$0(0);
        }
        if (listB == null) {
            CollectionUtils.$$$reportNull$$$0(1);
        }
        int nA = listA.size();
        int nB = listB.size();
        if (nB == 0) {
            ImmutableList<T> immutableList = listA;
            if (immutableList == null) {
                CollectionUtils.$$$reportNull$$$0(2);
            }
            return immutableList;
        }
        if (nA == 0) {
            ImmutableList<T> immutableList = listB;
            if (immutableList == null) {
                CollectionUtils.$$$reportNull$$$0(3);
            }
            return immutableList;
        }
        ImmutableList.Builder b2 = ImmutableList.builder();
        b2.addAll(listA);
        b2.addAll(listB);
        ImmutableList immutableList = b2.build();
        if (immutableList == null) {
            CollectionUtils.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    @NotNull
    public static <T> ImmutableList<T> concat(List<T> ... lists) {
        if (lists == null) {
            CollectionUtils.$$$reportNull$$$0(5);
        }
        switch (lists.length) {
            case 0: {
                ImmutableList immutableList = ImmutableList.of();
                if (immutableList == null) {
                    CollectionUtils.$$$reportNull$$$0(6);
                }
                return immutableList;
            }
            case 1: {
                ImmutableList immutableList = ImmutableList.copyOf(lists[0]);
                if (immutableList == null) {
                    CollectionUtils.$$$reportNull$$$0(7);
                }
                return immutableList;
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List<T> list : lists) {
            builder.addAll(list);
        }
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            CollectionUtils.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    @NotNull
    public static <K extends Comparable<K>, T> ImmutableSortedMap<K, Couple<T>> sortingMerge(@NotNull Iterable<? extends T> collectionA, @NotNull Iterable<? extends T> collectionB, @NotNull Function<? super T, ? extends K> keyFunction) {
        Comparable k;
        if (collectionA == null) {
            CollectionUtils.$$$reportNull$$$0(9);
        }
        if (collectionB == null) {
            CollectionUtils.$$$reportNull$$$0(10);
        }
        if (keyFunction == null) {
            CollectionUtils.$$$reportNull$$$0(11);
        }
        TreeMap<Comparable, T> mapA = new TreeMap<Comparable, T>();
        TreeMap<Comparable, T> mapB = new TreeMap<Comparable, T>();
        for (T a2 : collectionA) {
            k = (Comparable)keyFunction.apply(a2);
            mapA.put(k, a2);
        }
        for (T b2 : collectionB) {
            k = (Comparable)keyFunction.apply(b2);
            mapB.put(k, b2);
        }
        ImmutableSortedSet keys = CollectionUtils.union(mapA.navigableKeySet(), mapB.navigableKeySet());
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Comparable key : keys) {
            Object a3 = mapA.get(key);
            Object b3 = mapB.get(key);
            builder.put((Object)key, (Object)Couple.of(a3, b3));
        }
        ImmutableSortedMap immutableSortedMap = builder.build();
        if (immutableSortedMap == null) {
            CollectionUtils.$$$reportNull$$$0(12);
        }
        return immutableSortedMap;
    }

    public static <T extends Comparable<T>> ImmutableSortedSet<T> union(SortedSet<T> setA, SortedSet<T> setB) {
        int nB;
        int nA = setA == null ? 0 : setA.size();
        int n = nB = setB == null ? 0 : setB.size();
        if (nA == 0 && nB == 0) {
            return ImmutableSortedSet.of();
        }
        if (nB == 0) {
            return ImmutableSortedSet.copyOf(setA);
        }
        if (nA == 0) {
            return ImmutableSortedSet.copyOf(setB);
        }
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        if (nA >= nB) {
            builder.addAll(setA);
            for (Comparable b2 : setB) {
                if (setA.contains(b2)) continue;
                builder.add((Object)b2);
            }
        } else {
            builder.addAll(setB);
            for (Comparable a2 : setA) {
                if (setB.contains(a2)) continue;
                builder.add((Object)a2);
            }
        }
        return builder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listA";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listB";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/CollectionUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionA";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionB";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/CollectionUtils";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sortingMerge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sortingMerge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

