/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

import com.intellij.database.types.DasAliasDefinedType;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasBuiltinWrapperType;
import com.intellij.database.types.DasType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlUserTypeDefinition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0007\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u000b\u001a\n\u0010\f\u001a\u00020\r*\u00020\r\u00a8\u0006\u000e"}, d2={"createAliasType", "Lcom/intellij/database/types/DasAliasDefinedType;", "definition", "Lcom/intellij/sql/psi/SqlUserTypeDefinition;", "renderScale", "", "scale", "", "renderSize", "size", "unwrap", "Lcom/intellij/database/types/DasBuiltinType;", "unwrapAlias", "Lcom/intellij/database/types/DasType;", "intellij.database.core.impl"})
public final class DasTypeUtilsKt {
    @Nullable
    public static final String renderSize(int size) {
        String string;
        switch (size) {
            case -1: {
                string = null;
                break;
            }
            case 0x7FFFFFFE: {
                string = "*";
                break;
            }
            case 0x7FFFFFFF: {
                string = "max";
                break;
            }
            default: {
                string = String.valueOf(size);
            }
        }
        return string;
    }

    @Nullable
    public static final String renderScale(int scale) {
        return scale != 0 ? String.valueOf(scale) : null;
    }

    @NotNull
    public static final DasBuiltinType unwrap(@NotNull DasBuiltinType $this$unwrap) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrap, (String)"$this$unwrap");
        return $this$unwrap instanceof DasBuiltinWrapperType ? ((DasBuiltinWrapperType)$this$unwrap).getInnerType() : $this$unwrap;
    }

    @NotNull
    public static final DasType unwrapAlias(@NotNull DasType $this$unwrapAlias) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrapAlias, (String)"$this$unwrapAlias");
        return $this$unwrapAlias instanceof DasAliasDefinedType ? ((DasAliasDefinedType)$this$unwrapAlias).getInnerType() : $this$unwrapAlias;
    }

    @NotNull
    public static final DasAliasDefinedType createAliasType(@NotNull SqlUserTypeDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        return new DasAliasDefinedType(definition){
            final /* synthetic */ SqlUserTypeDefinition $definition;

            @NotNull
            public SqlUserTypeDefinition getDefinition() {
                return this.$definition;
            }

            @NotNull
            public DasType getInnerType() {
                SqlTypeElement sqlTypeElement = this.$definition.getAliasedTypeElement();
                if (sqlTypeElement == null || (sqlTypeElement = sqlTypeElement.getDasType()) == null) {
                    DasType dasType = DasType.UNKNOWN;
                    sqlTypeElement = dasType;
                    Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"DasType.UNKNOWN");
                }
                return sqlTypeElement;
            }
            {
                this.$definition = $captured_local_variable$0;
            }
        };
    }
}

