/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

import com.intellij.database.model.DasNamed;
import com.intellij.database.types.DasScope;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u0010\r\u001a\u00020\tH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/types/DasSimpleScope;", "T", "Lcom/intellij/database/model/DasNamed;", "Lcom/intellij/database/types/DasScope;", "elements", "", "(Ljava/lang/Iterable;)V", "itemMap", "Lcom/intellij/util/containers/MultiMap;", "", "getAllElements", "", "getElementsByName", "name", "intellij.database.core.impl"})
public final class DasSimpleScope<T extends DasNamed>
implements DasScope<T> {
    private final MultiMap<String, T> itemMap;

    @NotNull
    public Collection<T> getAllElements() {
        Collection collection = this.itemMap.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"itemMap.values()");
        return collection;
    }

    @NotNull
    public Collection<T> getElementsByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Collection collection = this.itemMap.get((Object)name);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"itemMap[name]");
        return collection;
    }

    public DasSimpleScope(@NotNull Iterable<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.itemMap = new MultiMap();
        for (DasNamed element2 : elements) {
            this.itemMap.putValue((Object)element2.getName(), (Object)element2);
        }
    }
}

