/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasTypeUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0010\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\tH\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\r\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u001fH\u0016J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/intellij/database/types/DasBuiltinTypeWithLengthUnits;", "Lcom/intellij/database/types/DasBuiltinType;", "name", "", "length", "", "unit", "Lcom/intellij/database/model/LengthUnit;", "isExplicitUnit", "", "(Ljava/lang/String;ILcom/intellij/database/model/LengthUnit;Z)V", "()Z", "getLength", "()I", "getUnit", "()Lcom/intellij/database/model/LengthUnit;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "getKind", "Lcom/intellij/database/types/DasBuiltinType$Kind;", "getName", "hashCode", "render", "toDataType", "Lcom/intellij/database/model/DataType;", "Lorg/jetbrains/annotations/NotNull;", "toString", "intellij.database.core.impl"})
public final class DasBuiltinTypeWithLengthUnits
implements DasBuiltinType {
    private final String name;
    private final int length;
    @NotNull
    private final LengthUnit unit;
    private final boolean isExplicitUnit;

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public DasBuiltinType.Kind getKind() {
        return DasBuiltinType.Kind.STRING;
    }

    @NotNull
    public String render() {
        String string = DasTypeUtilsKt.renderSize(this.length);
        if (string == null) {
            return this.name;
        }
        String lengthStr = string;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        $this$buildString.append(this.name);
        $this$buildString.append("(");
        $this$buildString.append(lengthStr);
        if (Intrinsics.areEqual((Object)this.unit, (Object)LengthUnit.NONE) ^ true && this.isExplicitUnit) {
            $this$buildString.append(" ").append(this.unit.suffix);
        }
        $this$buildString.append(")");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    public DataType toDataType() {
        DataType dataType = DataTypeFactory.of(null, this.name, this.length, 0, this.unit, null, this.isExplicitUnit, false);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataTypeFactory.of(\n    \u2026isExplicitUnit, false\n  )");
        return dataType;
    }

    public final int getLength() {
        return this.length;
    }

    @NotNull
    public final LengthUnit getUnit() {
        return this.unit;
    }

    public final boolean isExplicitUnit() {
        return this.isExplicitUnit;
    }

    public DasBuiltinTypeWithLengthUnits(@NotNull String name, int length, @NotNull LengthUnit unit, boolean isExplicitUnit) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this.name = name;
        this.length = length;
        this.unit = unit;
        this.isExplicitUnit = isExplicitUnit;
    }

    public /* synthetic */ DasBuiltinTypeWithLengthUnits(String string, int n, LengthUnit lengthUnit, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        if ((n2 & 4) != 0) {
            LengthUnit lengthUnit2 = LengthUnit.NONE;
            Intrinsics.checkNotNullExpressionValue((Object)lengthUnit2, (String)"LengthUnit.NONE");
            lengthUnit = lengthUnit2;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        this(string, n, lengthUnit, bl);
    }

    private final String component1() {
        return this.name;
    }

    public final int component2() {
        return this.length;
    }

    @NotNull
    public final LengthUnit component3() {
        return this.unit;
    }

    public final boolean component4() {
        return this.isExplicitUnit;
    }

    @NotNull
    public final DasBuiltinTypeWithLengthUnits copy(@NotNull String name, int length, @NotNull LengthUnit unit, boolean isExplicitUnit) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return new DasBuiltinTypeWithLengthUnits(name, length, unit, isExplicitUnit);
    }

    public static /* synthetic */ DasBuiltinTypeWithLengthUnits copy$default(DasBuiltinTypeWithLengthUnits dasBuiltinTypeWithLengthUnits, String string, int n, LengthUnit lengthUnit, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = dasBuiltinTypeWithLengthUnits.name;
        }
        if ((n2 & 2) != 0) {
            n = dasBuiltinTypeWithLengthUnits.length;
        }
        if ((n2 & 4) != 0) {
            lengthUnit = dasBuiltinTypeWithLengthUnits.unit;
        }
        if ((n2 & 8) != 0) {
            bl = dasBuiltinTypeWithLengthUnits.isExplicitUnit;
        }
        return dasBuiltinTypeWithLengthUnits.copy(string, n, lengthUnit, bl);
    }

    @NotNull
    public String toString() {
        return "DasBuiltinTypeWithLengthUnits(name=" + this.name + ", length=" + this.length + ", unit=" + this.unit + ", isExplicitUnit=" + this.isExplicitUnit + ")";
    }

    public int hashCode() {
        String string = this.name;
        LengthUnit lengthUnit = this.unit;
        int n = (((string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.length)) * 31 + (lengthUnit != null ? lengthUnit.hashCode() : 0)) * 31;
        int n2 = this.isExplicitUnit ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DasBuiltinTypeWithLengthUnits)) break block3;
                DasBuiltinTypeWithLengthUnits dasBuiltinTypeWithLengthUnits = (DasBuiltinTypeWithLengthUnits)object;
                if (!Intrinsics.areEqual((Object)this.name, (Object)dasBuiltinTypeWithLengthUnits.name) || this.length != dasBuiltinTypeWithLengthUnits.length || !Intrinsics.areEqual((Object)this.unit, (Object)dasBuiltinTypeWithLengthUnits.unit) || this.isExplicitUnit != dasBuiltinTypeWithLengthUnits.isExplicitUnit) break block3;
            }
            return true;
        }
        return false;
    }
}

