/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script;

import com.intellij.database.script.MongoJSLanguage;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.script.Script;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptModelUtilCore {
    public static final Key<Long> PART_OFFSET = Key.create((String)"PART_OFFSET");
    public static final Key<Integer> PART_INDEX = Key.create((String)"PART_INDEX");
    public static final Key<Integer> PART_ERRORS = Key.create((String)"PART_ERRORS");
    public static final Key<DatabaseSettings.SplitScriptMode> SPLIT_SCRIPT_MODE = Key.create((String)"SPLIT_SCRIPT_MODE");
    public static final Function<ScriptModel.ModelIt<?>, TextRange> TO_RANGE = it2 -> it2.range().shiftRight((int)it2.rangeOffset());
    public static final Function<ScriptModel.ModelIt<?>, String> TO_TEXT = it2 -> it2.text();
    public static final Function<ScriptModel.ModelIt<?>, IElementType> TO_TYPE = it2 -> it2.type();
    public static final Function<ScriptModel.ModelIt<?>, Object> TO_OBJECT = it2 -> it2.object();
    public static final Function<ScriptModel.ParamIt<?>, String> TO_NAME = it2 -> it2.name();

    protected ScriptModelUtilCore() {
    }

    @NotNull
    public static Condition<TextRange> INTERSECTS_RANGE(TextRange range) {
        Condition condition = r -> {
            int e;
            int s2 = Math.max(r.getStartOffset(), range.getStartOffset());
            if (s2 == (e = Math.min(r.getEndOffset(), range.getEndOffset()))) {
                return s2 == r.getEndOffset() || range.getLength() == 0;
            }
            return s2 < e;
        };
        if (condition == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(0);
        }
        return condition;
    }

    @NotNull
    public static Condition<TextRange> CONTAINS_RANGE(TextRange range) {
        Condition condition = r -> r.equals((Object)range) || r.contains(range);
        if (condition == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(1);
        }
        return condition;
    }

    @NotNull
    public static Condition<TextRange> IN_RANGE(TextRange range) {
        Condition condition = r -> range.contains(r);
        if (condition == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(2);
        }
        return condition;
    }

    @NotNull
    public static Condition<ScriptModel.ModelIt<?>> AT_OFFSET2(int offset) {
        Condition condition = o -> o.range().contains(offset);
        if (condition == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(3);
        }
        return condition;
    }

    @NotNull
    public static <V> Function<SyntaxTraverser<V>, SyntaxTraverser<V>> LIMIT_TO_RANGE(final TextRange range) {
        return new Function.Mono<SyntaxTraverser<V>>(){

            public SyntaxTraverser<V> fun(SyntaxTraverser<V> vs) {
                return ScriptModelUtilCore.inRange(vs, range);
            }
        };
    }

    @Nullable
    public static <V> DatabaseSettings.SplitScriptMode getSplitScriptMode(@NotNull Script<V> script) {
        if (script == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(4);
        }
        try {
            Iterator iterator = script.getScript().iterator();
            if (iterator.hasNext()) {
                SyntaxTraverser st = (SyntaxTraverser)iterator.next();
                return (DatabaseSettings.SplitScriptMode)((Object)st.getUserData(SPLIT_SCRIPT_MODE));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public static <V> ScriptModel<V> adjustModelForSelection(@NotNull ScriptModel<V> model, @NotNull Document document, @NotNull TextRange selectionRange, @NotNull DatabaseSettings.ExecOption execOption) {
        TextRange adjustedRange;
        if (model == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(5);
        }
        if (document == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(6);
        }
        if (selectionRange == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(7);
        }
        if (execOption == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(8);
        }
        int fixedOffset = (adjustedRange = ScriptModelUtilCore.adjustSelectionRange(model, document, selectionRange, execOption)).contains(selectionRange.getStartOffset()) ? selectionRange.getStartOffset() : adjustedRange.getStartOffset();
        ScriptModel scriptModel = selectionRange.getLength() == 0 ? model.subModel((TextRange)new ScriptModel.PositionRange(fixedOffset)) : model.subModel(adjustedRange);
        if (scriptModel == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(9);
        }
        return scriptModel;
    }

    @NotNull
    public static TextRange getSelectionForConsole(@Nullable Editor editor, @NotNull DatabaseSettings.ExecOption execOption) {
        if (execOption == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                ScriptModelUtilCore.$$$reportNull$$$0(11);
            }
            return textRange;
        }
        if (execOption.execSelection == 3) {
            TextRange textRange = EditorUtil.getSelectionInAnyMode((Editor)editor);
            if (textRange == null) {
                ScriptModelUtilCore.$$$reportNull$$$0(12);
            }
            return textRange;
        }
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        TextRange textRange = TextRange.create((int)caret.getSelectionStart(), (int)caret.getSelectionEnd());
        if (textRange == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(13);
        }
        return textRange;
    }

    @NotNull
    public static TextRange adjustSelectionRange(@NotNull ScriptModel<?> model, @NotNull Document document, @NotNull TextRange selectionRange, @NotNull DatabaseSettings.ExecOption execOption) {
        if (model == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(14);
        }
        if (document == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(15);
        }
        if (selectionRange == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(16);
        }
        if (execOption == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(17);
        }
        if (selectionRange.isEmpty()) {
            int lineEnd;
            int lineNumber;
            int lineStart;
            int lineStartFixed;
            CharSequence sequence = document.getCharsSequence();
            int sequenceLength = sequence.length();
            if (sequenceLength == 0) {
                TextRange textRange = selectionRange;
                if (textRange == null) {
                    ScriptModelUtilCore.$$$reportNull$$$0(18);
                }
                return textRange;
            }
            int offset = Math.min(sequenceLength - 1, selectionRange.getStartOffset());
            if (!Character.isWhitespace(sequence.charAt(offset))) {
                ++offset;
            }
            if ((lineStartFixed = EditorActionUtil.findFirstNonSpaceOffsetInRange((CharSequence)sequence, (int)(lineStart = document.getLineStartOffset(lineNumber = document.getLineNumber(offset))), (int)(lineEnd = document.getLineEndOffset(lineNumber)))) >= 0) {
                TextRange subRange = TextRange.create((int)lineStartFixed, (int)Math.max(lineStartFixed, offset));
                EvaluationHelper evaluationHelper = (EvaluationHelper)EvaluationHelper.EP.forLanguage(model.getLanguage());
                TextRange r = (TextRange)model.subModel((TextRange)new ScriptModel.PositionRange(subRange)).statements().filter(st -> evaluationHelper.isStatement(st.api()).value(st.object())).transform(TO_RANGE).last();
                if (r != null) {
                    TextRange textRange = r;
                    if (textRange == null) {
                        ScriptModelUtilCore.$$$reportNull$$$0(19);
                    }
                    return textRange;
                }
            }
            TextRange textRange = selectionRange;
            if (textRange == null) {
                ScriptModelUtilCore.$$$reportNull$$$0(20);
            }
            return textRange;
        }
        if (execOption.execSelection == 1) {
            return new ScriptModel.StrictRange(selectionRange);
        }
        if (execOption.execSelection == 2) {
            TextRange textRange = selectionRange;
            if (textRange == null) {
                ScriptModelUtilCore.$$$reportNull$$$0(21);
            }
            return textRange;
        }
        if (execOption.execSelection == 3) {
            ScriptModel.SmartRange smartRange = new ScriptModel.SmartRange(selectionRange);
            ScriptModel m = model.subModel((TextRange)smartRange);
            if (m.statements().take(2).size() > 1) {
                TextRange r = selectionRange;
                for (TextRange range : m.statements().transform(TO_RANGE)) {
                    r = r.union(range);
                }
                return new ScriptModel.SmartRange(r);
            }
            ScriptModel.SmartRange smartRange2 = smartRange;
            if (smartRange2 == null) {
                ScriptModelUtilCore.$$$reportNull$$$0(22);
            }
            return smartRange2;
        }
        throw new AssertionError(execOption.execSelection);
    }

    @NotNull
    public static <V> SyntaxTraverser<V> inRange(@NotNull SyntaxTraverser<V> s2, @NotNull TextRange range) {
        if (s2 == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(23);
        }
        if (range == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(24);
        }
        int partOffset = ScriptModelUtilCore.getPartOffsetAsInt(s2);
        if (range.getStartOffset() < partOffset) {
            SyntaxTraverser syntaxTraverser = (SyntaxTraverser)s2.expandAndFilter(Conditions.alwaysFalse());
            if (syntaxTraverser == null) {
                ScriptModelUtilCore.$$$reportNull$$$0(25);
            }
            return syntaxTraverser;
        }
        TextRange adjusted = range.shiftRight(-partOffset);
        SyntaxTraverser ranged = (SyntaxTraverser)s2.onRange(Conditions.compose((Function)s2.api.TO_RANGE, ScriptModelUtilCore.INTERSECTS_RANGE(adjusted)));
        SyntaxTraverser syntaxTraverser = range instanceof ScriptModel.ChosenRange ? (SyntaxTraverser)ranged.filter(Conditions.compose((Function)s2.api.TO_RANGE, ScriptModelUtilCore.IN_RANGE(adjusted))) : ranged;
        if (syntaxTraverser == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(26);
        }
        return syntaxTraverser;
    }

    public static int getPartOffsetAsInt(SyntaxTraverser<?> s2) {
        return (int)ScriptModelUtilCore.getPartOffset(s2);
    }

    public static long getPartOffset(SyntaxTraverser<?> s2) {
        Long o = (Long)s2.getUserData(PART_OFFSET);
        return o == null ? 0L : o;
    }

    public static <V> String statementText(ScriptModel.StatementIt<V> st, ScriptModel.PStorage storage, Condition<? super ScriptModel.ParamIt<V>> paramCondition) {
        JBIterable params = st.parameters().filter(Conditions.not(paramCondition));
        return ScriptModelUtilCore.statementText(storage, params, st.text(), st.range().getStartOffset());
    }

    @NotNull
    public static String statementText(@NotNull ScriptModel.PStorage storage, @NotNull JBIterable<? extends ScriptModel.ParamIt<?>> params, @NotNull String text2, int offset) {
        if (storage == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(27);
        }
        if (params == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(28);
        }
        if (text2 == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(29);
        }
        int curIndex = 0;
        StringBuilder sb = null;
        for (ScriptModel.ParamIt it2 : params) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            TextRange r = it2.range();
            Object v = storage.getValue((Object)it2.name());
            if (v == null) {
                sb.append(text2, curIndex, r.getEndOffset() - offset);
            } else {
                sb.append(text2, curIndex, r.getStartOffset() - offset);
                sb.append(v);
            }
            curIndex = r.getEndOffset() - offset;
        }
        String string = sb == null ? text2 : sb.append(text2, curIndex, text2.length()).toString();
        if (string == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(30);
        }
        return string;
    }

    public static <V> void updateOriginVirtualFile(V current, @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(31);
        }
        if (!(current instanceof PsiElement)) {
            return;
        }
        PsiFile file = ((PsiElement)current).getContainingFile();
        VirtualFile currentVirtualFile = file.getViewProvider().getVirtualFile();
        if (currentVirtualFile instanceof LightVirtualFile && ((LightVirtualFile)currentVirtualFile).getOriginalFile() == null) {
            VirtualFile origin = virtualFile;
            if (origin instanceof LightVirtualFile && ((LightVirtualFile)origin).getOriginalFile() != null) {
                origin = ((LightVirtualFile)origin).getOriginalFile();
            }
            ((LightVirtualFile)currentVirtualFile).setOriginalFile(origin);
        }
    }

    @NotNull
    public static <V> Iterable<String> getRelativeSnippet(V current, SyntaxTraverser.Api<V> api) {
        Object parent2 = api.parent(current);
        if (parent2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ScriptModelUtilCore.$$$reportNull$$$0(32);
            }
            return jBIterable;
        }
        TextRange pr = api.rangeOf(parent2);
        TextRange cr = api.rangeOf(current);
        int delta = 15;
        int a2 = cr.getStartOffset() - pr.getStartOffset();
        int b2 = cr.getEndOffset() - pr.getStartOffset();
        int s2 = Math.max(a2 - delta, 0);
        int e = Math.min(b2 + delta, pr.getLength());
        int a1 = s2 < delta ? 0 : s2;
        int b1 = pr.getLength() - e < delta ? pr.getLength() : e;
        CharSequence t = api.textOf(parent2);
        JBIterable jBIterable = JBIterable.of((Object[])new String[]{(a1 > 0 ? "..." : "") + t.subSequence(a1, a2), t.subSequence(a2, b2).toString(), t.subSequence(b2, b1) + (b1 < pr.getLength() ? "..." : "")});
        if (jBIterable == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(33);
        }
        return jBIterable;
    }

    @Contract(value="null -> false")
    public static boolean isJSFile(@Nullable PsiFile file) {
        return file != null && DbVFSUtils.isMongo(file.getProject(), file.getViewProvider().getVirtualFile());
    }

    @Nullable
    public static Language getHostLanguage(VirtualFile vFile) {
        VirtualFile virtualFile = vFile;
        if (virtualFile instanceof LightVirtualFile) {
            virtualFile = ((LightVirtualFile)virtualFile).getOriginalFile();
        }
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        return Comparing.equal((Object)virtualFile, (Object)vFile) ? null : LanguageUtil.getFileLanguage((VirtualFile)virtualFile);
    }

    public static int getSelectionOption(TextRange range) {
        return range instanceof ScriptModel.StrictRange ? 1 : (range instanceof ScriptModel.SmartRange ? 3 : 2);
    }

    @Nullable
    public static Language getJSLanguage() {
        Language lang = Language.findLanguageByID((String)"MongoJSExt");
        if (lang != null) {
            return lang;
        }
        lang = Language.findLanguageByID((String)"ECMAScript 6");
        if (lang != null) {
            return lang;
        }
        lang = Language.findLanguageByID((String)"JavaScript");
        if (lang != null) {
            return lang;
        }
        return MongoJSLanguage.INSTANCE;
    }

    @NotNull
    public static <V> Condition<V> wholeFileCondition(SyntaxTraverser<V> s2, TextRange scriptRange, Condition<? super V> wsOrComment, Condition<? super V> isStatement) {
        Condition condition = v -> {
            if (!(s2.api.typeOf(v) instanceof IFileElementType)) {
                return false;
            }
            JBIterable it2 = ((SyntaxTraverser)((SyntaxTraverser)s2.withRoot(v)).reset()).preOrderDfsTraversal().skip(1);
            Object st = it2.filter(isStatement).first();
            if (st == null) {
                return s2.api.rangeOf(v).getLength() > 256 || !StringUtil.isEmptyOrSpaces((CharSequence)s2.api.textOf(v));
            }
            if (!(scriptRange instanceof ScriptModel.PositionRange) && scriptRange.getLength() > 0) {
                if (scriptRange instanceof ScriptModel.StrictRange) {
                    return !Comparing.equal((Object)s2.api.rangeOf(v), (Object)s2.api.rangeOf(st));
                }
                return s2.api.rangeOf(st).getStartOffset() > 0 && it2.takeWhile(Conditions.notEqualTo((Object)st)).filter(o -> !wsOrComment.value(o)).isNotEmpty();
            }
            return ((SyntaxTraverser)s2.withRoot(v)).preOrderDfsTraversal().take(3).size() > 2;
        };
        if (condition == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(34);
        }
        return condition;
    }

    @Nullable
    public static Document getScriptDocument(VirtualFile virtualFile) {
        return virtualFile instanceof ReadOnlyLightVirtualFile || SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)virtualFile) ? null : (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(virtualFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/script/ScriptModelUtilCore";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionRange";
                break;
            }
            case 8: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execOption";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "INTERSECTS_RANGE";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "CONTAINS_RANGE";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "IN_RANGE";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "AT_OFFSET2";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/script/ScriptModelUtilCore";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustModelForSelection";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionForConsole";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustSelectionRange";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "inRange";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "statementText";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeSnippet";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "wholeFileCondition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSplitScriptMode";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "adjustModelForSelection";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionForConsole";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "adjustSelectionRange";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "inRange";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "statementText";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "updateOriginVirtualFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ParamHelper
    implements DocumentListener {
        private static final Key<ParamHelper> PARAM_NAMES = Key.create((String)"PARAM_NAMES");
        private final AtomicInteger counter = new AtomicInteger();
        private final ConcurrentMap<Segment, String> map = new ConcurrentHashMap<Segment, String>();

        private ParamHelper() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                ParamHelper.$$$reportNull$$$0(0);
            }
            if (this.map.size() < 100) {
                return;
            }
            Iterator it2 = this.map.keySet().iterator();
            while (it2.hasNext()) {
                if (((RangeMarker)it2.next()).isValid()) continue;
                it2.remove();
            }
        }

        @Nullable
        public static String getParameterId(@NotNull ScriptModel.ParamIt<?> it2, String baseName, @Nullable UserDataHolder userDataHolder) {
            TextRange segment;
            if (it2 == null) {
                ParamHelper.$$$reportNull$$$0(1);
            }
            if (userDataHolder == null) {
                return null;
            }
            ParamHelper names = (ParamHelper)PARAM_NAMES.get(userDataHolder);
            if (names == null) {
                names = new ParamHelper();
                PARAM_NAMES.set(userDataHolder, (Object)names);
                if (userDataHolder instanceof Document) {
                    ((Document)userDataHolder).addDocumentListener((DocumentListener)names);
                }
            }
            TextRange r = it2.range().shiftRight((int)it2.rangeOffset());
            if (userDataHolder instanceof DocumentEx) {
                DocumentEx document = (DocumentEx)userDataHolder;
                Ref found = Ref.create();
                document.processRangeMarkersOverlappingWith(r.getStartOffset(), r.getEndOffset(), marker -> {
                    if (!r.equalsToRange(marker.getStartOffset(), marker.getEndOffset())) {
                        return true;
                    }
                    if (marker.isGreedyToLeft() || baseName == null && marker.isGreedyToRight()) {
                        return true;
                    }
                    found.set(marker);
                    return false;
                });
                RangeMarker marker2 = (RangeMarker)found.get();
                if (marker2 == null || !marker2.isValid()) {
                    marker2 = document.createRangeMarker(r);
                    if (baseName != null) {
                        marker2.setGreedyToRight(true);
                    }
                }
                segment = marker2;
            } else {
                segment = r;
            }
            String name = (String)names.map.get(segment);
            return name != null ? name : (String)ConcurrencyUtil.cacheOrGet(names.map, (Object)segment, (Object)(baseName != null ? baseName : "#" + names.counter.incrementAndGet()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "it";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/script/ScriptModelUtilCore$ParamHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getParameterId";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

