/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scopes;

import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.scopes.DbPackageSetParserExtension;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourcePackageSet
extends PackageSetBase {
    private final String myDataSourceName;
    private final ThreadLocal<Pair<WeakReference<Project>, String[]>> myDataSourceIdCache;

    public DataSourcePackageSet(@NotNull String dataSourceName) {
        if (dataSourceName == null) {
            DataSourcePackageSet.$$$reportNull$$$0(0);
        }
        this.myDataSourceIdCache = new ThreadLocal();
        this.myDataSourceName = dataSourceName;
    }

    public boolean contains(@NotNull VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
        String[] ids;
        if (file == null) {
            DataSourcePackageSet.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DataSourcePackageSet.$$$reportNull$$$0(2);
        }
        if ((ids = this.getDataSourceIds(project)).length == 0) {
            return false;
        }
        String uniqueId = DataSourcePackageSet.getDataSourceId(file);
        return ArrayUtil.contains((String)uniqueId, (String[])ids);
    }

    @NotNull
    public PackageSet createCopy() {
        DataSourcePackageSet dataSourcePackageSet = this;
        if (dataSourcePackageSet == null) {
            DataSourcePackageSet.$$$reportNull$$$0(3);
        }
        return dataSourcePackageSet;
    }

    @NotNull
    public String getText() {
        String string = DbPackageSetParserExtension.compose(this.myDataSourceName);
        if (string == null) {
            DataSourcePackageSet.$$$reportNull$$$0(4);
        }
        return string;
    }

    public int getNodePriority() {
        return 0;
    }

    @NotNull
    private String[] getDataSourceIds(@NotNull Project project) {
        Pair<WeakReference<Project>, String[]> cache;
        Project key;
        if (project == null) {
            DataSourcePackageSet.$$$reportNull$$$0(5);
        }
        Project project2 = key = (cache = this.myDataSourceIdCache.get()) == null ? null : (Project)((WeakReference)cache.first).get();
        if (key == project) {
            String[] stringArray = (String[])cache.second;
            if (stringArray == null) {
                DataSourcePackageSet.$$$reportNull$$$0(6);
            }
            return stringArray;
        }
        String[] res2 = DataSourcePackageSet.findDataSourceIds(project, this.myDataSourceName);
        this.myDataSourceIdCache.set((Pair<WeakReference<Project>, String[]>)Pair.create(new WeakReference<Project>(project), (Object)res2));
        if (res2 == null) {
            DataSourcePackageSet.$$$reportNull$$$0(7);
        }
        return res2;
    }

    @NotNull
    private static String[] findDataSourceIds(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            DataSourcePackageSet.$$$reportNull$$$0(8);
        }
        if (name == null) {
            DataSourcePackageSet.$$$reportNull$$$0(9);
        }
        ArrayList res2 = new ArrayList();
        for (DbDataSource dataSource2 : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            if (!name.equals(dataSource2.getName())) continue;
            ContainerUtil.addIfNotNull(res2, (Object)dataSource2.getUniqueId());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(res2);
        if (stringArray == null) {
            DataSourcePackageSet.$$$reportNull$$$0(10);
        }
        return stringArray;
    }

    @Nullable
    private static String getDataSourceId(@NotNull VirtualFile file) {
        if (file == null) {
            DataSourcePackageSet.$$$reportNull$$$0(11);
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return ((DatabaseElementVirtualFileImpl)file).getDataSourceId();
        }
        String id = DbVFSUtils.getDataSourceId(file);
        if (id != null) {
            return id;
        }
        return DbSrcUtilsCore.getDataSource(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceName";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/scopes/DataSourcePackageSet";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/scopes/DataSourcePackageSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceIds";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findDataSourceIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceIds";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findDataSourceIds";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

