/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.DasIndex;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeColumnListBase;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeIndex
extends DeColumnListBase {
    public boolean unique;
    public final List<Item> items;

    protected DeIndex(@NotNull DeModel model) {
        if (model == null) {
            DeIndex.$$$reportNull$$$0(0);
        }
        super(model);
        this.items = new ArrayList<Item>();
    }

    public DeIndex(@NotNull String name, @NotNull DeTable table, @NotNull DeModel model) {
        if (name == null) {
            DeIndex.$$$reportNull$$$0(1);
        }
        if (table == null) {
            DeIndex.$$$reportNull$$$0(2);
        }
        if (model == null) {
            DeIndex.$$$reportNull$$$0(3);
        }
        super(name, table, model);
        this.items = new ArrayList<Item>();
    }

    @Override
    @Nullable
    public DeIndex getEditedDeObject() {
        return (DeIndex)super.getEditedDeObject();
    }

    @Override
    @Nullable
    public BasicIndex getEditedBasic() {
        return (BasicIndex)super.getEditedBasic();
    }

    @Override
    @NotNull
    public Iterable<DeColumn> getColumns() {
        JBIterable jBIterable = JBIterable.from(this.items).transform(item -> item.column);
        if (jBIterable == null) {
            DeIndex.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public DeObject copyFrom(@NotNull DeObject obj, boolean withChildren, @NotNull DeObject.DeCopier copier) {
        if (obj == null) {
            DeIndex.$$$reportNull$$$0(5);
        }
        if (copier == null) {
            DeIndex.$$$reportNull$$$0(6);
        }
        super.copyFrom(obj, withChildren, copier);
        DeIndex idx = (DeIndex)obj;
        this.unique = idx.unique;
        this.items.clear();
        for (Item item : idx.items) {
            this.items.add(new Item(copier.copy(item.column, false), item.sorting));
        }
        DeIndex deIndex = this;
        if (deIndex == null) {
            DeIndex.$$$reportNull$$$0(7);
        }
        return deIndex;
    }

    @Override
    @NotNull
    public DeObject emptyClone(@NotNull DeModel model) {
        if (model == null) {
            DeIndex.$$$reportNull$$$0(8);
        }
        return new DeIndex(model);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.INDEX;
        if (objectKind == null) {
            DeIndex.$$$reportNull$$$0(9);
        }
        return objectKind;
    }

    @Override
    public boolean isAlteredIgnoringChild(@NotNull DeObject other, @NotNull Collection<? extends DeObject> children2, @NotNull Collection<? extends DeObject> otherChildren) {
        if (other == null) {
            DeIndex.$$$reportNull$$$0(10);
        }
        if (children2 == null) {
            DeIndex.$$$reportNull$$$0(11);
        }
        if (otherChildren == null) {
            DeIndex.$$$reportNull$$$0(12);
        }
        return this.unique != ((DeIndex)other).unique || DeIndex.isSortingAltered(this, (DeIndex)other) || super.isAlteredIgnoringChild(other, children2, otherChildren);
    }

    protected static boolean isSortingAltered(@NotNull DeIndex a2, @NotNull DeIndex b2) {
        if (a2 == null) {
            DeIndex.$$$reportNull$$$0(13);
        }
        if (b2 == null) {
            DeIndex.$$$reportNull$$$0(14);
        }
        if (a2.items.size() != b2.items.size()) {
            return true;
        }
        for (int i2 = 0; i2 < a2.items.size(); ++i2) {
            if (a2.items.get((int)i2).sorting == b2.items.get((int)i2).sorting) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DeIndex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherChildren";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DeIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFrom";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "emptyClone";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAlteredIgnoringChild";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSortingAltered";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Item {
        @Nullable
        public final DeColumn column;
        public final DasIndex.Sorting sorting;

        public Item(@Nullable DeColumn column2, DasIndex.Sorting sorting) {
            this.column = column2;
            this.sorting = sorting;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (!Comparing.equal((Object)this.column, (Object)item.column)) {
                return false;
            }
            return this.sorting == item.sorting;
        }

        public int hashCode() {
            int result = Comparing.hashcode((Object)this.column);
            result = 31 * result + this.sorting.hashCode();
            return result;
        }
    }
}

