/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicGrantsHolder;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.schemaEditor.DbGrantsEditorUtilsKt;
import com.intellij.database.schemaEditor.DbObjectGrantsEditor;
import com.intellij.database.schemaEditor.DbObjectGrantsEditorKt;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001aB\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u0002H\u0002\u0012\u0002\b\u00030\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000b\u001aD\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000b\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u0002H\u0002\u0012\u0002\b\u00030\u00052\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u000f0\u000e\u001aB\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u000f0\u000b\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0011*\u00020\u00072\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00110\u00052\u0006\u0010\b\u001a\u00020\u0007\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0013\u00a8\u0006\u0014"}, d2={"applyGrants", "", "G", "Lcom/intellij/database/model/properties/Grants$Grant;", "grantCtl", "Lcom/intellij/database/model/properties/Grants$Controller;", "edited", "Lcom/intellij/database/model/basic/BasicElement;", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "newGrants", "", "convertGrants", "items", "", "Lcom/intellij/database/schemaEditor/DbObjectGrantsEditor$GrantForUser;", "extractGrants", "U", "enableAutoPopup", "Lcom/intellij/ui/EditorTextField;", "intellij.database.impl"})
public final class DbObjectGrantsEditorKt {
    @NotNull
    public static final <G extends Grants.Grant, U extends BasicElement> List<DbObjectGrantsEditor.GrantForUser<G>> extractGrants(@NotNull Grants.Controller<G, U> grantCtl, @NotNull BasicElement e) {
        Grants<G> grants;
        BasicGrantsHolder<G> holder;
        Intrinsics.checkNotNullParameter(grantCtl, (String)"grantCtl");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        BasicGrantsHolder<G> basicGrantsHolder = holder = grantCtl.grantsHolder(e);
        Grants<G> grants2 = grants = basicGrantsHolder != null ? basicGrantsHolder.getGrants() : null;
        Iterable<Collection<G>> objectGrants = grants2 != null ? grants2.grantsForByGrantee(e) : null;
        ArrayList<DbObjectGrantsEditor.GrantForUser<G>> res2 = new ArrayList<DbObjectGrantsEditor.GrantForUser<G>>();
        Iterable<Collection<G>> iterable = objectGrants;
        if (iterable != null) {
            Iterable<Collection<G>> $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            Iterator<Collection<G>> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Collection<G> element$iv;
                Collection<G> gGrants = element$iv = iterator.next();
                boolean bl = false;
                Grants.Grant cur2 = (Grants.Grant)CollectionsKt.first((Iterable)gGrants);
                U grantee = grantCtl.findGrantee(cur2, holder);
                DbObjectGrantsEditor.GrantForUser<Grants.Grant> g = new DbObjectGrantsEditor.GrantForUser<Grants.Grant>(grantCtl);
                Grants.Grant grant = cur2;
                Intrinsics.checkNotNullExpressionValue((Object)grant, (String)"cur");
                g.setUserKey(grant);
                Object object = grantee;
                if (object == null || (object = object.getKind()) == null) {
                    ObjectKind objectKind = ObjectKind.USER;
                    object = objectKind;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ObjectKind.USER");
                }
                g.setUserKind((ObjectKind)object);
                g.setUserText(grantCtl.granteeText(grantee, (Grants.Grant)g.getUserKey()));
                DbGrantsEditorUtilsKt.collectPermissions(g, gGrants);
                res2.add(g);
            }
        }
        return res2;
    }

    @NotNull
    public static final <G extends Grants.Grant> List<G> convertGrants(@NotNull Grants.Controller<G, ?> grantCtl, @NotNull BasicModElement e, @NotNull Collection<DbObjectGrantsEditor.GrantForUser<G>> items2) {
        Intrinsics.checkNotNullParameter(grantCtl, (String)"grantCtl");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        G objectGrant = grantCtl.lower(e);
        if (objectGrant == null) {
            return CollectionsKt.emptyList();
        }
        ArrayList res2 = new ArrayList();
        for (DbObjectGrantsEditor.GrantForUser<G> item : items2) {
            G userGrant = grantCtl.withGranteeFrom(objectGrant, item.getUserKey());
            DbGrantsEditorUtilsKt.extractPermissions(item, grantCtl, userGrant, res2);
        }
        return res2;
    }

    public static final <G extends Grants.Grant> void applyGrants(@NotNull Grants.Controller<G, ?> grantCtl, @Nullable BasicElement edited, @NotNull BasicModElement e, @NotNull List<? extends G> newGrants) {
        Intrinsics.checkNotNullParameter(grantCtl, (String)"grantCtl");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(newGrants, (String)"newGrants");
        BasicGrantsHolder<G> basicGrantsHolder = grantCtl.grantsHolder(e);
        if (basicGrantsHolder == null) {
            return;
        }
        BasicGrantsHolder<G> holder = basicGrantsHolder;
        SortedSet<G> grants = holder.getGrants().toMutableSet();
        BasicElement basicElement = edited;
        if (basicElement != null) {
            BasicElement basicElement2 = basicElement;
            boolean bl = false;
            boolean bl2 = false;
            BasicElement it2 = basicElement2;
            boolean bl3 = false;
            basicElement = grantCtl.lower(it2);
            if (basicElement != null) {
                basicElement2 = basicElement;
                bl = false;
                bl2 = false;
                it2 = basicElement2;
                boolean bl4 = false;
                grants.subSet(it2, grantCtl.upper(it2)).clear();
            }
        }
        grants.addAll((Collection)newGrants);
        holder.setGrants(holder.getGrants().with((Iterable)grants));
    }

    public static final void enableAutoPopup(@NotNull EditorTextField $this$enableAutoPopup) {
        Intrinsics.checkNotNullParameter((Object)$this$enableAutoPopup, (String)"$this$enableAutoPopup");
        $this$enableAutoPopup.addSettingsProvider((EditorSettingsProvider)enableAutoPopup.1.INSTANCE);
    }
}

