/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.ui.UrlPropertiesPanel;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFacadeCore;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSequence;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.schemaEditor.AutoSelectListener;
import com.intellij.database.schemaEditor.DbObjectGrantsEditor;
import com.intellij.database.schemaEditor.DbObjectGrantsEditorKt;
import com.intellij.database.schemaEditor.DbObjectNameEditor;
import com.intellij.database.schemaEditor.DbUserGrantsEditor;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilder;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.ModelLightCopier;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbObjectEditorFactory {
    public static final DbObjectEditorFactory DEFAULT = new DbObjectEditorFactory();
    private static final Map<Class<?>, Converter<String, ?>> ourConverters;
    private static final Map<Class<? extends Collection>, Factory<? extends Collection<?>>> ourCollections;

    @NotNull
    public static DbObjectEditorFactory forDbms(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(0);
        }
        DbObjectEditorFactory dbObjectEditorFactory = DbImplUtil.getModelHelper(dbms).getObjectEditorFactory();
        if (dbObjectEditorFactory == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(1);
        }
        return dbObjectEditorFactory;
    }

    @NotNull
    public DbObjectEditor createObjectEditor(@NotNull Project project, @NotNull BasicMetaObject<?> meta) {
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(2);
        }
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(3);
        }
        DbObjectEditor dbObjectEditor = this.createObjectEditor(project, meta, null);
        if (dbObjectEditor == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(4);
        }
        return dbObjectEditor;
    }

    @NotNull
    public BasicModElement pull(@NotNull BasicModModel target, @NotNull BasicElement source, @NotNull BasicMetaObject<?> edit) {
        if (target == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(5);
        }
        if (source == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(6);
        }
        if (edit == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(7);
        }
        Grants.Controller<?, ?> gc = ModelFacadeCore.forDbms(target.getDbms()).getModelHelper().getGrantController();
        Ref res2 = Ref.create();
        ((BaseModel)target).modify(target.getRoot(), BasicModRoot.class, true, r -> {
            res2.set((Object)DbObjectEditorFactory.pullObjectsForGrantee(target, source, gc));
            if (res2.isNull()) {
                res2.set((Object)ModelLightCopier.copy(source, target));
                this.pullGrantees(source, (BasicModElement)res2.get(), gc);
            }
        });
        BasicModElement basicModElement = (BasicModElement)res2.get();
        if (basicModElement == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(8);
        }
        return basicModElement;
    }

    @Nullable
    private static <G extends Grants.Grant, U extends BasicElement> BasicModElement pullObjectsForGrantee(@NotNull BasicModModel target, @NotNull BasicElement source, @Nullable Grants.Controller<G, U> gc) {
        if (target == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(9);
        }
        if (source == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(10);
        }
        Object grantee = gc == null ? null : (Object)gc.asGrantee(source);
        BasicElement parent2 = source.getParent();
        if (grantee == null || parent2 == null) {
            return null;
        }
        BasicModElement resP = ModelLightCopier.copy(parent2, target, true);
        return (BasicModElement)ObjectUtils.tryCast(gc.findGrantee(gc.withGrantee(gc.create(), grantee), resP), BasicModElement.class);
    }

    private <U extends BasicElement> void pullGrantees(@NotNull BasicElement src, @NotNull BasicModElement tgt, @Nullable Grants.Controller<?, U> ge) {
        if (src == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(11);
        }
        if (tgt == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(12);
        }
        if (ge == null) {
            return;
        }
        JBIterable<Family<U>> srcG = ge.granteeFamiliesFor(src);
        JBIterable<Family<U>> tgtG = ge.granteeFamiliesFor(tgt);
        Iterator srcIt = srcG.iterator();
        Iterator tgtIt = tgtG.iterator();
        while (srcIt.hasNext() && tgtIt.hasNext()) {
            this.pullFamily((Family)srcIt.next(), (ModFamily)tgtIt.next());
        }
    }

    protected void pullFamily(@Nullable BasicElement src, @Nullable BasicModElement tgt, @NotNull ObjectKind kind) {
        if (kind == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(13);
        }
        this.pullFamily(src == null ? null : src.familyOf(kind), tgt == null ? null : tgt.familyOf(kind));
    }

    protected void pullFamily(@Nullable Family<?> src, @Nullable ModFamily<?> tgt) {
        if (src != null && tgt != null && tgt.isEmpty() && src.isNotEmpty()) {
            ModelLightCopier.copyFamily(src, tgt);
        }
    }

    @NotNull
    public DbObjectEditor createObjectEditor(@NotNull Project project, @NotNull BasicMetaObject<?> meta, @Nullable List<BasicMetaProperty<?>> invalid) {
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(14);
        }
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(15);
        }
        ArrayList properties = ContainerUtil.newArrayList((Object[])meta.properties);
        this.reorderProperties(meta, properties);
        List<DbObjectEditor> editors = this.createEditors(project, meta, properties, invalid);
        return new CompoundObjectEditor(editors);
    }

    @NotNull
    protected List<DbObjectEditor> createEditors(@NotNull Project project, @NotNull BasicMetaObject<?> meta, @NotNull List<BasicMetaProperty<?>> properties, @Nullable List<BasicMetaProperty<?>> invalid) {
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(16);
        }
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(17);
        }
        if (properties == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(18);
        }
        ArrayList<DbObjectEditor> editors = new ArrayList<DbObjectEditor>(properties.size());
        while (!properties.isEmpty()) {
            BasicMetaProperty<?> property = properties.get(0);
            if (!this.createPropertyEditor(project, meta, property, properties, editors) && invalid != null) {
                invalid.add(property);
            }
            properties.remove(property);
        }
        ContainerUtil.addIfNotNull(editors, (Object)DbObjectEditorFactory.createAnyGrantsEditor(project, meta));
        ArrayList<DbObjectEditor> arrayList = editors;
        if (arrayList == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @Nullable
    public static DbObjectEditor createAnyGrantsEditor(@NotNull Project project, @NotNull BasicMetaObject<?> meta) {
        Dbms dbms;
        Grants.Controller<?, ?> grantCtl;
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(20);
        }
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(21);
        }
        if ((grantCtl = ModelFacadeCore.forDbms(dbms = meta.getModel().dbms).getModelHelper().getGrantController()) == null) {
            return null;
        }
        if (grantCtl.asGrantee((BasicElement)meta.newDataObject()) != null) {
            return DbObjectEditorFactory.createGranteeGrantsEditor(project, meta, grantCtl);
        }
        return DbObjectEditorFactory.createGrantsEditor(project, meta, grantCtl);
    }

    @Nullable
    public static <G extends Grants.Grant, U extends BasicElement> DbObjectGrantsEditor<G, U> createGrantsEditor(@NotNull Project project, @NotNull BasicMetaObject<?> meta, @Nullable Grants.Controller<G, U> grantCtl) {
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(22);
        }
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(23);
        }
        Iterable<String> p2 = grantCtl == null ? null : grantCtl.possiblePrivileges(meta);
        return grantCtl == null || !p2.iterator().hasNext() ? null : new DbObjectGrantsEditor<G, U>(project, meta.getModel().dbms, grantCtl);
    }

    @Nullable
    public static <G extends Grants.Grant, U extends BasicElement> DbUserGrantsEditor<G, U> createGranteeGrantsEditor(@NotNull Project project, @NotNull BasicMetaObject<?> meta, @Nullable Grants.Controller<G, U> grantCtl) {
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(24);
        }
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(25);
        }
        return grantCtl == null ? null : new DbUserGrantsEditor<G, U>(project, meta.getModel().dbms, grantCtl);
    }

    protected boolean createPropertyEditor(@NotNull Project project, @NotNull BasicMetaObject<?> meta, BasicMetaProperty<?> property, @NotNull List<BasicMetaProperty<?>> properties, @NotNull List<DbObjectEditor> editors) {
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(26);
        }
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(27);
        }
        if (properties == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(28);
        }
        if (editors == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(29);
        }
        if (meta.isInternal(property)) {
            return true;
        }
        DbObjectEditor editor = this.createPropertyEditor(project, meta, property, properties);
        if (editor == null) {
            return false;
        }
        editors.add(editor);
        return true;
    }

    @NlsSafe
    @NotNull
    protected String getTitle(@NotNull BasicMetaProperty<?> prop) {
        if (prop == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(30);
        }
        return DbObjectEditorFactory.words(prop.name);
    }

    protected void reorderProperties(@NotNull BasicMetaObject<?> meta, @NotNull List<BasicMetaProperty<?>> properties) {
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(31);
        }
        if (properties == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(32);
        }
        DbObjectEditorFactory.moveTo(properties, 0, BasicModNamedElement.NAME, BasicModNamedElement.COMMENT, BasicModTableOrView.TEMPORARY, BasicModTypedElement.DATA_TYPE, BasicModSequence.SEQUENCE_IDENTITY);
    }

    public static <T> void moveTo(List<T> list, int idx, T ... values2) {
        for (T value2 : values2) {
            int newIdx = DbObjectEditorFactory.moveTo(list, idx, value2);
            if (newIdx == -1) continue;
            idx = newIdx + 1;
        }
    }

    public static <T> int moveTo(List<T> list, int idx, T value2) {
        int valIdx = list.indexOf(value2);
        if (valIdx == -1) {
            return -1;
        }
        if (valIdx == idx) {
            return idx;
        }
        if (valIdx < idx) {
            --idx;
        }
        list.add(idx, list.remove(valIdx));
        return idx;
    }

    private static NameValueType parseNvt(String s2) {
        int valSep = s2.indexOf(61);
        int valSepSafe = valSep == -1 ? s2.length() : valSep;
        int typeSep = StringUtil.indexOf((CharSequence)s2, (char)':', (int)0, (int)valSepSafe);
        return new NameValueType(s2.substring(0, typeSep == -1 ? valSepSafe : typeSep), valSep == -1 ? "" : s2.substring(valSep + 1), typeSep == -1 ? "" : s2.substring(typeSep + 1, valSepSafe));
    }

    @NotNull
    private static String serializeNvt(NameValueType nvt) {
        String string = nvt.getName() + (String)(StringUtil.isEmpty((String)nvt.getType()) ? "" : ":" + nvt.getType()) + "=" + nvt.getValue();
        if (string == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static NameValue parseNv(String s2) {
        int valSep = s2.indexOf(61);
        int valSepSafe = valSep == -1 ? s2.length() : valSep;
        return new NameValue(s2.substring(0, valSepSafe), valSep == -1 ? "" : s2.substring(valSep + 1));
    }

    @NotNull
    private static String serializeNv(NameValue nvt) {
        String string = nvt.getName() + "=" + nvt.getValue();
        if (string == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(34);
        }
        return string;
    }

    private static <T> void put(ContainerUtil.ImmutableMapBuilder<Class<?>, Converter<String, ?>> builder, Class<T> clazz, Function<T, String> from, Function<String, T> to) {
        builder.put(clazz, new Converter<String, T>(from, to));
    }

    @Nullable
    public DbObjectEditor createPropertyEditor(@NotNull Project project, @NotNull BasicMetaObject<?> meta, @NotNull BasicMetaProperty<?> property, @NotNull List<BasicMetaProperty<?>> properties) {
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(35);
        }
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(36);
        }
        if (property == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(37);
        }
        if (properties == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(38);
        }
        if (property == BasicModNamedElement.NAME) {
            properties.remove(BasicModNamedElement.NAME);
            properties.remove(BasicModNamedElement.NAME_QUOTED);
            properties.remove(BasicModNamedElement.NAME_SCRIPTED);
            properties.remove(BasicModNamedElement.NAME_SURROGATE);
            return new DbObjectNameEditor(project);
        }
        Converter<String, ?> converter = ourConverters.get(property.getValueClass());
        if (converter != null) {
            return new DbObjectTextPropEditor(property, this.getTitle(property), converter.from, converter.to);
        }
        BasicMetaProperty<Object> prop = property.tryCast(Boolean.class);
        if (prop != null) {
            return new DbObjectBoolPropEditor((BasicMetaProperty<Boolean>)prop, this.getTitle(property));
        }
        prop = property.tryCast(SequenceIdentity.class);
        if (prop != null) {
            return new DbSeqIdPropEditor((BasicMetaProperty<SequenceIdentity>)prop, this.getTitle(property));
        }
        prop = property.tryCast(Enum.class);
        if (prop != null) {
            return new DbObjectEnumPropEditor((BasicMetaProperty<Enum<?>>)prop, this.getTitle(property));
        }
        if (property.type instanceof BasicMetaType.CollectionMetaType) {
            return this.createPropertyEditor(project, meta, property, (BasicMetaType.CollectionMetaType)property.type);
        }
        return null;
    }

    @Nullable
    public DbObjectEditor createPropertyEditor(Project project, BasicMetaObject<?> meta, BasicMetaProperty<?> property, BasicMetaType.CollectionMetaType<?, ?> type) {
        Factory<? extends Collection<?>> fac = ourCollections.get(property.getValueClass());
        if (fac == null) {
            return null;
        }
        Converter<String, ?> converter = ourConverters.get(type.elementClass);
        if (converter != null) {
            return new DbObjectTextCollectionPropEditor(property, this.getTitle(property), converter.from, converter.to, fac);
        }
        if (Enum.class.isAssignableFrom(type.elementClass)) {
            return this.createEnumListEditor(property, type.elementClass, fac);
        }
        return null;
    }

    public <E extends Enum<E>, C extends Collection<E>> DbObjectEditor createEnumListEditor(BasicMetaProperty<C> property, Class<E> enumClass, Factory<C> fac) {
        return new DbObjectTextCollectionPropEditor(property, this.getTitle(property), Enum::name, n -> Enum.valueOf(enumClass, n), fac);
    }

    @NotNull
    private static String words(@NotNull String s2) {
        if (s2 == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(39);
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char prev = i2 < 1 ? (char)'\u0000' : s2.charAt(i2 - 1);
            char cur2 = s2.charAt(i2);
            if (Character.isLowerCase(prev) && Character.isUpperCase(cur2)) {
                sb.append(' ');
            }
            sb.append(cur2);
        }
        String string = sb.toString();
        if (string == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(40);
        }
        return string;
    }

    static {
        ourCollections = ContainerUtil.immutableMapBuilder().put(List.class, ArrayList::new).put(Set.class, LinkedHashSet::new).build();
        ContainerUtil.ImmutableMapBuilder builder = ContainerUtil.immutableMapBuilder();
        DbObjectEditorFactory.put(builder, String.class, Functions.id(), Functions.id());
        DbObjectEditorFactory.put(builder, OneTimeString.class, s2 -> s2 == null ? "" : s2.toString(false), s2 -> new OneTimeString(s2));
        DbObjectEditorFactory.put(builder, Byte.class, Object::toString, Byte::parseByte);
        DbObjectEditorFactory.put(builder, Short.class, Object::toString, Short::parseShort);
        DbObjectEditorFactory.put(builder, Integer.class, Object::toString, Integer::parseInt);
        DbObjectEditorFactory.put(builder, Long.class, Object::toString, Long::parseLong);
        DbObjectEditorFactory.put(builder, Float.class, Object::toString, Float::parseFloat);
        DbObjectEditorFactory.put(builder, Double.class, Object::toString, Double::parseDouble);
        DbObjectEditorFactory.put(builder, BigInteger.class, Object::toString, BigInteger::new);
        DbObjectEditorFactory.put(builder, DataType.class, dt -> dt.equals(DataType.UNKNOWN) ? "" : dt.getSpecification(), s2 -> StringUtil.isEmpty((String)s2) ? DataType.UNKNOWN : DataTypeFactory.of(s2));
        DbObjectEditorFactory.put(builder, NameValue.class, DbObjectEditorFactory::serializeNv, DbObjectEditorFactory::parseNv);
        DbObjectEditorFactory.put(builder, NameValueType.class, DbObjectEditorFactory::serializeNvt, DbObjectEditorFactory::parseNvt);
        ourConverters = builder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 19: 
            case 33: 
            case 34: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 19: 
            case 33: 
            case 34: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 19: 
            case 33: 
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory";
                break;
            }
            case 2: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 15: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edit";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tgt";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 18: 
            case 28: 
            case 32: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "forDbms";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createObjectEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "pull";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditors";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeNvt";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeNv";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "words";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forDbms";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 19: 
            case 33: 
            case 34: 
            case 40: {
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createObjectEditor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pull";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "pullObjectsForGrantee";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "pullGrantees";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "pullFamily";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createEditors";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createAnyGrantsEditor";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createGrantsEditor";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createGranteeGrantsEditor";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createPropertyEditor";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "reorderProperties";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "words";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 19: 
            case 33: 
            case 34: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Converter<A, B> {
        public final Function<B, A> from;
        public final Function<A, B> to;

        private Converter(Function<B, A> from, Function<A, B> to) {
            this.from = from;
            this.to = to;
        }
    }

    public static abstract class DbObjectEditorBase
    extends DatabaseScriptDialog {
        private ScriptingTaskBuilder myBuilder;

        public DbObjectEditorBase(@NotNull Project project, @NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull @NlsContexts.DialogTitle String title) {
            if (project == null) {
                DbObjectEditorBase.$$$reportNull$$$0(0);
            }
            if (dataSource2 == null) {
                DbObjectEditorBase.$$$reportNull$$$0(1);
            }
            if (title == null) {
                DbObjectEditorBase.$$$reportNull$$$0(2);
            }
            super(project, dataSource2, searchPath, title);
        }

        protected abstract void reset();

        protected abstract void apply();

        protected void applySourceFromPreview(@NotNull BasicModSourceAware e) {
            if (e == null) {
                DbObjectEditorBase.$$$reportNull$$$0(3);
            }
            DbObjectEditorBase.applySource(this.myProject, DbSqlUtilCore.getSqlDialect((DbElement)this.mySource), e, this.myPreviewPanel.getQuery());
        }

        public static void applySource(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull BasicModSourceAware e, String query) {
            if (project == null) {
                DbObjectEditorBase.$$$reportNull$$$0(4);
            }
            if (dialect == null) {
                DbObjectEditorBase.$$$reportNull$$$0(5);
            }
            if (e == null) {
                DbObjectEditorBase.$$$reportNull$$$0(6);
            }
            Object tmp2 = e.getMetaObject().newDataObject();
            SqlFile file = SqlPsiFacade.getInstance((Project)project).createROFile(dialect, (CharSequence)query);
            PsiObject def = (PsiObject)((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)file.getDdl())).expandAndSkip(o -> o instanceof SqlAlterStatement)).filter(PsiObject.class).first();
            if (def == null) {
                return;
            }
            ((SqlObjectBuilder)SqlObjectBuilder.EP.forDbms(dialect.getDbms())).build((BasicModElement)tmp2, (DasObject)def, new SqlObjectBuilder.ContextWithSource((BasicModElement)tmp2, e){
                final /* synthetic */ BasicModElement val$tmp;
                final /* synthetic */ BasicModSourceAware val$e;
                {
                    this.val$tmp = basicModElement;
                    this.val$e = basicModSourceAware;
                }

                @Override
                public void writeSource(@NotNull BasicModSourceAware object, @Nullable CompositeText src) {
                    if (object == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (src != null) {
                        super.writeSource(object == this.val$tmp ? this.val$e : object, src);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectEditorBase$1", "writeSource"));
                }
            });
        }

        @Override
        @NotNull
        protected JComponent createTopComponent() {
            this.myBuilder = this.createBuilder();
            JComponent editor = this.getObjectEditor().getComponent();
            editor.setMinimumSize((Dimension)JBUI.size((int)300, (int)300));
            this.reset();
            UserActivityWatcher watcher = new UserActivityWatcher();
            watcher.addUserActivityListener(this::generate, this.myDisposable);
            watcher.register((Component)editor);
            ApplicationManager.getApplication().invokeLater(this::generate, ModalityState.stateForComponent((Component)this.getRootPane()));
            JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)editor, (boolean)true);
            if (jScrollPane == null) {
                DbObjectEditorBase.$$$reportNull$$$0(7);
            }
            return jScrollPane;
        }

        protected abstract DbObjectEditor getObjectEditor();

        protected abstract ScriptingTaskBuilder createBuilder();

        @Override
        @NotNull
        protected List<AnAction> createPreviewActions() {
            List<AnAction> list = Collections.singletonList(DbObjectEditorBase.createSettingsPopupAction((Getter<ScriptingTask>)((Getter)() -> this.getTask()), (Consumer<ScriptingOptions>)((Consumer)o -> this.settingsChanged(this.appendCodeStyle((ScriptingOptions)o)))));
            if (list == null) {
                DbObjectEditorBase.$$$reportNull$$$0(8);
            }
            return list;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            DbObjectEditor e = (DbObjectEditor)((JBTreeTraverser)JBTreeTraverser.from(o -> o instanceof CompoundObjectEditor ? ((CompoundObjectEditor)o).getEditors() : Collections.emptyList()).withRoot((Object)this.getObjectEditor())).traverse(TreeTraversal.LEAVES_DFS).first();
            return e == null ? null : e.getComponent();
        }

        @Override
        protected ScriptingTask getTask() {
            this.apply();
            return this.myBuilder.build();
        }

        @Override
        protected void settingsChanged(ScriptingOptions options) {
            this.myBuilder.setOptions(options);
            this.generate();
        }

        private void generate() {
            ScriptingResult script = ScriptGenerators.INSTANCE.makeScript(this.myProject, this.getTask());
            this.updateText(script);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectEditorBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectEditorBase";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTopComponent";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPreviewActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applySourceFromPreview";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applySource";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CompoundObjectEditor
    extends DbObjectEditor {
        private final List<DbObjectEditor> myEditors;
        private final JComponent myComponent;
        public static final int SMALL_WIDTH = 2;
        public static final int GRID_WIDTH = 6;

        public CompoundObjectEditor(@NotNull List<DbObjectEditor> editors) {
            if (editors == null) {
                CompoundObjectEditor.$$$reportNull$$$0(0);
            }
            this.myEditors = editors;
            List<Pair<Integer, Integer>> cells = this.getCells();
            Pair last = (Pair)ContainerUtil.getLastItem(cells);
            this.myComponent = new JPanel((LayoutManager)new GridLayoutManager(((Integer)last.first).intValue(), 6));
            for (int i2 = 0; i2 < editors.size(); ++i2) {
                DbObjectEditor editor = editors.get(i2);
                String title = editor.getTitle();
                TypesRegistry.ParamEditor.FieldSize size = editor.getFieldSize();
                boolean vertical = editor.isVertical();
                Pair<Integer, Integer> cell = cells.get(i2);
                if (title != null) {
                    JBLabel label = new JBLabel(title);
                    GridConstraints lc = UrlPropertiesPanel.createLabelConstraints((Integer)cell.first, (Integer)cell.second, label.getPreferredSize().getWidth());
                    if (vertical) {
                        lc.setColSpan(6);
                    }
                    this.myComponent.add((Component)label, lc);
                }
                int vOffset = vertical ? 1 : 0;
                int hOffset = title == null || vertical ? 0 : 1;
                GridConstraints constraints = UrlPropertiesPanel.createConstraints((Integer)cell.first + vOffset, (Integer)cell.second + hOffset, this.getWidth(size) - hOffset, 0, vertical ? 3 : 1, -1, true);
                if (vertical) {
                    constraints.setVSizePolicy(UrlPropertiesPanel.getPolicy(true));
                }
                this.myComponent.add((Component)editor.getComponent(), constraints);
            }
        }

        @NotNull
        public List<DbObjectEditor> getEditors() {
            List<DbObjectEditor> list = this.myEditors;
            if (list == null) {
                CompoundObjectEditor.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public List<Pair<Integer, Integer>> getCells() {
            ArrayList<Pair<Integer, Integer>> cells = new ArrayList<Pair<Integer, Integer>>();
            int row = 0;
            int col = 0;
            for (DbObjectEditor editor : this.myEditors) {
                TypesRegistry.ParamEditor.FieldSize s2 = editor.getFieldSize();
                int w = this.getWidth(s2);
                if (col + w > 6) {
                    col = 0;
                    ++row;
                }
                cells.add((Pair<Integer, Integer>)Pair.create((Object)row, (Object)col));
                col += w;
                if (!editor.isVertical()) continue;
                assert (s2 == TypesRegistry.ParamEditor.FieldSize.LARGE);
                ++row;
            }
            cells.add(Pair.create((Object)(row + 1), (Object)0));
            ArrayList<Pair<Integer, Integer>> arrayList = cells;
            if (arrayList == null) {
                CompoundObjectEditor.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        protected int getWidth(TypesRegistry.ParamEditor.FieldSize s2) {
            return s2 == TypesRegistry.ParamEditor.FieldSize.LARGE ? 6 : (s2 == TypesRegistry.ParamEditor.FieldSize.MEDIUM ? 4 : 2);
        }

        @Override
        public void apply(@Nullable BasicElement edited, @NotNull BasicModElement e) {
            if (e == null) {
                CompoundObjectEditor.$$$reportNull$$$0(3);
            }
            for (DbObjectEditor editor : this.myEditors) {
                editor.apply(edited, e);
            }
        }

        @Override
        public void reset(@NotNull BasicElement e) {
            if (e == null) {
                CompoundObjectEditor.$$$reportNull$$$0(4);
            }
            for (DbObjectEditor editor : this.myEditors) {
                editor.reset(e);
            }
        }

        @Override
        public void enable(@NotNull Function<BasicMetaProperty<?>, Boolean> enabled) {
            if (enabled == null) {
                CompoundObjectEditor.$$$reportNull$$$0(5);
            }
            for (DbObjectEditor editor : this.myEditors) {
                editor.enable(enabled);
            }
        }

        @Override
        public void initCompletion(@NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath) {
            if (dataSource2 == null) {
                CompoundObjectEditor.$$$reportNull$$$0(6);
            }
            for (DbObjectEditor editor : this.myEditors) {
                editor.initCompletion(dataSource2, searchPath);
            }
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                CompoundObjectEditor.$$$reportNull$$$0(7);
            }
            return jComponent;
        }

        @Override
        @Nullable
        public String getTitle() {
            return null;
        }

        @Override
        @NotNull
        public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
            TypesRegistry.ParamEditor.FieldSize fieldSize = TypesRegistry.ParamEditor.FieldSize.LARGE;
            if (fieldSize == null) {
                CompoundObjectEditor.$$$reportNull$$$0(8);
            }
            return fieldSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$CompoundObjectEditor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enabled";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$CompoundObjectEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditors";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCells";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "enable";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "initCompletion";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbObjectEnumPropEditor
    extends DbObjectSinglePropEditor<Enum<?>> {
        private final ComboBox<Enum<?>> myBox;

        public DbObjectEnumPropEditor(@NotNull BasicMetaProperty<Enum<?>> property, @NlsContexts.Label @Nullable String title) {
            if (property == null) {
                DbObjectEnumPropEditor.$$$reportNull$$$0(0);
            }
            super(property, title);
            this.myBox = new ComboBox((Object[])property.getValueClass().getEnumConstants());
        }

        @Override
        public void apply(@Nullable BasicElement edited, @NotNull BasicModElement e) {
            if (e == null) {
                DbObjectEnumPropEditor.$$$reportNull$$$0(1);
            }
            this.myProperty.set(e, (Enum)this.myBox.getSelectedItem());
        }

        @Override
        public void reset(@NotNull BasicElement e) {
            if (e == null) {
                DbObjectEnumPropEditor.$$$reportNull$$$0(2);
            }
            this.myBox.setSelectedItem(this.myProperty.get(e));
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            ComboBox<Enum<?>> comboBox = this.myBox;
            if (comboBox == null) {
                DbObjectEnumPropEditor.$$$reportNull$$$0(3);
            }
            return comboBox;
        }

        @Override
        @NotNull
        public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
            TypesRegistry.ParamEditor.FieldSize fieldSize = TypesRegistry.ParamEditor.FieldSize.MEDIUM;
            if (fieldSize == null) {
                DbObjectEnumPropEditor.$$$reportNull$$$0(4);
            }
            return fieldSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectEnumPropEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectEnumPropEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbObjectBoolPropEditor
    extends DbObjectSinglePropEditor<Boolean> {
        private final JBCheckBox myBox;

        public DbObjectBoolPropEditor(@NotNull BasicMetaProperty<Boolean> property, @NlsContexts.Label @Nullable String title) {
            if (property == null) {
                DbObjectBoolPropEditor.$$$reportNull$$$0(0);
            }
            super(property, null);
            this.myBox = new JBCheckBox(title);
        }

        @Override
        public void apply(@Nullable BasicElement edited, @NotNull BasicModElement e) {
            if (e == null) {
                DbObjectBoolPropEditor.$$$reportNull$$$0(1);
            }
            this.myProperty.set(e, this.myBox.isSelected());
        }

        @Override
        public void reset(@NotNull BasicElement e) {
            if (e == null) {
                DbObjectBoolPropEditor.$$$reportNull$$$0(2);
            }
            this.myBox.setSelected(Boolean.TRUE.equals(this.myProperty.get(e)));
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JBCheckBox jBCheckBox = this.myBox;
            if (jBCheckBox == null) {
                DbObjectBoolPropEditor.$$$reportNull$$$0(3);
            }
            return jBCheckBox;
        }

        @Override
        @NotNull
        public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
            TypesRegistry.ParamEditor.FieldSize fieldSize = TypesRegistry.ParamEditor.FieldSize.SMALL;
            if (fieldSize == null) {
                DbObjectBoolPropEditor.$$$reportNull$$$0(4);
            }
            return fieldSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectBoolPropEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectBoolPropEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbObjectTextCollectionPropEditor<T, C extends Collection<T>>
    extends DbObjectSinglePropEditor<C> {
        private final Function<? super T, String> myFrom;
        private final Function<? super String, ? extends T> myTo;
        private final Factory<? extends C> myFac;
        private final JTextField myTextField;

        public DbObjectTextCollectionPropEditor(@NotNull BasicMetaProperty<C> property, @Nullable @NlsContexts.Label String title, @NotNull Function<? super T, String> from, @NotNull Function<? super String, ? extends T> to, @NotNull Factory<? extends C> fac) {
            if (property == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(1);
            }
            if (to == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(2);
            }
            if (fac == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(3);
            }
            super(property, title);
            this.myFrom = from;
            this.myTo = to;
            this.myFac = fac;
            this.myTextField = new JTextField();
            this.myTextField.addFocusListener(AutoSelectListener.INSTANCE);
        }

        @Override
        public void apply(@Nullable BasicElement edited, @NotNull BasicModElement e) {
            if (e == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(4);
            }
            try {
                this.myProperty.set(e, JBIterable.from((Iterable)StringUtil.split((String)this.myTextField.getText(), (String)",")).map(this.myTo).addAllTo((Collection)this.myFac.create()));
                DbUIUtil.setError(this.myTextField, null);
            }
            catch (Throwable th) {
                DbUIUtil.setError(this.myTextField, th.getMessage());
            }
        }

        @Override
        public void reset(@NotNull BasicElement e) {
            if (e == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(5);
            }
            this.myTextField.setText(StringUtil.join((Iterable)JBIterable.from((Iterable)((Iterable)this.myProperty.get(e))).map(this.myFrom), (String)","));
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JTextField jTextField = this.myTextField;
            if (jTextField == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(6);
            }
            return jTextField;
        }

        @Override
        @NotNull
        public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
            TypesRegistry.ParamEditor.FieldSize fieldSize = TypesRegistry.ParamEditor.FieldSize.LARGE;
            if (fieldSize == null) {
                DbObjectTextCollectionPropEditor.$$$reportNull$$$0(7);
            }
            return fieldSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fac";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectTextCollectionPropEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectTextCollectionPropEditor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbSeqIdPropEditor
    extends DbObjectSinglePropEditor<SequenceIdentity> {
        private final JComponent myPanel;
        private final JTextField myMin;
        private final JTextField myMax;
        private final JTextField myStep;

        protected DbSeqIdPropEditor(@NotNull BasicMetaProperty<SequenceIdentity> property, @NlsContexts.Label @Nullable String title) {
            if (property == null) {
                DbSeqIdPropEditor.$$$reportNull$$$0(0);
            }
            super(property, null);
            this.myPanel = new JPanel((LayoutManager)new GridLayoutManager(1, 6));
            this.myMin = this.addField(DatabaseBundle.message((String)"label.min", (Object[])new Object[0]), 0);
            this.myMax = this.addField(DatabaseBundle.message((String)"label.max", (Object[])new Object[0]), 2);
            this.myStep = this.addField(DatabaseBundle.message((String)"label.step", (Object[])new Object[0]), 4);
        }

        private JTextField addField(@NlsContexts.Label String title, int base) {
            JBLabel lbl = new JBLabel(title);
            this.myPanel.add((Component)lbl, UrlPropertiesPanel.createLabelConstraints(0, base, lbl.getPreferredSize().width));
            JTextField field = new JTextField();
            this.myPanel.add((Component)field, UrlPropertiesPanel.createSimpleConstraints(0, base + 1, 1));
            field.addFocusListener(AutoSelectListener.INSTANCE);
            return field;
        }

        @Override
        public void apply(@Nullable BasicElement edited, @NotNull BasicModElement e) {
            if (e == null) {
                DbSeqIdPropEditor.$$$reportNull$$$0(1);
            }
            BigInteger min = DbSeqIdPropEditor.getVal(this.myMin);
            BigInteger max = DbSeqIdPropEditor.getVal(this.myMax);
            BigInteger step = DbSeqIdPropEditor.getVal(this.myStep);
            SequenceIdentity prev = edited == null ? null : (SequenceIdentity)this.myProperty.get(edited);
            BigInteger next = prev == null ? null : prev.next;
            this.myProperty.set(e, SequenceIdentity.of(min, next, step, max));
        }

        @Nullable
        private static BigInteger getVal(JTextField field) {
            String text2 = field.getText();
            if (StringUtil.isEmpty((String)text2)) {
                return null;
            }
            try {
                BigInteger val = new BigInteger(text2);
                DbUIUtil.setError(field, null);
                return val;
            }
            catch (Throwable th) {
                DbUIUtil.setError(field, th.getMessage());
                return null;
            }
        }

        @Override
        public void reset(@NotNull BasicElement e) {
            SequenceIdentity se;
            if (e == null) {
                DbSeqIdPropEditor.$$$reportNull$$$0(2);
            }
            BigInteger min = (se = (SequenceIdentity)this.myProperty.get(e)) == null ? null : se.min;
            BigInteger max = se == null ? null : se.max;
            BigInteger increment = se == null ? null : se.increment;
            this.myMin.setText(min == null ? "" : min.toString());
            this.myMax.setText(max == null ? "" : max.toString());
            this.myStep.setText(increment == null ? "" : increment.toString());
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myPanel;
            if (jComponent == null) {
                DbSeqIdPropEditor.$$$reportNull$$$0(3);
            }
            return jComponent;
        }

        @Override
        @NotNull
        public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
            TypesRegistry.ParamEditor.FieldSize fieldSize = TypesRegistry.ParamEditor.FieldSize.LARGE;
            if (fieldSize == null) {
                DbSeqIdPropEditor.$$$reportNull$$$0(4);
            }
            return fieldSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbSeqIdPropEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbSeqIdPropEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbObjectReferencePropEditor<T>
    extends DbObjectSinglePropEditor<T> {
        private final TextFieldWithCompletion myTextField;
        private final BasicMetaObject<?> myMeta;
        private final Function<BasicElement, Pair<BasicElement, String>> myExtract;
        private final PairConsumer<BasicModElement, Pair<BasicElement, String>> myAssign;
        private JBIterable<BasicElement> myTraverser;

        public static DbObjectReferencePropEditor<String> createNameReferenceEditor(@NotNull Project project, @NotNull BasicMetaProperty<String> property, @Nullable @NlsContexts.Label String title, @NotNull BasicMetaObject<?> meta) {
            if (project == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(0);
            }
            if (property == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(1);
            }
            if (meta == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(2);
            }
            return new DbObjectReferencePropEditor<String>(project, property, title, meta, (Function<BasicElement, Pair<BasicElement, String>>)((Function)o -> Pair.create(null, (Object)((String)property.get((BasicElement)o)))), (PairConsumer<BasicModElement, Pair<BasicElement, String>>)((PairConsumer)(o, p2) -> property.set((BasicModElement)o, (String)p2.second)));
        }

        public DbObjectReferencePropEditor(@NotNull Project project, @NotNull BasicMetaProperty<T> property, @NlsContexts.Label @Nullable String title, @NotNull BasicMetaObject<?> meta, @NotNull Function<BasicElement, Pair<BasicElement, String>> extract, @NotNull PairConsumer<BasicModElement, Pair<BasicElement, String>> assign) {
            if (project == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(3);
            }
            if (property == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(4);
            }
            if (meta == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(5);
            }
            if (extract == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(6);
            }
            if (assign == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(7);
            }
            super(property, title);
            this.myTextField = new TextFieldWithCompletion(project, (TextCompletionProvider)new TextFieldCompletionProvider(){

                protected void addCompletionVariants(@NotNull String text2, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
                    if (text2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (prefix == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (result == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    this.addVariants(result);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "text";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "prefix";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "result";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectReferencePropEditor$1";
                    objectArray[2] = "addCompletionVariants";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, "", true, true, true);
            this.myTextField.addFocusListener((FocusListener)AutoSelectListener.INSTANCE);
            DbObjectGrantsEditorKt.enableAutoPopup((EditorTextField)this.myTextField);
            this.myMeta = meta;
            this.myExtract = extract;
            this.myAssign = assign;
        }

        private void addVariants(@NotNull CompletionResultSet result) {
            if (result == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(8);
            }
            if (this.myTraverser != null) {
                result.addAllElements((Iterable)this.myTraverser.filter(o -> result.getPrefixMatcher().prefixMatches(o.getName())).map(o -> LookupElementBuilder.create((String)o.getName()).withIcon(DbPresentationCore.getIcon(o)).withTypeText(DbPresentation.getPresentableName(o.getMetaObject()))));
            }
            result.stopHere();
        }

        @Override
        public void initCompletion(@NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath) {
            BasicModel model;
            if (dataSource2 == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(9);
            }
            if ((model = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class)) == null) {
                this.myTraverser = null;
                return;
            }
            HashSet metas = new HashSet();
            for (BasicMetaObject<?> t = this.myMeta; t != null; t = t.getParent()) {
                metas.add(t);
            }
            this.myTraverser = ((JBTreeTraverser)JBTreeTraverser.from(o -> JBIterable.from(o.getFamilies()).filter(f -> metas.contains(f.getMetaObject())).flatten((Function)Functions.id())).withRoot((Object)model.getRoot())).traverse().filter(o -> o.getMetaObject() == this.myMeta);
        }

        @Override
        public void apply(@Nullable BasicElement edited, @NotNull BasicModElement e) {
            if (e == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(10);
            }
            String name = this.myTextField.getText();
            BasicElement obj = this.myTraverser == null ? null : (BasicElement)this.myTraverser.filter(DasUtil.byName((String)name)).first();
            this.myAssign.consume((Object)e, (Object)Pair.create((Object)obj, (Object)name));
        }

        @Override
        public void reset(@NotNull BasicElement e) {
            Pair ext;
            if (e == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(11);
            }
            this.myTextField.setText(StringUtil.notNullize((ext = (Pair)this.myExtract.fun((Object)e)) == null ? null : (String)ext.second));
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            TextFieldWithCompletion textFieldWithCompletion = this.myTextField;
            if (textFieldWithCompletion == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(12);
            }
            return textFieldWithCompletion;
        }

        @Override
        @NotNull
        public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
            TypesRegistry.ParamEditor.FieldSize fieldSize = TypesRegistry.ParamEditor.FieldSize.LARGE;
            if (fieldSize == null) {
                DbObjectReferencePropEditor.$$$reportNull$$$0(13);
            }
            return fieldSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extract";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assign";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectReferencePropEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectReferencePropEditor";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNameReferenceEditor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addVariants";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "initCompletion";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 12: 
                case 13: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbObjectTextPropEditor<T>
    extends DbObjectSinglePropEditor<T> {
        private final Function<? super T, String> myFrom;
        private final Function<? super String, ? extends T> myTo;
        private final JTextField myTextField;

        public DbObjectTextPropEditor(@NotNull BasicMetaProperty<T> property, @NlsContexts.Label @Nullable String title, @NotNull Function<? super T, String> from, @NotNull Function<? super String, ? extends T> to) {
            if (property == null) {
                DbObjectTextPropEditor.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DbObjectTextPropEditor.$$$reportNull$$$0(1);
            }
            if (to == null) {
                DbObjectTextPropEditor.$$$reportNull$$$0(2);
            }
            super(property, title);
            this.myFrom = from;
            this.myTo = to;
            this.myTextField = this.isPassword(property) ? new JBPasswordField() : new JTextField();
            this.myTextField.addFocusListener(AutoSelectListener.INSTANCE);
        }

        private boolean isPassword(@NotNull BasicMetaProperty<T> property) {
            if (property == null) {
                DbObjectTextPropEditor.$$$reportNull$$$0(3);
            }
            return property.name.equals("Password") && property.type.valueClass == OneTimeString.class;
        }

        @Override
        public void apply(@Nullable BasicElement edited, @NotNull BasicModElement e) {
            if (e == null) {
                DbObjectTextPropEditor.$$$reportNull$$$0(4);
            }
            try {
                this.myProperty.set(e, this.myTo.fun((Object)this.myTextField.getText()));
                DbUIUtil.setError(this.myTextField, null);
            }
            catch (Throwable th) {
                DbUIUtil.setError(this.myTextField, th.getMessage());
            }
        }

        @Override
        public void reset(@NotNull BasicElement e) {
            if (e == null) {
                DbObjectTextPropEditor.$$$reportNull$$$0(5);
            }
            this.myTextField.setText((String)this.myFrom.fun(this.myProperty.get(e)));
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JTextField jTextField = this.myTextField;
            if (jTextField == null) {
                DbObjectTextPropEditor.$$$reportNull$$$0(6);
            }
            return jTextField;
        }

        @Override
        @NotNull
        public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
            TypesRegistry.ParamEditor.FieldSize fieldSize = Number.class.isAssignableFrom(this.myProperty.getValueClass()) ? TypesRegistry.ParamEditor.FieldSize.SMALL : TypesRegistry.ParamEditor.FieldSize.LARGE;
            if (fieldSize == null) {
                DbObjectTextPropEditor.$$$reportNull$$$0(7);
            }
            return fieldSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectTextPropEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectTextPropEditor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isPassword";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class DbObjectSinglePropEditor<T>
    extends DbObjectEditor {
        protected final BasicMetaProperty<T> myProperty;
        private final @NlsContexts.Label String myTitle;

        protected DbObjectSinglePropEditor(@NotNull BasicMetaProperty<T> property, @NlsContexts.Label @Nullable String title) {
            if (property == null) {
                DbObjectSinglePropEditor.$$$reportNull$$$0(0);
            }
            this.myProperty = property;
            this.myTitle = title;
        }

        @Override
        @NlsContexts.Label
        public String getTitle() {
            return this.myTitle;
        }

        @Override
        public void enable(@NotNull Function<BasicMetaProperty<?>, Boolean> enabled) {
            if (enabled == null) {
                DbObjectSinglePropEditor.$$$reportNull$$$0(1);
            }
            boolean state = (Boolean)enabled.fun(this.myProperty);
            JComponent component = this.getComponent();
            component.setEnabled(state);
            component.setToolTipText(state ? "" : DatabaseBundle.message((String)"not.supported", (Object[])new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enabled";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectSinglePropEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "enable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class DbObjectEditor {
        public abstract void apply(@Nullable BasicElement var1, @NotNull BasicModElement var2);

        public abstract void reset(@NotNull BasicElement var1);

        public abstract void enable(@NotNull Function<BasicMetaProperty<?>, Boolean> var1);

        public void initCompletion(@NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath) {
            if (dataSource2 == null) {
                DbObjectEditor.$$$reportNull$$$0(0);
            }
        }

        @NlsContexts.Label
        @Nullable
        public abstract String getTitle();

        @NotNull
        public abstract JComponent getComponent();

        @NotNull
        public abstract TypesRegistry.ParamEditor.FieldSize getFieldSize();

        public boolean isVertical() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbObjectEditor", "initCompletion"));
        }
    }
}

