/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.properties.Grants;
import com.intellij.database.schemaEditor.DbGrantsEditorUtilsKt;
import com.intellij.database.schemaEditor.GrantData;
import com.intellij.database.schemaEditor.StateKey;
import com.intellij.database.util.DbUIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\b\u001a\u00020\u0006*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u001aA\u0010\r\u001a\u00020\u0006\"\b\b\u0000\u0010\u000e*\u00020\f*\u00020\t2\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u0002H\u000e\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u0002H\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0013\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"preferredRowHeight", "", "table", "Ljavax/swing/JTable;", "row", "setupDynamicRowHeight", "", "updateRowHeights", "collectPermissions", "Lcom/intellij/database/schemaEditor/GrantData;", "gGrants", "", "Lcom/intellij/database/model/properties/Grants$Grant;", "extractPermissions", "G", "grantCtl", "Lcom/intellij/database/model/properties/Grants$Controller;", "targetGrant", "res", "", "(Lcom/intellij/database/schemaEditor/GrantData;Lcom/intellij/database/model/properties/Grants$Controller;Lcom/intellij/database/model/properties/Grants$Grant;Ljava/util/List;)V", "intellij.database.impl"})
public final class DbGrantsEditorUtilsKt {
    /*
     * WARNING - void declaration
     */
    public static final <G extends Grants.Grant> void extractPermissions(@NotNull GrantData $this$extractPermissions, @NotNull Grants.Controller<G, ?> grantCtl, @NotNull G targetGrant, @NotNull List<G> res2) {
        Intrinsics.checkNotNullParameter((Object)$this$extractPermissions, (String)"$this$extractPermissions");
        Intrinsics.checkNotNullParameter(grantCtl, (String)"grantCtl");
        Intrinsics.checkNotNullParameter(targetGrant, (String)"targetGrant");
        Intrinsics.checkNotNullParameter(res2, (String)"res");
        for (Grants.State state : Grants.State.values()) {
            Map<String, BitSet> grouped = $this$extractPermissions.groupColumnsForState(state);
            for (Map.Entry<String, BitSet> entry : grouped.entrySet()) {
                void it2;
                BitSet bitSet = entry.getValue();
                boolean bl = false;
                boolean bl2 = false;
                BitSet bitSet2 = bitSet;
                String string = entry.getKey();
                G g = targetGrant;
                Grants.Controller<G, ?> controller = grantCtl;
                boolean bl3 = false;
                boolean bl4 = !it2.isEmpty();
                G grant = controller.withPermission(g, string, bl4 ? bitSet : null, state);
                res2.add(grant);
            }
        }
    }

    public static final void collectPermissions(@NotNull GrantData $this$collectPermissions, @NotNull Collection<? extends Grants.Grant> gGrants) {
        Intrinsics.checkNotNullParameter((Object)$this$collectPermissions, (String)"$this$collectPermissions");
        Intrinsics.checkNotNullParameter(gGrants, (String)"gGrants");
        for (Grants.Grant grant : gGrants) {
            if (grant.isSub()) {
                grant.getSubsStream().forEach(new IntConsumer($this$collectPermissions, grant){
                    final /* synthetic */ GrantData $this_collectPermissions;
                    final /* synthetic */ Grants.Grant $grant;

                    public final void accept(int col) {
                        ((Map)this.$this_collectPermissions.getGrants()).put(new StateKey(this.$grant.getPermissionName(), col), this.$grant.getState());
                    }
                    {
                        this.$this_collectPermissions = grantData;
                        this.$grant = grant;
                    }
                });
                continue;
            }
            ((Map)$this$collectPermissions.getGrants()).put(new StateKey(grant.getPermissionName(), null), grant.getState());
        }
    }

    public static final void setupDynamicRowHeight(@NotNull JTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        table.getModel().addTableModelListener(new TableModelListener(table){
            final /* synthetic */ JTable $table;

            public final void tableChanged(TableModelEvent it2) {
                DbUIUtil.invokeLater(new Runnable(this){
                    final /* synthetic */ setupDynamicRowHeight.1 this$0;

                    public final void run() {
                        DbGrantsEditorUtilsKt.access$updateRowHeights(this.this$0.$table);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$table = jTable;
            }
        });
    }

    private static final void updateRowHeights(JTable table) {
        int rc = table.getRowCount();
        for (int row = 0; row < rc; ++row) {
            int height = DbGrantsEditorUtilsKt.preferredRowHeight(table, row);
            table.setRowHeight(row, height);
        }
    }

    private static final int preferredRowHeight(JTable table, int row) {
        int height = table.getRowHeight();
        int cc = table.getColumnCount();
        for (int col = 0; col < cc; ++col) {
            Component component;
            Component component2 = component = table.getCellRenderer(row, col).getTableCellRendererComponent(table, table.getValueAt(row, col), false, false, row, col);
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"component");
            Dimension size = component2.getPreferredSize();
            height = RangesKt.coerceAtLeast((int)height, (int)size.height);
        }
        return height;
    }

    public static final /* synthetic */ void access$updateRowHeights(JTable table) {
        DbGrantsEditorUtilsKt.updateRowHeights(table);
    }
}

