/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/run/ui/table/UnparsedValueHoverListener;", "Lcom/intellij/ui/hover/TableHoverListener;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/Disposable;)V", "alarm", "Lcom/intellij/util/Alarm;", "Lorg/jetbrains/annotations/NotNull;", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "balloonColumn", "", "Ljava/lang/Integer;", "balloonRow", "hideTooltip", "", "onHover", "table", "Ljavax/swing/JTable;", "row", "column", "showTooltip", "intellij.database.impl"})
public final class UnparsedValueHoverListener
extends TableHoverListener {
    private final Alarm alarm;
    private Integer balloonRow;
    private Integer balloonColumn;
    private Balloon balloon;

    public void onHover(@NotNull JTable table, int row, int column2) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        if (row == -1 || column2 == -1) {
            return;
        }
        Object value2 = table.getValueAt(row, column2);
        this.alarm.cancelAllRequests();
        if (!(value2 instanceof UnparsedValue)) {
            this.hideTooltip();
        } else {
            this.showTooltip(table, row, column2);
        }
    }

    private final void showTooltip(JTable table, int row, int column2) {
        Integer n = this.balloonRow;
        if (n != null && n == row) {
            Integer n2 = this.balloonColumn;
            if (n2 != null && n2 == column2) {
                return;
            }
        }
        this.hideTooltip();
        this.alarm.addRequest(new Runnable(this, row, column2, table){
            final /* synthetic */ UnparsedValueHoverListener this$0;
            final /* synthetic */ int $row;
            final /* synthetic */ int $column;
            final /* synthetic */ JTable $table;

            public final void run() {
                block0: {
                    UnparsedValueHoverListener.access$setBalloon$p(this.this$0, JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(DatabaseBundle.message((String)"popup.content.unparsed.value", (Object[])new Object[0]), MessageType.ERROR, null).setHideOnAction(true).setHideOnClickOutside(true).setHideOnLinkClick(true).createBalloon());
                    UnparsedValueHoverListener.access$setBalloonRow$p(this.this$0, this.$row);
                    UnparsedValueHoverListener.access$setBalloonColumn$p(this.this$0, this.$column);
                    Rectangle cellRect = this.$table.getCellRect(this.$row, this.$column, true);
                    JScrollPane scrollPane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)this.$table);
                    Rectangle rectangle = cellRect;
                    Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"cellRect");
                    Point point = rectangle.getLocation();
                    boolean bl = false;
                    boolean bl2 = false;
                    Point $this$apply = point;
                    boolean bl3 = false;
                    $this$apply.translate(cellRect.width / 2, cellRect.height);
                    int n = $this$apply.x;
                    JComponent jComponent = scrollPane;
                    int n2 = jComponent != null && (jComponent = ((JScrollPane)jComponent).getHorizontalScrollBar()) != null ? ((JScrollBar)jComponent).getValue() : 0;
                    boolean bl4 = false;
                    $this$apply.move(Math.max(n, n2), $this$apply.y);
                    Point point2 = point;
                    Balloon balloon = UnparsedValueHoverListener.access$getBalloon$p(this.this$0);
                    if (balloon == null) break block0;
                    balloon.show(new RelativePoint((Component)this.$table, point2), Balloon.Position.below);
                }
            }
            {
                this.this$0 = unparsedValueHoverListener;
                this.$row = n;
                this.$column = n2;
                this.$table = jTable;
            }
        }, 300);
    }

    private final void hideTooltip() {
        Balloon balloon = this.balloon;
        if (balloon != null) {
            balloon.hide();
        }
        this.balloon = null;
        this.balloonRow = null;
        this.balloonColumn = null;
    }

    public UnparsedValueHoverListener(@NotNull Disposable disposable2) {
        Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
        Alarm alarm2 = AlarmFactory.getInstance().create(Alarm.ThreadToUse.SWING_THREAD, disposable2);
        Intrinsics.checkNotNullExpressionValue((Object)alarm2, (String)"AlarmFactory.getInstance\u2026SWING_THREAD, disposable)");
        this.alarm = alarm2;
    }

    public static final /* synthetic */ Balloon access$getBalloon$p(UnparsedValueHoverListener $this) {
        return $this.balloon;
    }

    public static final /* synthetic */ void access$setBalloon$p(UnparsedValueHoverListener $this, Balloon balloon) {
        $this.balloon = balloon;
    }

    public static final /* synthetic */ Integer access$getBalloonRow$p(UnparsedValueHoverListener $this) {
        return $this.balloonRow;
    }

    public static final /* synthetic */ void access$setBalloonRow$p(UnparsedValueHoverListener $this, Integer n) {
        $this.balloonRow = n;
    }

    public static final /* synthetic */ Integer access$getBalloonColumn$p(UnparsedValueHoverListener $this) {
        return $this.balloonColumn;
    }

    public static final /* synthetic */ void access$setBalloonColumn$p(UnparsedValueHoverListener $this, Integer n) {
        $this.balloonColumn = n;
    }
}

