/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.GridSelectionImpl;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.SelectionModelWithViewColumns;
import com.intellij.database.datagrid.SelectionModelWithViewRows;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.selection.GridSelectionTracker;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.IntUnaryOperator;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;

class TableSelectionModel
implements SelectionModel<DataConsumer.Row, DataConsumer.Column>,
SelectionModelWithViewRows,
SelectionModelWithViewColumns {
    private final TableResultView myTable;
    private final TableResultPanel myGrid;
    private final GridSelectionTracker myTracker;

    TableSelectionModel(@NotNull TableResultView table, @NotNull TableResultPanel grid) {
        if (table == null) {
            TableSelectionModel.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            TableSelectionModel.$$$reportNull$$$0(1);
        }
        this.myTable = table;
        this.myGrid = grid;
        this.myTracker = new GridSelectionTracker(this.myGrid, this.myTable);
        this.myTable.putClientProperty("SelectionModel", this);
    }

    @NotNull
    public GridSelectionImpl store() {
        int[] rows = TableSelectionModel.convert(this.myTable.getRowCount(), arg_0 -> this.myTable.convertRowIndexToModel(arg_0), this.myTable.getSelectedRows());
        int[] columns = TableSelectionModel.convert(this.myTable.getColumnCount(), arg_0 -> this.myTable.convertColumnIndexToModel(arg_0), this.myTable.getSelectedColumns());
        if (this.myTable.isTransposed()) {
            int[] temp = rows;
            rows = columns;
            columns = temp;
        }
        return new GridSelectionImpl(ModelIndexSet.forRows(this.myGrid, rows), ModelIndexSet.forColumns(this.myGrid, columns));
    }

    @Override
    @NotNull
    public GridSelectionTracker getTracker() {
        GridSelectionTracker gridSelectionTracker = this.myTracker;
        if (gridSelectionTracker == null) {
            TableSelectionModel.$$$reportNull$$$0(2);
        }
        return gridSelectionTracker;
    }

    public void setColumnSelectionInterval(int idx0, int idx1) {
        TableSelectionModel.setSelectionInterval(this.myTable.getColumnModel().getSelectionModel(), false, this.myTable.getColumnCount() - 1, idx0, idx1);
    }

    public void addColumnSelectionInterval(int idx0, int idx1) {
        TableSelectionModel.setSelectionInterval(this.myTable.getColumnModel().getSelectionModel(), true, this.myTable.getColumnCount() - 1, idx0, idx1);
    }

    public void setRowSelectionInterval(int idx0, int idx1) {
        TableSelectionModel.setSelectionInterval(this.myTable.getSelectionModel(), false, this.myTable.getRowCount() - 1, idx0, idx1);
    }

    public void addRowSelectionInterval(int idx0, int idx1) {
        TableSelectionModel.setSelectionInterval(this.myTable.getSelectionModel(), true, this.myTable.getRowCount() - 1, idx0, idx1);
    }

    @Override
    public void setColumnSelection(@NotNull ModelIndexSet<DataConsumer.Column> columns, boolean selectAtLeastOneCell) {
        if (columns == null) {
            TableSelectionModel.$$$reportNull$$$0(3);
        }
        ViewIndexSet<DataConsumer.Column> viewIndexSet = columns.toView(this.myGrid);
        this.setSelection(true, viewIndexSet.asArray());
        if (!selectAtLeastOneCell) {
            return;
        }
        GridSelectionImpl selection = this.store();
        if (selection.getSelectedRows().size() == 0) {
            int firstRow = this.myTable.getRawIndexConverter().row2Model().applyAsInt(0);
            this.setRowSelection(ModelIndexSet.forRows(this.myGrid, firstRow), false);
        }
    }

    @Override
    public void setColumnSelection(@NotNull ModelIndex<DataConsumer.Column> column2, boolean selectAtLeastOneCell) {
        if (column2 == null) {
            TableSelectionModel.$$$reportNull$$$0(4);
        }
        this.setColumnSelection(ModelIndexSet.forColumns(this.myGrid, column2.value), selectAtLeastOneCell);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.myTable.getSelectionModel().isSelectionEmpty() || this.myTable.getColumnModel().getSelectionModel().isSelectionEmpty();
    }

    @Override
    public boolean isSelected(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (row == null) {
            TableSelectionModel.$$$reportNull$$$0(5);
        }
        if (column2 == null) {
            TableSelectionModel.$$$reportNull$$$0(6);
        }
        return this.isSelected(row.toView(this.myGrid), column2.toView(this.myGrid));
    }

    @Override
    public boolean isSelected(@NotNull ViewIndex<DataConsumer.Row> row, @NotNull ViewIndex<DataConsumer.Column> column2) {
        if (row == null) {
            TableSelectionModel.$$$reportNull$$$0(7);
        }
        if (column2 == null) {
            TableSelectionModel.$$$reportNull$$$0(8);
        }
        int displayRow = this.myTable.isTransposed() ? column2.asInteger() : row.asInteger();
        int displayColumn = this.myTable.isTransposed() ? row.asInteger() : column2.asInteger();
        return this.myTable.isRowSelected(displayRow) && this.myTable.isColumnSelected(displayColumn);
    }

    @Override
    public boolean isSelectedColumn(@NotNull ModelIndex<DataConsumer.Column> column2) {
        if (column2 == null) {
            TableSelectionModel.$$$reportNull$$$0(9);
        }
        ViewIndex<DataConsumer.Column> colIdx = column2.toView(this.myGrid);
        int index2 = colIdx.asInteger();
        return this.myTable.isTransposed() ? this.myTable.isRowSelected(index2) : this.myTable.isColumnSelected(index2);
    }

    @Override
    public boolean isSelectedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            TableSelectionModel.$$$reportNull$$$0(10);
        }
        ViewIndex<DataConsumer.Row> rowIdx = row.toView(this.myGrid);
        int index2 = rowIdx.asInteger();
        return this.myTable.isTransposed() ? this.myTable.isColumnSelected(index2) : this.myTable.isRowSelected(index2);
    }

    @Override
    public void setRowSelection(@NotNull ModelIndexSet<DataConsumer.Row> rows, boolean selectAtLeastOneCell) {
        if (rows == null) {
            TableSelectionModel.$$$reportNull$$$0(11);
        }
        ViewIndexSet<DataConsumer.Row> viewIndexSet = rows.toView(this.myGrid);
        this.setSelection(false, viewIndexSet.asArray());
        if (!selectAtLeastOneCell) {
            return;
        }
        GridSelectionImpl selection = this.store();
        if (selection.getSelectedColumns().size() == 0) {
            int firstColumn = this.myTable.getRawIndexConverter().column2Model().applyAsInt(0);
            this.setColumnSelection(ModelIndexSet.forColumns(this.myGrid, firstColumn), false);
        }
    }

    @Override
    public void setSelection(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (rows == null) {
            TableSelectionModel.$$$reportNull$$$0(12);
        }
        if (columns == null) {
            TableSelectionModel.$$$reportNull$$$0(13);
        }
        this.setRowSelection(rows, false);
        this.setColumnSelection(columns, false);
    }

    @Override
    public void setSelection(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (row == null) {
            TableSelectionModel.$$$reportNull$$$0(14);
        }
        if (column2 == null) {
            TableSelectionModel.$$$reportNull$$$0(15);
        }
        this.setRowSelection(row, false);
        this.setColumnSelection(column2, false);
    }

    @Override
    public void setRowSelection(@NotNull ModelIndex<DataConsumer.Row> row, boolean selectAtLeastOneCell) {
        if (row == null) {
            TableSelectionModel.$$$reportNull$$$0(16);
        }
        this.setRowSelection(ModelIndexSet.forRows(this.myGrid, row.value), selectAtLeastOneCell);
    }

    @Override
    public int getSelectedRowCount() {
        return this.myTable.isTransposed() ? this.myTable.getSelectedColumnCount() : this.myTable.getSelectedRowCount();
    }

    @Override
    public int getSelectedColumnCount() {
        return this.myTable.isTransposed() ? this.myTable.getSelectedRowCount() : this.myTable.getSelectedColumnCount();
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Row> getSelectedRow() {
        int viewRowIndex = this.myTable.isTransposed() ? this.myTable.getSelectedColumn() : this.myTable.getSelectedRow();
        ModelIndex<DataConsumer.Row> modelIndex = ViewIndex.forRow(this.myGrid, viewRowIndex >= 0 ? viewRowIndex : -1).toModel(this.myGrid);
        if (modelIndex == null) {
            TableSelectionModel.$$$reportNull$$$0(17);
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getSelectedRows() {
        ModelIndexSet<DataConsumer.Row> modelIndexSet = ViewIndexSet.forRows(this.myGrid, this.myTable.isTransposed() ? this.myTable.getSelectedColumns() : this.myTable.getSelectedRows()).toModel(this.myGrid);
        if (modelIndexSet == null) {
            TableSelectionModel.$$$reportNull$$$0(18);
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Row> getLeadSelectionRow() {
        int idx = this.myTable.isTransposed() ? this.myTable.getColumnModel().getSelectionModel().getLeadSelectionIndex() : this.myTable.getSelectionModel().getLeadSelectionIndex();
        ModelIndex<DataConsumer.Row> modelIndex = ViewIndex.forRow(this.myGrid, idx).toModel(this.myGrid);
        if (modelIndex == null) {
            TableSelectionModel.$$$reportNull$$$0(19);
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> getSelectedColumn() {
        ModelIndex<DataConsumer.Column> modelIndex = ViewIndex.forColumn(this.myGrid, this.myTable.isTransposed() ? this.myTable.getSelectedRow() : this.myTable.getSelectedColumn()).toModel(this.myGrid);
        if (modelIndex == null) {
            TableSelectionModel.$$$reportNull$$$0(20);
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> getLeadSelectionColumn() {
        int idx = this.myTable.isTransposed() ? this.myTable.getSelectionModel().getLeadSelectionIndex() : this.myTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        ModelIndex<DataConsumer.Column> modelIndex = ViewIndex.forColumn(this.myGrid, idx).toModel(this.myGrid);
        if (modelIndex == null) {
            TableSelectionModel.$$$reportNull$$$0(21);
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getSelectedColumns() {
        ModelIndexSet<DataConsumer.Column> modelIndexSet = ViewIndexSet.forColumns(this.myGrid, this.myTable.isTransposed() ? this.myTable.getSelectedRows() : this.myTable.getSelectedColumns()).toModel(this.myGrid);
        if (modelIndexSet == null) {
            TableSelectionModel.$$$reportNull$$$0(22);
        }
        return modelIndexSet;
    }

    @Override
    public void selectWholeRow() {
        this.myGrid.getAutoscrollLocker().runWithLock(() -> {
            this.myGrid.getHiddenColumnSelectionHolder().setWholeRowSelected(!this.myTable.isTransposed());
            this.setColumnSelectionInterval(this.myTable.getColumnCount() - 1, 0);
        });
    }

    @Override
    public void selectWholeColumn() {
        this.myGrid.getAutoscrollLocker().runWithLock(() -> this.setRowSelectionInterval(this.myTable.getRowCount() - 1, 0));
    }

    private void setSelection(boolean columns, int[] array) {
        if (this.myTable.isTransposed() && columns || !this.myTable.isTransposed() && !columns) {
            TableSelectionModel.setSelection(this.myTable.getSelectionModel(), false, this.myTable.getRowCount() - 1, array);
        } else {
            TableSelectionModel.setSelection(this.myTable.getColumnModel().getSelectionModel(), false, this.myTable.getColumnCount() - 1, array);
        }
    }

    @Override
    public void addRowSelection(@NotNull ModelIndexSet<DataConsumer.Row> selection) {
        if (selection == null) {
            TableSelectionModel.$$$reportNull$$$0(23);
        }
        TableSelectionModel.setSelection(this.myTable.getSelectionModel(), true, this.myTable.getRowCount() - 1, selection.asArray());
    }

    @Override
    public int selectedViewRowsCount() {
        return this.myTable.isTransposed() ? this.getSelectedRows().size() : this.getSelectedColumns().size();
    }

    @Override
    public int selectedViewColumnsCount() {
        return this.myTable.isTransposed() ? this.getSelectedColumns().size() : this.getSelectedRows().size();
    }

    private static void setSelection(ListSelectionModel selectionModel, boolean add, int maxSelectionIdx, int ... selection) {
        if (maxSelectionIdx < 0) {
            return;
        }
        if (!add) {
            selectionModel.clearSelection();
        }
        for (int index2 : selection) {
            if (index2 == -1) continue;
            TableSelectionModel.setSelectionInterval(selectionModel, true, maxSelectionIdx, index2, index2);
        }
    }

    private static void setSelectionInterval(ListSelectionModel selectionModel, boolean add, int maxSelectionIdx, int idx0, int idx1) {
        if (maxSelectionIdx < 0) {
            return;
        }
        idx0 = TableSelectionModel.index(idx0, maxSelectionIdx);
        idx1 = TableSelectionModel.index(idx1, maxSelectionIdx);
        if (add) {
            selectionModel.addSelectionInterval(idx0, idx1);
        } else {
            selectionModel.setSelectionInterval(idx0, idx1);
        }
    }

    private static int index(int idx, int maxIdx) {
        return Math.max(0, Math.min(idx, maxIdx));
    }

    private static int[] convert(int maxIndex, IntUnaryOperator function2, int[] indices) {
        return Arrays.stream(indices).filter(index2 -> index2 < maxIndex && index2 >= 0).map(function2).filter(index2 -> index2 != -1).toArray();
    }

    @Override
    @NotNull
    public GridSelection<DataConsumer.Row, DataConsumer.Column> fit(@NotNull GridSelection<DataConsumer.Row, DataConsumer.Column> selection) {
        if (selection == null) {
            TableSelectionModel.$$$reportNull$$$0(24);
        }
        int rowCount = this.myTable.isTransposed() ? this.myTable.getColumnCount() : this.myTable.getRowCount();
        int columnCount = this.myTable.isTransposed() ? this.myTable.getRowCount() : this.myTable.getColumnCount();
        ModelIndexSet<DataConsumer.Row> rows = ModelIndexSet.forRows(this.myGrid, TableSelectionModel.fit(selection.getSelectedRows().asArray(), rowCount));
        ModelIndexSet<DataConsumer.Column> columns = ModelIndexSet.forColumns(this.myGrid, TableSelectionModel.fit(selection.getSelectedColumns().asArray(), columnCount));
        return new GridSelectionImpl(rows, columns);
    }

    private static int[] fit(@NotNull int[] indices, int max) {
        if (indices == null) {
            TableSelectionModel.$$$reportNull$$$0(25);
        }
        ArrayList<Integer> newIndices = new ArrayList<Integer>();
        for (int index2 : indices) {
            if (index2 >= max) continue;
            newIndices.add(index2);
        }
        return ArrayUtil.toIntArray(newIndices);
    }

    @Override
    public void restore(@NotNull GridSelection<DataConsumer.Row, DataConsumer.Column> selection) {
        if (selection == null) {
            TableSelectionModel.$$$reportNull$$$0(26);
        }
        this.myTable.clearSelection();
        SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = this.myGrid.getSelectionModel();
        selectionModel.setSelection(selection.getSelectedRows(), selection.getSelectedColumns());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/table/TableSelectionModel";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/table/TableSelectionModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracker";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRow";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRows";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelectionRow";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedColumn";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelectionColumn";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setColumnSelection";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedColumn";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedRow";
                break;
            }
            case 11: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setRowSelection";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addRowSelection";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fit";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

