/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridColumnLayout;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.RawIndexConverter;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.GridTableCellEditor;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.ResultViewWithCells;
import com.intellij.database.run.ui.ResultViewWithColumns;
import com.intellij.database.run.ui.ResultViewWithRows;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.database.run.ui.grid.CellRenderingUtils;
import com.intellij.database.run.ui.grid.DataGridSearchSession;
import com.intellij.database.run.ui.grid.DefaultGridColumnLayout;
import com.intellij.database.run.ui.grid.DummyGridColumnLayout;
import com.intellij.database.run.ui.grid.GridColorSchemeUtil;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.grid.GridSearchSession;
import com.intellij.database.run.ui.grid.JBTableWithResizableCells;
import com.intellij.database.run.ui.grid.ResizableCellEditorsSupport;
import com.intellij.database.run.ui.grid.TableCellImageCache;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderers;
import com.intellij.database.run.ui.table.GridSelectionGrower;
import com.intellij.database.run.ui.table.GridTableModel;
import com.intellij.database.run.ui.table.TableGoToRowHelper;
import com.intellij.database.run.ui.table.TablePositionWidgetHelper;
import com.intellij.database.run.ui.table.TableRawIndexConverter;
import com.intellij.database.run.ui.table.TableResultRowHeader;
import com.intellij.database.run.ui.table.TableScrollPositionManager;
import com.intellij.database.run.ui.table.TableSelectionModel;
import com.intellij.database.run.ui.table.UnparsedValueHoverListener;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.find.FindModel;
import com.intellij.find.SearchSession;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import gnu.trove.TIntObjectProcedure;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.IntUnaryOperator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TableResultView
extends JBTableWithResizableCells
implements ResultView,
ResultViewWithCells,
ResultViewWithColumns,
ResultViewWithRows,
EditorColorsListener,
UISettingsListener {
    public static final Key<EventObject> EDITING_STARTER_CLIENT_PROPERTY_KEY = Key.create((String)"EventThatCausedEditingToStart");
    private static final ColorKey HOVER_BACKGROUND = ColorKey.createColorKey((String)"Table.hoverBackground", (Color)JBUI.CurrentTheme.Table.Hover.background((boolean)true));
    private final TableResultPanel myResultPanel;
    private final MyTableColumnCache myColumnCache;
    private final Renderers myRenderers;
    private final TableCellImageCache myCellImageCache;
    private final GridCellEditorFactoryProvider myEditorProvider;
    private final TableRawIndexConverter myRawIndexConverter;
    private final ActionGroup myColumnHeaderPopupActions;
    private final ActionGroup myRowHeaderPopupActions;
    private final GridColumnLayout<DataConsumer.Row, DataConsumer.Column> myColumnLayout;
    private final GridSelectionGrower myGrower;
    private ModelIndex<DataConsumer.Column> myClickedHeaderColumnIdx;
    private double myFontSizeIncrement;
    private double myFontSizeScale;
    private int myColumnsHashCode;
    private PaintingSession myPaintingSession;
    private Ref<Object> myCommonValue;
    private boolean myWasAutomaticallyTransposed;

    public TableResultView(TableResultPanel resultPanel, @NotNull GridCellEditorFactoryProvider editorProvider, @NotNull ActionGroup columnHeaderPopupActions, @NotNull ActionGroup rowHeaderPopupActions) {
        if (editorProvider == null) {
            TableResultView.$$$reportNull$$$0(0);
        }
        if (columnHeaderPopupActions == null) {
            TableResultView.$$$reportNull$$$0(1);
        }
        if (rowHeaderPopupActions == null) {
            TableResultView.$$$reportNull$$$0(2);
        }
        super(new GridTableModel.Regular(resultPanel), new MyTableColumnModel());
        this.myFontSizeIncrement = 0.0;
        this.myFontSizeScale = 1.0;
        this.myWasAutomaticallyTransposed = false;
        this.myResultPanel = resultPanel;
        this.myCellImageCache = new TableCellImageCache(this, this.myResultPanel);
        this.myEditorProvider = editorProvider;
        this.myColumnHeaderPopupActions = columnHeaderPopupActions;
        this.myRowHeaderPopupActions = rowHeaderPopupActions;
        this.myRawIndexConverter = new TableRawIndexConverter(this);
        this.myColumnCache = new MyTableColumnCache();
        this.myRenderers = new Renderers(this.myResultPanel, this);
        this.myClickedHeaderColumnIdx = ModelIndex.forColumn(this.myResultPanel, -1);
        this.myColumnLayout = ApplicationManager.getApplication().isUnitTestMode() ? new DummyGridColumnLayout() : new DefaultGridColumnLayout(this, resultPanel);
        this.myGrower = new GridSelectionGrower(this.myResultPanel, this);
        this.getTableHeader().setDefaultRenderer(this.createHeaderRenderer());
        this.setAdditionalRowsCount(5);
        new ResizableCellEditorsSupport(this);
        this.setupFocusListener();
        this.setupMagnificator();
        this.setEnableAntialiasing(true);
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
        this.setFont(this.getColorsScheme().getFont(EditorFontType.PLAIN));
        this.updateFonts();
        this.adjustDefaultActions();
        this.addPropertyChangeListener("tableCellEditor", e -> DataGridUtil.updateWidgets(resultPanel));
        new TableSelectionModel(this, this.myResultPanel);
        new TableGoToRowHelper(this, this.myResultPanel);
        new TablePositionWidgetHelper(this, this.myResultPanel);
        new TableScrollPositionManager(this, this.myResultPanel);
        this.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                TableResultView.this.myGrower.reset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/table/TableResultView$1", "valueChanged"));
            }
        });
        this.myResultPanel.addDataGridListener(new DataGridListener(){

            @Override
            public void onValueEdited(DataGrid dataGrid, @Nullable Object object) {
                TableResultView.this.myCommonValue = Ref.create((Object)object);
            }
        }, this);
        this.addSelectionChangedListener(true, () -> this.getScrollPane().repaint());
        new UnparsedValueHoverListener(this).addTo((JComponent)((Object)this));
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        TableResultView tableResultView = this;
        if (tableResultView == null) {
            TableResultView.$$$reportNull$$$0(3);
        }
        return tableResultView;
    }

    @Override
    public void setValueAt(@Nullable Object v, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, boolean allowImmediateUpdate, @Nullable Object requestor) {
        if (row == null) {
            TableResultView.$$$reportNull$$$0(4);
        }
        if (column2 == null) {
            TableResultView.$$$reportNull$$$0(5);
        }
        int viewRowIdx = this.isTransposed() ? column2.toView(this.myResultPanel).asInteger() : row.toView(this.myResultPanel).asInteger();
        int viewColumnIdx = this.isTransposed() ? row.toView(this.myResultPanel).asInteger() : column2.toView(this.myResultPanel).asInteger();
        this.setValueAt(v, viewRowIdx, viewColumnIdx, allowImmediateUpdate, requestor);
    }

    @Override
    public void setTransposed(boolean transposed) {
        this.myWasAutomaticallyTransposed = false;
        if (this.isTransposed() == transposed) {
            return;
        }
        DataGridUtil.saveAndRestoreSelection(this.myResultPanel, () -> {
            this.doTranspose();
            this.createDefaultColumnsFromModel();
        });
    }

    @Override
    @NotNull
    public JScrollBar getVerticalScrollBar() {
        JScrollBar jScrollBar = this.getScrollPane().getVerticalScrollBar();
        if (jScrollBar == null) {
            TableResultView.$$$reportNull$$$0(6);
        }
        return jScrollBar;
    }

    @NotNull
    private JScrollPane getScrollPane() {
        JScrollPane jScrollPane = Objects.requireNonNull((JScrollPane)ComponentUtil.getParentOfType(JScrollPane.class, (Component)((Object)this)));
        if (jScrollPane == null) {
            TableResultView.$$$reportNull$$$0(7);
        }
        return jScrollPane;
    }

    @Override
    @NotNull
    public JScrollBar getHorizontalScrollBar() {
        JScrollBar jScrollBar = this.getScrollPane().getHorizontalScrollBar();
        if (jScrollBar == null) {
            TableResultView.$$$reportNull$$$0(8);
        }
        return jScrollBar;
    }

    @Override
    public void resetLayout() {
        this.myColumnLayout.resetLayout();
    }

    @Override
    public void growSelection() {
        this.myGrower.growSelection();
    }

    @Override
    public void shrinkSelection() {
        this.myGrower.shrinkSelection();
    }

    @Override
    public void addSelectionChangedListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            TableResultView.$$$reportNull$$$0(9);
        }
        this.addSelectionChangedListener(false, listener2);
    }

    private void addSelectionChangedListener(boolean allowAdjustingValue, @NotNull Runnable listener2) {
        if (listener2 == null) {
            TableResultView.$$$reportNull$$$0(10);
        }
        ListSelectionListener l = e -> {
            if (allowAdjustingValue || !e.getValueIsAdjusting()) {
                listener2.run();
            }
        };
        this.getColumnModel().getSelectionModel().addListSelectionListener(l);
        this.getSelectionModel().addListSelectionListener(l);
    }

    @Override
    public void restoreColumnsOrder(Map<Integer, ModelIndex<DataConsumer.Column>> expectedToModel) {
        if (this.isTransposed()) {
            return;
        }
        IntUnaryOperator column2View = this.getRawIndexConverter().column2View();
        int columnsCount = this.myResultPanel.getVisibleColumnCount();
        for (int expectedPos = 0; expectedPos < columnsCount; ++expectedPos) {
            int actualPos;
            ModelIndex<DataConsumer.Column> modelIndex = expectedToModel.get(expectedPos);
            if (modelIndex == null || (actualPos = column2View.applyAsInt(modelIndex.value)) == -1 || actualPos == expectedPos) continue;
            this.moveColumn(actualPos, expectedPos);
        }
    }

    public void setViewColumnVisible(ModelIndex<?> modelColumnIdx, boolean visible) {
        ViewIndex<?> viewColumnIdx = modelColumnIdx.toView(this.myResultPanel);
        if (visible && viewColumnIdx.asInteger() < 0) {
            boolean firstTimeShown = !this.getColumnCache().hasCachedColumn(modelColumnIdx.asInteger());
            this.addColumn(this.getColumnCache().getOrCreateColumn(modelColumnIdx.asInteger()));
            int lastColumnIndex = this.getColumnCount() - 1;
            this.myResultPanel.runWithIgnoreSelectionChanges(() -> {
                for (int viewTargetColumnIdx = 0; viewTargetColumnIdx < lastColumnIndex; ++viewTargetColumnIdx) {
                    if (this.getColumnModel().getColumn(viewTargetColumnIdx).getModelIndex() <= modelColumnIdx.asInteger()) continue;
                    this.moveColumn(lastColumnIndex, viewTargetColumnIdx);
                    break;
                }
            });
            if (firstTimeShown) {
                this.myColumnLayout.columnsShown(this.isTransposed() ? ModelIndexSet.forRows(this.myResultPanel, modelColumnIdx.asInteger()) : ModelIndexSet.forColumns(this.myResultPanel, modelColumnIdx.asInteger()));
            }
        } else if (!visible && viewColumnIdx.asInteger() >= 0) {
            this.getTableHeader().setDraggedColumn(null);
            this.myResultPanel.runWithIgnoreSelectionChanges(() -> this.getColumnModel().removeColumn(this.getColumnModel().getColumn(viewColumnIdx.asInteger())));
        }
    }

    @NotNull
    public ModelIndex<DataConsumer.Column> uiColumn(int uiColumn) {
        int modelIndex = uiColumn < 1 || uiColumn >= this.myResultPanel.getVisibleColumnCount() + 1 ? -1 : this.getRawIndexConverter().column2Model().applyAsInt(uiColumn - 1);
        ModelIndex<DataConsumer.Column> modelIndex2 = ModelIndex.forColumn(this.myResultPanel, modelIndex);
        if (modelIndex2 == null) {
            TableResultView.$$$reportNull$$$0(11);
        }
        return modelIndex2;
    }

    @NotNull
    public ModelIndex<DataConsumer.Row> uiRow(int uiRow) {
        ModelIndex<DataConsumer.Row> modelIndex = ModelIndex.forRow(this.myResultPanel, uiRow < 1 ? -1 : uiRow - 1);
        if (modelIndex == null) {
            TableResultView.$$$reportNull$$$0(12);
        }
        return modelIndex;
    }

    @Override
    public void showFirstCell(int rowNumOnCurrentPage) {
        this.myResultPanel.showCell(this.uiRow(rowNumOnCurrentPage), this.uiColumn(0));
    }

    @NotNull
    private GridColorsScheme getColorsScheme() {
        GridColorsScheme gridColorsScheme = this.myResultPanel.getColorsScheme();
        if (gridColorsScheme == null) {
            TableResultView.$$$reportNull$$$0(13);
        }
        return gridColorsScheme;
    }

    @Override
    public void searchSessionUpdated() {
        this.updateRowFilter();
        this.getComponent().repaint();
    }

    @Nullable
    public JComponent getCellRendererComponent(@NotNull ViewIndex<DataConsumer.Row> viewRow, @NotNull ViewIndex<DataConsumer.Column> viewColumn, boolean forDisplay) {
        int column2;
        if (viewRow == null) {
            TableResultView.$$$reportNull$$$0(14);
        }
        if (viewColumn == null) {
            TableResultView.$$$reportNull$$$0(15);
        }
        if (!viewRow.isValid(this.myResultPanel) || !viewColumn.isValid(this.myResultPanel)) {
            return null;
        }
        int row = (this.isTransposed() ? viewColumn : viewRow).asInteger();
        TableCellRenderer renderer = this.getCellRenderer(row, column2 = (this.isTransposed() ? viewRow : viewColumn).asInteger());
        if (renderer == null) {
            return null;
        }
        return (JComponent)this.prepareRenderer(renderer, row, column2, forDisplay);
    }

    @Override
    public void setColumnEnabled(@NotNull ModelIndex<DataConsumer.Column> columnIdx, boolean state) {
        if (columnIdx == null) {
            TableResultView.$$$reportNull$$$0(16);
        }
        if (this.isTransposed()) {
            this.getModel().fireTableDataChanged();
        } else {
            this.setViewColumnVisible(columnIdx, state);
        }
    }

    @Override
    public void setRowEnabled(@NotNull ModelIndex<DataConsumer.Row> rowIdx, boolean state) {
        if (rowIdx == null) {
            TableResultView.$$$reportNull$$$0(17);
        }
        if (this.isTransposed()) {
            this.setViewColumnVisible(rowIdx, state);
        } else {
            this.getModel().fireTableDataChanged();
        }
    }

    @NotNull
    private MyCellRenderer createHeaderRenderer() {
        return new MyCellRenderer(this);
    }

    public void startPaintingSession() {
        this.myPaintingSession = new PaintingSession();
    }

    public void endPaintingSession() {
        this.myPaintingSession = null;
    }

    private void dropCaches() {
        this.myCellImageCache.reset();
    }

    public MyTableColumnCache getColumnCache() {
        return this.myColumnCache;
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> getContextColumn() {
        ModelIndex<DataConsumer.Column> modelIndex = this.myClickedHeaderColumnIdx;
        if (modelIndex == null) {
            TableResultView.$$$reportNull$$$0(18);
        }
        return modelIndex;
    }

    @Override
    public void updateSortKeysFromColumnAttributes() {
        RowSorter rowSorter = this.getRowSorter();
        if (rowSorter != null) {
            rowSorter.setSortKeys(this.isTransposed() || this.myResultPanel.isSortViaOrderBy() ? null : this.createSortKeys());
        }
    }

    @Override
    public void orderingAndVisibilityChanged() {
        this.getModel().fireTableDataChanged();
    }

    @NotNull
    private List<RowSorter.SortKey> createSortKeys() {
        if (this.isTransposed()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TableResultView.$$$reportNull$$$0(19);
            }
            return list;
        }
        TreeMap<Integer, DataConsumer.Column> sortOrderMap = this.myResultPanel.getSortOrderMap();
        int orderIdx = 0;
        Object[] keys = new RowSorter.SortKey[sortOrderMap.size()];
        for (DataConsumer.Column column2 : sortOrderMap.values()) {
            RowSorter.SortKey key = new RowSorter.SortKey(column2.columnNum, this.myResultPanel.getSortOrder(column2) < 0 ? SortOrder.ASCENDING : SortOrder.DESCENDING);
            keys[orderIdx++] = key;
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])keys);
        if (arrayList == null) {
            TableResultView.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public RawIndexConverter getRawIndexConverter() {
        TableRawIndexConverter tableRawIndexConverter = this.myRawIndexConverter;
        if (tableRawIndexConverter == null) {
            TableResultView.$$$reportNull$$$0(21);
        }
        return tableRawIndexConverter;
    }

    @Override
    @NotNull
    public DataGridSearchSession createSearchSession(@Nullable FindModel findModel) {
        FindModel newFindModel;
        FindModel findModel2 = newFindModel = findModel == null ? null : new FindModel();
        if (findModel != null) {
            newFindModel.copyFrom(findModel);
        }
        return new DataGridSearchSession(this.myResultPanel.getProject(), this.myResultPanel, newFindModel);
    }

    @Override
    public void searchSessionStarted(@NotNull SearchSession searchSession) {
        if (searchSession == null) {
            TableResultView.$$$reportNull$$$0(22);
        }
        if (!(searchSession instanceof GridSearchSession)) {
            return;
        }
        ((GridSearchSession)searchSession).addListener(this, this);
    }

    public void doTranspose() {
        this.myColumnCache.retainColumns(ContainerUtil.emptyList());
        this.setModel(this.isTransposed() ? new GridTableModel.Regular(this.myResultPanel) : new GridTableModel.Transposed(this.myResultPanel));
        this.myRawIndexConverter.transpose();
        this.myColumnLayout.setTransposed(this.isTransposed());
        this.myResultPanel.updateSortKeysFromColumnAttributes();
        this.getModel().fireTableDataChanged();
    }

    public void addNotify() {
        super.addNotify();
        int hash = this.computeColumnsHashCode();
        if (hash == this.myColumnsHashCode) {
            return;
        }
        this.layoutColumns().doWhenDone(() -> {
            this.myColumnsHashCode = hash;
        });
    }

    protected void paintComponent(@NotNull Graphics g) {
        if (g == null) {
            TableResultView.$$$reportNull$$$0(23);
        }
        this.adjustCacheSize();
        super.paintComponent(g);
        this.paintCellsEffects(g);
    }

    private void adjustCacheSize() {
        if (!this.myCellImageCache.isCacheEnabled()) {
            return;
        }
        TableColumnModel columnModel = this.getColumnModel();
        int columnCount = columnModel == null ? 0 : columnModel.getColumnCount();
        int rowCount = this.getRowCount();
        Rectangle visibleRect = this.getVisibleRect();
        if (columnCount == 0 || rowCount == 0 || visibleRect.isEmpty()) {
            return;
        }
        int minColumnWidth = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < columnCount; ++i2) {
            TableColumn column2 = columnModel.getColumn(i2);
            minColumnWidth = Math.min(minColumnWidth, column2.getMinWidth());
        }
        int rowHeight = this.getRowHeight();
        int rowsMax = rowHeight == 0 ? rowCount : Math.min(rowCount, (int)Math.ceil((float)visibleRect.height / (float)rowHeight));
        rowsMax = Math.min(100, rowsMax);
        int colsMax = minColumnWidth == 0 ? columnCount : Math.min(columnCount, (int)Math.ceil((float)visibleRect.width / (float)minColumnWidth));
        colsMax = Math.min(30, colsMax);
        int factor = Math.max(1, Registry.intValue((String)"database.grid.cache.factor"));
        this.myCellImageCache.adjustCacheSize(rowsMax * colsMax * factor);
    }

    private void paintCellsEffects(Graphics g) {
        Rectangle visibleArea = g.getClipBounds();
        Point at = new Point((int)visibleArea.getMinX(), (int)visibleArea.getMinY());
        int fromRow = this.rowAtPoint(at);
        int fromColumn = this.columnAtPoint(at);
        at.setLocation(visibleArea.getMaxX(), visibleArea.getMaxY());
        int toRow = this.rowAtPoint(at);
        int toColumn = this.columnAtPoint(at);
        if (fromColumn == -1) {
            fromColumn = 0;
        }
        if (toRow == -1) {
            toRow = 0;
        }
        if (toColumn == -1) {
            toColumn = this.getColumnCount() - 1;
        }
        if (fromRow == -1) {
            toRow = this.getRowCount() - 1;
        }
        for (int row = fromRow; row <= toRow; ++row) {
            for (int column2 = fromColumn; column2 <= toColumn; ++column2) {
                this.paintCellEffects(g, row, column2);
            }
        }
    }

    private void paintCellEffects(Graphics g, int row, int column2) {
        CellAttributes attributes2 = this.myResultPanel.getMarkupModel().getCellAttributes(ViewIndex.forRow(this.myResultPanel, this.isTransposed() ? column2 : row).toModel(this.myResultPanel), ViewIndex.forColumn(this.myResultPanel, this.isTransposed() ? row : column2).toModel(this.myResultPanel), this.getColorsScheme());
        if (attributes2 != null) {
            CellRenderingUtils.paintCellEffect(g, this.getCellRect(row, column2, true), attributes2);
        }
    }

    private int computeColumnsHashCode() {
        int hash = 0;
        List<DataConsumer.Column> columns = this.myResultPanel.getDataModel().getColumns();
        for (DataConsumer.Column column2 : columns) {
            hash = System.identityHashCode(column2) + 31 * hash;
        }
        return hash;
    }

    @Override
    public boolean isViewModified() {
        for (int viewColumnIdx = 0; viewColumnIdx < this.getColumnCount(); ++viewColumnIdx) {
            ViewIndex<Object> viewIndex = this.isTransposed() ? ViewIndex.forRow(this.myResultPanel, viewColumnIdx) : ViewIndex.forColumn(this.myResultPanel, viewColumnIdx);
            ModelIndex<Object> modelIndex = viewIndex.toModel(this.myResultPanel);
            if (!modelIndex.isValid(this.myResultPanel) || !viewIndex.isValid(this.myResultPanel) || modelIndex.asInteger() == viewIndex.asInteger()) continue;
            return true;
        }
        for (MyTableColumn tableColumn : this.myColumnCache) {
            if (tableColumn.isWidthSetByLayout()) continue;
            return true;
        }
        int defaultRowHeight = this.getRowHeight();
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            if (this.getRowHeight(i2) == defaultRowHeight) continue;
            return true;
        }
        return false;
    }

    @Override
    public void contentLanguageUpdated(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Language language) {
        int viewColumn;
        if (columnIdx == null) {
            TableResultView.$$$reportNull$$$0(24);
        }
        if (language == null) {
            TableResultView.$$$reportNull$$$0(25);
        }
        if (this.isTransposed() ? this.getColumnCount() == 0 : this.getRowCount() == 0) {
            return;
        }
        int viewRow = this.isTransposed() ? columnIdx.toView(this.myResultPanel).asInteger() : 0;
        TableCellRenderer renderer = this.getCellRenderer(viewRow, viewColumn = this.isTransposed() ? 0 : columnIdx.toView(this.myResultPanel).asInteger());
        if (renderer instanceof TableCellImageCache.CachingCellRendererWrapper) {
            ((TableCellImageCache.CachingCellRendererWrapper)renderer).clearCache();
        }
        this.revalidate();
        this.repaint();
    }

    private void setupFocusListener() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                Component component;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (TableResultView.this.isEditing() && (component = TableResultView.this.getEditorComponent()) != null) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(component, true));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/table/TableResultView$3", "focusGained"));
            }
        });
    }

    private void setupMagnificator() {
        this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, new Magnificator(){

            public Point magnify(double scale, Point at) {
                Rectangle r1;
                int column2 = TableResultView.this.columnAtPoint(at);
                int row = TableResultView.this.rowAtPoint(at);
                Rectangle rectangle = r1 = column2 < 0 || row < 0 ? TableResultView.this.getBounds() : TableResultView.this.getCellRect(row, column2, true);
                if (r1.width == 0 || r1.height == 0) {
                    return at;
                }
                double xPerc = (double)(at.x - r1.x) / (double)r1.width;
                double yPerc = (double)(at.y - r1.y) / (double)r1.height;
                TableResultView.this.changeFontSize(0, scale);
                Rectangle r2 = column2 < 0 || row < 0 ? TableResultView.this.getBounds() : TableResultView.this.getCellRect(row, column2, true);
                return new Point((int)((double)r2.x + (double)r2.width * xPerc), (int)((double)r2.y + (double)r2.height * yPerc));
            }
        });
    }

    private void adjustDefaultActions() {
        ActionMap actionMap = this.getActionMap();
        final Action selectPreviousRowCell = actionMap.get("selectPreviousRowCell");
        actionMap.put("selectPreviousRowCell", new AbstractAction(){

            @Override
            public boolean isEnabled() {
                return false;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                selectPreviousRowCell.actionPerformed(e);
            }
        });
        final Action startEditing = actionMap.get("startEditing");
        actionMap.put("startEditing", new AbstractAction(){

            @Override
            public boolean isEnabled() {
                return false;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                startEditing.actionPerformed(e);
            }
        });
    }

    public void columnMarginChanged(ChangeEvent e) {
        TableColumn resizingColumn;
        JTableHeader tableHeader = this.getTableHeader();
        TableColumn tableColumn = resizingColumn = tableHeader != null ? tableHeader.getResizingColumn() : null;
        if (resizingColumn != null && this.autoResizeMode == 0) {
            resizingColumn.setPreferredWidth(resizingColumn.getWidth());
        }
        this.resizeAndRepaint();
    }

    public String getToolTipText(@NotNull MouseEvent event) {
        if (event == null) {
            TableResultView.$$$reportNull$$$0(26);
        }
        return "";
    }

    public void setRowHeight(int row, int rowHeight) {
        JViewport rowHeader;
        Container grandParent;
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        super.setRowHeight(row, rowHeight);
        Container parent2 = this.getParent();
        if (parent2 instanceof JViewport && (grandParent = parent2.getParent()) instanceof JScrollPane && (rowHeader = ((JScrollPane)grandParent).getRowHeader()) != null) {
            rowHeader.revalidate();
            rowHeader.repaint();
        }
    }

    @NotNull
    protected JTableHeader createDefaultTableHeader() {
        return new MyTableHeader();
    }

    @Override
    public void columnsAdded(ModelIndexSet<DataConsumer.Column> columnIndices) {
        this.columnAttributesUpdated();
        this.getModel().columnsAdded(columnIndices);
        this.dropCaches();
        this.myColumnLayout.newColumnsAdded(columnIndices);
    }

    @Override
    public void columnAttributesUpdated() {
        List<DataConsumer.Column> columns = this.myResultPanel.getDataModel().getColumns();
        if (!this.isTransposed()) {
            this.getColumnCache().retainColumns(columns);
            this.createDefaultColumnsFromModel();
        }
    }

    @Override
    public void columnsRemoved(ModelIndexSet<DataConsumer.Column> columns) {
        this.getModel().columnsRemoved(columns);
        if (!this.isTransposed()) {
            this.createDefaultColumnsFromModel();
        }
        this.dropCaches();
    }

    @Override
    public void rowsAdded(ModelIndexSet<DataConsumer.Row> rows) {
        this.getModel().rowsAdded(rows);
        if (this.isTransposed()) {
            this.createDefaultColumnsFromModel();
        }
        this.myColumnLayout.newRowsAdded(rows);
    }

    @Override
    public void afterLastRowAdded() {
        Component rowHeader;
        if (!this.isTransposed() && this.getViewRowCount() == 1 && DatabaseSettings.getSettings().getAutoTransposeMode() == DatabaseSettings.AutoTransposeMode.ONE_ROW) {
            this.setTransposed(true);
            this.myWasAutomaticallyTransposed = true;
            return;
        }
        if (this.myWasAutomaticallyTransposed && this.isTransposed() && this.getViewRowCount() != 1) {
            this.setTransposed(false);
            return;
        }
        JComponent mainResultViewComponent = this.myResultPanel.getMainResultViewComponent();
        JViewport header = mainResultViewComponent instanceof JScrollPane ? ((JScrollPane)mainResultViewComponent).getRowHeader() : null;
        Component component = rowHeader = header == null ? null : header.getView();
        if (rowHeader == null) {
            return;
        }
        if (rowHeader instanceof TableResultRowHeader) {
            ((TableResultRowHeader)rowHeader).updatePreferredSize();
        }
        rowHeader.revalidate();
        rowHeader.repaint();
    }

    @Override
    public void rowsRemoved(ModelIndexSet<DataConsumer.Row> rows) {
        this.getModel().rowsRemoved(rows);
        if (this.isTransposed()) {
            this.createDefaultColumnsFromModel();
        }
    }

    @Override
    public void cellsUpdated(ModelIndexSet<DataConsumer.Row> rows, ModelIndexSet<DataConsumer.Column> columns, @Nullable Object requestor) {
        this.getModel().cellsUpdated(rows, columns, requestor);
        this.myColumnLayout.newRowsAdded(rows);
    }

    public void dispose() {
        this.removeEditor();
    }

    @Override
    public void changeSelectedColumnsWidth(int delta) {
        int[] columns = this.getSelectedColumns();
        TableColumnModel columnModel = this.getColumnModel();
        for (int column2 : columns) {
            if (column2 < 0) continue;
            GridColumn tableColumn = (GridColumn)((Object)columnModel.getColumn(column2));
            int width = tableColumn.getColumnWidth();
            tableColumn.setColumnWidth(Math.max(0, width + delta));
        }
    }

    @Override
    public void resetRowHeights() {
        int defaultRowHeight = this.getRowHeight();
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            if (this.getRowHeight(i2) == defaultRowHeight) continue;
            this.setRowHeight(i2, defaultRowHeight);
        }
    }

    public void setModel(@NotNull TableModel model) {
        if (model == null) {
            TableResultView.$$$reportNull$$$0(27);
        }
        super.setModel(model);
        TableRowSorter<TableModel> rowSorter = this.createRowSorter(model);
        rowSorter.setMaxSortKeys(1);
        rowSorter.setSortsOnUpdates(this.isSortOnUpdates());
        DbUIUtil.invokeLater(() -> {
            if (this.getRowSorter() == rowSorter) {
                this.updateRowFilter();
            }
        });
        this.setRowSorter(rowSorter);
    }

    public void updateRowFilter() {
        DefaultRowSorter sorter = (DefaultRowSorter)this.getRowSorter();
        sorter.setRowFilter(this.createFilter());
    }

    @NotNull
    private RowFilter<TableModel, Integer> createFilter() {
        final RowFilter baseFilter = this.isTransposed() ? new MyTransposedViewColumnFilter(this.myResultPanel) : new MySearchRowFilter(this.myResultPanel);
        return new RowFilter<TableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                if (!baseFilter.include(entry)) {
                    return false;
                }
                int intIdx = entry.getIdentifier();
                ModelIndex<Object> rowIdx = TableResultView.this.isTransposed() ? ModelIndex.forColumn(TableResultView.this.myResultPanel, intIdx) : ModelIndex.forRow(TableResultView.this.myResultPanel, intIdx);
                return !TableResultView.this.myResultPanel.isRowFilteredOut(rowIdx);
            }
        };
    }

    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column2) {
        if (renderer == null) {
            TableResultView.$$$reportNull$$$0(28);
        }
        Component component = this.prepareRenderer(renderer, row, column2, true);
        if (component == null) {
            TableResultView.$$$reportNull$$$0(29);
        }
        return component;
    }

    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column2, boolean forDisplay) {
        if (renderer == null) {
            TableResultView.$$$reportNull$$$0(30);
        }
        Component component = super.prepareRenderer(renderer, row, column2);
        ViewIndex<DataConsumer.Row> rowIdx = ViewIndex.forRow(this.myResultPanel, this.isTransposed() ? column2 : row);
        ViewIndex<DataConsumer.Column> columnIdx = ViewIndex.forColumn(this.myResultPanel, this.isTransposed() ? row : column2);
        Component component2 = ResultViewWithCells.prepareComponent(component, this.myResultPanel, this, rowIdx, columnIdx, forDisplay);
        if (component2 == null) {
            TableResultView.$$$reportNull$$$0(31);
        }
        return component2;
    }

    @Override
    @Nullable
    public Color getCellBackground(@NotNull ViewIndex<DataConsumer.Row> row, @NotNull ViewIndex<DataConsumer.Column> column2, boolean selected) {
        if (row == null) {
            TableResultView.$$$reportNull$$$0(32);
        }
        if (column2 == null) {
            TableResultView.$$$reportNull$$$0(33);
        }
        return selected ? this.getSelectionBackground() : this.myResultPanel.getColorModel().getCellBackground(row.toModel(this.myResultPanel), column2.toModel(this.myResultPanel));
    }

    @Override
    @NotNull
    public Color getCellForeground(boolean selected) {
        Color color = selected ? this.getSelectionForeground() : this.getForeground();
        if (color == null) {
            TableResultView.$$$reportNull$$$0(34);
        }
        return color;
    }

    public boolean isCellEditable(int row, int column2) {
        return this.myResultPanel.isCellEditingAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editCellAt(int row, int column2, EventObject e) {
        ComponentUtil.putClientProperty((JComponent)((Object)this), EDITING_STARTER_CLIENT_PROPERTY_KEY, (Object)e);
        try {
            boolean bl = super.editCellAt(row, column2, e);
            return bl;
        }
        finally {
            ComponentUtil.putClientProperty((JComponent)((Object)this), EDITING_STARTER_CLIENT_PROPERTY_KEY, null);
        }
    }

    @Override
    public void createDefaultColumnsFromModel() {
        GridTableModel model = this.getModel();
        if (model == null) {
            return;
        }
        this.getTableHeader().setDraggedColumn(null);
        ((MyTableColumnModel)this.getColumnModel()).removeAllColumns();
        IntArrayList newColumnIndices = new IntArrayList();
        for (int columnDataIdx = 0; columnDataIdx < model.getColumnCount(); ++columnDataIdx) {
            boolean notShownEarlier = !this.myColumnCache.hasCachedColumn(columnDataIdx);
            this.myColumnCache.getOrCreateColumn(columnDataIdx);
            boolean enabled = this.isTransposed() || this.myResultPanel.isColumnEnabled(this.getColumn(columnDataIdx));
            ModelIndex<Object> modelColumnIdx = this.isTransposed() ? ModelIndex.forRow(this.myResultPanel, columnDataIdx) : ModelIndex.forColumn(this.myResultPanel, columnDataIdx);
            this.setViewColumnVisible(modelColumnIdx, enabled);
            if (!notShownEarlier || !enabled) continue;
            newColumnIndices.add(columnDataIdx);
        }
        if (!newColumnIndices.isEmpty()) {
            ModelIndexSet<Object> dataIndices = this.isTransposed() ? ModelIndexSet.forRows(this.myResultPanel, newColumnIndices.toIntArray()) : ModelIndexSet.forColumns(this.myResultPanel, newColumnIndices.toIntArray());
            this.myColumnLayout.columnsShown(dataIndices);
        }
    }

    public int getScrollableUnitIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        if (visibleRect == null) {
            TableResultView.$$$reportNull$$$0(35);
        }
        if (orientation == 1) {
            return this.getColorsScheme().getEditorFontSize();
        }
        return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    public Font getFont() {
        return this.myPaintingSession != null ? this.myPaintingSession.getFont() : (this.myResultPanel == null ? super.getFont() : this.doGetFont());
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        this.updateFonts();
    }

    public void changeFontSize(int increment, double scale) {
        int oldFontSize;
        double newIncrement = this.myFontSizeIncrement * scale + (double)increment;
        double newScale = this.myFontSizeScale * scale;
        int newFontSize = this.fontSize(newIncrement, newScale);
        if (newFontSize == (oldFontSize = this.getFont().getSize())) {
            return;
        }
        this.myFontSizeIncrement = newIncrement;
        this.myFontSizeScale = newScale;
        this.updateFonts();
    }

    private void updateFonts() {
        Font font = this.getFont();
        this.setFont(font);
        this.setRowHeight(this.getRowHeight());
        JTableHeader tableHeader = this.getTableHeader();
        if (tableHeader != null) {
            tableHeader.setFont(this.getScaledFont(font));
        }
        this.layoutColumns();
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            TableResultView.$$$reportNull$$$0(36);
        }
        if (this.changeHeaderFont(uiSettings)) {
            this.layoutColumns();
        }
    }

    private boolean changeHeaderFont(UISettings settings) {
        boolean normalMode;
        boolean presentationMode;
        JTableHeader header = this.getTableHeader();
        if (settings == null || header == null || header.getFont() == null) {
            return false;
        }
        int fontSize = header.getFont().getSize();
        boolean bl = presentationMode = settings.getPresentationMode() && fontSize != settings.getPresentationModeFontSize();
        if (presentationMode) {
            header.setFont(header.getFont().deriveFont((float)settings.getPresentationModeFontSize()));
        }
        boolean bl2 = normalMode = !settings.getPresentationMode() && fontSize == settings.getPresentationModeFontSize();
        if (normalMode) {
            header.setFont(this.getScaledFont(header.getFont()));
        }
        return presentationMode || normalMode;
    }

    private int fontSize(double fontSizeIncrement, double fontSizeScale) {
        int baseFontSize = this.getColorsScheme().getEditorFontSize();
        int newFontSize = (int)Math.max(fontSizeScale * (double)baseFontSize + fontSizeIncrement, 8.0);
        return Math.min(Math.max(EditorFontsConstants.getMaxEditorFontSize(), baseFontSize), newFontSize);
    }

    @Override
    public int getRowHeight() {
        return this.myPaintingSession != null ? this.myPaintingSession.getRowHeight() : this.doGetRowHeight();
    }

    public int getTextLineHeight() {
        return (int)Math.ceil((float)this.getFontMetrics(this.getFont()).getHeight() * this.getColorsScheme().getLineSpacing());
    }

    public Color getSelectionForeground() {
        return this.myPaintingSession != null ? this.myPaintingSession.getSelectionForeground() : (this.myResultPanel == null ? super.getSelectionForeground() : GridColorSchemeUtil.doGetSelectionForeground(this.getColorsScheme()));
    }

    public Color getSelectionBackground() {
        return this.myPaintingSession != null ? this.myPaintingSession.getSelectionBackground() : (this.myResultPanel == null ? super.getSelectionBackground() : GridColorSchemeUtil.doGetSelectionBackground(this.getColorsScheme()));
    }

    public Color getForeground() {
        return this.myPaintingSession != null ? this.myPaintingSession.getForeground() : (this.myResultPanel == null ? super.getBackground() : GridColorSchemeUtil.doGetForeground(this.getColorsScheme()));
    }

    public Color getBackground() {
        return this.myPaintingSession != null ? this.myPaintingSession.getBackground() : (this.myResultPanel == null ? super.getForeground() : GridColorSchemeUtil.doGetBackground(this.getColorsScheme()));
    }

    public void setBackground(@NotNull Color bg) {
        if (bg == null) {
            TableResultView.$$$reportNull$$$0(37);
        }
    }

    public Color getGridColor() {
        return this.myPaintingSession != null ? this.myPaintingSession.getGridColor() : (this.myResultPanel == null ? super.getGridColor() : GridColorSchemeUtil.doGetGridColor(this.getColorsScheme()));
    }

    public void tableChanged(TableModelEvent e) {
        if (this.myResultPanel == null) {
            super.tableChanged(e);
            return;
        }
        this.myResultPanel.getAutoscrollLocker().runWithLock(() -> super.tableChanged(e));
        this.myResultPanel.fireContentChanged(e instanceof GridTableModel.RequestedTableModelEvent ? ((GridTableModel.RequestedTableModelEvent)e).getRequestor() : null);
    }

    public GridTableModel getModel() {
        return (GridTableModel)super.getModel();
    }

    public Object getValueAt(int row, int column2) {
        boolean commonValue = this.isEditing() && this.isCellSelected(row, column2) && this.isMultiEditingAllowed();
        return commonValue ? this.myCommonValue.get() : super.getValueAt(row, column2);
    }

    public void removeEditor() {
        try {
            super.removeEditor();
        }
        finally {
            this.myCommonValue = null;
        }
    }

    @Override
    public boolean isTransposed() {
        return this.getModel() instanceof GridTableModel.Transposed;
    }

    private void onRowHeaderClicked(ModelIndex<DataConsumer.Row> rowIdx, MouseEvent e) {
        if (e.getID() != 501) {
            return;
        }
        if (this.myResultPanel.isHeaderSelecting() && this.isTransposed()) {
            int tableViewColumnIdx = this.myRawIndexConverter.row2View().applyAsInt(rowIdx.value);
            this.selectViewColumnInterval(tableViewColumnIdx, e);
        }
        if (e.isPopupTrigger() && this.myRowHeaderPopupActions != ActionGroup.EMPTY_GROUP) {
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", this.myRowHeaderPopupActions);
            popupMenu.getComponent().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void onColumnHeaderClicked(ModelIndex<DataConsumer.Column> columnIdx, MouseEvent e) {
        if (e.getID() == 500 && e.getButton() == 1) {
            this.toggleSortOrder(columnIdx, e.getModifiersEx() == 512);
            return;
        }
        if (e.getID() != 500 && e.getButton() == 2 && e.getClickCount() == 1) {
            if (columnIdx.value >= 0) {
                this.myResultPanel.setColumnEnabled(columnIdx, false);
            }
            return;
        }
        if (e.isPopupTrigger()) {
            if (this.myResultPanel.isHeaderSelecting() && !this.isTransposed()) {
                int tableViewColumnIdx = this.myRawIndexConverter.column2View().applyAsInt(columnIdx.value);
                this.selectViewColumnInterval(tableViewColumnIdx, e);
            }
            if (this.myColumnHeaderPopupActions != ActionGroup.EMPTY_GROUP) {
                this.myClickedHeaderColumnIdx = columnIdx;
                ListPopup popupMenu = JBPopupFactory.getInstance().createActionGroupPopup(null, this.myColumnHeaderPopupActions, DataManager.getInstance().getDataContext((Component)this.getComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
                popupMenu.addListener(new JBPopupListener(){

                    public void onClosed(@NotNull LightweightWindowEvent event) {
                        if (event == null) {
                            8.$$$reportNull$$$0(0);
                        }
                        DbUIUtil.invokeLater(() -> {
                            TableResultView.this.myClickedHeaderColumnIdx = ModelIndex.forColumn(TableResultView.this.myResultPanel, -1);
                        });
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/run/ui/table/TableResultView$8", "onClosed"));
                    }
                });
                Point point = new Point(e.getX(), e.getY());
                Point location = e.getComponent().getLocationOnScreen();
                point.translate(location.x, location.y);
                popupMenu.showInScreenCoordinates(e.getComponent(), point);
            }
        }
    }

    private void selectViewColumnInterval(int viewColumn, @NotNull MouseEvent e) {
        if (e == null) {
            TableResultView.$$$reportNull$$$0(38);
        }
        boolean interval = DbUIUtil.isIntervalModifierSet(e);
        boolean exclusive = DbUIUtil.isExclusiveModifierSet(e);
        TableSelectionModel selectionModel = (TableSelectionModel)ObjectUtils.tryCast(SelectionModel.get(this.myResultPanel, this), TableSelectionModel.class);
        if (selectionModel == null) {
            return;
        }
        if (interval) {
            int lead = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (exclusive) {
                selectionModel.addRowSelectionInterval(this.getRowCount() - 1, 0);
                selectionModel.addColumnSelectionInterval(viewColumn, lead);
            } else {
                selectionModel.setRowSelectionInterval(this.getRowCount() - 1, 0);
                selectionModel.setColumnSelectionInterval(viewColumn, lead);
            }
        } else if (exclusive) {
            this.removeColumnSelectionInterval(viewColumn, viewColumn);
        } else {
            selectionModel.setRowSelectionInterval(this.getRowCount() - 1, 0);
            selectionModel.setColumnSelectionInterval(viewColumn, viewColumn);
        }
    }

    @Override
    @Nullable
    public GridColumn getLayoutColumn(@NotNull ModelIndex<?> column2) {
        if (column2 == null) {
            TableResultView.$$$reportNull$$$0(39);
        }
        return this.getLayoutColumn(column2, column2.toView(this.myResultPanel));
    }

    @Nullable
    public GridColumn getLayoutColumn(@NotNull ModelIndex<?> column2, @NotNull ViewIndex<?> viewColumnIdx) {
        if (column2 == null) {
            TableResultView.$$$reportNull$$$0(40);
        }
        if (viewColumnIdx == null) {
            TableResultView.$$$reportNull$$$0(41);
        }
        return viewColumnIdx.asInteger() != -1 ? this.getColumnCache().getOrCreateColumn(column2.asInteger()) : null;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getVisibleRows() {
        int rowCount = this.isTransposed() ? this.getModel().getColumnCount() : this.getModel().getRowCount();
        int[] viewRowIndices = new int[rowCount];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            viewRowIndices[i2] = i2;
        }
        ModelIndexSet<DataConsumer.Row> rowIndices = ViewIndexSet.forRows(this.myResultPanel, viewRowIndices).toModel(this.myResultPanel);
        return this.validIndexSet(rowIndices, rowIndices1 -> ModelIndexSet.forRows(this.myResultPanel, rowIndices1));
    }

    @Override
    @NotNull
    public GridCellEditorFactoryProvider getEditorFactoryProvider() {
        GridCellEditorFactoryProvider gridCellEditorFactoryProvider = this.myEditorProvider;
        if (gridCellEditorFactoryProvider == null) {
            TableResultView.$$$reportNull$$$0(42);
        }
        return gridCellEditorFactoryProvider;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getVisibleColumns() {
        int visibleColumns = this.getViewColumnCount();
        int[] viewIndices = new int[visibleColumns];
        for (int i2 = 0; i2 < visibleColumns; ++i2) {
            viewIndices[i2] = i2;
        }
        ModelIndexSet<DataConsumer.Column> columnIndices = ViewIndexSet.forColumns(this.myResultPanel, viewIndices).toModel(this.myResultPanel);
        return this.validIndexSet(columnIndices, columnIndices1 -> ModelIndexSet.forColumns(this.myResultPanel, columnIndices1));
    }

    @Override
    public int getViewColumnCount() {
        return this.isTransposed() ? this.getRowCount() : this.getColumnCount();
    }

    @Override
    public int getViewRowCount() {
        return this.isTransposed() ? this.getColumnCount() : this.getRowCount();
    }

    @NotNull
    private <T> ModelIndexSet<T> validIndexSet(@NotNull ModelIndexSet<T> indexSet, @NotNull Function<int[], ModelIndexSet<T>> factory) {
        if (indexSet == null) {
            TableResultView.$$$reportNull$$$0(43);
        }
        if (factory == null) {
            TableResultView.$$$reportNull$$$0(44);
        }
        IntArrayList validIndices = new IntArrayList(indexSet.size());
        for (ModelIndex idx : indexSet.asIterable()) {
            if (!idx.isValid(this.myResultPanel)) continue;
            validIndices.add(idx.asInteger());
        }
        ModelIndexSet modelIndexSet = (ModelIndexSet)factory.fun((Object)validIndices.toIntArray());
        if (modelIndexSet == null) {
            TableResultView.$$$reportNull$$$0(45);
        }
        return modelIndexSet;
    }

    @Override
    public boolean stopEditing() {
        int[] nArray;
        int[] nArray2;
        TableCellEditor editor = this.getCellEditor();
        if (editor == null) {
            return true;
        }
        if (!this.isMultiEditingAllowed()) {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = this.getEditingColumn();
        } else {
            nArray2 = this.getSelectedColumns();
        }
        int[] columnDataIdx = Arrays.stream(nArray2).map(arg_0 -> this.convertColumnIndexToModel(arg_0)).toArray();
        if (!this.isMultiEditingAllowed()) {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = this.getEditingRow();
        } else {
            nArray = this.getSelectedRows();
        }
        int[] rowDataIdx = Arrays.stream(nArray).map(arg_0 -> this.convertRowIndexToModel(arg_0)).toArray();
        ModelIndexSet<DataConsumer.Row> myEditingRowIdx = ModelIndexSet.forRows(this.myResultPanel, this.isTransposed() ? columnDataIdx : rowDataIdx);
        ModelIndexSet<DataConsumer.Column> myEditingColumnIdx = ModelIndexSet.forColumns(this.myResultPanel, this.isTransposed() ? rowDataIdx : columnDataIdx);
        return this.myResultPanel.isSafeToUpdate(myEditingRowIdx, myEditingColumnIdx, editor.getCellEditorValue()) && editor.stopCellEditing();
    }

    @Override
    public void cancelEditing() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
    }

    @Override
    public boolean isCellEditingAllowed() {
        return true;
    }

    @Override
    public void editSelectedCell() {
        int leadRow = this.getSelectionModel().getLeadSelectionIndex();
        int leadColumn = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (leadRow == -1 || leadColumn == -1) {
            return;
        }
        TableUtil.editCellAt((JTable)((Object)this), (int)leadRow, (int)leadColumn);
    }

    @Override
    public boolean isMultiEditingAllowed() {
        int[] selectedColumns = this.isTransposed() ? this.getSelectedRows() : this.getSelectedColumns();
        int[] selectedRows = this.isTransposed() ? this.getSelectedColumns() : this.getSelectedRows();
        ModelIndexSet<DataConsumer.Column> indexSet = ViewIndexSet.forColumns(this.myResultPanel, selectedColumns).toModel(this.myResultPanel);
        List<DataConsumer.Column> columns = this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA).getColumns(indexSet);
        DasTable dasTable = DataGridUtil.getDatabaseTable(this.myResultPanel);
        JBIterable indices = dasTable == null ? JBIterable.empty() : DasUtil.getIndices((DasTable)dasTable);
        DataConsumer.Column uniqueColumn = (DataConsumer.Column)ContainerUtil.find(columns, column2 -> {
            DasColumn dasColumn = DataGridUtil.getDatabaseColumn((DataGrid)this.myResultPanel, column2);
            if (dasColumn == null || DasUtil.isPrimary((DasColumn)dasColumn) || DasUtil.isAutoGenerated((DasColumn)dasColumn)) {
                return dasColumn != null;
            }
            for (DasIndex index2 : indices) {
                if (!DasUtil.containsName((String)dasColumn.getName(), (MultiRef)index2.getColumnsRef()) || !index2.isUnique()) continue;
                return true;
            }
            return false;
        });
        return this.myCommonValue != null && (uniqueColumn == null || selectedRows.length == 1) && this.canEditTogether(columns);
    }

    private void toggleSortOrder(@NotNull ModelIndex<DataConsumer.Column> idx, boolean additive) {
        if (idx == null) {
            TableResultView.$$$reportNull$$$0(46);
        }
        this.myResultPanel.getAutoscrollLocker().runWithLock(() -> this.myResultPanel.toggleSortColumns(Collections.singletonList(idx), additive));
    }

    private boolean canEditTogether(@NotNull List<DataConsumer.Column> columns) {
        DbDataSource system;
        if (columns == null) {
            TableResultView.$$$reportNull$$$0(47);
        }
        if ((system = DataGridUtil.getDatabaseSystem(this.myResultPanel)) == null || system.getDbms().in(Dbms.DOCUMENT_ORIENTED)) {
            return true;
        }
        DomainRegistry registry = BaseDomainRegistry.get(DataGridUtil.getDbms(this.myResultPanel), system.getVersion());
        if (registry == null) {
            return false;
        }
        for (int i2 = 0; i2 < columns.size(); ++i2) {
            DataConsumer.Column outer = columns.get(i2);
            Domain outerDomain = registry.getDomain(outer);
            if (outerDomain == null) {
                return false;
            }
            for (int j = i2 + 1; j < columns.size(); ++j) {
                DataConsumer.Column inner = columns.get(j);
                Domain innerDomain = registry.getDomain(inner);
                if (innerDomain == null) {
                    return false;
                }
                Compatibility compatibility = outerDomain.getCompatibility(innerDomain);
                if (compatibility.isCompatible()) continue;
                return false;
            }
        }
        return true;
    }

    protected TableRowSorter<TableModel> createRowSorter(TableModel model) {
        final GridTableModel m = this.getModel();
        return new TableRowSorter<TableModel>((TableModel)m){
            {
                super(arg0);
                this.setModelWrapper(new DefaultRowSorter.ModelWrapper<TableModel, Integer>(){

                    @Override
                    public TableModel getModel() {
                        return m;
                    }

                    @Override
                    public int getColumnCount() {
                        return m.getColumnCount();
                    }

                    @Override
                    public int getRowCount() {
                        return m.getRowCount();
                    }

                    @Override
                    public Object getValueAt(int row, int column2) {
                        return TableResultView.this.getRow(row);
                    }

                    @Override
                    public Integer getIdentifier(int row) {
                        return row;
                    }
                });
            }

            @Override
            public void toggleSortOrder(int columnDataIdx) {
            }

            @Override
            protected boolean useToString(int column2) {
                return false;
            }

            @Override
            public Comparator<?> getComparator(int modelColumnIdx) {
                Comparator<Object> comparator2 = null;
                if (!TableResultView.this.isTransposed()) {
                    DataConsumer.Column column2 = TableResultView.this.getColumn(modelColumnIdx);
                    comparator2 = TableResultView.this.myResultPanel.getColumnAttributes().getComparator(column2);
                }
                return comparator2 != null ? comparator2 : super.getComparator(modelColumnIdx);
            }

            @Override
            public boolean isSortable(int columnDataIdx) {
                DataConsumer.Column column2 = !TableResultView.this.isTransposed() ? TableResultView.this.getColumn(columnDataIdx) : null;
                return column2 != null && TableResultView.this.myResultPanel.getColumnAttributes().getComparator(column2) != null;
            }
        };
    }

    public TableCellEditor getCellEditor(int row, int column2) {
        ModelIndex<DataConsumer.Row> rowIdx = ViewIndex.forRow(this.myResultPanel, this.isTransposed() ? column2 : row).toModel(this.myResultPanel);
        ModelIndex<DataConsumer.Column> columnIdx = ViewIndex.forColumn(this.myResultPanel, this.isTransposed() ? row : column2).toModel(this.myResultPanel);
        GridCellEditorFactory editorFactory = this.myEditorProvider.getEditorFactory(this.myResultPanel, rowIdx, columnIdx);
        DataConsumer.Column dataColumn = this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx);
        return dataColumn != null && !DbImplUtil.isRowId(dataColumn) && editorFactory != null ? new GridTableCellEditor(this.myResultPanel, rowIdx, columnIdx, editorFactory) : null;
    }

    public TableCellRenderer getCellRenderer(int row, int column2) {
        TableCellRenderer renderer = this.myRenderers.getRenderer(row, column2);
        renderer = renderer == null && row >= 0 && column2 >= 0 ? super.getCellRenderer(row, column2) : renderer;
        return renderer == null ? null : this.myCellImageCache.wrapCellRenderer(renderer);
    }

    public void setValueAt(Object value2, int viewRowIdx, int viewColumnIdx) {
        this.setValueAt(value2, viewRowIdx, viewColumnIdx, true, null);
    }

    private void setValueAt(Object value2, int viewRowIdx, int viewColumnIdx, boolean allowImmediateUpdate, @Nullable Object requestor) {
        int[] nArray;
        int[] nArray2;
        boolean allowed = this.isMultiEditingAllowed();
        if (allowed) {
            nArray2 = this.getSelectedRows();
        } else {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = viewRowIdx;
        }
        int[] rows = nArray2;
        if (allowed) {
            nArray = this.getSelectedColumns();
        } else {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = viewColumnIdx;
        }
        int[] columns = nArray;
        ViewIndexSet<DataConsumer.Row> rowsSet = ViewIndexSet.forRows(this.myResultPanel, this.isTransposed() ? columns : rows);
        ViewIndexSet<DataConsumer.Column> columnsSet = ViewIndexSet.forColumns(this.myResultPanel, this.isTransposed() ? rows : columns);
        GridTableCellEditor editor = (GridTableCellEditor)((Object)ObjectUtils.tryCast((Object)this.getCellEditor(), GridTableCellEditor.class));
        Runnable moveToNextCellRunnable = editor != null && editor.shouldMoveFocus() ? () -> IdeFocusManager.findInstanceByComponent((Component)((Object)this)).doWhenFocusSettlesDown(() -> this.moveToNextCell((ViewIndex)rowsSet.last(), (ViewIndex)columnsSet.last())) : null;
        this.myResultPanel.setValueAt(rowsSet.toModel(this.myResultPanel), columnsSet.toModel(this.myResultPanel), value2, allowImmediateUpdate, moveToNextCellRunnable, requestor);
    }

    private void moveToNextCell(@NotNull ViewIndex<DataConsumer.Row> rowIndex, @NotNull ViewIndex<DataConsumer.Column> colIndex) {
        SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel;
        if (rowIndex == null) {
            TableResultView.$$$reportNull$$$0(48);
        }
        if (colIndex == null) {
            TableResultView.$$$reportNull$$$0(49);
        }
        if ((selectionModel = this.myResultPanel.getSelectionModel()).getSelectedRowCount() != 1 || selectionModel.getSelectedColumnCount() != 1 || !ApplicationManager.getApplication().isUnitTestMode() && (!UIUtil.isFocusAncestor((Component)((Object)this)) || this.isEditing())) {
            return;
        }
        if (!Comparing.equal(selectionModel.getSelectedRow(), rowIndex.toModel(this.myResultPanel)) || !Comparing.equal(selectionModel.getSelectedColumn(), colIndex.toModel(this.myResultPanel))) {
            return;
        }
        if (this.myResultPanel.isInsertedRow(rowIndex.toModel(this.myResultPanel))) {
            ViewIndex<DataConsumer.Column> nextColumn = ViewIndex.forColumn(this.myResultPanel, colIndex.asInteger() + 1);
            colIndex = nextColumn.isValid(this.myResultPanel) ? nextColumn : colIndex;
        } else {
            ViewIndex<DataConsumer.Row> nextRow = ViewIndex.forRow(this.myResultPanel, rowIndex.asInteger() + 1);
            rowIndex = nextRow.isValid(this.myResultPanel) ? nextRow : rowIndex;
        }
        this.myResultPanel.scrollToLocally(rowIndex, colIndex);
    }

    private Font doGetFont() {
        return this.getScaledFont(this.getColorsScheme().getFont(EditorFontType.PLAIN));
    }

    private Font getScaledFont(Font font) {
        return UISettings.getInstance().getPresentationMode() ? font : (font == null ? null : font.deriveFont((float)this.fontSize(this.myFontSizeIncrement, this.myFontSizeScale)));
    }

    private int doGetRowHeight() {
        return this.getTextLineHeight() + this.getRowMargin();
    }

    public static Rectangle getLabelTextRect(JLabel label) {
        Dimension pref = label.getPreferredSize();
        Rectangle bounds = label.getBounds();
        Insets insets = label.getInsets();
        int w = Math.min(pref.width, bounds.width);
        bounds.setSize(w - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
        bounds.translate(insets.left, insets.top);
        return bounds;
    }

    @Nullable
    private DataConsumer.Row getRow(int modelRowIdx) {
        return this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA).getRow(ModelIndex.forRow(this.myResultPanel, modelRowIdx));
    }

    @Nullable
    private DataConsumer.Column getColumn(int modelColumnIdx) {
        return this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA).getColumn(ModelIndex.forColumn(this.myResultPanel, modelColumnIdx));
    }

    @NotNull
    public static Icon getSortOrderIcon(int sortOrder) {
        Icon icon = sortOrder < 0 ? AllIcons.General.ArrowUp : (sortOrder > 0 ? AllIcons.General.ArrowDown : AllIcons.General.ArrowSplitCenterV);
        if (icon == null) {
            TableResultView.$$$reportNull$$$0(50);
        }
        return icon;
    }

    @NotNull
    private ActionCallback layoutColumns() {
        this.myResultPanel.trueLayout();
        ActionCallback callback = new ActionCallback();
        DbUIUtil.invokeLater(() -> {
            if (SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && this.myColumnLayout.resetLayout()) {
                callback.setDone();
            }
        });
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            TableResultView.$$$reportNull$$$0(51);
        }
        return actionCallback;
    }

    @NlsSafe
    public static String getSortOrderText(int sortOrder) {
        return sortOrder != 0 ? String.valueOf(Math.abs(sortOrder)) : "";
    }

    @Nullable
    protected Color getHoveredRowBackground() {
        return this.getColorsScheme().getColor(HOVER_BACKGROUND);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 31: 
            case 34: 
            case 42: 
            case 45: 
            case 50: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 31: 
            case 34: 
            case 42: 
            case 45: 
            case 50: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnHeaderPopupActions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowHeaderPopupActions";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 31: 
            case 34: 
            case 42: 
            case 45: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/table/TableResultView";
                break;
            }
            case 4: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 5: 
            case 33: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRow";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewColumn";
                break;
            }
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchSession";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRect";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewColumnIdx";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSet";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIndex";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/table/TableResultView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerticalScrollBar";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollPane";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHorizontalScrollBar";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "uiColumn";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "uiRow";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextColumn";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createSortKeys";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawIndexConverter";
                break;
            }
            case 29: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRenderer";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellForeground";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorFactoryProvider";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "validIndexSet";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortOrderIcon";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "layoutColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 31: 
            case 34: 
            case 42: 
            case 45: 
            case 50: 
            case 51: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setValueAt";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionChangedListener";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCellRendererComponent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setColumnEnabled";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setRowEnabled";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "searchSessionStarted";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "paintComponent";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "contentLanguageUpdated";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getToolTipText";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenderer";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getCellBackground";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getScrollableUnitIncrement";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "uiSettingsChanged";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setBackground";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "selectViewColumnInterval";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutColumn";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "validIndexSet";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "toggleSortOrder";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "canEditTogether";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "moveToNextCell";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 31: 
            case 34: 
            case 42: 
            case 45: 
            case 50: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySearchRowFilter
    extends RowFilter<TableModel, Integer> {
        final TableResultPanel myGrid;

        MySearchRowFilter(@NotNull TableResultPanel grid) {
            if (grid == null) {
                MySearchRowFilter.$$$reportNull$$$0(0);
            }
            this.myGrid = grid;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            GridSearchSession searchSession = (GridSearchSession)ObjectUtils.tryCast((Object)this.myGrid.getSearchSession(), GridSearchSession.class);
            if (searchSession == null || !searchSession.isFilteringEnabled() || StringUtil.isEmpty((String)searchSession.getFindModel().getStringToFind())) {
                return true;
            }
            ModelIndex<DataConsumer.Row> row = ModelIndex.forRow(this.myGrid, (int)entry.getIdentifier());
            return !this.myGrid.getVisibleColumns().asIterable().filter(column2 -> searchSession.isMatchedCell(row, column2)).isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/table/TableResultView$MySearchRowFilter", "<init>"));
        }
    }

    private static class MyTransposedViewColumnFilter
    extends RowFilter<TableModel, Integer> {
        final DataGrid myGrid;

        MyTransposedViewColumnFilter(@NotNull DataGrid grid) {
            if (grid == null) {
                MyTransposedViewColumnFilter.$$$reportNull$$$0(0);
            }
            this.myGrid = grid;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            ModelIndex<DataConsumer.Column> column2 = ModelIndex.forColumn(this.myGrid, (int)entry.getIdentifier());
            return column2.isValid(this.myGrid) && this.myGrid.isColumnEnabled(column2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/table/TableResultView$MyTransposedViewColumnFilter", "<init>"));
        }
    }

    public class MyTableColumnCache
    implements Iterable<MyTableColumn> {
        private final TIntObjectHashMap<Entry> myColumnDataIndicesToEntries = new TIntObjectHashMap();

        public boolean hasCachedColumn(int columnDataIdx) {
            boolean isCached = this.hasValidEntry(columnDataIdx);
            if (!isCached) {
                this.myColumnDataIndicesToEntries.remove(columnDataIdx);
                return false;
            }
            return true;
        }

        public MyTableColumn getOrCreateColumn(int columnDataIdx) {
            Entry e = (Entry)this.myColumnDataIndicesToEntries.get(columnDataIdx);
            if (!this.hasCachedColumn(columnDataIdx) || e == null) {
                e = this.createEntry(columnDataIdx);
                this.myColumnDataIndicesToEntries.put(columnDataIdx, (Object)e);
            }
            return e.myTableColumn;
        }

        @NotNull
        private Entry createEntry(int columnDataIdx) {
            MyTableColumn tableColumn = TableResultView.this.isTransposed() ? this.createTableColumnForRow(ModelIndex.forRow(TableResultView.this.myResultPanel, columnDataIdx)) : this.createTableColumnForColumn(ModelIndex.forColumn(TableResultView.this.myResultPanel, columnDataIdx));
            Object columnData = this.getColumnData(columnDataIdx);
            return new Entry(Objects.requireNonNull(columnData), tableColumn);
        }

        public void retainColumns(final Collection<? extends DataConsumer.Column> columnsToRetain) {
            this.myColumnDataIndicesToEntries.retainEntries((TIntObjectProcedure)new TIntObjectProcedure<Entry>(){

                public boolean execute(int columnDataIdx, @NotNull Entry e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return columnsToRetain.contains(e.myColumnData);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/table/TableResultView$MyTableColumnCache$1", "execute"));
                }
            });
        }

        @Override
        public Iterator<MyTableColumn> iterator() {
            return new Iterator<MyTableColumn>(){
                private final TIntObjectIterator<Entry> myWrappee;
                private Entry myCurrentEntry;
                {
                    this.myWrappee = MyTableColumnCache.this.myColumnDataIndicesToEntries.iterator();
                }

                @Override
                public boolean hasNext() {
                    this.advance();
                    return this.myCurrentEntry != null;
                }

                @Override
                public MyTableColumn next() {
                    MyTableColumn column2 = this.myCurrentEntry.myTableColumn;
                    this.myCurrentEntry = null;
                    return column2;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private void advance() {
                    this.myCurrentEntry = null;
                    while (this.myWrappee.hasNext()) {
                        this.myWrappee.advance();
                        if (MyTableColumnCache.this.hasValidEntry(this.myWrappee.key())) {
                            this.myCurrentEntry = (Entry)this.myWrappee.value();
                            break;
                        }
                        this.myWrappee.remove();
                    }
                }
            };
        }

        private boolean hasValidEntry(int columnDataIdx) {
            Entry e = (Entry)this.myColumnDataIndicesToEntries.get(columnDataIdx);
            if (e == null) {
                return false;
            }
            Object cachedColumnData = e.myColumnData;
            Object currentColumnData = this.getColumnData(columnDataIdx);
            if (Comparing.equal((Object)cachedColumnData, (Object)currentColumnData)) {
                return true;
            }
            if (cachedColumnData instanceof DataConsumer.Row && currentColumnData instanceof DataConsumer.Row) {
                DataConsumer.Row cachedRow = (DataConsumer.Row)cachedColumnData;
                DataConsumer.Row currentRow = (DataConsumer.Row)currentColumnData;
                if (cachedRow.rowNum == currentRow.rowNum && cachedRow.values.length == currentRow.values.length) {
                    int mismatchedValuesCount = 0;
                    for (int i2 = 0; i2 < cachedRow.values.length; ++i2) {
                        if (Comparing.equal((Object)cachedRow.values[i2], (Object)currentRow.values[i2])) continue;
                        ++mismatchedValuesCount;
                    }
                    if (mismatchedValuesCount < 2) {
                        return true;
                    }
                }
            }
            return false;
        }

        private Object getColumnData(int columnDataIdx) {
            return TableResultView.this.isTransposed() ? TableResultView.this.getRow(columnDataIdx) : TableResultView.this.getColumn(columnDataIdx);
        }

        @NotNull
        private MyTableColumn createTableColumnForColumn(ModelIndex<DataConsumer.Column> columnIdx) {
            DataConsumer.Column column2 = Objects.requireNonNull(TableResultView.this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx));
            return new MyTableColumn(column2, columnIdx.asInteger());
        }

        @NotNull
        private MyTableColumn createTableColumnForRow(ModelIndex<DataConsumer.Row> rowIdx) {
            return new MyTableColumn(rowIdx.asInteger());
        }

        private final class Entry {
            @NotNull
            public final Object myColumnData;
            @NotNull
            public final MyTableColumn myTableColumn;

            Entry(@NotNull Object columnData, MyTableColumn tableColumn) {
                if (columnData == null) {
                    Entry.$$$reportNull$$$0(0);
                }
                if (tableColumn == null) {
                    Entry.$$$reportNull$$$0(1);
                }
                this.myColumnData = columnData;
                this.myTableColumn = tableColumn;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "columnData";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "tableColumn";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/ui/table/TableResultView$MyTableColumnCache$Entry";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    protected class MyTableColumn
    extends TableColumn
    implements GridColumn {
        private final DataConsumer.Column myColumn;
        private final UserDataHolder myDataHolderDelegate;
        private int myWidthFromLayout;

        public MyTableColumn(int modelIndex) {
            this(null, modelIndex);
        }

        private MyTableColumn(DataConsumer.Column column2, int modelIndex) {
            super(modelIndex);
            this.myDataHolderDelegate = new UserDataHolderBase();
            this.myColumn = column2;
        }

        public Icon getIcon(boolean forDisplay) {
            if (this.myColumn == null) {
                return null;
            }
            DasColumn column2 = forDisplay ? DataGridUtil.getDatabaseColumn((DataGrid)TableResultView.this.myResultPanel, this.myColumn) : null;
            return column2 != null ? DbPresentationCore.getIcon((DasObject)column2) : DbPresentationCore.getIcon(DataGridUtil.getDbms(TableResultView.this.myResultPanel), ObjectKind.COLUMN);
        }

        @Override
        @NlsContexts.ColumnName
        @NotNull
        public String getHeaderValue() {
            String string = this.myColumn == null ? DataGridUtil.getRowName(TableResultView.this.myResultPanel, this.getModelIndex()) : TableResultView.this.myResultPanel.getColumnAttributes().getName(this.myColumn);
            if (string == null) {
                MyTableColumn.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public int getPreferredHeaderWidth() {
            Component headerComponent;
            TableCellRenderer cellRenderer = TableResultView.this.getTableHeader().getDefaultRenderer();
            MyCellRenderer renderer = (MyCellRenderer)ObjectUtils.tryCast((Object)cellRenderer, MyCellRenderer.class);
            if (renderer != null) {
                headerComponent = renderer.getHeaderCellRendererComponent(this.getModelIndex(), false);
            } else {
                int viewIndex = TableResultView.this.convertColumnIndexToView(this.getModelIndex());
                headerComponent = cellRenderer.getTableCellRendererComponent((JTable)((Object)TableResultView.this), this.getHeaderValue(), false, false, -1, viewIndex);
            }
            return headerComponent.getPreferredSize().width;
        }

        @NlsContexts.Tooltip
        @Nullable
        public String getTooltipText() {
            return TableResultView.this.myResultPanel.getColumnTooltipHtml(this.myColumn);
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                MyTableColumn.$$$reportNull$$$0(1);
            }
            return (T)this.myDataHolderDelegate.getUserData(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            if (key == null) {
                MyTableColumn.$$$reportNull$$$0(2);
            }
            this.myDataHolderDelegate.putUserData(key, value2);
        }

        @Override
        public int getColumnWidth() {
            return this.getPreferredWidth();
        }

        @Override
        public void setColumnWidth(int width) {
            this.myWidthFromLayout = width;
            this.setPreferredWidth(width);
        }

        public boolean isWidthSetByLayout() {
            return this.myWidthFromLayout == this.getPreferredWidth();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/table/TableResultView$MyTableColumn";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHeaderValue";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/table/TableResultView$MyTableColumn";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserData";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "putUserData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class MyHeaderCellComponent
    extends CellRendererPanel {
        private final TableResultView myTable;
        private final JLabel myNameLabel;
        private final JLabel mySortLabel;
        private MyTableColumn myCurrentColumn;

        public MyHeaderCellComponent(TableResultView table) {
            this.myTable = table;
            this.myNameLabel = new MyJBLabel();
            this.mySortLabel = new MyJBLabel();
            this.myNameLabel.setHorizontalAlignment(2);
            this.myNameLabel.setBorder(IdeBorderFactory.createEmptyBorder((Insets)CellRenderingUtils.NAME_LABEL_INSETS));
            this.mySortLabel.setVerticalAlignment(0);
            this.mySortLabel.setBorder(IdeBorderFactory.createEmptyBorder((Insets)CellRenderingUtils.SORT_LABEL_INSETS));
            this.setLayout(new BorderLayout(JBUIScale.scale((int)2), 0));
            this.add(this.myNameLabel, "Center");
            this.add(this.mySortLabel, "East");
            this.setBorder((Border)new CustomLineBorder(0, 0, 1, 1){

                protected Color getColor() {
                    Color gridColor = myTable.getGridColor();
                    return gridColor != null ? gridColor : super.getColor();
                }
            });
        }

        protected void paintComponent(Graphics g) {
            UISettings.setupAntialiasing((Graphics)g);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            this.setSelected(true);
            super.paintComponent(g);
        }

        protected Rectangle getNameRect() {
            return TableResultView.getLabelTextRect(this.myNameLabel);
        }

        protected int getModelIdx() {
            return this.myCurrentColumn.getModelIndex();
        }

        public MyHeaderCellComponent prepare(int columnDataIdx, boolean forDisplay) {
            this.myCurrentColumn = this.myTable.getColumnCache().getOrCreateColumn(columnDataIdx);
            this.myNameLabel.setIcon(this.myCurrentColumn.getIcon(forDisplay));
            this.myNameLabel.setText(this.myCurrentColumn.getHeaderValue());
            Icon sortLabelIcon = null;
            String sortLabelText = "";
            if (!this.myTable.isTransposed()) {
                DataConsumer.Column column2 = this.myTable.getColumn(columnDataIdx);
                if (column2 != null) {
                    if (this.myTable.myResultPanel.getColumnAttributes().getComparator(column2) != null) {
                        int sortOrder = this.myTable.myResultPanel.getSortOrder(column2);
                        sortLabelIcon = TableResultView.getSortOrderIcon(sortOrder);
                        sortLabelText = TableResultView.getSortOrderText(sortOrder);
                    }
                    this.myNameLabel.setHorizontalAlignment(ObjectFormatter.isNumericValue(null, column2, DataGridUtil.getDbms(this.myTable.myResultPanel)) ? 4 : 2);
                }
            } else {
                this.myNameLabel.setHorizontalAlignment(2);
            }
            this.mySortLabel.setIcon(sortLabelIcon);
            this.mySortLabel.setText(sortLabelText);
            return this;
        }

        public String getToolTipText(MouseEvent event) {
            return this.myCurrentColumn != null ? this.myCurrentColumn.getTooltipText() : super.getToolTipText(event);
        }

        public Color getBackground() {
            return this.myCurrentColumn == null ? super.getBackground() : (this.myTable.isTransposed() ? this.myTable.myResultPanel.getColorModel().getRowHeaderBackground(ModelIndex.forRow(this.myTable.myResultPanel, this.myCurrentColumn.getModelIndex())) : this.myTable.myResultPanel.getColorModel().getColumnHeaderBackground(ModelIndex.forColumn(this.myTable.myResultPanel, this.myCurrentColumn.getModelIndex())));
        }

        private class MyJBLabel
        extends JBLabel {
            private MyJBLabel() {
            }

            public Color getBackground() {
                return MyHeaderCellComponent.this.myTable.getBackground();
            }

            public Color getForeground() {
                return MyHeaderCellComponent.this.myTable.getForeground();
            }

            public Font getFont() {
                return UIUtil.getFontWithFallback((Font)MyHeaderCellComponent.this.myTable.getTableHeader().getFont());
            }
        }
    }

    private static final class GridCellRendererWrapper
    implements TableCellRenderer {
        final GridCellRenderer delegate;
        final TableResultView myResultView;

        private GridCellRendererWrapper(GridCellRenderer renderer, TableResultView resultView) {
            this.delegate = renderer;
            this.myResultView = resultView;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column2) {
            DataGrid grid = this.delegate.myGrid;
            ViewIndex<DataConsumer.Row> rowIdx = ViewIndex.forRow(grid, this.myResultView.isTransposed() ? column2 : row);
            ViewIndex<DataConsumer.Column> columnIdx = ViewIndex.forColumn(grid, this.myResultView.isTransposed() ? row : column2);
            return this.delegate.getComponent(rowIdx, columnIdx, value2);
        }
    }

    private static final class Renderers {
        final GridCellRenderers myGridRenderers;
        final TableResultView myResultView;
        final Map<GridCellRenderer, TableCellRenderer> myTableCellRenderers = new Reference2ObjectOpenHashMap();

        Renderers(TableResultPanel resultPanel, TableResultView resultView) {
            this.myGridRenderers = new GridCellRenderers(resultPanel);
            this.myResultView = resultView;
            Disposer.register((Disposable)resultPanel, (Disposable)this.myGridRenderers);
        }

        public TableCellRenderer getRenderer(int row, int column2) {
            ModelIndex<DataConsumer.Column> columnIdx;
            DataGrid grid = this.myGridRenderers.grid;
            ModelIndex<DataConsumer.Row> rowIdx = ViewIndex.forRow(grid, this.myResultView.isTransposed() ? column2 : row).toModel(grid);
            GridCellRenderer gridCellRenderer = this.myGridRenderers.getRenderer(rowIdx, columnIdx = ViewIndex.forColumn(grid, this.myResultView.isTransposed() ? row : column2).toModel(grid));
            if (gridCellRenderer == null) {
                return null;
            }
            TableCellRenderer renderer = this.myTableCellRenderers.get(gridCellRenderer);
            if (renderer == null) {
                renderer = new GridCellRendererWrapper(gridCellRenderer, this.myResultView);
                this.myTableCellRenderers.put(gridCellRenderer, renderer);
            }
            return renderer;
        }
    }

    private class PaintingSession {
        private Font myFont;
        private Color myGridColor;
        private Color myForeground;
        private Color myBackground;
        private Color mySelectionForeground;
        private Color mySelectionBackground;
        private int myRowHeight = -1;

        private PaintingSession() {
        }

        public Font getFont() {
            return this.myFont != null ? this.myFont : (this.myFont = TableResultView.this.doGetFont());
        }

        public int getRowHeight() {
            return this.myRowHeight != -1 ? this.myRowHeight : (this.myRowHeight = TableResultView.this.doGetRowHeight());
        }

        public Color getGridColor() {
            return this.myGridColor != null ? this.myGridColor : (this.myGridColor = GridColorSchemeUtil.doGetGridColor(TableResultView.this.getColorsScheme()));
        }

        public Color getForeground() {
            return this.myForeground != null ? this.myForeground : (this.myForeground = GridColorSchemeUtil.doGetForeground(TableResultView.this.getColorsScheme()));
        }

        public Color getBackground() {
            return this.myBackground != null ? this.myBackground : (this.myBackground = GridColorSchemeUtil.doGetBackground(TableResultView.this.getColorsScheme()));
        }

        public Color getSelectionForeground() {
            return this.mySelectionForeground != null ? this.mySelectionForeground : (this.mySelectionForeground = GridColorSchemeUtil.doGetSelectionForeground(TableResultView.this.getColorsScheme()));
        }

        public Color getSelectionBackground() {
            return this.mySelectionBackground != null ? this.mySelectionBackground : (this.mySelectionBackground = GridColorSchemeUtil.doGetSelectionBackground(TableResultView.this.getColorsScheme()));
        }
    }

    protected class MyTableHeader
    extends JBTable.JBTableHeader {
        private int myLastPositiveHeight;

        protected MyTableHeader() {
            super((JBTable)TableResultView.this);
            this.myLastPositiveHeight = 0;
            this.setOpaque(false);
            this.setFocusable(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(@NotNull MouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.processEvent(e);
                }

                @Override
                public void mousePressed(@NotNull MouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.processEvent(e);
                }

                @Override
                public void mouseReleased(@NotNull MouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    this.processEvent(e);
                }

                private void processEvent(MouseEvent e) {
                    if (TableResultView.this.isTransposed()) {
                        int modelRow = TableResultView.this.myRawIndexConverter.row2Model().applyAsInt(MyTableHeader.this.columnAtPoint(e.getPoint()));
                        if (modelRow >= 0) {
                            TableResultView.this.onRowHeaderClicked(ModelIndex.forRow(TableResultView.this.myResultPanel, modelRow), e);
                        }
                    } else {
                        int modelColumn = TableResultView.this.myRawIndexConverter.column2Model().applyAsInt(MyTableHeader.this.columnAtPoint(e.getPoint()));
                        if (modelColumn >= 0) {
                            TableResultView.this.onColumnHeaderClicked(ModelIndex.forColumn(TableResultView.this.myResultPanel, modelColumn), e);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/database/run/ui/table/TableResultView$MyTableHeader$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseClicked";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mousePressed";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseReleased";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public boolean getReorderingAllowed() {
            return !TableResultView.this.isTransposed();
        }

        public Dimension getPreferredSize() {
            Dimension d2 = super.getPreferredSize();
            if (d2.height <= 0) {
                d2.height = this.myLastPositiveHeight;
            }
            return d2;
        }

        public void setSize(int width, int height) {
            super.setSize(width, height);
            if (height > 0) {
                this.myLastPositiveHeight = height;
            }
        }

        public void paint(@NotNull Graphics g) {
            if (g == null) {
                MyTableHeader.$$$reportNull$$$0(0);
            }
            Rectangle clip = g.getClipBounds();
            clip.width = Math.max(0, Math.min(clip.width, this.getTable().getWidth() - clip.x));
            g.setClip(clip);
            super.paint(g);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/database/run/ui/table/TableResultView$MyTableHeader", "paint"));
        }
    }

    static class MyTableColumnModel
    extends DefaultTableColumnModel {
        MyTableColumnModel() {
        }

        @Override
        public void addColumn(TableColumn aColumn) {
            if (!(aColumn instanceof MyTableColumn)) {
                throw new IllegalArgumentException("Unexpected column type");
            }
            super.addColumn(aColumn);
        }

        @Override
        public MyTableColumn getColumn(int columnIndex) {
            return (MyTableColumn)super.getColumn(columnIndex);
        }

        public void removeAllColumns() {
            int columnCount = this.tableColumns.size();
            if (columnCount == 0) {
                return;
            }
            if (this.selectionModel != null) {
                this.selectionModel.removeIndexInterval(0, columnCount - 1);
            }
            for (TableColumn column2 : this.tableColumns) {
                column2.removePropertyChangeListener(this);
            }
            this.totalColumnWidth = -1;
            for (int i2 = columnCount - 1; i2 >= 0; --i2) {
                this.tableColumns.remove(i2);
                this.fireColumnRemoved(new TableColumnModelEvent(this, i2, 0));
            }
        }
    }

    public static class MyCellRenderer
    extends MyHeaderCellComponent
    implements TableCellRenderer {
        private final TableCellRenderer myOriginalRenderer;

        public MyCellRenderer(@NotNull TableResultView table) {
            if (table == null) {
                MyCellRenderer.$$$reportNull$$$0(0);
            }
            super(table);
            this.myOriginalRenderer = table.getTableHeader().getDefaultRenderer();
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column2) {
            if (table == null) {
                MyCellRenderer.$$$reportNull$$$0(1);
            }
            Component component = row == -1 ? this.getHeaderCellRendererComponent(table.convertColumnIndexToModel(column2), true) : this.myOriginalRenderer.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column2);
            if (component == null) {
                MyCellRenderer.$$$reportNull$$$0(2);
            }
            return component;
        }

        protected Component getHeaderCellRendererComponent(int columnDataIdx, boolean forDisplay) {
            return this.prepare(columnDataIdx, forDisplay);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/table/TableResultView$MyCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/table/TableResultView$MyCellRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableCellRendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getTableCellRendererComponent";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

