/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.selection;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.util.DbImplUtil;
import com.intellij.util.containers.Stack;
import java.util.OptionalInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridSelectionTracker {
    private final Stack<ModelIndex<DataConsumer.Row>> myRows;
    private final DataGrid myGrid;
    private boolean myAdjusting;

    public GridSelectionTracker(@NotNull DataGrid grid, @NotNull ResultView view2) {
        if (grid == null) {
            GridSelectionTracker.$$$reportNull$$$0(0);
        }
        if (view2 == null) {
            GridSelectionTracker.$$$reportNull$$$0(1);
        }
        this.myGrid = grid;
        this.myRows = new Stack();
        this.myGrid.addDataGridListener(new DataGridListener(){

            @Override
            public void onSelectionChanged(DataGrid dataGrid) {
                if (GridSelectionTracker.this.myAdjusting) {
                    return;
                }
                GridSelectionTracker.this.myRows.clear();
            }
        }, view2);
    }

    public void performOperation(@NotNull Operation operation) {
        if (operation == null) {
            GridSelectionTracker.$$$reportNull$$$0(2);
        }
        if (!this.checkAndFillStack(operation)) {
            return;
        }
        operation.perform(this);
        this.updateSelection();
    }

    public boolean canPerformOperation(@NotNull Operation operation) {
        if (operation == null) {
            GridSelectionTracker.$$$reportNull$$$0(3);
        }
        return operation.checkStackSize(this.myRows.size()) || operation.checkSelectedRowsCount(this.myGrid.getSelectionModel().getSelectedRowCount()) && operation.checkSelectedColumnsCount(this.myGrid.getSelectionModel().getSelectedColumnCount()) && this.checkRowEquality();
    }

    private boolean checkAndFillStack(@NotNull Operation operation) {
        if (operation == null) {
            GridSelectionTracker.$$$reportNull$$$0(4);
        }
        if (!this.canPerformOperation(operation)) {
            return false;
        }
        if (this.myRows.isEmpty()) {
            this.myRows.addAll(this.myGrid.getSelectionModel().getSelectedRows().asList());
        }
        return true;
    }

    private void updateSelection() {
        this.run(() -> this.myGrid.getSelectionModel().setRowSelection(this.getRows(), false));
    }

    @NotNull
    private ModelIndexSet<DataConsumer.Row> getRows() {
        int[] rows = this.myRows.stream().filter(idx -> idx.isValid(this.myGrid)).mapToInt(Index::asInteger).toArray();
        ModelIndexSet<DataConsumer.Row> modelIndexSet = ModelIndexSet.forRows(this.myGrid, rows);
        if (modelIndexSet == null) {
            GridSelectionTracker.$$$reportNull$$$0(5);
        }
        return modelIndexSet;
    }

    @Nullable
    private ModelIndex<DataConsumer.Row> findNext(@NotNull ViewIndex<DataConsumer.Row> stopRow) {
        if (stopRow == null) {
            GridSelectionTracker.$$$reportNull$$$0(6);
        }
        ViewIndex<DataConsumer.Row> startRow = this.getLastRow();
        ViewIndex<DataConsumer.Row> next = ViewIndex.forRow(this.myGrid, this.next(startRow.asInteger()));
        ModelIndex<DataConsumer.Row> startRowModelIdx = startRow.toModel(this.myGrid);
        while (next.asInteger() != startRow.asInteger()) {
            if (stopRow.asInteger() == next.asInteger()) {
                return null;
            }
            ModelIndex<DataConsumer.Row> nextModelIdx = next.toModel(this.myGrid);
            boolean isValid = next.isValid(this.myGrid);
            boolean isNotSelectedRow = !this.myGrid.getSelectionModel().isSelectedRow(nextModelIdx);
            boolean isNotInStack = !this.myRows.contains(nextModelIdx);
            boolean valuesAreEqual = this.rowEquals(startRowModelIdx, nextModelIdx);
            if (isNotInStack && isValid && isNotSelectedRow && valuesAreEqual) {
                return nextModelIdx;
            }
            next = ViewIndex.forRow(this.myGrid, this.next(next.asInteger()));
        }
        return null;
    }

    @NotNull
    private ViewIndex<DataConsumer.Row> getLastRow() {
        if (!this.myRows.isEmpty()) {
            ViewIndex<DataConsumer.Row> viewIndex = ((ModelIndex)this.myRows.peek()).toView(this.myGrid);
            if (viewIndex == null) {
                GridSelectionTracker.$$$reportNull$$$0(7);
            }
            return viewIndex;
        }
        ViewIndexSet rows = this.myGrid.getSelectionModel().getSelectedRows().toView(this.myGrid);
        OptionalInt max = rows.asList().stream().mapToInt(Index::asInteger).max();
        if (max.isEmpty()) {
            ViewIndex<DataConsumer.Row> viewIndex = ViewIndex.forRow(this.myGrid, 0);
            if (viewIndex == null) {
                GridSelectionTracker.$$$reportNull$$$0(8);
            }
            return viewIndex;
        }
        ViewIndex<DataConsumer.Row> viewIndex = ViewIndex.forRow(this.myGrid, max.getAsInt());
        if (viewIndex == null) {
            GridSelectionTracker.$$$reportNull$$$0(9);
        }
        return viewIndex;
    }

    private boolean checkRowEquality() {
        ModelIndexSet rows = this.myGrid.getSelectionModel().getSelectedRows();
        ModelIndex previous = (ModelIndex)rows.first();
        for (ModelIndex rowIdx : rows.asIterable()) {
            if (this.rowEquals(rowIdx, previous)) continue;
            return false;
        }
        return true;
    }

    private boolean rowEquals(@NotNull ModelIndex<DataConsumer.Row> first2, @NotNull ModelIndex<DataConsumer.Row> second) {
        if (first2 == null) {
            GridSelectionTracker.$$$reportNull$$$0(10);
        }
        if (second == null) {
            GridSelectionTracker.$$$reportNull$$$0(11);
        }
        GridModel model = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        ModelIndexSet columns = this.myGrid.getSelectionModel().getSelectedColumns();
        for (ModelIndex colIdx : columns.asIterable()) {
            if (DbImplUtil.valuesEqual(model.getValueAt(first2, colIdx), model.getValueAt(second, colIdx))) continue;
            return false;
        }
        return true;
    }

    private int next(int current) {
        return ++current >= this.myGrid.getVisibleRowsCount() ? 0 : current;
    }

    private void run(@NotNull Runnable runnable) {
        if (runnable == null) {
            GridSelectionTracker.$$$reportNull$$$0(12);
        }
        this.myAdjusting = true;
        try {
            runnable.run();
        }
        finally {
            this.myAdjusting = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/selection/GridSelectionTracker";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopRow";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/selection/GridSelectionTracker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastRow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performOperation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canPerformOperation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkAndFillStack";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findNext";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "rowEquals";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Operation {
        SELECT_NEXT(1, 1, 1){

            @Override
            boolean perform(@NotNull GridSelectionTracker tracker) {
                ModelIndex<DataConsumer.Row> next;
                if (tracker == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((next = tracker.findNext(tracker.getLastRow())) == null) {
                    return false;
                }
                tracker.myRows.add(next);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker$Operation$1", "perform"));
            }
        }
        ,
        SELECT_ALL(1, 1, 1){

            @Override
            boolean perform(@NotNull GridSelectionTracker tracker) {
                ModelIndex<DataConsumer.Row> next;
                if (tracker == null) {
                    2.$$$reportNull$$$0(0);
                }
                int rowCount = tracker.myRows.size();
                ViewIndex<DataConsumer.Row> row = tracker.getLastRow();
                while ((next = tracker.findNext(row)) != null) {
                    tracker.myRows.add(next);
                }
                return rowCount != tracker.myRows.size();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker$Operation$2", "perform"));
            }
        }
        ,
        UNSELECT_PREVIOUS(2, 1, 2){

            @Override
            boolean perform(@NotNull GridSelectionTracker tracker) {
                if (tracker == null) {
                    3.$$$reportNull$$$0(0);
                }
                tracker.myRows.pop();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/database/run/ui/grid/selection/GridSelectionTracker$Operation$3", "perform"));
            }
        };

        private final int myMinStackSize;
        private final int myMinSelectedColumns;
        private final int myMinSelectedRows;

        private Operation(int minStackSize, int minSelectedColumns, int minSelectedRows) {
            this.myMinStackSize = minStackSize;
            this.myMinSelectedColumns = minSelectedColumns;
            this.myMinSelectedRows = minSelectedRows;
        }

        boolean checkStackSize(int size) {
            return size >= this.myMinStackSize;
        }

        boolean checkSelectedColumnsCount(int count) {
            return count >= this.myMinSelectedColumns;
        }

        boolean checkSelectedRowsCount(int count) {
            return count >= this.myMinSelectedRows;
        }

        abstract boolean perform(@NotNull GridSelectionTracker var1);
    }
}

