/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.Grid;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.awt.Component;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultTextRendererFactory
implements GridCellRendererFactory {
    private final DataGrid myGrid;
    private final Map<String, TextRenderer> myRenderers;

    DefaultTextRendererFactory(@NotNull DataGrid grid) {
        if (grid == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
        this.myRenderers = FactoryMap.createMap(languageId -> {
            TextRenderer renderer = new TextRenderer(this.myGrid, (String)languageId);
            Disposer.register((Disposable)this.myGrid, (Disposable)renderer);
            return renderer;
        }, () -> new Reference2ObjectOpenHashMap());
    }

    @Override
    public boolean supports(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (row == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(2);
        }
        return true;
    }

    @Override
    @NotNull
    public GridCellRenderer getOrCreateRenderer(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (row == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(3);
        }
        if (column2 == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(4);
        }
        GridCellRenderer gridCellRenderer = this.myRenderers.get(DefaultTextRendererFactory.getLanguage(this.myGrid, row, column2).getID());
        if (gridCellRenderer == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(5);
        }
        return gridCellRenderer;
    }

    @NotNull
    public static Language getLanguage(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        Language language;
        if (grid == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(6);
        }
        if (row == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(7);
        }
        if (columnIdx == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(8);
        }
        if ((language = GridHelper.get(DataGridUtil.getDbms(grid)).getCellLanguage(grid, row, columnIdx)) != null) {
            Language language2 = language;
            if (language2 == null) {
                DefaultTextRendererFactory.$$$reportNull$$$0(9);
            }
            return language2;
        }
        language = grid.getContentLanguage(columnIdx);
        Object object = language == Language.ANY ? PlainTextLanguage.INSTANCE : language;
        if (object == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(10);
        }
        return object;
    }

    @Nullable
    private static DataConsumer.Column getColumn(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Grid<DataConsumer.Row, DataConsumer.Column> grid) {
        if (columnIdx == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(11);
        }
        if (grid == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(12);
        }
        return grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateRenderer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateRenderer";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColumn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TextRenderer
    extends GridCellRenderer {
        private final Map<Object, String> myValueTextCache;
        private final String myLanguageId;
        private EditorTextFieldCellRenderer.AbbreviatingRendererComponent myComponent;
        private Inlay<HintRenderer> inlay;

        public TextRenderer(@NotNull DataGrid grid) {
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(0);
            }
            this(grid, PlainTextLanguage.INSTANCE.getID());
        }

        public TextRenderer(@NotNull DataGrid grid, @NotNull String languageId) {
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(1);
            }
            if (languageId == null) {
                TextRenderer.$$$reportNull$$$0(2);
            }
            super(grid);
            this.myValueTextCache = CollectionFactory.createConcurrentWeakKeySoftValueIdentityMap((int)10, (float)0.75f, (int)1);
            this.myLanguageId = languageId;
            new UiNotifyConnector((Component)((Object)grid.getComponent()), new Activatable(){

                public void hideNotify() {
                    myValueTextCache.clear();
                }
            });
        }

        @NotNull
        public static EditorTextFieldCellRenderer.AbbreviatingRendererComponent createComponent(@NotNull Project project, @Nullable Language language) {
            if (project == null) {
                TextRenderer.$$$reportNull$$$0(3);
            }
            EditorTextFieldCellRenderer.AbbreviatingRendererComponent component = language == PlainTextLanguage.INSTANCE ? new EditorTextFieldCellRenderer.AbbreviatingRendererComponent(project, language, false, true) : new EditorTextFieldCellRenderer.AbbreviatingRendererComponent(project, language, false, false, ' ');
            component.setBorder((Border)new JBEmptyBorder(0, 3, 0, 3));
            EditorTextFieldCellRenderer.AbbreviatingRendererComponent abbreviatingRendererComponent = component;
            if (abbreviatingRendererComponent == null) {
                TextRenderer.$$$reportNull$$$0(4);
            }
            return abbreviatingRendererComponent;
        }

        @Override
        public int getSuitability(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            if (row == null) {
                TextRenderer.$$$reportNull$$$0(5);
            }
            if (column2 == null) {
                TextRenderer.$$$reportNull$$$0(6);
            }
            return 1;
        }

        @Override
        @NotNull
        public JComponent getComponent(@NotNull ViewIndex<DataConsumer.Row> rowIdx, @NotNull ViewIndex<DataConsumer.Column> columnIdx, @Nullable Object value2) {
            if (rowIdx == null) {
                TextRenderer.$$$reportNull$$$0(7);
            }
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(8);
            }
            Pair<Integer, Integer> modelRowAndColumn = this.myGrid.getRawIndexConverter().rowAndColumn2Model().fun(rowIdx.asInteger(), columnIdx.asInteger());
            ModelIndex<DataConsumer.Column> modelColumn = ModelIndex.forColumn(this.myGrid, (int)((Integer)modelRowAndColumn.second));
            JComponent jComponent = this.getComponent(rowIdx, columnIdx, value2, modelColumn);
            if (jComponent == null) {
                TextRenderer.$$$reportNull$$$0(9);
            }
            return jComponent;
        }

        @NotNull
        public JComponent getComponent(@NotNull ViewIndex<DataConsumer.Row> rowIdx, @NotNull ViewIndex<DataConsumer.Column> columnIdx, @Nullable Object value2, @NotNull ModelIndex<DataConsumer.Column> modelColumn) {
            if (rowIdx == null) {
                TextRenderer.$$$reportNull$$$0(10);
            }
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(11);
            }
            if (modelColumn == null) {
                TextRenderer.$$$reportNull$$$0(12);
            }
            if (this.myComponent == null) {
                this.myComponent = TextRenderer.createComponent(DataGridUtil.getProject(this.myGrid), Language.findLanguageByID((String)this.myLanguageId));
                ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myComponent).subscribe(EditorColorsManager.TOPIC, scheme -> {
                    this.myGrid.getComponent().globalSchemeChange(scheme);
                    this.myComponent.getEditor().reinitSettings();
                });
            }
            EditorEx editor = this.myComponent.getEditor();
            this.configureEditor(editor);
            boolean selected = this.myGrid.getSelectionModel().isSelected(rowIdx, columnIdx);
            TextAttributes attributes2 = TextRenderer.getAttributes(value2, (TextAttributesScheme)editor.getColorsScheme(), selected);
            String valueText = this.getValueText(modelColumn, value2 == null ? ReservedCellValue.NULL : value2);
            this.myComponent.setText(valueText, attributes2, selected);
            if (this.inlay != null) {
                Disposer.dispose(this.inlay);
            }
            this.inlay = null;
            String inlayMessage = TextRenderer.getInlayMessage(value2, modelColumn, this.myGrid);
            if (inlayMessage != null) {
                this.inlay = editor.getInlayModel().addInlineElement(0, (EditorCustomElementRenderer)new HintRenderer(inlayMessage));
            }
            EditorTextFieldCellRenderer.AbbreviatingRendererComponent abbreviatingRendererComponent = this.myComponent;
            if (abbreviatingRendererComponent == null) {
                TextRenderer.$$$reportNull$$$0(13);
            }
            return abbreviatingRendererComponent;
        }

        @Nullable
        private static String getInlayMessage(@Nullable Object value2, @NotNull ModelIndex<DataConsumer.Column> modelColumn, DataGrid grid) {
            if (modelColumn == null) {
                TextRenderer.$$$reportNull$$$0(14);
            }
            if (value2 instanceof byte[]) {
                return StringUtil.formatFileSize((long)((byte[])value2).length, (String)"");
            }
            if (!(value2 instanceof LobInfo)) {
                return null;
            }
            LobInfo info = (LobInfo)value2;
            if (!info.isTruncated()) {
                return value2 instanceof LobInfo.BlobInfo ? StringUtil.formatFileSize((long)info.length, (String)"") : null;
            }
            if (info instanceof LobInfo.ClobInfo && ((LobInfo.ClobInfo)info).data == null || info instanceof LobInfo.BlobInfo && ((LobInfo.BlobInfo)info).data == null) {
                DataConsumer.Column column2 = DefaultTextRendererFactory.getColumn(modelColumn, grid);
                return (String)(column2 == null ? "" : "(" + StringUtil.toUpperCase((String)column2.typeName) + ") ") + StringUtil.formatFileSize((long)info.length, (String)"");
            }
            return String.format("%s of %s", StringUtil.formatFileSize((long)info.getLoadedDataLength(), (String)""), StringUtil.formatFileSize((long)info.length, (String)""));
        }

        public static TextAttributes getAttributes(@Nullable Object value2, @NotNull TextAttributesScheme scheme, boolean selected) {
            if (scheme == null) {
                TextRenderer.$$$reportNull$$$0(15);
            }
            TextAttributesKey attributesKey = TextRenderer.getAttributesKey(value2);
            return !selected && attributesKey != null ? scheme.getAttributes(attributesKey) : null;
        }

        protected void configureEditor(@NotNull EditorEx editor) {
            if (editor == null) {
                TextRenderer.$$$reportNull$$$0(16);
            }
            TextRenderer.configureEditor(editor, this.myGrid);
        }

        public static void configureEditor(@NotNull EditorEx editor, @NotNull Grid<DataConsumer.Row, DataConsumer.Column> grid) {
            EditorColorsScheme scheme;
            boolean schemeAlreadySet;
            if (editor == null) {
                TextRenderer.$$$reportNull$$$0(17);
            }
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(18);
            }
            boolean bl = schemeAlreadySet = (scheme = editor.getColorsScheme()) instanceof DelegateColorScheme && ((DelegateColorScheme)scheme).getDelegate() == grid.getColorsScheme() && scheme.getEditorFontSize() == grid.getPreferredFocusedComponent().getFont().getSize();
            if (schemeAlreadySet) {
                return;
            }
            EditorColorsScheme bounded = editor.createBoundColorSchemeDelegate((EditorColorsScheme)grid.getColorsScheme());
            bounded.setEditorFontSize(grid.getPreferredFocusedComponent().getFont().getSize());
            editor.setColorsScheme(bounded);
        }

        @NotNull
        protected String getValueText(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Object value2) {
            String cachedText;
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(19);
            }
            if (value2 == null) {
                TextRenderer.$$$reportNull$$$0(20);
            }
            String string = cachedText = value2 instanceof ReservedCellValue ? null : this.myValueTextCache.get(value2);
            if (cachedText != null) {
                String string2 = cachedText;
                if (string2 == null) {
                    TextRenderer.$$$reportNull$$$0(21);
                }
                return string2;
            }
            String text2 = TextRenderer.getText(columnIdx, value2, this.myGrid);
            if (!(value2 instanceof ReservedCellValue)) {
                this.myValueTextCache.put(value2, text2);
            }
            String string3 = text2;
            if (string3 == null) {
                TextRenderer.$$$reportNull$$$0(22);
            }
            return string3;
        }

        @NotNull
        private static String getText(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Object value2, @NotNull DataGrid grid) {
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(23);
            }
            if (value2 == null) {
                TextRenderer.$$$reportNull$$$0(24);
            }
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(25);
            }
            String string = value2 instanceof ReservedCellValue ? ((ReservedCellValue)((Object)value2)).getDisplayName() : TextRenderer.getDisplayString(TextRenderer.getText(value2, columnIdx, grid));
            if (string == null) {
                TextRenderer.$$$reportNull$$$0(26);
            }
            return string;
        }

        @NotNull
        private static String getText(@NotNull Object value2, @NotNull ModelIndex<DataConsumer.Column> columnIdx, DataGrid grid) {
            DataConsumer.Column column2;
            if (value2 == null) {
                TextRenderer.$$$reportNull$$$0(27);
            }
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(28);
            }
            String string = (column2 = DefaultTextRendererFactory.getColumn(columnIdx, grid)) != null ? grid.getObjectFormatter().getPlainValue(value2, column2, DataGridUtil.getDbms(grid), ObjectFormatter.Mode.DISPLAY) : value2.toString();
            if (string == null) {
                TextRenderer.$$$reportNull$$$0(29);
            }
            return string;
        }

        public static String getDisplayString(@NotNull String str) {
            int lineEnd;
            if (str == null) {
                TextRenderer.$$$reportNull$$$0(30);
            }
            if (DataGridUtil.isFailedToLoad(str) && (lineEnd = str.indexOf(10, "<failed to load>".length() + 1)) > -1) {
                str = str.substring("<failed to load>".length(), lineEnd).trim();
            }
            return TextRenderer.trimTrailingWhitespace(str);
        }

        private static String trimTrailingWhitespace(String s2) {
            int end2;
            for (end2 = s2.length(); end2 > 0 && s2.charAt(end2 - 1) <= ' ' && s2.charAt(end2 - 1) != '\n'; --end2) {
            }
            return s2.substring(0, end2);
        }

        @Override
        public void dispose() {
            if (this.myComponent != null) {
                Disposer.dispose((Disposable)this.myComponent);
            }
        }

        @Nullable
        public static TextAttributesKey getAttributesKey(@Nullable Object value2) {
            if (value2 == null || value2 == ReservedCellValue.UNSET) {
                return DatabaseColors.GRID_NULL_VALUE;
            }
            if (value2 instanceof ObjectFormatter.ImageInfo) {
                return DatabaseColors.GRID_IMAGE_VALUE;
            }
            if (DataGridUtil.isFailedToLoad(value2)) {
                return DatabaseColors.GRID_ERROR_VALUE;
            }
            if (value2 instanceof LobInfo.FileClobInfo || value2 instanceof LobInfo.FileBlobInfo) {
                return DatabaseColors.GRID_UPLOAD_VALUE;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 9: 
                case 13: 
                case 21: 
                case 22: 
                case 26: 
                case 29: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 9: 
                case 13: 
                case 21: 
                case 22: 
                case 26: 
                case 29: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 9: 
                case 13: 
                case 21: 
                case 22: 
                case 26: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowIdx";
                    break;
                }
                case 8: 
                case 11: 
                case 19: 
                case 23: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnIdx";
                    break;
                }
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelColumn";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 20: 
                case 24: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
                case 9: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueText";
                    break;
                }
                case 26: 
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createComponent";
                    break;
                }
                case 4: 
                case 9: 
                case 13: 
                case 21: 
                case 22: 
                case 26: 
                case 29: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuitability";
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getComponent";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getInlayMessage";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttributes";
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "configureEditor";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueText";
                    break;
                }
                case 23: 
                case 24: 
                case 25: 
                case 27: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "getDisplayString";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 9: 
                case 13: 
                case 21: 
                case 22: 
                case 26: 
                case 29: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

